/*
 * Decompiled with CFR 0.152.
 */
class ModuleVariable {
    boolean writeEnable = false;
    boolean readEnable = false;
    final int valuesLength = 16;
    byte[] values = new byte[17];
    int length = 0;

    ModuleVariable(int address, int variableLength) {
        this.values[0] = (byte)address;
        this.length = variableLength;
    }

    void setIntValue(int intValue) {
        switch (this.length) {
            case 4: {
                this.values[13] = (byte)(intValue >> 24 & 0xFF);
            }
            case 3: {
                this.values[14] = (byte)(intValue >> 16 & 0xFF);
            }
            case 2: {
                this.values[15] = (byte)(intValue >> 8 & 0xFF);
            }
            case 1: {
                this.values[16] = (byte)(intValue & 0xFF);
            }
        }
    }

    void setFloatValue(float floatValue) {
        this.setIntValue(Float.floatToIntBits(floatValue));
    }

    int TestWriteAndFillBuffer(byte[] buffer, int bufferIndex) {
        if (this.writeEnable && bufferIndex + this.length + 1 < 180) {
            buffer[bufferIndex++] = this.values[0];
            for (int i = 17 - this.length; i < 17; ++i) {
                buffer[bufferIndex++] = this.values[i];
            }
            this.writeEnable = false;
        }
        return bufferIndex;
    }

    int[] TestReadAndFillBuffer(byte[] buffer, int[] bufferIndex) {
        if (this.readEnable && bufferIndex[0] < 180 && bufferIndex[1] + 1 + this.length < 180) {
            int n = bufferIndex[0];
            bufferIndex[0] = n + 1;
            buffer[n] = this.values[0];
            bufferIndex[1] = bufferIndex[1] + (1 + this.length);
            this.readEnable = false;
        }
        return bufferIndex;
    }
}

