/*
 * Decompiled with CFR 0.152.
 */
package net.sf.image4j.io;

import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import net.sf.image4j.io.CountingDataInput;
import net.sf.image4j.io.CountingInputStream;
import net.sf.image4j.io.IOUtils;

public class LittleEndianInputStream
extends DataInputStream
implements CountingDataInput {
    public LittleEndianInputStream(CountingInputStream countingInputStream) {
        super(countingInputStream);
    }

    @Override
    public int getCount() {
        return ((CountingInputStream)this.in).getCount();
    }

    public int skip(int n, boolean bl) throws IOException {
        return IOUtils.skip(this, n, bl);
    }

    public short readShortLE() throws IOException {
        int n = this.read();
        int n2 = this.read();
        if (n < 0 || n2 < 0) {
            throw new EOFException();
        }
        short s = (short)((n2 << 8) + (n << 0));
        return s;
    }

    public int readIntLE() throws IOException {
        int n = this.read();
        int n2 = this.read();
        int n3 = this.read();
        int n4 = this.read();
        if (n < -1 || n2 < -1 || n3 < -1 || n4 < -1) {
            throw new EOFException();
        }
        int n5 = (n4 << 24) + (n3 << 16) + (n2 << 8) + (n << 0);
        return n5;
    }

    public float readFloatLE() throws IOException {
        int n = this.readIntLE();
        float f = Float.intBitsToFloat(n);
        return f;
    }

    public long readLongLE() throws IOException {
        int n = this.readIntLE();
        int n2 = this.readIntLE();
        long l = ((long)n << 32) + ((long)n2 & 0xFFFFFFFFL);
        return l;
    }

    public double readDoubleLE() throws IOException {
        long l = this.readLongLE();
        double d = Double.longBitsToDouble(l);
        return d;
    }

    public long readUnsignedInt() throws IOException {
        long l = this.readUnsignedByte();
        long l2 = this.readUnsignedByte();
        long l3 = this.readUnsignedByte();
        long l4 = this.readUnsignedByte();
        long l5 = l << 24 | l2 << 16 | l3 << 8 | l4;
        return l5;
    }

    public long readUnsignedIntLE() throws IOException {
        long l = this.readUnsignedByte();
        long l2 = this.readUnsignedByte();
        long l3 = this.readUnsignedByte();
        long l4 = this.readUnsignedByte();
        long l5 = l4 << 24 | l3 << 16 | l2 << 8 | l;
        return l5;
    }
}

