/*
 * Decompiled with CFR 0.152.
 */
package com.fivecolibs.utils;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import net.sf.image4j.codec.ico.ICODecoder;

public final class FCOCUtils {
    public static final Color m_MEDIUMGREEN = new Color(0, 190, 0);
    public static final Color m_ORANGEWARNING = new Color(255, 135, 15);

    public static final int getChecksum(byte[] acBuffer, int nBufferLength) {
        int nChecksum = 0;
        int nTemp = 0;
        int j = 0;
        int i = nBufferLength;
        while (i > 0) {
            if (i > 1) {
                nTemp = (acBuffer[j] << 8 & 0xFF00) + (acBuffer[j + 1] & 0xFF);
                j += 2;
                nChecksum += ~nTemp & 0xFFFF;
            } else {
                nChecksum += ~(acBuffer[j++] << 8 & 0xFF00) & 0xFFFF;
            }
            i -= 2;
        }
        nChecksum = ((nChecksum & 0xFFFF0000) >> 16) + (nChecksum & 0xFFFF);
        nChecksum = ((nChecksum & 0xFFFF0000) >> 16) + (nChecksum & 0xFFFF);
        return nChecksum;
    }

    public static final void addChecksum(byte[] acBuffer, int nBufferLength) {
        int nChecksum = FCOCUtils.getChecksum(acBuffer, nBufferLength);
        acBuffer[nBufferLength + 0] = (byte)((nChecksum & 0xFF00) >> 8);
        acBuffer[nBufferLength + 1] = (byte)(nChecksum & 0xFF);
    }

    public static final void centerFrame(JFrame FrameToCenter) {
        Dimension FrameDim = Toolkit.getDefaultToolkit().getScreenSize();
        FrameToCenter.setLocation((FrameDim.width - FrameToCenter.getSize().width) / 2, (FrameDim.height - FrameToCenter.getSize().height) / 2);
    }

    public static final void setContainerEnabled(Component Comp, boolean isEnabled) {
        try {
            Comp.setEnabled(isEnabled);
            Container Cont = (Container)Comp;
            Component[] componentArray = Cont.getComponents();
            int n = componentArray.length;
            int n2 = 0;
            while (n2 < n) {
                Component SubComp = componentArray[n2];
                FCOCUtils.setContainerEnabled(SubComp, isEnabled);
                ++n2;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void intToByteArrayLE(int nValue, Byte[] aArray, int nIndex) {
        FCOCUtils.intToByteArrayLE(nValue, aArray, nIndex, 4);
    }

    public static void intToByteArrayLE(int nValue, Byte[] aArray, int nIndex, int nLength) throws IllegalArgumentException {
        switch (nLength) {
            case 4: {
                aArray[nIndex + 3] = (byte)(nValue >>> 24);
            }
            case 3: {
                aArray[nIndex + 2] = (byte)(nValue >>> 16);
            }
            case 2: {
                aArray[nIndex + 1] = (byte)(nValue >>> 8);
            }
            case 1: {
                aArray[nIndex + 0] = (byte)nValue;
                break;
            }
            default: {
                throw new IllegalArgumentException("Error: intToByteArrayLE nLength must be between 1 and 4.");
            }
        }
    }

    public static void unsignedIntToByteArrayLE(long lValue, Byte[] aArray, int nIndex) {
        FCOCUtils.unsignedIntToByteArrayLE(lValue, aArray, nIndex, 4);
    }

    public static void unsignedIntToByteArrayLE(long lValue, Byte[] aArray, int nIndex, int nLength) throws IllegalArgumentException {
        switch (nLength) {
            case 7: {
                aArray[nIndex + 3] = (byte)(lValue >>> 56);
            }
            case 6: {
                aArray[nIndex + 3] = (byte)(lValue >>> 48);
            }
            case 5: {
                aArray[nIndex + 3] = (byte)(lValue >>> 32);
            }
            case 4: {
                aArray[nIndex + 3] = (byte)(lValue >>> 24);
            }
            case 3: {
                aArray[nIndex + 2] = (byte)(lValue >>> 16);
            }
            case 2: {
                aArray[nIndex + 1] = (byte)(lValue >>> 8);
            }
            case 1: {
                aArray[nIndex + 0] = (byte)lValue;
                break;
            }
            default: {
                throw new IllegalArgumentException("Error: intToByteArrayLE nLength must be between 1 and 7.");
            }
        }
    }

    public static void intToByteArrayBE(int nValue, Byte[] aArray, int nIndex) {
        FCOCUtils.intToByteArrayBE(nValue, aArray, nIndex, 4);
    }

    public static void intToByteArrayBE(int nValue, Byte[] aArray, int nIndex, int nLength) throws IllegalArgumentException {
        switch (nLength) {
            case 4: {
                aArray[nIndex++] = (byte)(nValue >>> 24);
            }
            case 3: {
                aArray[nIndex++] = (byte)(nValue >>> 16);
            }
            case 2: {
                aArray[nIndex++] = (byte)(nValue >>> 8);
            }
            case 1: {
                aArray[nIndex] = (byte)nValue;
                break;
            }
            default: {
                throw new IllegalArgumentException("Error: intToByteArrayLE nLength must be between 1 and 4.");
            }
        }
    }

    public static final int byteArrayLEToInt(Byte[] aArray, int nIndex) {
        return FCOCUtils.byteArrayLEToInt(aArray, nIndex, 4);
    }

    public static final int byteArrayLEToInt(Byte[] aArray, int nIndex, int nLength) throws IllegalArgumentException {
        int nValue = 0;
        if (nLength < 1 || nLength > 4) {
            throw new IllegalArgumentException("Error: byteArrayLEToInt nLength must be between 1 and 4.");
        }
        int i = 3;
        while (i > 3 - nLength) {
            nValue |= (aArray[nIndex + nLength - 1 - (3 - i)].intValue() & 0xFF) << i * 8;
            --i;
        }
        return nValue >>= (4 - nLength) * 8;
    }

    public static final long byteArrayLEToUnsignedInt(Byte[] aArray, int nIndex) {
        return FCOCUtils.byteArrayLEToUnsignedInt(aArray, nIndex, 4);
    }

    public static final long byteArrayLEToUnsignedInt(Byte[] aArray, int nIndex, int nLength) throws IllegalArgumentException {
        long lValue = 0L;
        if (nLength < 1 || nLength > 7) {
            throw new IllegalArgumentException("Error: byteArrayLEToUnsignedInt nLength must be between 1 and 7.");
        }
        int i = 0;
        while (i < nLength) {
            lValue |= (long)(aArray[nIndex + i].intValue() & 0xFF) << i * 8;
            ++i;
        }
        return lValue;
    }

    public static final long byteArrayLEToUnsignedInt(byte[] achArray, int nIndex, int nLength) throws IllegalArgumentException {
        long lValue = 0L;
        if (nLength < 1 || nLength > 7) {
            throw new IllegalArgumentException("Error: byteArrayLEToUnsignedInt nLength must be between 1 and 7.");
        }
        int i = 0;
        while (i < nLength) {
            lValue |= (long)(achArray[nIndex + i] & 0xFF) << i * 8;
            ++i;
        }
        return lValue;
    }

    public static final int byteArrayBEToInt(Byte[] aArray, int nIndex) {
        return FCOCUtils.byteArrayBEToInt(aArray, nIndex, 4);
    }

    public static final int byteArrayBEToInt(Byte[] aArray, int nIndex, int nLength) throws IllegalArgumentException {
        if (nLength < 1 || nLength > 4) {
            throw new IllegalArgumentException("Error: byteArrayBEToInt nLength must be between 1 and 4.");
        }
        int nValue = 0;
        int i = 3;
        while (i > 3 - nLength) {
            nValue |= (aArray[nIndex + (3 - i)].intValue() & 0xFF) << i * 8;
            --i;
        }
        return nValue >>= (4 - nLength) * 8;
    }

    public static final int byteArrayBEToInt(byte[] achArray, int nIndex, int nLength) throws IllegalArgumentException {
        if (nLength < 1 || nLength > 4) {
            throw new IllegalArgumentException("Error: byteArrayBEToInt nLength must be between 1 and 4.");
        }
        int nValue = 0;
        int i = 3;
        while (i > 3 - nLength) {
            nValue |= (achArray[nIndex + (3 - i)] & 0xFF) << i * 8;
            --i;
        }
        return nValue >>= (4 - nLength) * 8;
    }

    public static final int byteArrayBEToUnsignedInt(byte[] achArray, int nIndex, int nLength) throws IllegalArgumentException {
        if (nLength < 1 || nLength > 4) {
            throw new IllegalArgumentException("Error: byteArrayBEToInt nLength must be between 1 and 4.");
        }
        int nValue = 0;
        int i = 3;
        while (i > 3 - nLength) {
            nValue = (int)((long)nValue | (long)(achArray[nIndex + (3 - i)] & 0xFF) << i * 8);
            --i;
        }
        return nValue >>= (4 - nLength) * 8;
    }

    public static final byte int2Bcd(int nBinValue) throws IllegalArgumentException {
        if (nBinValue >= 0 && nBinValue < 100) {
            int nResult = (nBinValue / 10 & 0xF) << 4;
            return (byte)(nResult += nBinValue % 10 & 0xF);
        }
        throw new IllegalArgumentException("Error: int2Bcd nBinValue must be between 0 and 99.");
    }

    public static final int bcd2Int(byte chBcdValue) {
        int nResult = ((chBcdValue & 0xF0) >> 4) * 10;
        return nResult += chBcdValue & 0xF;
    }

    public static final String toHexString(int nValue) {
        return FCOCUtils.toHexString(nValue, 2);
    }

    public static final String toHexString(int nValue, int nLength) {
        String szValue = Integer.toHexString(nValue).toUpperCase();
        while (szValue.length() % nLength != 0) {
            szValue = "0" + szValue;
        }
        szValue = szValue.substring(szValue.length() - nLength);
        return szValue;
    }

    public static final String padHexString(String szValue) {
        while (szValue.length() % 2 != 0) {
            szValue = "0" + szValue;
        }
        return szValue;
    }

    public static final String byteArrayToString(byte[] achArray, int nOffset, int nMaxLength) {
        StringBuilder sb = new StringBuilder();
        int nMaxOffset = nOffset + nMaxLength;
        while (achArray[nOffset] != 0) {
            sb.append((char)achArray[nOffset++]);
            if (nOffset == nMaxOffset) break;
        }
        return sb.toString();
    }

    public static final String byteArrayToString(Byte[] aArray, int nOffset, int nMaxLength) {
        StringBuilder sb = new StringBuilder();
        int nMaxOffset = nOffset + nMaxLength;
        while (aArray[nOffset] != 0) {
            sb.append((char)aArray[nOffset++].byteValue());
            if (nOffset == nMaxOffset) break;
        }
        return sb.toString();
    }

    public static final String byteArrayLEToString(byte[] achArray, int nOffset, int nMaxLength) {
        StringBuilder sb = new StringBuilder();
        int nMinOffset = nOffset;
        nOffset += nMaxLength;
        while (achArray[nOffset] != 0) {
            sb.append((char)achArray[nOffset--]);
            if (nOffset == nMinOffset) break;
        }
        return sb.toString();
    }

    public static final <T> T[] concatArrays(T[] aFirst, T[] aSecond) {
        T[] result = Arrays.copyOf(aFirst, aFirst.length + aSecond.length);
        System.arraycopy(aSecond, 0, result, aFirst.length, aSecond.length);
        return result;
    }

    public static ImageIcon createImageIcon(String szPath) {
        URL ImgURL = FCOCUtils.class.getResource(szPath);
        try {
            return new ImageIcon(ImgURL);
        }
        catch (NullPointerException e) {
            System.out.println("Icon " + szPath + " not found !");
            return null;
        }
    }

    public static List<BufferedImage> getAppIconImages(Class<?> ThisClass) throws IOException {
        ArrayList<BufferedImage> ImageList;
        try {
            ImageList = ICODecoder.read((InputStream)ThisClass.getResourceAsStream("/images/ico.ico"));
        }
        catch (IOException e) {
            ImageList = new ArrayList<BufferedImage>();
            ImageList.add(ImageIO.read(ThisClass.getResource("/images/logo198px.gif")));
            ImageList.add(ImageIO.read(ThisClass.getResource("/images/logo75px.gif")));
            ImageList.add(ImageIO.read(ThisClass.getResource("/images/logo40px.gif")));
            ImageList.add(ImageIO.read(ThisClass.getResource("/images/logo32px.png")));
        }
        return ImageList;
    }

    public static void setMouseListenerRecursively(JComponent Comp, MouseAdapter MouseAdapt) {
        Comp.addMouseListener(MouseAdapt);
        Component[] componentArray = Comp.getComponents();
        int n = componentArray.length;
        int n2 = 0;
        while (n2 < n) {
            Component cc = componentArray[n2];
            if (cc instanceof JComponent) {
                FCOCUtils.setMouseListenerRecursively((JComponent)cc, MouseAdapt);
            }
            ++n2;
        }
    }

    public static void setToolTipRecursively(JComponent Comp, String szText, MouseAdapter MouseAdapt) {
        Comp.setToolTipText(szText);
        if (MouseAdapt != null) {
            Comp.addMouseListener(MouseAdapt);
        }
        Component[] componentArray = Comp.getComponents();
        int n = componentArray.length;
        int n2 = 0;
        while (n2 < n) {
            Component cc = componentArray[n2];
            if (cc instanceof JComponent) {
                FCOCUtils.setToolTipRecursively((JComponent)cc, szText, MouseAdapt);
            }
            ++n2;
        }
    }

    public static Dimension getDisplaySize() {
        Dimension Display = new Dimension();
        int nWidth = 0;
        int nHeight = 0;
        GraphicsDevice[] gs = GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices();
        int j = 0;
        while (j < gs.length) {
            nWidth += gs[j].getDisplayMode().getWidth();
            nHeight = gs[j].getDisplayMode().getHeight();
            ++j;
        }
        Display.setSize(nWidth, nHeight);
        return Display;
    }

    public static Rectangle getDisplayBounds() {
        Rectangle DisplayBounds = new Rectangle();
        int x = 0;
        int y = 0;
        int nWidth = 0;
        int nHeight = 0;
        GraphicsDevice[] gs = GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices();
        int j = 0;
        while (j < gs.length) {
            Rectangle gc = gs[j].getDefaultConfiguration().getBounds();
            nWidth += gc.width;
            nHeight = gc.height;
            if (x > gc.x) {
                x = gc.x;
            }
            if (y > gc.y) {
                y = gc.y;
            }
            ++j;
        }
        DisplayBounds.setBounds(x, y, nWidth, nHeight);
        return DisplayBounds;
    }
}

