/*
 * Decompiled with CFR 0.152.
 */
package com.fivecolibs.devices;

import java.util.BitSet;
import java.util.concurrent.ConcurrentLinkedQueue;

public class FCOCRegisterBase {
    public static final int nAT_FCT = 0;
    public static final int nAT_R = 1;
    public static final int nAT_W = 2;
    public static final int nAT_RW = 3;
    public static final int nDT_INT = 0;
    public static final int nDT_UINT = 1;
    public static final int nDT_BIN = 2;
    public static final int nDT_PERCENT = 3;
    public static final int nDT_TEXT = 4;
    public static final int nDT_ARRAY = 5;
    public static final int nDT_FIXEDP_50_50 = 6;
    public static final int nDT_FIXEDP_25_75 = 7;
    public static final int nDT_FIXEDP_75_25 = 8;
    private final int m_nAddress;
    private final int m_nSize;
    private final int m_nAccesType;
    private final int m_nDataType;
    private Object m_DataR;
    private Object m_LastDataW;
    protected final ConcurrentLinkedQueue<Object> m_DataWQueue = new ConcurrentLinkedQueue();
    private boolean m_isAutoReadEnabled = false;
    private final Object m_GeneralCallbackParameter;

    public FCOCRegisterBase(int nAddress, int nSize, int nAccessType, int nDataType, boolean isAutoReadEnabled, Object GeneralCallbackParameter) throws IllegalArgumentException {
        if (nSize < 0) {
            throw new IllegalArgumentException("Register size cannot be negative !");
        }
        if (nAccessType == 0 && nSize > 0) {
            throw new IllegalArgumentException("Function size must be 0 !");
        }
        this.m_nAddress = nAddress;
        this.m_nSize = nSize;
        this.m_nAccesType = nAccessType;
        this.m_nDataType = nDataType;
        this.m_isAutoReadEnabled = isAutoReadEnabled;
        Object Data = null;
        this.m_GeneralCallbackParameter = GeneralCallbackParameter;
        if (nAccessType != 0) {
            switch (nDataType) {
                case 0: {
                    if (this.m_nSize <= 8) {
                        Data = 0L;
                        break;
                    }
                    throw new IllegalArgumentException("Register INT type does not support a size bigger than 8 !", null);
                }
                case 3: {
                    if (this.m_nSize <= 7) {
                        Data = 0.0;
                        break;
                    }
                    throw new IllegalArgumentException("Register PERCENT types do not support a size bigger than 7 !", null);
                }
                case 1: {
                    if (this.m_nSize <= 7) {
                        Data = 0L;
                        break;
                    }
                    throw new IllegalArgumentException("Register UINT types do not support a size bigger than 7 !", null);
                }
                case 2: {
                    Data = new BitSet(this.m_nSize * 8);
                    break;
                }
                case 4: {
                    Data = new String("");
                    break;
                }
                case 5: {
                    Data = new Byte[this.m_nSize];
                    int i = 0;
                    while (i < this.m_nSize) {
                        Data[i] = 0;
                        ++i;
                    }
                    break;
                }
                case 6: 
                case 7: 
                case 8: {
                    if (nSize % 2 != 0) {
                        throw new IllegalArgumentException("Register FIXEDP type size must be multiple of 2 !", null);
                    }
                    Data = 0.0;
                    break;
                }
            }
            this.m_DataR = Data;
            this.m_LastDataW = Data;
        }
    }

    public FCOCRegisterBase(int nAddress, int nSize, int nAccessType, int nDataType, boolean isAutoReadEnabled) throws IllegalArgumentException {
        this(nAddress, nSize, nAccessType, nDataType, isAutoReadEnabled, null);
    }

    public int getAddress() {
        return this.m_nAddress;
    }

    public int getSize() {
        return this.m_nSize;
    }

    public int getAccesType() {
        return this.m_nAccesType;
    }

    public int getDataType() {
        return this.m_nDataType;
    }

    public synchronized Object getDataToWrite() {
        if (!this.m_DataWQueue.isEmpty()) {
            this.m_LastDataW = this.m_DataWQueue.poll();
        }
        return this.m_LastDataW;
    }

    public synchronized Object getDataLastWritten() {
        return this.m_LastDataW;
    }

    public synchronized Object getDataRead() {
        return this.m_DataR;
    }

    public synchronized void setDataToWrite(Object Value) throws IllegalArgumentException {
        this.setData(Value, false);
    }

    public synchronized void setDataRead(Object Value) throws IllegalArgumentException {
        this.setData(Value, true);
    }

    private void setData(Object Value, boolean isRead) throws IllegalArgumentException {
        Object Data;
        switch (this.m_nDataType) {
            case 0: 
            case 1: {
                if (Value.getClass().getSimpleName().equals("Long")) {
                    Data = (long)((Long)Value);
                    break;
                }
                throw new IllegalArgumentException("Register value must be Long.");
            }
            case 3: {
                if (Value.getClass().getSimpleName().equals("Double")) {
                    double dPercent = (Double)Value;
                    if (dPercent >= 0.0 && dPercent <= 100.0) {
                        Data = (double)((Double)Value);
                        break;
                    }
                    throw new IllegalArgumentException("Register value must be between 0 and 100.");
                }
                throw new IllegalArgumentException("Register value must be Double.");
            }
            case 2: {
                if (Value.getClass().getSimpleName().equals("BitSet")) {
                    if (((BitSet)Value).size() >= this.m_nSize * 8) {
                        Data = ((BitSet)Value).clone();
                        break;
                    }
                    throw new IllegalArgumentException("Register BitSet size must be " + this.m_nSize * 8 + ".");
                }
                throw new IllegalArgumentException("Register value must be BitSet.");
            }
            case 4: {
                if (Value.getClass().getSimpleName().equals("String")) {
                    Data = new String(((String)Value).toString());
                    break;
                }
                throw new IllegalArgumentException("Register value must be String.");
            }
            case 5: {
                if (Value.getClass().getSimpleName().equals("Byte[]")) {
                    Byte[] aByteValue = (Byte[])Value;
                    Data = new Byte[this.m_nSize];
                    int i = this.m_nSize - 1;
                    while (i >= 0) {
                        Data[i] = (byte)aByteValue[i];
                        --i;
                    }
                    break;
                }
                throw new IllegalArgumentException("Register value must be Byte[].");
            }
            case 6: 
            case 7: 
            case 8: {
                if (Value.getClass().getSimpleName().equals("Double")) {
                    Data = (double)((Double)Value);
                    break;
                }
                throw new IllegalArgumentException("Register value must be Double.");
            }
            default: {
                throw new IllegalArgumentException("Register data type is unknown or not supported.");
            }
        }
        if (isRead) {
            this.m_DataR = Data;
        } else {
            this.m_DataWQueue.add(Data);
        }
    }

    public boolean isAutoReadEnabled() {
        return this.m_isAutoReadEnabled;
    }

    public Object getGeneralCallbackParameter() {
        return this.m_GeneralCallbackParameter;
    }

    public void setAutoReadEnabled(boolean isAutoReadEnabled) {
        this.m_isAutoReadEnabled = isAutoReadEnabled;
    }
}

