/*
 * Decompiled with CFR 0.152.
 */
package com.fivecolibs.devices;

import com.fivecolibs.devices.FCOCDevice;
import com.fivecolibs.devices.FCOCRegisterBase;
import com.fivecolibs.devices.FCOEComState;
import com.fivecolibs.devices.FCOEDataEventType;
import com.fivecolibs.devices.FCOIDeviceEvent;
import com.fivecolibs.devices.FCOIPort;
import com.fivecolibs.utils.FCOCUtils;
import java.io.FileWriter;
import java.io.IOException;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.BitSet;
import java.util.Calendar;
import java.util.Date;
import java.util.Hashtable;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.springframework.util.StopWatch;

public class FCOCRAPDevice
extends FCOCDevice {
    protected static final String m_szLOGFILENAME = String.valueOf(System.getProperty("user.home")) + "\\Desktop\\FCOCRAPDevice.txt";
    private static Object m_LogFileMutex = new Object();
    protected static final boolean m_isTIMEDEBUGENABLED = false;
    public static final int m_nINITMAXPACKETSIZE = 128;
    protected int m_nMaxPacketSize = 128;
    protected int m_nPeriodTooShortCount = 0;
    private final int m_nLocalAddress;
    private int m_nRemoteAddress;
    private final boolean m_isNested;
    private final Hashtable<String, FCOCRAPDevice> m_OtherDevicesList = new Hashtable();
    private int m_nLastOtherDevice = 0;
    private final Hashtable<String, FCOCRAPDevice> m_NestedDevicesList = new Hashtable();
    private int m_nLastRoutedNestedDevice = 0;
    private int m_nInterface = 0;
    protected EDeviceSteps m_DevicesStep = EDeviceSteps.ThisDevice;
    private boolean m_isStillWaitingRead = false;
    protected FCOIPort m_CommPort;
    protected final ConcurrentLinkedQueue<FCOCDevice.CQueueElement> m_RequestQueue;
    protected final ConcurrentLinkedQueue<FCOCDevice.CQueueElement> m_AnswersQueue;

    public FCOCRAPDevice(int nNumberOfRegisters, int nBufferSize, long lThreadSleep, int nParentMaxBufferSize, FCOIPort CommunicationPort, int nLocalAddress, int nRemoteAddress, boolean isNested, int nInterface) throws IOException {
        super(nNumberOfRegisters, nBufferSize, lThreadSleep, nParentMaxBufferSize);
        if (nBufferSize > 128) {
            throw new IllegalArgumentException("This FRAP protocol implementation need an initial packet size not greater than 128 bytes!");
        }
        if (nLocalAddress < 1 || nLocalAddress > 255) {
            throw new IllegalArgumentException("Local address must be between 1 and 255 !");
        }
        if (nRemoteAddress < 0 || nRemoteAddress > 255) {
            throw new IllegalArgumentException("Remote address must be between 0 and 255 !");
        }
        this.m_RequestQueue = this.m_ReadQueue;
        this.m_AnswersQueue = this.m_ReadCallbackQueue;
        this.m_nLocalAddress = nLocalAddress;
        this.m_nRemoteAddress = nRemoteAddress;
        this.m_isNested = isNested;
        if (!isNested) {
            if (CommunicationPort == null) {
                throw new IllegalArgumentException("Invalid port object !");
            }
            this.m_CommPort = CommunicationPort;
            this.m_ComThread.start();
        } else {
            this.m_nInterface = nInterface;
            if (nInterface != -1 && (nInterface < 0 || nInterface > 15)) {
                throw new IllegalArgumentException("Interface num must be between 0 and 15 !");
            }
        }
    }

    public FCOCRAPDevice(int nNumberOfRegisters, int nBufferSize, long lThreadSleep, FCOIPort CommunicationPort, int nLocalAddress, int nRemoteAddress, boolean isNested, int nInterface) throws IOException {
        this(nNumberOfRegisters, nBufferSize, lThreadSleep, nBufferSize, CommunicationPort, nLocalAddress, nRemoteAddress, isNested, nInterface);
    }

    public FCOCRAPDevice(int nNumberOfRegisters, int nBufferSize, FCOIPort CommunicationPort, int nLocalAddress, int nRemoteAddress, boolean isNested, int nInterface) throws IOException {
        this(nNumberOfRegisters, nBufferSize, 1000L, nBufferSize, CommunicationPort, nLocalAddress, nRemoteAddress, isNested, nInterface);
    }

    @Override
    public void delete() {
        if (!this.m_ComThread.isAlive()) {
            return;
        }
        int nTimeout = 20;
        while (this.m_WriteQueue.size() > 0 && nTimeout-- > 0) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.m_isThreadEnabled = false;
        nTimeout = 20;
        while (this.m_ComThread.isAlive() && nTimeout-- > 0) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addDeviceListener(FCOIDeviceEvent DevListener) {
        super.addDeviceListener(DevListener);
        Hashtable<String, FCOCRAPDevice> hashtable = this.m_OtherDevicesList;
        synchronized (hashtable) {
            for (FCOCRAPDevice OtherDevice : this.m_OtherDevicesList.values()) {
                OtherDevice.addDeviceListener(DevListener);
            }
        }
        hashtable = this.m_NestedDevicesList;
        synchronized (hashtable) {
            for (FCOCRAPDevice OtherDevice : this.m_NestedDevicesList.values()) {
                OtherDevice.addDeviceListener(DevListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeDeviceListener(FCOIDeviceEvent DevListener) {
        this.m_ListenerList.remove(FCOIDeviceEvent.class, DevListener);
        Hashtable<String, FCOCRAPDevice> hashtable = this.m_OtherDevicesList;
        synchronized (hashtable) {
            for (FCOCRAPDevice OtherDevice : this.m_OtherDevicesList.values()) {
                OtherDevice.removeDeviceListener(DevListener);
            }
        }
        hashtable = this.m_NestedDevicesList;
        synchronized (hashtable) {
            for (FCOCRAPDevice OtherDevice : this.m_NestedDevicesList.values()) {
                OtherDevice.removeDeviceListener(DevListener);
            }
        }
    }

    @Override
    public void addRegister(String szRegisterName, int nRegisterAddress, int nRegisterSize, int nRegisterAccessType, int nDataType, boolean isAutoReadEnabled) throws IllegalArgumentException {
        if (nRegisterSize > 31) {
            throw new IllegalArgumentException("Register size cannot be greater than 31 for FRAP protocol !");
        }
        super.addRegister(szRegisterName, nRegisterAddress, nRegisterSize, nRegisterAccessType, nDataType, isAutoReadEnabled);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FCOCDevice addSubDevice(String szNestedDeviceName, int nSubAddress, int nNumberOfRegisters, int nInterface) throws IOException {
        Hashtable<String, FCOCRAPDevice> hashtable = this.m_NestedDevicesList;
        synchronized (hashtable) {
            if (this.m_NestedDevicesList.containsKey(szNestedDeviceName)) {
                System.out.println("Unable to add " + szNestedDeviceName + " because it already exists.");
                return this.m_NestedDevicesList.get(szNestedDeviceName);
            }
            FCOCRAPDevice NestedDevice = new FCOCRAPDevice(nNumberOfRegisters, 128, null, 255, nSubAddress, true, nInterface);
            FCOIDeviceEvent[] listeners = this.getDeviceListeners();
            int i = listeners.length - 1;
            while (i >= 0) {
                NestedDevice.addDeviceListener(listeners[i]);
                --i;
            }
            this.m_NestedDevicesList.put(szNestedDeviceName, NestedDevice);
            return NestedDevice;
        }
    }

    @Override
    public void removeSubDevice(String szNestedDeviceName) {
        this.m_NestedDevicesList.remove(szNestedDeviceName);
    }

    @Override
    public void setThreadLoopTime(long lThreadSleep) {
        if (this.m_lThreadLoopTime < lThreadSleep) {
            this.m_nPeriodTooShortCount = -50;
        }
        super.setThreadLoopTime(lThreadSleep);
    }

    @Override
    public int getInterface() {
        return this.m_nInterface;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FCOCDevice addOtherDevice(String szOtherDeviceName, int nAddress, int nNumberOfRegisters) throws IOException {
        Hashtable<String, FCOCRAPDevice> hashtable = this.m_OtherDevicesList;
        synchronized (hashtable) {
            if (this.m_OtherDevicesList.containsKey(szOtherDeviceName)) {
                System.out.println("Unable to add " + szOtherDeviceName + " because it already exists.");
                return this.m_OtherDevicesList.get(szOtherDeviceName);
            }
            FCOCRAPDevice OtherDevice = new FCOCRAPDevice(nNumberOfRegisters, 128, null, this.m_nLocalAddress, nAddress, true, -1);
            FCOIDeviceEvent[] listeners = this.getDeviceListeners();
            int i = listeners.length - 1;
            while (i >= 0) {
                OtherDevice.addDeviceListener(listeners[i]);
                --i;
            }
            this.m_OtherDevicesList.put(szOtherDeviceName, OtherDevice);
            return OtherDevice;
        }
    }

    public void removeOtherDevice(String szOtherDeviceName) {
        this.m_OtherDevicesList.remove(szOtherDeviceName);
    }

    public void setNewRemoteAddress(int nRemoteAddress) {
        if (nRemoteAddress < 0 || nRemoteAddress > 255) {
            throw new IllegalArgumentException("Remote address must be between 0 and 255 !");
        }
        this.m_nRemoteAddress = nRemoteAddress;
    }

    public int getRemoteAddress() {
        return this.m_nRemoteAddress;
    }

    public FCOIPort getCommunicationPort() {
        return this.m_CommPort;
    }

    @Override
    public void setMaxParentBufferSize(int nParentMaxBufferSize) {
        super.setMaxParentBufferSize(nParentMaxBufferSize);
        if (this.m_nMaxPacketSize > this.m_nBufferSize) {
            this.m_nMaxPacketSize = this.m_nBufferSize;
        }
    }

    @Override
    public void setBufferSize(int nBufferSize) {
        if (nBufferSize <= this.m_nParentMaxBufferSize) {
            super.setBufferSize(nBufferSize);
        } else {
            this.m_nBufferSize = this.m_nParentMaxBufferSize;
        }
        if (this.m_nMaxPacketSize > this.m_nBufferSize) {
            this.m_nMaxPacketSize = this.m_nBufferSize;
        }
    }

    public int setMaxPacketSize(int nMaxPacketSize) {
        if (nMaxPacketSize > this.m_nBufferSize) {
            nMaxPacketSize = this.m_nBufferSize;
        }
        if (nMaxPacketSize > this.m_nParentMaxBufferSize) {
            nMaxPacketSize = this.m_nParentMaxBufferSize;
        }
        this.m_nMaxPacketSize = nMaxPacketSize;
        return this.m_nMaxPacketSize;
    }

    public int getMaxPacketSize() {
        return this.m_nMaxPacketSize;
    }

    @Override
    protected void addElementToReadQueue(FCOCDevice.CQueueElement Element) {
        this.m_RequestQueue.add(Element);
    }

    @Override
    protected void addElementToWriteQueue(FCOCRegisterBase Register) {
        this.m_RequestQueue.add(new FCOCDevice.CQueueElement(this, Register, null, false));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean isReadQueueContains(FCOCRegisterBase Register) {
        boolean isPresent = false;
        ConcurrentLinkedQueue<FCOCDevice.CQueueElement> concurrentLinkedQueue = this.m_RequestQueue;
        synchronized (concurrentLinkedQueue) {
            for (FCOCDevice.CQueueElement QueueElementItem : this.m_RequestQueue) {
                if (QueueElementItem.m_Register != Register || !QueueElementItem.m_isReadRequest) continue;
                isPresent = true;
                break;
            }
        }
        return isPresent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean isWriteQueueContains(FCOCRegisterBase Register) {
        boolean isPresent = false;
        ConcurrentLinkedQueue<FCOCDevice.CQueueElement> concurrentLinkedQueue = this.m_RequestQueue;
        synchronized (concurrentLinkedQueue) {
            for (FCOCDevice.CQueueElement QueueElementItem : this.m_RequestQueue) {
                if (QueueElementItem.m_Register != Register || QueueElementItem.m_isReadRequest) continue;
                isPresent = true;
            }
        }
        return isPresent;
    }

    @Override
    protected int fillBufferWithData(FCOCRegisterBase Register, byte[] acBuffer, int nOffset) {
        acBuffer[nOffset++] = (byte)(64 + Register.getSize());
        acBuffer[nOffset++] = (byte)Register.getAddress();
        Object DataToWrite = Register.getDataToWrite();
        if (DataToWrite != null) {
            switch (Register.getDataType()) {
                case 0: 
                case 1: {
                    long lValue = (Long)DataToWrite;
                    int i = 0;
                    while (i < Register.getSize()) {
                        acBuffer[nOffset++] = (byte)(lValue >> i * 8 & 0xFFL);
                        ++i;
                    }
                    break;
                }
                case 3: {
                    double dPercent = (Double)DataToWrite;
                    long lPercent = (long)(Math.pow(2.0, Register.getSize() * 8) * dPercent / 100.0);
                    if ((double)lPercent > Math.pow(2.0, Register.getSize() * 8) - 1.0) {
                        lPercent = (long)(Math.pow(2.0, Register.getSize() * 8) - 1.0);
                    }
                    int i = 0;
                    while (i < Register.getSize()) {
                        acBuffer[nOffset++] = (byte)(lPercent >> i * 8 & 0xFFL);
                        ++i;
                    }
                    break;
                }
                case 2: {
                    BitSet Data = (BitSet)DataToWrite;
                    int i = 0;
                    while (i < Register.getSize()) {
                        byte cTemp = 0;
                        int j = 0;
                        while (j < 8) {
                            if (Data.get(8 * i + j)) {
                                cTemp = (byte)(cTemp | 1 << j);
                            }
                            ++j;
                        }
                        acBuffer[nOffset++] = cTemp;
                        ++i;
                    }
                    break;
                }
                case 4: {
                    String szText = (String)DataToWrite;
                    if (szText.length() > Register.getSize()) {
                        szText = szText.substring(0, Register.getSize() - 1);
                    }
                    byte[] acText = szText.getBytes();
                    int i = 0;
                    while (i < Register.getSize()) {
                        acBuffer[nOffset++] = i < szText.length() ? acText[i] : (byte)0;
                        ++i;
                    }
                    break;
                }
                case 5: {
                    Byte[] aByte = (Byte[])DataToWrite;
                    int i = 0;
                    while (i < Register.getSize()) {
                        acBuffer[nOffset++] = aByte[i];
                        ++i;
                    }
                    break;
                }
                case 6: {
                    double dValue = (Double)DataToWrite;
                    long lValue = (long)(dValue * Math.pow(2.0, 8 * Register.getSize() / 2));
                    int i = 0;
                    while (i < Register.getSize()) {
                        acBuffer[nOffset++] = (byte)(lValue >> i * 8 & 0xFFL);
                        ++i;
                    }
                    break;
                }
                case 7: {
                    double dValue = (Double)DataToWrite;
                    long lValue = (long)(dValue * Math.pow(2.0, 24 * Register.getSize() / 4));
                    int i = 0;
                    while (i < Register.getSize()) {
                        acBuffer[nOffset++] = (byte)(lValue >> i * 8 & 0xFFL);
                        ++i;
                    }
                    break;
                }
                case 8: {
                    double dValue = (Double)DataToWrite;
                    long lValue = (long)(dValue * Math.pow(2.0, 8 * Register.getSize() / 4));
                    int i = 0;
                    while (i < Register.getSize()) {
                        acBuffer[nOffset++] = (byte)(lValue >> i * 8 & 0xFFL);
                        ++i;
                    }
                    break;
                }
                default: {
                    nOffset += Register.getSize();
                }
            }
        }
        return nOffset;
    }

    @Override
    protected int getDataFromBuffer(FCOCRegisterBase Register, byte[] acBuffer, int nOffset) {
        switch (Register.getDataType()) {
            case 0: 
            case 1: 
            case 3: 
            case 6: 
            case 7: 
            case 8: {
                long lValue = 0L;
                int i = 0;
                while (i < Register.getSize()) {
                    long lMask = i == Register.getSize() - 1 && (Register.getDataType() == 0 || Register.getDataType() == 6 || Register.getDataType() == 7 || Register.getDataType() == 8) ? -1L : 255L;
                    lValue |= ((long)acBuffer[nOffset++] & lMask) << i * 8;
                    ++i;
                }
                if (Register.getDataType() == 3) {
                    Register.setDataRead((double)(100L * lValue) / Math.pow(2.0, Register.getSize() * 8));
                    break;
                }
                if (Register.getDataType() == 6) {
                    Register.setDataRead((double)lValue / Math.pow(2.0, 8 * Register.getSize() / 2));
                    break;
                }
                if (Register.getDataType() == 7) {
                    Register.setDataRead((double)lValue / Math.pow(2.0, 24 * Register.getSize() / 4));
                    break;
                }
                if (Register.getDataType() == 8) {
                    Register.setDataRead((double)lValue / Math.pow(2.0, 8 * Register.getSize() / 4));
                    break;
                }
                Register.setDataRead(lValue);
                break;
            }
            case 2: {
                BitSet Data = new BitSet(Register.getSize() * 8);
                int i = 0;
                while (i < Register.getSize()) {
                    byte cTemp = acBuffer[nOffset++];
                    int j = 0;
                    while (j < 8) {
                        if ((cTemp & 1 << j) == 1 << j) {
                            Data.set(8 * i + j);
                        }
                        ++j;
                    }
                    ++i;
                }
                Register.setDataRead(Data);
                break;
            }
            case 4: {
                Register.setDataRead(FCOCUtils.byteArrayToString(acBuffer, nOffset, Register.getSize()));
                nOffset += Register.getSize();
                break;
            }
            case 5: {
                Byte[] aData = new Byte[Register.getSize()];
                int i = 0;
                while (i < Register.getSize()) {
                    aData[i] = acBuffer[nOffset++];
                    ++i;
                }
                Register.setDataRead(aData);
                break;
            }
            default: {
                nOffset += Register.getSize();
            }
        }
        return nOffset;
    }

    /*
     * Unable to fully structure code
     */
    protected FCOCDevice.CGetNextPacketResult createRequest(byte[] acBuffer, int nBufferOffset, boolean isPreviousReadStillWaiting, int nMaxTxBufSize, int nMaxRxBufSize, int nInitialReturnBufSize) {
        block15: {
            block16: {
                nInitialBufferOffset = nBufferOffset;
                nReturnBufSize = nInitialReturnBufSize;
                if (!isPreviousReadStillWaiting) {
                    this.addAutoreadRegisterToQueue();
                }
                if (FCOCRAPDevice.m_isDebugLogEnabled) {
                    this.writeComLog("Max size used: \tTx=" + (nMaxTxBufSize - nBufferOffset) + "\tRx=" + (nMaxRxBufSize - nInitialReturnBufSize), null, 0, 0, false);
                }
                if (this.m_RequestQueue.size() <= 0) break block15;
                acBuffer[nBufferOffset + 0] = (byte)this.m_nRemoteAddress;
                acBuffer[nBufferOffset + 1] = (byte)this.m_nLocalAddress;
                if (this.m_nRemoteAddress != 0) {
                    acBuffer[nBufferOffset + 4] = -31;
                    acBuffer[nBufferOffset + 5] = (byte)this.m_nUniqueID++;
                    nBufferOffset += 6;
                    nReturnBufSize += 8;
                } else {
                    nBufferOffset += 4;
                }
                QueuEl = this.m_RequestQueue.peek();
                if (QueuEl == null || QueuEl.m_Register == null) break block16;
                do {
                    Register = QueuEl.m_Register;
                    if (QueuEl.m_isReadRequest) ** GOTO lbl30
                    if (nBufferOffset + Register.getSize() + 2 < nMaxTxBufSize - 2) {
                        this.m_RequestQueue.poll();
                        nBufferOffset = this.fillBufferWithData(Register, acBuffer, nBufferOffset);
                    } else {
                        if (!FCOCRAPDevice.m_isDebugLogEnabled) break;
                        this.fireComDevEvtOccured(this, FCOEComState.FRAGMENTED);
                        break;
lbl30:
                        // 1 sources

                        if (nBufferOffset + 2 < nMaxTxBufSize - 2 && nReturnBufSize + Register.getSize() + 2 < nMaxRxBufSize) {
                            QueuEl = this.m_RequestQueue.poll();
                            acBuffer[nBufferOffset++] = (byte)(0 + Register.getSize());
                            acBuffer[nBufferOffset++] = (byte)Register.getAddress();
                            nReturnBufSize += 2 + Register.getSize();
                        } else {
                            if (!FCOCRAPDevice.m_isDebugLogEnabled) break;
                            this.fireComDevEvtOccured(this, FCOEComState.FRAGMENTED);
                            break;
                        }
                    }
                    QueuEl.m_nFrameID = this.m_nUniqueID - 1;
                    this.m_AnswersQueue.add(QueuEl);
                } while ((QueuEl = this.m_RequestQueue.peek()) != null);
            }
            acBuffer[nBufferOffset++] = -29;
            nSize = nBufferOffset - 3 - nInitialBufferOffset;
            if (nSize < 128) {
                i = nInitialBufferOffset + 4;
                while (i < nBufferOffset) {
                    acBuffer[i - 1] = acBuffer[i];
                    ++i;
                }
                --nBufferOffset;
                acBuffer[nInitialBufferOffset + 2] = (byte)(nSize & 127);
            } else {
                acBuffer[nInitialBufferOffset + 2] = (byte)((byte)nSize | 128);
                acBuffer[nInitialBufferOffset + 3] = (byte)(nSize >> 7 & 127);
            }
            if (nSize > 16383) {
                System.err.println("FCORAPDevice: Packet size is > 16383 !");
            }
            if (nReturnBufSize < 132) {
                --nReturnBufSize;
            }
            nChecksum = 0;
            i = nInitialBufferOffset;
            while (i < nBufferOffset) {
                nChecksum += acBuffer[i];
                ++i;
            }
            acBuffer[nBufferOffset++] = (byte)(nChecksum & 255);
        }
        return new FCOCDevice.CGetNextPacketResult(this, nBufferOffset, nReturnBufSize, this.m_RequestQueue.size() > 0, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    protected int handleAnswer(int nBytesReceived, byte[] acBuffer, int nBufferOffset, Object Destination) {
        block39: {
            block35: {
                block36: {
                    block37: {
                        block38: {
                            nWaitingUniqueID = this.m_nUniqueID - 1;
                            nHeaderSize = 3;
                            if (nBytesReceived < 6 || this.m_nRemoteAddress != 0 && acBuffer[nBufferOffset + 1] != (byte)this.m_nRemoteAddress || !this.m_isNested && acBuffer[nBufferOffset] != (byte)this.m_nLocalAddress) break block35;
                            nInitialBufferOffset = nBufferOffset;
                            nRxSize = acBuffer[nInitialBufferOffset + 2] & 127;
                            if ((acBuffer[nInitialBufferOffset + 2] & 128) != 0) {
                                nRxSize += acBuffer[nInitialBufferOffset + 3] * 128;
                                nHeaderSize = 4;
                            }
                            if (nRxSize > 16383) {
                                System.err.println("Frap cannot handle packet bigger than 16383");
                                this.fireComDevEvtOccured(this, FCOEComState.FRAMESIZEERROR);
                                return 0;
                            }
                            if (nBytesReceived < nRxSize + 3) break block36;
                            nChecksum = 0;
                            i = nInitialBufferOffset;
                            while (i < nInitialBufferOffset + nRxSize + nHeaderSize - 1) {
                                nChecksum += acBuffer[i];
                                ++i;
                            }
                            if (acBuffer[nInitialBufferOffset + nRxSize + nHeaderSize - 1] != (byte)nChecksum) break block37;
                            if ((acBuffer[nBufferOffset += nHeaderSize] & 248) != 208 && Destination != this) {
                                return 0;
                            }
                            if ((acBuffer[nBufferOffset] & 208) != 208 && (acBuffer[nBufferOffset] & 228) != 228 && this.m_nRemoteAddress != 0 && (acBuffer[nBufferOffset++] != -30 || acBuffer[nBufferOffset++] != (byte)nWaitingUniqueID)) break block38;
                            i = nBufferOffset;
                            while (i < nRxSize + nInitialBufferOffset + nHeaderSize - 2) {
                                switch (acBuffer[i] & 255) {
                                    case 32: 
                                    case 33: 
                                    case 34: 
                                    case 35: 
                                    case 36: 
                                    case 37: 
                                    case 38: 
                                    case 39: 
                                    case 40: 
                                    case 41: 
                                    case 42: 
                                    case 43: 
                                    case 44: 
                                    case 45: 
                                    case 46: 
                                    case 47: 
                                    case 48: 
                                    case 49: 
                                    case 50: 
                                    case 51: 
                                    case 52: 
                                    case 53: 
                                    case 54: 
                                    case 55: 
                                    case 56: 
                                    case 57: 
                                    case 58: 
                                    case 59: 
                                    case 60: 
                                    case 61: 
                                    case 62: 
                                    case 63: {
                                        y = i;
                                        var13_16 = this.m_aRegistersList;
                                        synchronized (var13_16) {
                                            while ((QueuEl = this.m_AnswersQueue.poll()) != null) {
                                                if (QueuEl.m_nFrameID != nWaitingUniqueID || !QueuEl.m_isReadRequest) continue;
                                                RegisterItem = QueuEl.m_Register;
                                                if (RegisterItem.getAddress() == (acBuffer[i + 1] & 255) && RegisterItem.getSize() == (acBuffer[i] & 31)) {
                                                    y = this.getDataFromBuffer(RegisterItem, acBuffer, i + 2) - 1;
                                                    this.fireDataDevEvtOccured(this, this.getKeyFromValue(RegisterItem, this.m_aRegistersList), RegisterItem.getDataRead(), FCOEDataEventType.VALIDDATAEVENT, QueuEl.m_CallbackParameter);
                                                } else {
                                                    System.out.println("FCOCRAPDevice error: Register address in answer is not the one expected !");
                                                    this.fireComDevEvtOccured(this, FCOEComState.FRAMEDATAERROR);
                                                }
                                                ** GOTO lbl47
                                            }
                                            System.out.println("FCOCRAPDevice error: Unexpected data in answer packet !");
                                            this.fireComDevEvtOccured(this, FCOEComState.FRAMEDATAERROR);
                                        }
lbl47:
                                        // 3 sources

                                        i = y;
                                        break;
                                    }
                                    case 208: 
                                    case 209: 
                                    case 210: 
                                    case 211: 
                                    case 212: 
                                    case 213: 
                                    case 214: 
                                    case 215: {
                                        nInterface = acBuffer[i++] & 15;
                                        nRouteSize = acBuffer[i] & 127;
                                        if ((acBuffer[i++] & 128) != 0) {
                                            nRouteSize += acBuffer[i++] * 128;
                                        }
                                        var15_20 = this.m_NestedDevicesList;
                                        synchronized (var15_20) {
                                            for (FCOCRAPDevice NestedDevice : this.m_NestedDevicesList.values()) {
                                                if (NestedDevice.getInterface() != nInterface) continue;
                                                nOffsetShift = NestedDevice.handleAnswer(nRouteSize, acBuffer, i, Destination);
                                                i += nOffsetShift;
                                                if (nOffsetShift > 0) break;
                                            }
                                            break;
                                        }
                                    }
                                    case 224: {
                                        var15_20 = this.m_aRegistersList;
                                        synchronized (var15_20) {
                                            while ((QueuEl = this.m_AnswersQueue.poll()) != null) {
                                                if (QueuEl.m_nFrameID != nWaitingUniqueID) continue;
                                                RegisterItem = QueuEl.m_Register;
                                                if (RegisterItem.getAddress() == (acBuffer[i + 1] & 255)) {
                                                    CallbackPara = QueuEl.m_CallbackParameter;
                                                    if (!QueuEl.m_isReadRequest) {
                                                        CallbackPara = RegisterItem.getGeneralCallbackParameter();
                                                    }
                                                    this.fireDataDevEvtOccured(this, this.getKeyFromValue(RegisterItem, this.m_aRegistersList), null, FCOEDataEventType.INVALIDREGACCESS, CallbackPara);
                                                } else {
                                                    System.out.println("FCOCRAPDevice error: Register address in answer is not the one expected !");
                                                    this.fireComDevEvtOccured(this, FCOEComState.UNKNOWNERROR);
                                                }
                                                ** GOTO lbl87
                                            }
                                            System.out.println("FCOCRAPDevice error: Unexpected data in answer packet !");
                                            this.fireComDevEvtOccured(this, FCOEComState.UNKNOWNERROR);
                                        }
lbl87:
                                        // 3 sources

                                        ++i;
                                        break;
                                    }
                                    case 227: {
                                        break;
                                    }
                                    case 228: {
                                        this.fireComDevEvtOccured(this, FCOEComState.FRAMEDATAERROR);
                                        break;
                                    }
                                    default: {
                                        this.fireComDevEvtOccured(this, FCOEComState.UNKNOWNERROR);
                                    }
                                }
                                ++i;
                            }
                            return i;
                        }
                        System.out.println("FCOCRAPDevice error: FRAP handleAnswer frame ID error !");
                        this.fireComDevEvtOccured(this, FCOEComState.FRAMEIDERROR);
                        return nInitialBufferOffset + nBytesReceived;
                    }
                    System.out.println("FCOCRAPDevice error: FRAP handleAnswer checksum error !");
                    this.fireComDevEvtOccured(this, FCOEComState.CHECKSUMERROR);
                    return nInitialBufferOffset + nBytesReceived;
                }
                System.out.println("FCOCRAPDevice error: FRAP handleAnswer size error !");
                this.fireComDevEvtOccured(this, FCOEComState.FRAMESIZEERROR);
                break block39;
            }
            if (!this.m_isNested && acBuffer[nBufferOffset] == (byte)this.m_nLocalAddress) {
                var8_8 = this.m_OtherDevicesList;
                synchronized (var8_8) {
                    for (FCOCRAPDevice OtherDevice : this.m_OtherDevicesList.values()) {
                        if (acBuffer[nBufferOffset + 1] != (byte)OtherDevice.getRemoteAddress() || !Destination.equals(OtherDevice)) continue;
                        return OtherDevice.handleAnswer(nBytesReceived, acBuffer, nBufferOffset, Destination);
                    }
                }
            }
        }
        return 0;
    }

    protected synchronized boolean isNextMain() {
        return this.m_DevicesStep == EDeviceSteps.ThisDevice;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized FCOCDevice.CGetNextPacketResult getNextPacket(byte[] acBuffer, int nBufferOffset, boolean isMainDevice, int nMaxTxBufSize, int nMaxRxBufSize, int nReturnBufSize) {
        FCOCDevice.CGetNextPacketResult Return = new FCOCDevice.CGetNextPacketResult(this, nBufferOffset, 0, false, this);
        int nInitialBufferOffset = nBufferOffset;
        int nInitialReturnBufSize = nReturnBufSize;
        block15: while (true) {
            switch (this.m_DevicesStep) {
                case NestedDevices: {
                    Hashtable<String, FCOCRAPDevice> hashtable = this.m_NestedDevicesList;
                    synchronized (hashtable) {
                        if (!this.m_NestedDevicesList.isEmpty()) {
                            while (true) {
                                if (this.m_nLastRoutedNestedDevice >= this.m_NestedDevicesList.size()) {
                                    this.m_nLastRoutedNestedDevice = 0;
                                    break;
                                }
                                try {
                                    int i;
                                    FCOCRAPDevice NextToRoute = (FCOCRAPDevice)this.m_NestedDevicesList.values().toArray()[this.m_nLastRoutedNestedDevice];
                                    acBuffer[nBufferOffset++] = (byte)this.m_nRemoteAddress;
                                    acBuffer[nBufferOffset++] = (byte)this.m_nLocalAddress;
                                    nBufferOffset += 2;
                                    acBuffer[nBufferOffset++] = (byte)(192 + (NextToRoute.getInterface() & 0xF));
                                    acBuffer[nBufferOffset++] = -1;
                                    nReturnBufSize += 7;
                                    int nRoutePacketOffset = nBufferOffset += 2;
                                    int nSubPacketSize = NextToRoute.getBufferSize() - 2;
                                    if (nSubPacketSize > nMaxTxBufSize - 2) {
                                        nSubPacketSize = nMaxTxBufSize - 2;
                                    }
                                    Return = NextToRoute.getNextPacket(acBuffer, nBufferOffset, false, nSubPacketSize, nSubPacketSize, nReturnBufSize);
                                    int nSize = Return.m_nBufferOffset - nRoutePacketOffset;
                                    if (nSize == 0) {
                                        ++this.m_nLastRoutedNestedDevice;
                                        Return.m_nBufferOffset = nBufferOffset -= 8;
                                        continue;
                                    }
                                    if (nSize < 128) {
                                        int nRemoveBytes = 1;
                                        acBuffer[nRoutePacketOffset - 2] = (byte)(nSize & 0x7F);
                                        nSize = Return.m_nBufferOffset - 3 - nInitialBufferOffset;
                                        if (nSize < 128) {
                                            ++nRemoveBytes;
                                            acBuffer[nInitialBufferOffset + 2] = (byte)(nSize & 0x7F);
                                            i = nInitialBufferOffset + 4;
                                            while (i < nRoutePacketOffset - 1) {
                                                acBuffer[i - 1] = acBuffer[i];
                                                ++i;
                                            }
                                        }
                                        i = nRoutePacketOffset;
                                        while (i < Return.m_nBufferOffset) {
                                            acBuffer[i - nRemoveBytes] = acBuffer[i];
                                            ++i;
                                        }
                                        Return.m_nBufferOffset -= nRemoveBytes;
                                    } else {
                                        acBuffer[nRoutePacketOffset - 2] = (byte)(nSize | 0x80);
                                        acBuffer[nRoutePacketOffset - 1] = (byte)(nSize >> 7 & 0x7F);
                                        if (nSize > 16383) {
                                            System.err.println("Size of Message to Route is bigger than 16383");
                                        }
                                        nSize = Return.m_nBufferOffset - 2 - nInitialBufferOffset;
                                        acBuffer[nInitialBufferOffset + 2] = (byte)(nSize | 0x80);
                                        acBuffer[nInitialBufferOffset + 3] = (byte)(nSize >> 7 & 0x7F);
                                        if (nSize > 16383) {
                                            System.err.println("Size of Message to send is bigger than 16383");
                                        }
                                    }
                                    acBuffer[Return.m_nBufferOffset++] = -29;
                                    Return.m_nExpectedReturnBufSize += 9;
                                    int nChecksum = 0;
                                    i = nInitialBufferOffset;
                                    while (i < Return.m_nBufferOffset) {
                                        nChecksum += acBuffer[i];
                                        ++i;
                                    }
                                    acBuffer[Return.m_nBufferOffset++] = (byte)(nChecksum & 0xFF);
                                    if (!Return.m_isNotFinished) {
                                        ++this.m_nLastRoutedNestedDevice;
                                        if (this.m_nLastRoutedNestedDevice >= this.m_NestedDevicesList.size()) {
                                            this.m_nLastRoutedNestedDevice = 0;
                                            break;
                                        }
                                        Return.m_isNotFinished = true;
                                    }
                                    return Return;
                                }
                                catch (ArrayIndexOutOfBoundsException Exc) {
                                    this.m_nLastRoutedNestedDevice = 0;
                                    continue;
                                }
                                break;
                            }
                        }
                    }
                    if (!isMainDevice) {
                        this.m_DevicesStep = EDeviceSteps.ThisDevice;
                        if (Return.m_nExpectedReturnBufSize == 0) continue block15;
                        return Return;
                    }
                    this.m_DevicesStep = EDeviceSteps.OtherDevices;
                    if (Return.m_nBufferOffset != 0) {
                        return Return;
                    }
                }
                case OtherDevices: {
                    Hashtable<String, FCOCRAPDevice> hashtable = this.m_OtherDevicesList;
                    synchronized (hashtable) {
                        if (!this.m_OtherDevicesList.isEmpty()) {
                            while (true) {
                                if (this.m_nLastOtherDevice >= this.m_OtherDevicesList.size()) {
                                    this.m_nLastOtherDevice = 0;
                                    break;
                                }
                                try {
                                    int nOtherPacketOffset = nBufferOffset;
                                    FCOCRAPDevice OtherDevice = (FCOCRAPDevice)this.m_OtherDevicesList.values().toArray()[this.m_nLastOtherDevice];
                                    Return = OtherDevice.getNextPacket(acBuffer, nBufferOffset, false, OtherDevice.getBufferSize(), OtherDevice.getBufferSize(), nReturnBufSize);
                                    int nSize = Return.m_nBufferOffset - nOtherPacketOffset;
                                    if (nSize == 0) {
                                        ++this.m_nLastOtherDevice;
                                        continue;
                                    }
                                    if (!Return.m_isNotFinished) {
                                        ++this.m_nLastOtherDevice;
                                        if (this.m_nLastOtherDevice >= this.m_OtherDevicesList.size()) {
                                            this.m_nLastOtherDevice = 0;
                                            break;
                                        }
                                        Return.m_isNotFinished = true;
                                    }
                                    return Return;
                                }
                                catch (ArrayIndexOutOfBoundsException Exc) {
                                    this.m_nLastOtherDevice = 0;
                                    continue;
                                }
                                break;
                            }
                        }
                    }
                    if (this.getClass() != FCOCRAPDevice.class) {
                        this.m_DevicesStep = EDeviceSteps.Remote;
                        return Return;
                    }
                }
                default: {
                    this.m_DevicesStep = EDeviceSteps.ThisDevice;
                    if (!isMainDevice) break block15;
                    return Return;
                }
                case ThisDevice: 
            }
            break;
        }
        Return = this.createRequest(acBuffer, nInitialBufferOffset, this.m_isStillWaitingRead, nMaxTxBufSize, nMaxRxBufSize, nInitialReturnBufSize);
        this.m_isStillWaitingRead = Return.m_isNotFinished;
        if (!(this.m_isStillWaitingRead || isMainDevice || this.m_NestedDevicesList.isEmpty())) {
            Return.m_isNotFinished = true;
        }
        if (!this.m_isStillWaitingRead) {
            this.m_DevicesStep = EDeviceSteps.NestedDevices;
        }
        return Return;
    }

    @Override
    protected void fireComDevEvtOccured(FCOCDevice Source, FCOEComState ComState) {
        if (m_isDebugLogEnabled) {
            this.writeComLog("Com state event : " + ComState.toString(), null, 0, 0, ComState != FCOEComState.FRAGMENTED);
        }
        super.fireComDevEvtOccured(Source, ComState);
    }

    protected int[] getDataSize(byte[] acBuffer, int nDataSizeIndex) {
        int nDataLength;
        if ((nDataLength = acBuffer[nDataSizeIndex++] & 0xFF) > 127) {
            if ((acBuffer[nDataSizeIndex] & 0x80) == 128) {
                System.err.println("FCOCRAPDevice error : Packet size > 16383");
            }
            nDataLength = (nDataLength & 0x7F) + (acBuffer[nDataSizeIndex++] & 0xFF) * 128;
        }
        int[] anResult = new int[]{nDataLength, nDataSizeIndex};
        return anResult;
    }

    private int printMsg(byte[] acBuffer, int nFirstIndex, int nLastIndex, String[] aszMsg) {
        int[] anDataSize = this.getDataSize(acBuffer, nFirstIndex + 2);
        int i = nFirstIndex;
        while (i < nLastIndex) {
            block5: {
                String szExt;
                block7: {
                    block3: {
                        block6: {
                            String[] aszSubMsg;
                            int[] anNestLength;
                            block4: {
                                szExt = "";
                                if (i != nFirstIndex + 3) break block3;
                                if (anDataSize[0] <= 127) {
                                    aszMsg[0] = String.valueOf(aszMsg[0]) + "-- ";
                                } else {
                                    aszMsg[0] = String.valueOf(aszMsg[0]) + FCOCUtils.toHexString(acBuffer[i] & 0xFF) + " ";
                                    ++i;
                                }
                                if ((acBuffer[i] & 0xF0) != 192) break block4;
                                anNestLength = this.getDataSize(acBuffer, i + 2);
                                aszSubMsg = new String[]{""};
                                aszMsg[0] = String.valueOf(aszMsg[0]) + FCOCUtils.toHexString(acBuffer[i] & 0xFF) + " " + FCOCUtils.toHexString(acBuffer[i + 1] & 0xFF) + " " + FCOCUtils.toHexString(acBuffer[i + 2] & 0xFF) + " " + (anNestLength[1] > i + 3 ? FCOCUtils.toHexString(acBuffer[i + 3] & 0xFF) : "--") + "[";
                                i = this.printMsg(acBuffer, anNestLength[1], nLastIndex - 2, aszMsg);
                                aszMsg[0] = String.valueOf(aszMsg[0]) + aszSubMsg[0] + "]";
                                break block5;
                            }
                            if ((acBuffer[i] & 0xF0) != 208) break block6;
                            anNestLength = this.getDataSize(acBuffer, i + 1);
                            aszSubMsg = new String[]{""};
                            aszMsg[0] = String.valueOf(aszMsg[0]) + FCOCUtils.toHexString(acBuffer[i] & 0xFF) + "    " + FCOCUtils.toHexString(acBuffer[i + 1] & 0xFF) + " " + (anNestLength[1] > i + 2 ? FCOCUtils.toHexString(acBuffer[i + 2] & 0xFF) : "--") + "[";
                            i = this.printMsg(acBuffer, anNestLength[1], nLastIndex - 2, aszMsg);
                            aszMsg[0] = String.valueOf(aszMsg[0]) + aszSubMsg[0] + "]";
                            break block5;
                        }
                        szExt = " ";
                        break block7;
                    }
                    szExt = " ";
                }
                aszMsg[0] = String.valueOf(aszMsg[0]) + FCOCUtils.toHexString(acBuffer[i] & 0xFF) + szExt;
            }
            ++i;
        }
        aszMsg[0] = aszMsg[0].substring(0, aszMsg[0].length() - 1);
        return i - 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeComLog(String szDesc, byte[] acBuffer, int nFirstIndex, int nLastIndex, boolean addExtraReturn) {
        NumberFormat NbrFormat = NumberFormat.getInstance();
        NbrFormat.setMinimumIntegerDigits(3);
        Date now = new Date();
        SimpleDateFormat df = new SimpleDateFormat("dd.MM.yyyy  hh:mm:ss:SSS ");
        String currentTime = df.format(now);
        Object object = m_LogFileMutex;
        synchronized (object) {
            try {
                Throwable throwable = null;
                Object var12_14 = null;
                try (FileWriter aWriter = new FileWriter(m_szLOGFILENAME, true);){
                    aWriter.write(String.valueOf(System.getProperty("line.separator")) + currentTime + " " + szDesc);
                    if (nFirstIndex < nLastIndex) {
                        int[] anDataSize = this.getDataSize(acBuffer, nFirstIndex + 2);
                        aWriter.write(" (data length=" + NbrFormat.format(anDataSize[0]) + "):");
                        String[] aszMsg = new String[]{" "};
                        this.printMsg(acBuffer, nFirstIndex, nLastIndex, aszMsg);
                        aWriter.write(aszMsg[0]);
                    }
                    if (addExtraReturn) {
                        aWriter.write(System.getProperty("line.separator"));
                    }
                    aWriter.flush();
                    aWriter.close();
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * Exception decompiling
     */
    private String debugDecode(String szMsg, String szAddSpace) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Can't sort instructions [@NONE, blocks:[0, 10] lbl155 : CaseStatement: default:\u000a, @NONE, blocks:[0, 10] lbl155 : CaseStatement: default:\u000a]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:25)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:8)
         *     at java.base/java.util.TimSort.countRunAndMakeAscending(TimSort.java:360)
         *     at java.base/java.util.TimSort.sort(TimSort.java:220)
         *     at java.base/java.util.Arrays.sort(Arrays.java:1308)
         *     at java.base/java.util.ArrayList.sort(ArrayList.java:1804)
         *     at java.base/java.util.Collections.sort(Collections.java:178)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.buildSwitchCases(SwitchReplacer.java:271)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitch(SwitchReplacer.java:258)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitches(SwitchReplacer.java:66)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:517)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void run() {
        byte[] acBuffer = new byte[]{};
        boolean isConnected = false;
        long lPreviousTimestamp = Calendar.getInstance().getTime().getTime();
        boolean isPeriodTooShort = false;
        int nTimeoutCount = 0;
        NumberFormat NbrFormat = NumberFormat.getInstance();
        NbrFormat.setMinimumIntegerDigits(3);
        while (this.m_isThreadEnabled) {
            if (acBuffer.length != this.m_nBufferSize) {
                System.out.println("FRAP Com : Set new packet size to " + this.m_nBufferSize);
                acBuffer = new byte[this.m_nBufferSize];
            }
            if (!isConnected) {
                switch (this.m_CommPort.getState()) {
                    case Open: {
                        lPreviousTimestamp = Calendar.getInstance().getTime().getTime();
                        nTimeoutCount = 0;
                        this.m_nPeriodTooShortCount = 0;
                        isPeriodTooShort = false;
                        this.fireComDevEvtOccured(this, FCOEComState.CONNECTED);
                        this.m_AnswersQueue.clear();
                        isConnected = true;
                        break;
                    }
                    case Opening: {
                        if (this.m_DeviceComState != FCOEComState.CONNECTING) {
                            this.fireComDevEvtOccured(this, FCOEComState.CONNECTING);
                            break;
                        }
                    }
                    default: {
                        this.fireComDevEvtOccured(this, FCOEComState.DISCONNECTED);
                    }
                    case Closed: {
                        try {
                            this.m_CommPort.open();
                            break;
                        }
                        catch (IOException e) {
                            this.fireComDevEvtOccured(this, FCOEComState.FAILED);
                            System.out.println("FCOCRAPDevice: Unable to open com port :" + e.getMessage());
                        }
                    }
                }
            }
            if (!this.m_isInterfaceComSupended && isConnected) {
                int nBufferOffset = 0;
                int nReturnBufSize = 0;
                boolean isStillWaitingRead = false;
                Object Destination = null;
                int nBytesReceived = 0;
                try {
                    FCOCDevice.CGetNextPacketResult Request = this.getNextPacket(acBuffer, 0, true, this.m_nBufferSize, this.m_nBufferSize, 0);
                    nBufferOffset = Request.m_nBufferOffset;
                    nReturnBufSize = Request.m_nExpectedReturnBufSize;
                    isStillWaitingRead = Request.m_isNotFinished;
                    Destination = Request.m_Source;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.m_CommPort.close();
                    isConnected = false;
                    this.fireComDevEvtOccured(this, FCOEComState.LOST);
                }
                this.m_isWaitingAnswer = false;
                if (nBufferOffset > 0) {
                    try {
                        this.m_CommPort.discardInputBuffer();
                        this.m_CommPort.putData(acBuffer, 0, nBufferOffset);
                        if (m_isDebugLogEnabled) {
                            this.writeComLog("Snd FRAP packet to   0x" + FCOCUtils.toHexString(acBuffer[0], 2), acBuffer, 0, nBufferOffset, false);
                        }
                        if (nReturnBufSize > 0) {
                            this.m_isWaitingAnswer = true;
                        }
                    }
                    catch (IOException IoException) {
                        System.out.println("FCOCRAPDevice error: IO Exception: cannot write to port ! " + IoException.getMessage());
                        this.m_CommPort.close();
                        isConnected = false;
                        this.fireComDevEvtOccured(this, FCOEComState.LOST);
                    }
                    if (this.m_isWaitingAnswer) {
                        nReturnBufSize = 0;
                        int nBytesReceivedLastLoop = 0;
                        long lRxTryTimeout = 2000L;
                        while (lRxTryTimeout > 0L) {
                            StopWatch stopWatch;
                            block53: {
                                if (!isConnected) break;
                                stopWatch = new StopWatch();
                                stopWatch.start();
                                try {
                                    if (nReturnBufSize == 0 || nBytesReceived < nReturnBufSize) {
                                        int nLength = 0;
                                        nLength = nReturnBufSize == 0 ? 4 - nBytesReceived : nReturnBufSize - nBytesReceived;
                                        nBytesReceivedLastLoop = this.m_CommPort.getData(acBuffer, nBytesReceived, nLength, 10);
                                        if (nReturnBufSize == 0 && (nBytesReceived += nBytesReceivedLastLoop) >= 4) {
                                            nReturnBufSize = (acBuffer[2] & 0x7F) + 3;
                                            if ((acBuffer[2] & 0x80) == 128) {
                                                nReturnBufSize += (acBuffer[3] & 0x7F) * 128 + 1;
                                                byte cfr_ignored_0 = acBuffer[3];
                                            }
                                        }
                                    }
                                }
                                catch (ArrayIndexOutOfBoundsException ArrayIndexOutOfBoundsEx) {
                                    System.out.println("FCOCRAPDevice error: ArrayIndexOutOfBoundsException ! " + ArrayIndexOutOfBoundsEx.getMessage());
                                    this.m_CommPort.close();
                                    isConnected = false;
                                    this.fireComDevEvtOccured(this, FCOEComState.LOST);
                                }
                                catch (IOException IOExc) {
                                    System.out.println("FCOCRAPDevice error: ArrayIndexOutOfBoundsException ! " + IOExc.getMessage());
                                    IOExc.printStackTrace();
                                }
                                if (nReturnBufSize > 0 && nBytesReceived >= nReturnBufSize) {
                                    if (nBytesReceived > nReturnBufSize) {
                                        System.err.println(" --> too much !");
                                    }
                                    try {
                                        if (this.handleAnswer(nBytesReceived, acBuffer, 0, Destination) == 0) {
                                            nReturnBufSize = 0;
                                            nBytesReceived = 0;
                                            break block53;
                                        }
                                        stopWatch.stop();
                                        break;
                                    }
                                    catch (Exception e) {
                                        System.err.println("Error while handling answer: " + e.getMessage());
                                        e.printStackTrace();
                                        this.m_CommPort.close();
                                        isConnected = false;
                                        this.fireComDevEvtOccured(this, FCOEComState.LOST);
                                    }
                                }
                            }
                            stopWatch.stop();
                            lRxTryTimeout -= (long)((int)stopWatch.getLastTaskTimeMillis());
                        }
                        if (nBytesReceived == 0) {
                            this.fireComDevEvtOccured(this, FCOEComState.TIMEOUT);
                            nTimeoutCount = Math.max(1, (int)(1000L / this.m_lThreadLoopTime));
                        } else {
                            try {
                                if (m_isDebugLogEnabled) {
                                    this.writeComLog("Rec FRAP packet from 0x" + FCOCUtils.toHexString(acBuffer[1]), acBuffer, 0, nBytesReceived, true);
                                }
                                if ((nReturnBufSize == 0 || nBytesReceived < nReturnBufSize) && this.handleAnswer(nBytesReceived, acBuffer, 0, Destination) == 0) {
                                    this.fireComDevEvtOccured(this, FCOEComState.TIMEOUT);
                                }
                                if (--nTimeoutCount == 0) {
                                    this.fireComDevEvtOccured(this, FCOEComState.CONNECTED);
                                    isPeriodTooShort = false;
                                } else if (nTimeoutCount < -1000) {
                                    nTimeoutCount = -1;
                                }
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                                this.m_CommPort.close();
                                isConnected = false;
                                this.fireComDevEvtOccured(this, FCOEComState.LOST);
                            }
                        }
                    }
                }
                try {
                    long lSleepTime = 2L;
                    if (!isStillWaitingRead && this.isNextMain()) {
                        long lCurrentTimestamp = Calendar.getInstance().getTime().getTime();
                        long lDelta = lCurrentTimestamp - lPreviousTimestamp;
                        long lTheoreticalSleepTime = lSleepTime = this.m_lThreadLoopTime - lDelta;
                        if (lSleepTime < 0L) {
                            lSleepTime = 2L;
                            ++this.m_nPeriodTooShortCount;
                            if (this.m_nPeriodTooShortCount > 10) {
                                if (!isPeriodTooShort) {
                                    this.fireComDevEvtOccured(this, FCOEComState.PERIODTOOSHORT);
                                    isPeriodTooShort = true;
                                }
                                this.m_nPeriodTooShortCount = 10;
                            }
                        } else {
                            --this.m_nPeriodTooShortCount;
                        }
                        if (isPeriodTooShort && this.m_nPeriodTooShortCount < -5) {
                            isPeriodTooShort = false;
                            this.m_nPeriodTooShortCount = -6;
                            this.fireComDevEvtOccured(this, FCOEComState.CONNECTED);
                        }
                        if (m_isDebugLogEnabled) {
                            this.writeComLog("Next state " + (Object)((Object)this.m_DevicesStep) + "\tWaiting " + lSleepTime + " ms", null, 0, 0, true);
                        }
                        lPreviousTimestamp += (long)(lTheoreticalSleepTime < 0L ? (int)(Math.abs(lTheoreticalSleepTime) / this.m_lThreadLoopTime) + 1 : 1) * this.m_lThreadLoopTime;
                    }
                    Thread.sleep(lSleepTime);
                }
                catch (InterruptedException interruptedException) {}
                continue;
            }
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (this.m_CommPort != null) {
            this.m_CommPort.close();
        }
        this.fireComDevEvtOccured(this, FCOEComState.DISCONNECTED);
    }

    protected static enum EDeviceSteps {
        ThisDevice,
        NestedDevices,
        OtherDevices,
        Remote;

    }
}

