/*
 * Decompiled with CFR 0.152.
 */
package com.fivecolibs.devices;

import com.fivecolibs.devices.FCOEPortState;
import com.fivecolibs.devices.FCOIPort;
import java.io.IOException;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.Calendar;

public class FCOCPortUDP
implements FCOIPort {
    private int m_nUDPPort = 7010;
    private String m_szIPAdd = "";
    private DatagramSocket m_oSocket;
    private final PipedInputStream m_oInStream = new PipedInputStream();
    private final PipedOutputStream m_oOutStream = new PipedOutputStream();
    private Thread m_oTxRxThread;
    private CTxRxRunnable m_oCTxRxRunnable = null;
    private FCOEPortState m_State = FCOEPortState.Closed;

    public FCOCPortUDP(String szIPAddress, int nUDPPort) {
        this.m_szIPAdd = szIPAddress;
        this.m_nUDPPort = nUDPPort;
    }

    public FCOCPortUDP(String szIPAddress) {
        this(szIPAddress, 7010);
    }

    public String getIPAddress() {
        return this.m_szIPAdd;
    }

    public int getUDPPort() {
        return this.m_nUDPPort;
    }

    @Override
    public FCOEPortState getState() {
        return this.m_State;
    }

    @Override
    public void open() throws IOException {
        this.m_State = FCOEPortState.Opening;
        try {
            if (this.m_oSocket == null || this.m_oSocket.isClosed() || !this.m_oSocket.isConnected()) {
                this.m_oSocket = new DatagramSocket();
                this.m_oSocket.setSoTimeout(10);
                this.m_oCTxRxRunnable = new CTxRxRunnable(this.m_oInStream, this.m_oOutStream);
                this.m_oTxRxThread = new Thread((Runnable)this.m_oCTxRxRunnable, "UDP Tx Rx Thread with " + this.m_szIPAdd + "/" + this.m_nUDPPort);
                this.m_oTxRxThread.start();
                this.m_State = FCOEPortState.Open;
            }
        }
        catch (SocketException e) {
            this.m_State = FCOEPortState.Closed;
            throw e;
        }
    }

    @Override
    public void close() {
        if (this.m_State == FCOEPortState.Closed) {
            return;
        }
        if (this.m_State == FCOEPortState.Closing) {
            return;
        }
        this.m_State = FCOEPortState.Closing;
        if (this.m_oCTxRxRunnable != null) {
            this.m_oCTxRxRunnable.stop();
            this.m_oCTxRxRunnable = null;
        }
        this.m_oTxRxThread = null;
        if (this.m_oSocket != null) {
            this.m_oSocket.close();
            this.m_oSocket = null;
        }
        this.m_State = FCOEPortState.Closed;
    }

    @Override
    public void putData(byte[] acBuffer, int nOffset, int nLength) throws IOException {
        if (this.m_oOutStream != null) {
            this.m_oOutStream.write(acBuffer, nOffset, nLength);
        }
    }

    @Override
    public int getData(byte[] acBuffer, int nOffset, int nLength) throws IOException {
        if (this.m_oInStream != null) {
            return this.m_oInStream.read(acBuffer, nOffset, Math.min(nLength, this.m_oInStream.available()));
        }
        return 0;
    }

    @Override
    public int getData(byte[] acBuffer, int nOffset, int nLength, int nTimeout) throws IOException {
        long lMaxTimestamp = Calendar.getInstance().getTime().getTime() + (long)nTimeout;
        int nBytesReceived = 0;
        while (nBytesReceived < nLength) {
            nBytesReceived += this.getData(acBuffer, nOffset + nBytesReceived, nLength - nBytesReceived);
            if (Calendar.getInstance().getTime().getTime() > lMaxTimestamp) break;
        }
        return nBytesReceived;
    }

    @Override
    public void discardInputBuffer() {
        if (this.m_oInStream != null) {
            long lAv = 0L;
            do {
                try {
                    lAv = this.available();
                    this.m_oInStream.skip(lAv);
                }
                catch (IOException e) {
                    System.err.println("FCOCPortUDP: Actual input stream does not support skip method !");
                    return;
                }
            } while (lAv > 0L);
        }
    }

    @Override
    public int available() throws IOException {
        if (this.m_oInStream != null) {
            return this.m_oInStream.available();
        }
        return 0;
    }

    private class CTxRxRunnable
    implements Runnable {
        private static final int m_nRXTRYSIZE = 65536;
        private final PipedInputStream m_oInputStream = new PipedInputStream();
        private final PipedOutputStream m_oOutputStream = new PipedOutputStream();
        private boolean m_isRunning = true;

        public CTxRxRunnable(PipedInputStream oMasterPipedIS, PipedOutputStream oMasterPiperOS) throws IOException {
            this.m_oInputStream.connect(oMasterPiperOS);
            oMasterPipedIS.connect(this.m_oOutputStream);
        }

        @Override
        public void run() {
            byte[] acTempBuffer = new byte[65536];
            while (this.m_isRunning) {
                try {
                    if (this.m_oInputStream.available() > 0) {
                        int nLen = this.m_oInputStream.available();
                        byte[] acDataToSend = new byte[nLen];
                        this.m_oInputStream.read(acDataToSend, 0, nLen);
                        DatagramPacket oPacket = new DatagramPacket(acDataToSend, 0, nLen, InetAddress.getByName(FCOCPortUDP.this.m_szIPAdd), FCOCPortUDP.this.m_nUDPPort);
                        FCOCPortUDP.this.m_oSocket.send(oPacket);
                    }
                    DatagramPacket oPacket = new DatagramPacket(acTempBuffer, 65536);
                    int nRxLength = 0;
                    try {
                        do {
                            FCOCPortUDP.this.m_oSocket.receive(oPacket);
                            nRxLength = oPacket.getLength();
                            this.m_oOutputStream.write(acTempBuffer, 0, nRxLength);
                        } while (nRxLength > 0);
                    }
                    catch (SocketTimeoutException socketTimeoutException) {}
                }
                catch (IOException e) {
                    FCOCPortUDP.this.close();
                }
            }
        }

        public void stop() {
            this.m_isRunning = false;
        }
    }
}

