/*
 * Decompiled with CFR 0.152.
 */
package com.fivecolibs.devices;

import com.fivecolibs.devices.FCOEPortState;
import com.fivecolibs.devices.FCOIPort;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;
import java.util.Calendar;

public class FCOCPortTCP
implements FCOIPort {
    private int m_nTCPPort = 8010;
    private String m_szIPAdd = "";
    private Socket m_Socket;
    private DataInputStream m_InStream = null;
    private DataOutputStream m_OutStream = null;
    private FCOEPortState m_State = FCOEPortState.Closed;

    public FCOCPortTCP(String szIPAddress, int nTCPPort) {
        this.m_szIPAdd = szIPAddress;
        this.m_nTCPPort = nTCPPort;
    }

    public FCOCPortTCP(String szIPAddress) {
        this(szIPAddress, 8010);
    }

    public String getIPAddress() {
        return this.m_szIPAdd;
    }

    public int getTCPPort() {
        return this.m_nTCPPort;
    }

    @Override
    public FCOEPortState getState() {
        return this.m_State;
    }

    @Override
    public void open() throws IOException {
        this.m_State = FCOEPortState.Opening;
        try {
            if (this.m_Socket == null || this.m_Socket.isClosed() || !this.m_Socket.isConnected()) {
                this.m_Socket = new Socket(this.m_szIPAdd, this.m_nTCPPort);
                this.m_Socket.setKeepAlive(true);
                this.m_Socket.setTcpNoDelay(true);
                this.m_Socket.setSoTimeout(1000);
                this.m_InStream = new DataInputStream(this.m_Socket.getInputStream());
                this.m_OutStream = new DataOutputStream(this.m_Socket.getOutputStream());
                this.m_State = FCOEPortState.Open;
            }
        }
        catch (IOException e) {
            this.m_State = FCOEPortState.Closed;
            throw e;
        }
    }

    @Override
    public void close() {
        if (this.m_State == FCOEPortState.Closed) {
            return;
        }
        if (this.m_State == FCOEPortState.Closing) {
            return;
        }
        this.m_State = FCOEPortState.Closing;
        if (this.m_Socket != null) {
            try {
                this.m_InStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.m_InStream = null;
            try {
                this.m_OutStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.m_OutStream = null;
            try {
                this.m_Socket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.m_Socket = null;
        }
        this.m_State = FCOEPortState.Closed;
    }

    @Override
    public void putData(byte[] acBuffer, int nOffset, int nLength) throws IOException {
        if (this.m_OutStream != null) {
            this.m_OutStream.write(acBuffer, nOffset, nLength);
        }
    }

    @Override
    public int getData(byte[] acBuffer, int nOffset, int nLength) throws IOException {
        if (this.m_InStream != null) {
            return this.m_InStream.read(acBuffer, nOffset, Math.min(nLength, this.m_InStream.available()));
        }
        return 0;
    }

    @Override
    public int getData(byte[] acBuffer, int nOffset, int nLength, int nTimeout) throws IOException {
        long lMaxTimestamp = Calendar.getInstance().getTime().getTime() + (long)nTimeout;
        int nBytesReceived = 0;
        while (nBytesReceived < nLength) {
            nBytesReceived += this.getData(acBuffer, nOffset + nBytesReceived, nLength - nBytesReceived);
            if (Calendar.getInstance().getTime().getTime() > lMaxTimestamp) break;
        }
        return nBytesReceived;
    }

    @Override
    public void discardInputBuffer() {
        if (this.m_InStream != null) {
            long lAv = 0L;
            do {
                try {
                    lAv = this.available();
                    this.m_InStream.skip(lAv);
                }
                catch (IOException e) {
                    System.err.println("FCOCPortTCP: Actual input stream does not support skip method !");
                    return;
                }
            } while (lAv > 0L);
        }
    }

    @Override
    public int available() throws IOException {
        if (this.m_InStream != null) {
            return this.m_InStream.available();
        }
        return 0;
    }
}

