/*
 * Decompiled with CFR 0.152.
 */
package com.fivecolibs.devices;

import com.fivecolibs.devices.FCOEPortState;
import com.fivecolibs.devices.FCOIPort;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Calendar;
import purejavacomm.CommPortIdentifier;
import purejavacomm.NoSuchPortException;
import purejavacomm.PortInUseException;
import purejavacomm.PureJavaIllegalStateException;
import purejavacomm.SerialPort;
import purejavacomm.UnsupportedCommOperationException;

public class FCOCPortSerial
implements FCOIPort {
    private CommPortIdentifier m_PortID = null;
    private SerialPort m_SerPort = null;
    private OutputStream m_SerPortOuts = null;
    private InputStream m_SerPortIns = null;
    private final String m_szComPort;
    private final int m_nBaudRate;
    private FCOEPortState m_State = FCOEPortState.Closed;

    public FCOCPortSerial(String szComPort, int nBaudRate) {
        this.m_szComPort = szComPort;
        this.m_nBaudRate = nBaudRate;
    }

    public String getComPort() {
        return this.m_szComPort;
    }

    public int getBaudRate() {
        return this.m_nBaudRate;
    }

    @Override
    public FCOEPortState getState() {
        return this.m_State;
    }

    @Override
    public void open() throws IOException {
        try {
            this.m_PortID = CommPortIdentifier.getPortIdentifier((String)this.m_szComPort);
            this.m_SerPort = (SerialPort)this.m_PortID.open(FCOCPortSerial.class.getName(), 1000);
            this.m_SerPort.setDTR(true);
            this.m_SerPort.setSerialPortParams(this.m_nBaudRate, 8, 1, 0);
            this.m_SerPort.setFlowControlMode(0);
            this.m_SerPortOuts = this.m_SerPort.getOutputStream();
            this.m_SerPortIns = this.m_SerPort.getInputStream();
            this.m_State = FCOEPortState.Open;
        }
        catch (NoSuchPortException | PortInUseException | PureJavaIllegalStateException | UnsupportedCommOperationException e) {
            this.close();
            throw new IOException(e.getMessage(), e.getCause());
        }
    }

    @Override
    public void close() {
        if (this.m_State == FCOEPortState.Closed) {
            return;
        }
        if (this.m_State == FCOEPortState.Closing) {
            return;
        }
        if (this.m_PortID != null) {
            if (this.m_SerPortOuts != null) {
                try {
                    this.m_SerPortOuts.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.m_SerPortOuts = null;
            }
            if (this.m_SerPortIns != null) {
                try {
                    this.m_SerPortIns.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.m_SerPortIns = null;
            }
            if (this.m_SerPort != null) {
                this.m_SerPort.close();
                this.m_SerPort = null;
            }
            this.m_PortID = null;
        }
        this.m_State = FCOEPortState.Closed;
    }

    @Override
    public void putData(byte[] acBuffer, int nOffset, int nLength) throws IOException {
        if (this.m_SerPortOuts != null) {
            this.m_SerPortOuts.write(acBuffer, nOffset, nLength);
        }
    }

    @Override
    public int getData(byte[] acBuffer, int nOffset, int nLength) throws IOException {
        if (this.m_SerPortIns != null) {
            return this.m_SerPortIns.read(acBuffer, nOffset, Math.min(nLength, this.m_SerPortIns.available()));
        }
        return 0;
    }

    @Override
    public int getData(byte[] acBuffer, int nOffset, int nLength, int nTimeout) throws IOException {
        long lMaxTimestamp = Calendar.getInstance().getTime().getTime() + (long)nTimeout;
        int nBytesReceived = 0;
        while (nBytesReceived < nLength) {
            nBytesReceived += this.getData(acBuffer, nOffset + nBytesReceived, nLength - nBytesReceived);
            if (Calendar.getInstance().getTime().getTime() > lMaxTimestamp) break;
        }
        return nBytesReceived;
    }

    @Override
    public void discardInputBuffer() {
        long lAv = 0L;
        do {
            try {
                lAv = this.available();
                this.m_SerPortIns.skip(lAv);
            }
            catch (IOException e) {
                System.err.println("FCOCPortSerial: Actual input stream does not support skip method !");
                return;
            }
        } while (lAv > 0L);
    }

    @Override
    public int available() throws IOException {
        if (this.m_SerPortIns != null) {
            return this.m_SerPortIns.available();
        }
        return 0;
    }
}

