/*
 * Decompiled with CFR 0.152.
 */
package com.fivecolibs.devices;

public class FCOCInterfaceInfo {
    public FCOEInterfaceType m_eInterfaceType;
    public boolean m_isTheInterfaceToCommunicate;
    public boolean m_isFrap;
    public boolean m_isRoutable;
    public int m_unAdd;
    public int m_nMaxPacketSize;

    public FCOCInterfaceInfo(byte ucInterfaceType) {
        this(ucInterfaceType, 0, 0, 0);
    }

    public FCOCInterfaceInfo(byte ucInterfaceType, byte ucBitStatus) {
        this(ucInterfaceType, ucBitStatus, 0, 0);
    }

    public FCOCInterfaceInfo(byte ucInterfaceType, byte ucBitStatus, byte ucAdd) {
        this(ucInterfaceType, ucBitStatus, ucAdd, 0);
    }

    public FCOCInterfaceInfo(byte ucInterfaceType, byte ucBitStatus, byte ucAdd, int nMaxSize) {
        switch (ucInterfaceType >> 4 & 0xF) {
            case 0: {
                this.m_eInterfaceType = FCOEInterfaceType.NONE;
                return;
            }
            case 1: {
                this.m_eInterfaceType = FCOEInterfaceType.I2C;
                break;
            }
            case 2: {
                this.m_eInterfaceType = FCOEInterfaceType.IP;
                break;
            }
            case 3: {
                this.m_eInterfaceType = FCOEInterfaceType.RS485;
                break;
            }
            case 4: {
                this.m_eInterfaceType = FCOEInterfaceType.BLE;
                break;
            }
            case 5: {
                this.m_eInterfaceType = FCOEInterfaceType.CAN;
                break;
            }
            default: {
                this.m_eInterfaceType = FCOEInterfaceType.UNKNOWN;
                return;
            }
        }
        this.m_isTheInterfaceToCommunicate = (ucBitStatus & 1) == 1;
        this.m_isFrap = (ucBitStatus & 2) == 2;
        this.m_isRoutable = (ucBitStatus & 4) == 4;
        this.m_unAdd = ucAdd & 0xFF;
        this.m_nMaxPacketSize = nMaxSize;
    }

    public static enum FCOEInterfaceType {
        NONE("No interface"),
        I2C("I2C"),
        IP("IP"),
        RS485("RS485"),
        BLE("BLE"),
        CAN("CAN"),
        UNKNOWN("Unknown");

        private final String m_szUsualName;

        private FCOEInterfaceType(String szUsualName) {
            this.m_szUsualName = szUsualName;
        }

        public String getUsualName() {
            return this.m_szUsualName;
        }
    }
}

