/*
 * Decompiled with CFR 0.152.
 */
package com.fivecolibs.devices;

import com.fivecolibs.devices.FCOCDevice;
import com.fivecolibs.devices.FCOCRegisterBase;
import com.fivecolibs.devices.FCOEDataEventType;
import com.fivecolibs.utils.FCOCUtils;
import java.io.IOException;
import java.util.concurrent.ConcurrentLinkedQueue;

public class FCOCIPI2CSubDevice
extends FCOCDevice {
    protected final byte m_cI2CAddress;
    protected final ConcurrentLinkedQueue<FCOCDevice.CQueueElement> m_RequestQueue;

    public FCOCIPI2CSubDevice(int nNumberOfRegisters, byte cI2CAddress) {
        this(nNumberOfRegisters, cI2CAddress, 180, 1000L);
    }

    public FCOCIPI2CSubDevice(int nNumberOfRegisters, byte cI2CAddress, int nBufferSize, long lThreadSleep) {
        super(nNumberOfRegisters, nBufferSize, lThreadSleep);
        this.m_cI2CAddress = cI2CAddress;
        this.m_RequestQueue = this.m_ReadQueue;
    }

    @Override
    public FCOCDevice addSubDevice(String szSubDevName, int nAddress, int nNumberOfRegisters, int nInterface) throws IOException {
        return null;
    }

    @Override
    public void removeSubDevice(String szSubDevName) {
    }

    @Override
    public void delete() {
        int nTimeout = 20;
        while (this.m_WriteQueue.size() > 0 && nTimeout-- > 0) {
            try {
                Thread.sleep(100L);
            }
            catch (Exception e) {
                System.err.println("FCOCI2CIPSubDevice:delete: Unable to sleep. " + e.getMessage());
            }
        }
    }

    public FCOCDevice.CQueueElement[] getRequestQueue(boolean isAutoreadRegAdded) {
        if (isAutoreadRegAdded) {
            this.addAutoreadRegisterToQueue();
        }
        FCOCDevice.CQueueElement[] aRegBaseToRead = this.m_RequestQueue.toArray(new FCOCDevice.CQueueElement[0]);
        this.m_RequestQueue.clear();
        return aRegBaseToRead;
    }

    public void fireDataEvent(FCOCRegisterBase Register, Object data, FCOEDataEventType eState, Object CallbackParameter) {
        this.fireDataDevEvtOccured(this, this.getKeyFromValue(Register, this.m_aRegistersList), data, eState, CallbackParameter);
    }

    public static String getStringAddress(int nAddress) {
        return "0x" + FCOCUtils.toHexString(nAddress, 2);
    }

    public byte getAddress() {
        return this.m_cI2CAddress;
    }

    @Override
    public int getInterface() {
        return 0;
    }

    @Override
    protected void addElementToReadQueue(FCOCDevice.CQueueElement Element) {
        this.m_RequestQueue.add(Element);
    }

    @Override
    protected void addElementToWriteQueue(FCOCRegisterBase Register) {
        this.m_RequestQueue.add(new FCOCDevice.CQueueElement(Register, null, false));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean isReadQueueContains(FCOCRegisterBase Register) {
        boolean isPresent = false;
        ConcurrentLinkedQueue<FCOCDevice.CQueueElement> concurrentLinkedQueue = this.m_RequestQueue;
        synchronized (concurrentLinkedQueue) {
            for (FCOCDevice.CQueueElement QueueElementItem : this.m_RequestQueue) {
                if (QueueElementItem.m_Register != Register || !QueueElementItem.m_isReadRequest) continue;
                isPresent = true;
                break;
            }
        }
        return isPresent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean isWriteQueueContains(FCOCRegisterBase Register) {
        boolean isPresent = false;
        ConcurrentLinkedQueue<FCOCDevice.CQueueElement> concurrentLinkedQueue = this.m_RequestQueue;
        synchronized (concurrentLinkedQueue) {
            for (FCOCDevice.CQueueElement QueueElementItem : this.m_RequestQueue) {
                if (QueueElementItem.m_Register != Register || QueueElementItem.m_isReadRequest) continue;
                isPresent = true;
                break;
            }
        }
        return isPresent;
    }

    @Override
    protected int fillBufferWithData(FCOCRegisterBase Register, byte[] acBuffer, int nOffset) {
        return 0;
    }

    @Override
    protected int getDataFromBuffer(FCOCRegisterBase Register, byte[] acBuffer, int nOffset) {
        return 0;
    }

    @Override
    public void run() {
    }
}

