/*
 * Decompiled with CFR 0.152.
 */
package com.fivecolibs.devices;

import com.fivecolibs.devices.FCOCDevice;
import com.fivecolibs.devices.FCOCIPDevice;
import com.fivecolibs.devices.FCOCIPI2CSubDevice;
import com.fivecolibs.devices.FCOCPortTCP;
import com.fivecolibs.devices.FCOCRegisterBase;
import com.fivecolibs.devices.FCOEComState;
import com.fivecolibs.devices.FCOEDataEventType;
import com.fivecolibs.devices.FCOEPortState;
import com.fivecolibs.devices.FCOIDeviceEvent;
import com.fivecolibs.devices.FCOII2CScanBus;
import com.fivecolibs.devices.FCOIIPI2CDeviceEvent;
import com.fivecolibs.devices.FCOIPort;
import com.fivecolibs.utils.FCOCUtils;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;

public class FCOCIPI2CDevice
extends FCOCIPDevice {
    private boolean m_isBufferFull = false;
    private final Hashtable<String, FCOCIPI2CSubDevice> m_aI2CDevicesList = new Hashtable();
    private final ConcurrentLinkedQueue<CI2CQueueElement> m_I2CTxQueue = new ConcurrentLinkedQueue();
    private final ConcurrentLinkedQueue<CI2CQueueElement> m_I2CRxQueue = new ConcurrentLinkedQueue();

    public FCOCIPI2CDevice(FCOIPort CommunicationPort, int nNumberOfRegisters, int nBufferSize, long lThreadSleep) {
        super(CommunicationPort, nNumberOfRegisters, nBufferSize, lThreadSleep);
    }

    public FCOCIPI2CDevice(FCOIPort CommunicationPort, int nNumberOfRegisters) {
        super(CommunicationPort, nNumberOfRegisters);
    }

    @Override
    public void delete() {
        if (!this.m_ComThread.isAlive()) {
            return;
        }
        int nTimeout = 20;
        while ((this.m_WriteQueue.size() > 0 || this.m_I2CTxQueue.size() > 0) && nTimeout-- > 0) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.m_isThreadEnabled = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addDeviceListener(FCOIDeviceEvent DevListener) {
        super.addDeviceListener(DevListener);
        Hashtable<String, FCOCIPI2CSubDevice> hashtable = this.m_aI2CDevicesList;
        synchronized (hashtable) {
            for (FCOCIPI2CSubDevice I2CDevice : this.m_aI2CDevicesList.values()) {
                I2CDevice.addDeviceListener(DevListener);
            }
        }
    }

    public void scanI2Cbus(FCOII2CScanBus ScanEventHandler) {
        this.scanI2Cbus(ScanEventHandler, null);
    }

    public void scanI2Cbus(FCOII2CScanBus ScanEventHandler, int[] anAddressesToScan) {
        if (this.m_CommPort == null || this.m_CommPort.getState() != FCOEPortState.Open || this.m_CommPort.getClass() != FCOCPortTCP.class) {
            return;
        }
        new CScanI2CThread(this, ScanEventHandler, ((FCOCPortTCP)this.m_CommPort).getIPAddress(), anAddressesToScan);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FCOCIPI2CSubDevice addSubDevice(String szI2CDeviceName, int nI2CAddress, int nNumberOfRegisters, int nInterface) {
        Hashtable<String, FCOCIPI2CSubDevice> hashtable = this.m_aI2CDevicesList;
        synchronized (hashtable) {
            if (this.m_aI2CDevicesList.containsKey(szI2CDeviceName)) {
                System.out.println("Unable to add " + szI2CDeviceName + " because it already exists.");
                return this.m_aI2CDevicesList.get(szI2CDeviceName);
            }
            FCOCIPI2CSubDevice I2CDevice = new FCOCIPI2CSubDevice(nNumberOfRegisters, (byte)nI2CAddress);
            FCOIDeviceEvent[] listeners = this.getDeviceListeners();
            int i = listeners.length - 1;
            while (i >= 0) {
                I2CDevice.addDeviceListener(listeners[i]);
                --i;
            }
            this.m_aI2CDevicesList.put(szI2CDeviceName, I2CDevice);
            return I2CDevice;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeSubDevice(String szI2CDeviceName) {
        Hashtable<String, FCOCIPI2CSubDevice> hashtable = this.m_aI2CDevicesList;
        synchronized (hashtable) {
            if (this.m_aI2CDevicesList.containsKey(szI2CDeviceName)) {
                this.m_aI2CDevicesList.remove(szI2CDeviceName);
            } else {
                System.out.println("Unable to remove " + szI2CDeviceName + " because it is unknown.");
            }
        }
    }

    @Override
    public int getInterface() {
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void setI2CAutoreadSupended(String szI2CDeviceName, boolean isSuspended) {
        try {
            Hashtable<String, FCOCIPI2CSubDevice> hashtable = this.m_aI2CDevicesList;
            synchronized (hashtable) {
                this.m_aI2CDevicesList.get((Object)szI2CDeviceName).m_isAutoreadSuspended = isSuspended;
            }
        }
        catch (NullPointerException NPExcep) {
            System.err.println("FCOCIPI2CDevice error in setAutoreadSupended function : NullPointerException ! szRegisterName = " + szI2CDeviceName);
            NPExcep.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void addI2CDeviceRegister(String szI2CDeviceName, String szRegisterName, int nRegisterAddress, int nRegisterSize, int nRegisterAccessType, int nDataType, boolean isAutoReadEnabled) throws IllegalArgumentException {
        FCOCRegisterBase Register = new FCOCRegisterBase(nRegisterAddress, nRegisterSize, nRegisterAccessType, nDataType, isAutoReadEnabled);
        try {
            Hashtable hashtable = this.m_aI2CDevicesList.get((Object)szI2CDeviceName).m_aRegistersList;
            synchronized (hashtable) {
                this.m_aI2CDevicesList.get((Object)szI2CDeviceName).m_aRegistersList.put(szRegisterName, Register);
            }
        }
        catch (NullPointerException NPExcep) {
            System.err.println("FCOCIPI2CDevice error in addI2CDeviceRegister function : NullPointerException ! szRegisterName = " + szRegisterName);
            NPExcep.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public FCOCRegisterBase removeI2CDeviceRegister(String szI2CDeviceName, String szRegisterName) {
        Hashtable hashtable = this.m_aRegistersList;
        synchronized (hashtable) {
            Hashtable hashtable2 = this.m_aI2CDevicesList.get((Object)szI2CDeviceName).m_aRegistersList;
            synchronized (hashtable2) {
                return (FCOCRegisterBase)this.m_aI2CDevicesList.get((Object)szI2CDeviceName).m_aRegistersList.remove(szRegisterName);
            }
        }
    }

    private void fireI2CComDevEvtOccured(FCOCIPI2CDevice Source, String szI2CDeviceName, int nCause) {
        FCOIDeviceEvent[] listeners = this.getDeviceListeners();
        int i = listeners.length - 1;
        while (i >= 0) {
            ((FCOIIPI2CDeviceEvent)listeners[i]).comI2CEvtOccured(Source, szI2CDeviceName, nCause);
            --i;
        }
    }

    @Override
    protected int handleAnswer(int nBytesReceived, byte[] acBuffer) {
        while (nBytesReceived >= 8) {
            int nLengthOfParameters = FCOCIPI2CDevice.getUShortFromBuffer(acBuffer, 4);
            if (nBytesReceived < nLengthOfParameters + 8) break;
            int nChecksumReceived = FCOCIPI2CDevice.getUShortFromBuffer(acBuffer, nLengthOfParameters + 6);
            int nChecksum = FCOCIPI2CDevice.calcChecksum(acBuffer, nLengthOfParameters + 6);
            if (acBuffer[0] == 0 && nChecksumReceived == nChecksum) {
                switch (acBuffer[1]) {
                    case 8: {
                        if (m_isDebugLogEnabled) {
                            this.writeComLog("Receive I2C packet answer (ID=", acBuffer, 0, 8 + nLengthOfParameters, true);
                        }
                        int i = 6;
                        while (i < 6 + nLengthOfParameters) {
                            if (this.m_I2CRxQueue.size() < 1) {
                                System.err.println("I2C answer received but I2C RX Queue empty !");
                                break;
                            }
                            CI2CQueueElement QueueEl = this.m_I2CRxQueue.poll();
                            if (!QueueEl.m_isAWrite && acBuffer[i = this.getDataFromBuffer(QueueEl.m_Register, acBuffer, i)] == -121) {
                                QueueEl.m_I2CDevice.fireDataEvent(QueueEl.m_Register, QueueEl.m_Register.getDataRead(), FCOEDataEventType.VALIDDATAEVENT, QueueEl.m_CallbackParameter);
                            }
                            if (acBuffer[i] != -121) {
                                this.fireI2CComDevEvtOccured(this, this.getKeyFromValue(QueueEl.m_I2CDevice, this.m_aI2CDevicesList), 100);
                                if (m_isDebugLogEnabled) {
                                    System.err.println("Bad I2c ack received at offset " + (i - 6) + ". Read 0x" + FCOCUtils.toHexString(acBuffer[i]));
                                }
                            } else {
                                String szKey = this.getKeyFromValue(QueueEl.m_I2CDevice, this.m_aI2CDevicesList);
                                this.fireI2CComDevEvtOccured(this, szKey, 0);
                            }
                            ++i;
                        }
                        if (this.m_I2CRxQueue.size() <= 0) break;
                        if (m_isDebugLogEnabled) {
                            System.out.println("I2C Rx Queue not empty (" + this.m_I2CRxQueue.size() + " elements remains) !");
                        }
                        this.m_I2CRxQueue.clear();
                        break;
                    }
                    case 9: {
                        int eI2CComCause = -1;
                        switch (acBuffer[6]) {
                            case 1: {
                                eI2CComCause = 1;
                                break;
                            }
                            case 2: {
                                eI2CComCause = 2;
                                break;
                            }
                            case 3: {
                                eI2CComCause = 4;
                                break;
                            }
                        }
                        if (m_isDebugLogEnabled) {
                            this.writeComLog("Receive I2C error packet (ID=", acBuffer, 0, 8 + nLengthOfParameters, true);
                        }
                        this.fireI2CComDevEvtOccured(this, null, eI2CComCause);
                        break;
                    }
                    default: {
                        return super.handleAnswer(nBytesReceived, acBuffer);
                    }
                }
                int j = 0;
                int i = nLengthOfParameters + 8;
                while (i < nBytesReceived) {
                    acBuffer[j++] = acBuffer[i];
                    ++i;
                }
                nBytesReceived -= nLengthOfParameters + 8;
                continue;
            }
            System.err.println("FCOCIPDevice Error: received a bad packet from device.");
            this.fireComDevEvtOccured(this, FCOEComState.CHECKSUMERROR);
            return 0;
        }
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected FCOCDevice.CGetNextPacketResult getNextPacket(byte[] acBuffer, int nBufferOffset, int nAvailableTxBufSpace, int nAvailableRxBufSpace) {
        FCOCDevice.CGetNextPacketResult Return = new FCOCDevice.CGetNextPacketResult(this);
        int nReturnBufSize = 0;
        int nInitialBufferOffset = nBufferOffset;
        switch (this.m_DevicesStep) {
            case IPSub: {
                Hashtable<String, FCOCIPI2CSubDevice> hashtable = this.m_aI2CDevicesList;
                synchronized (hashtable) {
                    if (this.m_aI2CDevicesList.size() != 0) {
                        for (Map.Entry<String, FCOCIPI2CSubDevice> I2CDevEntry : this.m_aI2CDevicesList.entrySet()) {
                            FCOCDevice.CQueueElement[] RegToRead;
                            FCOCIPI2CSubDevice I2CDevice = I2CDevEntry.getValue();
                            FCOCDevice.CQueueElement[] cQueueElementArray = RegToRead = I2CDevice.getRequestQueue(!this.m_isBufferFull);
                            int n = RegToRead.length;
                            int n2 = 0;
                            while (n2 < n) {
                                FCOCDevice.CQueueElement QueueEl = cQueueElementArray[n2];
                                CI2CQueueElement I2CQueueEl = new CI2CQueueElement(I2CDevice, QueueEl.m_Register, !QueueEl.m_isReadRequest, QueueEl.m_CallbackParameter);
                                this.m_I2CTxQueue.add(I2CQueueEl);
                                ++n2;
                            }
                        }
                    }
                    this.m_isBufferFull = false;
                    if (this.m_I2CTxQueue.size() > 0) {
                        nReturnBufSize = 8;
                        nBufferOffset += 6;
                        do {
                            CI2CQueueElement QueueElement = this.m_I2CTxQueue.peek();
                            if (QueueElement.m_isAWrite) {
                                if (nBufferOffset + QueueElement.m_Register.getSize() + 4 < nAvailableTxBufSpace - 2) {
                                    this.m_I2CTxQueue.poll();
                                    this.m_I2CRxQueue.add(QueueElement);
                                    acBuffer[nBufferOffset++] = QueueElement.m_I2CDevice.getAddress();
                                    acBuffer[nBufferOffset++] = (byte)(QueueElement.m_Register.getSize() + 1);
                                    nBufferOffset = this.fillBufferWithData(QueueElement.m_Register, acBuffer, nBufferOffset);
                                    acBuffer[nBufferOffset++] = 0;
                                    ++nReturnBufSize;
                                    continue;
                                }
                                this.m_isBufferFull = true;
                                if (!m_isDebugLogEnabled) break;
                                this.fireComDevEvtOccured(this, FCOEComState.FRAGMENTED);
                                break;
                            }
                            if (nBufferOffset + 4 < nAvailableTxBufSpace - 2 && nReturnBufSize + QueueElement.m_Register.getSize() + 1 < nAvailableRxBufSpace - 8) {
                                this.m_I2CTxQueue.poll();
                                this.m_I2CRxQueue.add(QueueElement);
                                acBuffer[nBufferOffset++] = QueueElement.m_I2CDevice.getAddress();
                                acBuffer[nBufferOffset++] = 1;
                                acBuffer[nBufferOffset++] = (byte)QueueElement.m_Register.getAddress();
                                acBuffer[nBufferOffset++] = (byte)QueueElement.m_Register.getSize();
                                nReturnBufSize += QueueElement.m_Register.getSize() + 1;
                                continue;
                            }
                            this.m_isBufferFull = true;
                            if (!m_isDebugLogEnabled) break;
                            this.fireComDevEvtOccured(this, FCOEComState.FRAGMENTED);
                            break;
                        } while (this.m_I2CTxQueue.size() > 0);
                        FCOCIPI2CDevice.setUShortToBuffer(acBuffer, nInitialBufferOffset, 7);
                        FCOCIPI2CDevice.setUShortToBuffer(acBuffer, 2 + nInitialBufferOffset, this.m_nUniqueID++);
                        FCOCIPI2CDevice.setUShortToBuffer(acBuffer, 4 + nInitialBufferOffset, nBufferOffset - nInitialBufferOffset - 6);
                        FCOCIPI2CDevice.setUShortToBuffer(acBuffer, nBufferOffset, FCOCIPI2CDevice.calcChecksum(acBuffer, nBufferOffset - nInitialBufferOffset));
                        nBufferOffset += 2;
                        if (m_isDebugLogEnabled) {
                            this.writeComLog("Send I2C packet (ID=", acBuffer, nInitialBufferOffset, nBufferOffset, false);
                        }
                    }
                }
                if (!this.m_isBufferFull) {
                    this.m_DevicesStep = FCOCIPDevice.EDeviceSteps.IPRead;
                }
                Return.m_nBufferOffset = nBufferOffset;
                Return.m_nExpectedReturnBufSize = nReturnBufSize;
                Return.m_isNotFinished = this.m_isBufferFull;
                break;
            }
            default: {
                Return = super.getNextPacket(acBuffer, nBufferOffset, nAvailableTxBufSpace, nAvailableRxBufSpace);
            }
        }
        return Return;
    }

    private class CI2CQueueElement {
        public FCOCIPI2CSubDevice m_I2CDevice;
        public FCOCRegisterBase m_Register;
        public boolean m_isAWrite = false;
        public Object m_CallbackParameter = null;

        public CI2CQueueElement(FCOCIPI2CSubDevice I2CDevice, FCOCRegisterBase Register, boolean isAWrite, Object CallbackParameter) {
            this.m_I2CDevice = I2CDevice;
            this.m_Register = Register;
            this.m_isAWrite = isAWrite;
            this.m_CallbackParameter = CallbackParameter;
        }
    }

    private class CScanI2CThread
    implements Runnable {
        private final FCOCDevice m_Caller;
        private final Thread m_ScanThread = new Thread(this);
        private final FCOII2CScanBus m_ScanEventHandler;
        private final String m_szIPAdd;
        private int[] m_anAddressesToScan;

        public CScanI2CThread(FCOCDevice Caller, FCOII2CScanBus ScanEventHandler, String szIPAdd, int[] anAddressesToScan) {
            this.m_Caller = Caller;
            this.m_ScanEventHandler = ScanEventHandler;
            this.m_szIPAdd = szIPAdd;
            this.m_anAddressesToScan = anAddressesToScan != null ? anAddressesToScan : new int[0];
            this.m_ScanThread.start();
        }

        @Override
        public void run() {
            byte[] acScanPacketBytes = new byte[8 + this.m_anAddressesToScan.length];
            acScanPacketBytes[0] = 0;
            acScanPacketBytes[1] = 5;
            acScanPacketBytes[4] = 0;
            acScanPacketBytes[5] = (byte)this.m_anAddressesToScan.length;
            if (this.m_anAddressesToScan.length > 0) {
                int i = 0;
                while (i < this.m_anAddressesToScan.length) {
                    acScanPacketBytes[6 + i] = (byte)this.m_anAddressesToScan[i];
                    ++i;
                }
            }
            FCOCIPI2CDevice.setUShortToBuffer(acScanPacketBytes, 6 + this.m_anAddressesToScan.length, FCOCIPI2CDevice.calcChecksum(acScanPacketBytes, 6 + this.m_anAddressesToScan.length));
            try {
                DatagramPacket ScanPacket = new DatagramPacket(acScanPacketBytes, 8 + this.m_anAddressesToScan.length, InetAddress.getByName(this.m_szIPAdd), 7010);
                Enumeration<NetworkInterface> NetItfs = NetworkInterface.getNetworkInterfaces();
                while (NetItfs.hasMoreElements()) {
                    NetworkInterface NetItf = NetItfs.nextElement();
                    Enumeration<InetAddress> NetItfAddresses = NetItf.getInetAddresses();
                    while (NetItfAddresses.hasMoreElements()) {
                        InetAddress NetItfAddress = NetItfAddresses.nextElement();
                        try {
                            Throwable throwable = null;
                            Object var8_14 = null;
                            try (DatagramSocket ScanSocket = new DatagramSocket(new InetSocketAddress(NetItfAddress, 0));){
                                if (NetItfAddress.getClass() == Inet4Address.class) {
                                    System.out.print("Interface " + NetItf.getDisplayName() + " : ");
                                    try {
                                        ScanSocket.send(ScanPacket);
                                        System.out.println("FCOCIPI2CDevice packet sent");
                                    }
                                    catch (Exception e) {
                                        System.out.println("FCOCIPI2CDevice error: " + e.getLocalizedMessage());
                                    }
                                    ScanSocket.setSoTimeout(500);
                                    byte[] ScanAnswerBytes = new byte[256];
                                    DatagramPacket ScanAnswerPacket = new DatagramPacket(ScanAnswerBytes, 250);
                                    while (true) {
                                        ScanSocket.receive(ScanAnswerPacket);
                                        if (ScanAnswerBytes[0] != 0 || ScanAnswerBytes[1] != 6 || ScanAnswerBytes[3] != 0 || ScanAnswerBytes[5] <= 0) continue;
                                        int nDevFoundCount = ScanAnswerBytes[5];
                                        int[] anDevFound = new int[nDevFoundCount];
                                        int i = 0;
                                        while (i < nDevFoundCount) {
                                            anDevFound[i] = ScanAnswerBytes[i + 6];
                                            ++i;
                                        }
                                        Arrays.sort(anDevFound);
                                        this.m_ScanEventHandler.scanI2CDevEvtOccured(this.m_Caller, nDevFoundCount, anDevFound);
                                    }
                                }
                                ScanSocket.close();
                            }
                            catch (Throwable throwable2) {
                                if (throwable == null) {
                                    throwable = throwable2;
                                } else if (throwable != throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                                throw throwable;
                            }
                        }
                        catch (SocketTimeoutException socketTimeoutException) {
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
            catch (SocketException e) {
                e.printStackTrace();
            }
            catch (UnknownHostException e) {
                e.printStackTrace();
            }
        }
    }
}

