/*
 * Decompiled with CFR 0.152.
 */
package com.fivecolibs.devices;

import com.fivecolibs.devices.FCOCDevice;
import com.fivecolibs.devices.FCOCPortTCP;
import com.fivecolibs.devices.FCOCPortUDP;
import com.fivecolibs.devices.FCOCRegisterBase;
import com.fivecolibs.devices.FCOEComState;
import com.fivecolibs.devices.FCOEDataEventType;
import com.fivecolibs.devices.FCOIPort;
import com.fivecolibs.utils.FCOCUtils;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.BitSet;
import java.util.Calendar;
import java.util.Date;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.springframework.util.StopWatch;

public class FCOCIPDevice
extends FCOCDevice {
    protected static final String m_szLOGFILENAME = String.valueOf(System.getProperty("user.home")) + "\\Desktop\\FCOCIPDeviceLog.txt";
    protected static final boolean m_isTIMEDEBUGENABLED = false;
    public static int nUPGRADEPORT = 8004;
    protected FCOIPort m_CommPort;
    protected int m_nPeriodTooShortCount = 0;
    protected EDeviceSteps m_DevicesStep = EDeviceSteps.IPRead;
    private boolean m_isStillWaitingRead = false;

    public FCOCIPDevice(FCOIPort CommunicationPort, int nNumberOfRegisters, int nBufferSize, long lThreadSleep) {
        super(nNumberOfRegisters, nBufferSize, lThreadSleep);
        if (!CommunicationPort.getClass().isAssignableFrom(FCOCPortTCP.class) && !CommunicationPort.getClass().isAssignableFrom(FCOCPortUDP.class)) {
            throw new IllegalArgumentException("Communication port must be a FCOCTCPPort or FCOCPortUDP class!");
        }
        this.m_CommPort = CommunicationPort;
        this.m_ComThread.start();
    }

    public FCOCIPDevice(FCOIPort CommunicationPort, int nNumberOfRegisters) {
        this(CommunicationPort, nNumberOfRegisters, 180, 1000L);
    }

    @Override
    public synchronized void delete() {
        if (!this.m_ComThread.isAlive()) {
            return;
        }
        int nTimeout = 20;
        while (this.m_WriteQueue.size() > 0 && nTimeout-- > 0) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.m_isThreadEnabled = false;
    }

    @Override
    public void removeSubDevice(String szSubDevName) {
    }

    @Override
    public FCOCDevice addSubDevice(String szSubDevName, int nAddress, int nNumberOfRegisters, int nInterface) throws IOException {
        return null;
    }

    @Override
    public int getInterface() {
        return -1;
    }

    protected static int getUShortFromBuffer(byte[] acBuffer, int nOffset) {
        return (acBuffer[nOffset] << 8 & 0xFF00) + (acBuffer[nOffset + 1] & 0xFF);
    }

    protected static void setUShortToBuffer(byte[] acBuffer, int nOffset, int nValue) {
        acBuffer[nOffset++] = (byte)((nValue & 0xFF00) >> 8);
        acBuffer[nOffset] = (byte)(nValue & 0xFF);
    }

    protected static int calcChecksum(byte[] acBuffer, int nBufferLength) {
        int nChecksum = 0;
        int nTemp = 0;
        int j = 0;
        int i = nBufferLength;
        while (i > 0) {
            if (i > 1) {
                nTemp = (acBuffer[j] << 8 & 0xFF00) + (acBuffer[j + 1] & 0xFF);
                j += 2;
                nChecksum += ~nTemp & 0xFFFF;
            } else {
                nChecksum += ~(acBuffer[j++] << 8 & 0xFF00) & 0xFFFF;
            }
            i -= 2;
        }
        nChecksum = ((nChecksum & 0xFFFF0000) >> 16) + (nChecksum & 0xFFFF);
        nChecksum = ((nChecksum & 0xFFFF0000) >> 16) + (nChecksum & 0xFFFF);
        return nChecksum;
    }

    @Override
    protected void addElementToReadQueue(FCOCDevice.CQueueElement Element) {
        this.m_ReadQueue.add(Element);
    }

    @Override
    protected void addElementToWriteQueue(FCOCRegisterBase Register) {
        this.m_WriteQueue.add(Register);
    }

    @Override
    protected boolean isReadQueueContains(FCOCRegisterBase Register) {
        return this.readQueueContains(Register);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean isWriteQueueContains(FCOCRegisterBase Register) {
        boolean isPresent = false;
        ConcurrentLinkedQueue concurrentLinkedQueue = this.m_WriteQueue;
        synchronized (concurrentLinkedQueue) {
            for (FCOCRegisterBase QueueElementItem : this.m_WriteQueue) {
                if (QueueElementItem != Register) continue;
                isPresent = true;
            }
        }
        return isPresent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean readQueueContains(FCOCRegisterBase Register) {
        boolean isPresent = false;
        ConcurrentLinkedQueue concurrentLinkedQueue = this.m_ReadQueue;
        synchronized (concurrentLinkedQueue) {
            for (FCOCDevice.CQueueElement QueueElementItem : this.m_ReadQueue) {
                if (QueueElementItem.m_Register != Register) continue;
                isPresent = true;
            }
        }
        return isPresent;
    }

    @Override
    protected int fillBufferWithData(FCOCRegisterBase Register, byte[] acBuffer, int nOffset) {
        acBuffer[nOffset++] = (byte)Register.getAddress();
        Object DataToWrite = Register.getDataToWrite();
        if (DataToWrite != null) {
            switch (Register.getDataType()) {
                case 0: 
                case 1: {
                    long lValue = (Long)DataToWrite;
                    int i = Register.getSize() - 1;
                    while (i >= 0) {
                        acBuffer[nOffset++] = (byte)(lValue >> i * 8 & 0xFFL);
                        --i;
                    }
                    break;
                }
                case 3: {
                    double dPercent = (Double)DataToWrite;
                    long lPercent = (long)(Math.pow(2.0, Register.getSize() * 8) * dPercent / 100.0);
                    if ((double)lPercent > Math.pow(2.0, Register.getSize() * 8) - 1.0) {
                        lPercent = (long)(Math.pow(2.0, Register.getSize() * 8) - 1.0);
                    }
                    int i = Register.getSize() - 1;
                    while (i >= 0) {
                        acBuffer[nOffset++] = (byte)(lPercent >> i * 8 & 0xFFL);
                        --i;
                    }
                    break;
                }
                case 2: {
                    BitSet Data = (BitSet)DataToWrite;
                    int i = Register.getSize() - 1;
                    while (i >= 0) {
                        byte cTemp = 0;
                        int j = 0;
                        while (j < 8) {
                            if (Data.get(8 * i + j)) {
                                cTemp = (byte)(cTemp | 1 << j);
                            }
                            ++j;
                        }
                        acBuffer[nOffset++] = cTemp;
                        --i;
                    }
                    break;
                }
                case 4: {
                    String szText = (String)DataToWrite;
                    if (szText.length() > Register.getSize()) {
                        szText = szText.substring(0, Register.getSize());
                    }
                    byte[] acText = szText.getBytes();
                    int i = 0;
                    while (i < Register.getSize()) {
                        acBuffer[nOffset++] = i < szText.length() ? acText[i] : (byte)0;
                        ++i;
                    }
                    break;
                }
                case 5: {
                    Byte[] aByte = (Byte[])DataToWrite;
                    int i = Register.getSize() - 1;
                    while (i >= 0) {
                        acBuffer[nOffset++] = aByte[i];
                        --i;
                    }
                    break;
                }
                case 6: {
                    double dValue = (Double)DataToWrite;
                    long lValue = (long)(dValue * Math.pow(2.0, 8 * Register.getSize() / 2));
                    int i = Register.getSize() - 1;
                    while (i >= 0) {
                        acBuffer[nOffset++] = (byte)(lValue >> i * 8 & 0xFFL);
                        --i;
                    }
                    break;
                }
                case 7: {
                    double dValue = (Double)DataToWrite;
                    long lValue = (long)(dValue * Math.pow(2.0, 24 * Register.getSize() / 4));
                    int i = Register.getSize() - 1;
                    while (i >= 0) {
                        acBuffer[nOffset++] = (byte)(lValue >> i * 8 & 0xFFL);
                        --i;
                    }
                    break;
                }
                case 8: {
                    double dValue = (Double)DataToWrite;
                    long lValue = (long)(dValue * Math.pow(2.0, 8 * Register.getSize() / 4));
                    int i = Register.getSize() - 1;
                    while (i >= 0) {
                        acBuffer[nOffset++] = (byte)(lValue >> i * 8 & 0xFFL);
                        --i;
                    }
                    break;
                }
                default: {
                    nOffset += Register.getSize();
                }
            }
        }
        return nOffset;
    }

    @Override
    protected int getDataFromBuffer(FCOCRegisterBase Register, byte[] acBuffer, int nOffset) {
        switch (Register.getDataType()) {
            case 0: 
            case 1: 
            case 3: 
            case 6: 
            case 7: 
            case 8: {
                long lValue = 0L;
                int i = Register.getSize() - 1;
                while (i >= 0) {
                    long lMask = i == Register.getSize() - 1 && (Register.getDataType() == 0 || Register.getDataType() == 6 || Register.getDataType() == 7 || Register.getDataType() == 8) ? -1L : 255L;
                    lValue |= ((long)acBuffer[nOffset++] & lMask) << i * 8;
                    --i;
                }
                if (Register.getDataType() == 3) {
                    Register.setDataRead((double)(100L * lValue) / Math.pow(2.0, Register.getSize() * 8));
                    break;
                }
                if (Register.getDataType() == 6) {
                    Register.setDataRead((double)lValue / Math.pow(2.0, 8 * Register.getSize() / 2));
                    break;
                }
                if (Register.getDataType() == 7) {
                    Register.setDataRead((double)lValue / Math.pow(2.0, 24 * Register.getSize() / 4));
                    break;
                }
                if (Register.getDataType() == 8) {
                    Register.setDataRead((double)lValue / Math.pow(2.0, 8 * Register.getSize() / 4));
                    break;
                }
                Register.setDataRead(lValue);
                break;
            }
            case 2: {
                BitSet Data = new BitSet(Register.getSize() * 8);
                int i = Register.getSize() - 1;
                while (i >= 0) {
                    byte cTemp = acBuffer[nOffset++];
                    int j = 0;
                    while (j < 8) {
                        if ((cTemp & 1 << j) == 1 << j) {
                            Data.set(8 * i + j);
                        }
                        ++j;
                    }
                    --i;
                }
                Register.setDataRead(Data);
                break;
            }
            case 4: {
                Register.setDataRead(FCOCUtils.byteArrayToString(acBuffer, nOffset, Register.getSize()));
                nOffset += Register.getSize();
                break;
            }
            case 5: {
                Byte[] aData = new Byte[Register.getSize()];
                int i = Register.getSize() - 1;
                while (i >= 0) {
                    aData[i] = acBuffer[nOffset++];
                    --i;
                }
                Register.setDataRead(aData);
                break;
            }
            default: {
                nOffset += Register.getSize();
            }
        }
        return nOffset;
    }

    protected void writeComLog(String szDesc, byte[] acBuffer, int nFirstIndex, int nLastIndex, boolean addExtraReturn) {
        Date now = new Date();
        SimpleDateFormat df = new SimpleDateFormat("dd.MM.yyyy hh:mm:ss:SSS ");
        String currentTime = df.format(now);
        try {
            Throwable throwable = null;
            Object var10_12 = null;
            try (FileWriter aWriter = new FileWriter(m_szLOGFILENAME, true);){
                aWriter.write(String.valueOf(System.getProperty("line.separator")) + currentTime + " " + szDesc + FCOCUtils.byteArrayBEToUnsignedInt(acBuffer, 2, 2) + ", " + "length=" + FCOCUtils.byteArrayBEToUnsignedInt(acBuffer, 4, 2) + ")" + (nFirstIndex + 6 < nLastIndex ? ":" : ""));
                int i = nFirstIndex + 6;
                while (i < nLastIndex) {
                    if ((i - 6) % 16 == 0) {
                        aWriter.write(String.valueOf(System.getProperty("line.separator")) + "\tI" + FCOCUtils.toHexString(i - 6) + "h ");
                    }
                    aWriter.write(String.valueOf(FCOCUtils.toHexString(acBuffer[i] & 0xFF)) + " ");
                    ++i;
                }
                if (addExtraReturn) {
                    aWriter.write(System.getProperty("line.separator"));
                }
                aWriter.flush();
                aWriter.close();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected int handleAnswer(int nBytesReceived, byte[] acBuffer) {
        while (nBytesReceived >= 8) {
            int nLengthOfParameters = FCOCIPDevice.getUShortFromBuffer(acBuffer, 4);
            if (nBytesReceived < nLengthOfParameters + 8) break;
            int nChecksumReceived = FCOCIPDevice.getUShortFromBuffer(acBuffer, nLengthOfParameters + 6);
            int nChecksum = FCOCIPDevice.calcChecksum(acBuffer, nLengthOfParameters + 6);
            if (acBuffer[0] == 0 && nChecksumReceived == nChecksum) {
                switch (acBuffer[1]) {
                    case 35: {
                        if (m_isDebugLogEnabled) {
                            this.writeComLog("Receive read packet answer (ID=", acBuffer, 0, 8 + nLengthOfParameters, true);
                        }
                        int i = 6;
                        while (i < 6 + nLengthOfParameters) {
                            FCOCRegisterBase RegisterItem;
                            int y = i;
                            FCOCDevice.CQueueElement QueuEl = (FCOCDevice.CQueueElement)this.m_ReadCallbackQueue.poll();
                            if (QueuEl != null) {
                                RegisterItem = QueuEl.m_Register;
                                if (RegisterItem.getAddress() != acBuffer[i] || i + RegisterItem.getSize() > 6 + nLengthOfParameters) {
                                    System.err.println("FCOCIPDevice error: Register address in answer is not the one expected or value size is too low\t !");
                                    this.fireComDevEvtOccured(this, FCOEComState.UNKNOWNERROR);
                                    return 0;
                                }
                            } else {
                                System.err.println("FCOCIPDevice error: Unexpected data in answer packet !");
                                this.fireComDevEvtOccured(this, FCOEComState.UNKNOWNERROR);
                                return 0;
                            }
                            y = this.getDataFromBuffer(RegisterItem, acBuffer, i + 1) - 1;
                            this.fireDataDevEvtOccured(this, this.getKeyFromValue(RegisterItem, this.m_aRegistersList), RegisterItem.getDataRead(), FCOEDataEventType.VALIDDATAEVENT, QueuEl.m_CallbackParameter);
                            i = y;
                            ++i;
                        }
                        break;
                    }
                    case 36: {
                        if (!m_isDebugLogEnabled) break;
                        this.writeComLog("Receive write packet answer (ID=", acBuffer, 0, 8 + nLengthOfParameters, true);
                        break;
                    }
                    default: {
                        System.err.println("FCOCIPDevice Error: received a bad command code from device.");
                        this.fireComDevEvtOccured(this, FCOEComState.UNKNOWNERROR);
                        if (!m_isDebugLogEnabled) break;
                        this.writeComLog("Error: received a bad command code from device: 0x" + FCOCUtils.toHexString(acBuffer[1] & 0xFF), acBuffer, 0, 0, true);
                    }
                }
                int j = 0;
                int i = nLengthOfParameters + 8;
                while (i < nBytesReceived) {
                    acBuffer[j++] = acBuffer[i];
                    ++i;
                }
                nBytesReceived -= nLengthOfParameters + 8;
                continue;
            }
            System.err.println("FCOCIPDevice Error: received a bad packet from device.");
            this.fireComDevEvtOccured(this, FCOEComState.CHECKSUMERROR);
            return 0;
        }
        return 1;
    }

    protected synchronized boolean isNextReadIP() {
        return this.m_DevicesStep == EDeviceSteps.IPRead;
    }

    protected FCOCDevice.CGetNextPacketResult getNextPacket(byte[] acBuffer, int nBufferOffset, int nAvailableTxBufSpace, int nAvailableRxBufSpace) {
        FCOCDevice.CGetNextPacketResult Return = new FCOCDevice.CGetNextPacketResult(this);
        int nReturnBufSize = 8;
        int nInitialBufferOffset = nBufferOffset;
        switch (this.m_DevicesStep) {
            case IPWrite: {
                if (this.m_WriteQueue.size() > 0) {
                    nBufferOffset += 6;
                    do {
                        FCOCRegisterBase Register;
                        if (nBufferOffset + (Register = (FCOCRegisterBase)this.m_WriteQueue.peek()).getSize() + 1 >= nAvailableTxBufSpace - 2) {
                            if (!m_isDebugLogEnabled) break;
                            this.fireComDevEvtOccured(this, FCOEComState.FRAGMENTED);
                            break;
                        }
                        this.m_WriteQueue.poll();
                        nBufferOffset = this.fillBufferWithData(Register, acBuffer, nBufferOffset);
                    } while (this.m_WriteQueue.size() > 0);
                    FCOCIPDevice.setUShortToBuffer(acBuffer, nInitialBufferOffset, 34);
                    FCOCIPDevice.setUShortToBuffer(acBuffer, 2 + nInitialBufferOffset, this.m_nUniqueID++);
                    FCOCIPDevice.setUShortToBuffer(acBuffer, 4 + nInitialBufferOffset, nBufferOffset - nInitialBufferOffset - 6);
                    FCOCIPDevice.setUShortToBuffer(acBuffer, nBufferOffset, FCOCIPDevice.calcChecksum(acBuffer, nBufferOffset - nInitialBufferOffset));
                    nBufferOffset += 2;
                    if (m_isDebugLogEnabled) {
                        this.writeComLog("Send write packet (ID=", acBuffer, nInitialBufferOffset, nBufferOffset, false);
                    }
                }
                Return.m_nBufferOffset = nBufferOffset;
                Return.m_nExpectedReturnBufSize = nReturnBufSize;
                boolean bl = Return.m_isNotFinished = this.m_WriteQueue.size() > 0;
                if (Return.m_isNotFinished) break;
                if (this.getClass() == FCOCIPDevice.class) {
                    this.m_DevicesStep = EDeviceSteps.IPRead;
                    break;
                }
                this.m_DevicesStep = EDeviceSteps.IPSub;
                break;
            }
            default: {
                if (!this.m_isStillWaitingRead) {
                    this.addAutoreadRegisterToQueue();
                }
                if (this.m_ReadQueue.size() > 0) {
                    nBufferOffset += 6;
                    do {
                        FCOCDevice.CQueueElement QueueElement = (FCOCDevice.CQueueElement)this.m_ReadQueue.peek();
                        FCOCRegisterBase Register = QueueElement.m_Register;
                        if (nBufferOffset < nAvailableTxBufSpace - 2 && nReturnBufSize + Register.getSize() + 1 < nAvailableRxBufSpace - 8) {
                            this.m_ReadCallbackQueue.add((FCOCDevice.CQueueElement)this.m_ReadQueue.poll());
                            acBuffer[nBufferOffset++] = (byte)Register.getAddress();
                            nReturnBufSize += 1 + Register.getSize();
                            continue;
                        }
                        if (!m_isDebugLogEnabled) break;
                        this.fireComDevEvtOccured(this, FCOEComState.FRAGMENTED);
                        break;
                    } while (this.m_ReadQueue.size() > 0);
                    FCOCIPDevice.setUShortToBuffer(acBuffer, nInitialBufferOffset, 33);
                    FCOCIPDevice.setUShortToBuffer(acBuffer, 2 + nInitialBufferOffset, this.m_nUniqueID++);
                    FCOCIPDevice.setUShortToBuffer(acBuffer, 4 + nInitialBufferOffset, nBufferOffset - nInitialBufferOffset - 6);
                    FCOCIPDevice.setUShortToBuffer(acBuffer, nBufferOffset, FCOCIPDevice.calcChecksum(acBuffer, nBufferOffset - nInitialBufferOffset));
                    nBufferOffset += 2;
                    if (m_isDebugLogEnabled) {
                        this.writeComLog("Send read packet (ID=", acBuffer, nInitialBufferOffset, nBufferOffset, false);
                    }
                }
                this.m_isStillWaitingRead = this.m_ReadQueue.size() > 0;
                Return.m_nBufferOffset = nBufferOffset;
                Return.m_nExpectedReturnBufSize = nReturnBufSize;
                Return.m_isNotFinished = this.m_isStillWaitingRead;
                if (this.m_isInterfaceComSupended || this.m_isStillWaitingRead) break;
                this.m_DevicesStep = EDeviceSteps.IPWrite;
            }
        }
        return Return;
    }

    @Override
    public void run() {
        boolean isConnected = false;
        boolean isDisconnectEventSent = false;
        int nTimeoutCount = 0;
        long lPreviousTimestamp = Calendar.getInstance().getTime().getTime();
        boolean isPeriodTooShort = false;
        while (this.m_isThreadEnabled) {
            byte[] acBuffer = new byte[this.m_nBufferSize];
            if (!isConnected) {
                switch (this.m_CommPort.getState()) {
                    case Open: {
                        lPreviousTimestamp = Calendar.getInstance().getTime().getTime();
                        nTimeoutCount = 0;
                        this.m_nPeriodTooShortCount = 0;
                        this.fireComDevEvtOccured(this, FCOEComState.CONNECTED);
                        this.m_ReadCallbackQueue.clear();
                        this.m_isWaitingAnswer = false;
                        isConnected = true;
                        isDisconnectEventSent = false;
                        break;
                    }
                    case Opening: {
                        if (this.m_DeviceComState == FCOEComState.CONNECTING) break;
                        this.fireComDevEvtOccured(this, FCOEComState.CONNECTING);
                        break;
                    }
                    default: {
                        if (!isDisconnectEventSent) {
                            this.fireComDevEvtOccured(this, FCOEComState.DISCONNECTED);
                            isDisconnectEventSent = true;
                        }
                        try {
                            this.m_CommPort.open();
                            break;
                        }
                        catch (IOException e) {
                            System.out.println("FCOCIPDevice: Unable to open TCP port: " + e.getMessage());
                            this.fireComDevEvtOccured(this, FCOEComState.FAILED);
                        }
                    }
                }
            }
            if (!this.m_isInterfaceComSupended && isConnected) {
                this.m_ReadCallbackQueue.clear();
                FCOCDevice.CGetNextPacketResult Request = this.getNextPacket(acBuffer, 0, this.m_nBufferSize, this.m_nBufferSize);
                int nOutBufferOffset = Request.m_nBufferOffset;
                int nReturnBufSize = Request.m_nExpectedReturnBufSize;
                boolean isStillWaitingRead = Request.m_isNotFinished;
                if (nOutBufferOffset > 0) {
                    try {
                        this.m_CommPort.discardInputBuffer();
                        this.m_CommPort.putData(acBuffer, 0, nOutBufferOffset);
                        this.m_isWaitingAnswer = nReturnBufSize > 0;
                    }
                    catch (Exception e) {
                        System.err.println("Can't write to m_CommPort ! " + e.getMessage());
                        this.m_CommPort.close();
                        isConnected = false;
                        this.fireComDevEvtOccured(this, FCOEComState.LOST);
                    }
                } else {
                    this.m_isWaitingAnswer = false;
                }
                if (this.m_isWaitingAnswer) {
                    int nBytesReceived = 0;
                    int nBytesReceivedLastLoop = 0;
                    int nRxTryTimeout = 200;
                    while (nRxTryTimeout > 0) {
                        if (!isConnected) break;
                        StopWatch stopWatch = new StopWatch();
                        stopWatch.start();
                        try {
                            if (nReturnBufSize == 0 || nBytesReceived < nReturnBufSize) {
                                nBytesReceivedLastLoop = this.m_CommPort.getData(acBuffer, nBytesReceived, nReturnBufSize - nBytesReceived, nRxTryTimeout);
                                nBytesReceived += nBytesReceivedLastLoop;
                            }
                        }
                        catch (ArrayIndexOutOfBoundsException ArrayIndexOutOfBoundsEx) {
                            System.out.println("FCOCRAPDevice error: ArrayIndexOutOfBoundsException ! " + ArrayIndexOutOfBoundsEx.getMessage());
                            this.fireComDevEvtOccured(this, FCOEComState.LOST);
                            isConnected = false;
                        }
                        catch (IOException IOExc) {
                            System.out.println("FCOCRAPDevice error: ArrayIndexOutOfBoundsException ! " + IOExc.getMessage());
                            IOExc.printStackTrace();
                        }
                        if (nReturnBufSize > 0 && nBytesReceived >= nReturnBufSize) {
                            if (this.handleAnswer(nBytesReceived, acBuffer) == 0) {
                                nReturnBufSize = 0;
                                nBytesReceived = 0;
                            } else {
                                stopWatch.stop();
                                break;
                            }
                        }
                        stopWatch.stop();
                        nRxTryTimeout -= (int)stopWatch.getLastTaskTimeMillis();
                    }
                    if (nBytesReceived == 0) {
                        this.fireComDevEvtOccured(this, FCOEComState.TIMEOUT);
                        if (m_isDebugLogEnabled) {
                            this.writeComLog("Timeout occured", acBuffer, 0, 0, false);
                        }
                        nTimeoutCount = Math.max(1, (int)(1000L / this.m_lThreadLoopTime));
                    } else {
                        try {
                            if ((nReturnBufSize == 0 || nBytesReceived < nReturnBufSize) && this.handleAnswer(nBytesReceived, acBuffer) == 0) {
                                this.fireComDevEvtOccured(this, FCOEComState.TIMEOUT);
                                if (m_isDebugLogEnabled) {
                                    this.writeComLog("Timeout occured", acBuffer, 0, 0, false);
                                }
                            }
                            if (--nTimeoutCount == 0) {
                                this.fireComDevEvtOccured(this, FCOEComState.CONNECTED);
                                isPeriodTooShort = false;
                            } else if (nTimeoutCount < -1000) {
                                nTimeoutCount = -1;
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            isConnected = false;
                            this.fireComDevEvtOccured(this, FCOEComState.LOST);
                        }
                    }
                }
                try {
                    long lSleepTime = 2L;
                    if (!isStillWaitingRead && this.isNextReadIP()) {
                        long lCurrentTimestamp = Calendar.getInstance().getTime().getTime();
                        long lDelta = lCurrentTimestamp - lPreviousTimestamp;
                        long lTheoreticalSleepTime = lSleepTime = this.m_lThreadLoopTime - lDelta;
                        if (lSleepTime < 0L) {
                            lSleepTime = 2L;
                            ++this.m_nPeriodTooShortCount;
                            if (this.m_nPeriodTooShortCount > 10) {
                                this.fireComDevEvtOccured(this, FCOEComState.PERIODTOOSHORT);
                                isPeriodTooShort = true;
                            }
                            this.m_nPeriodTooShortCount = 10;
                        } else {
                            --this.m_nPeriodTooShortCount;
                        }
                        if (isPeriodTooShort && this.m_nPeriodTooShortCount < -5) {
                            isPeriodTooShort = false;
                            this.m_nPeriodTooShortCount = -6;
                            this.fireComDevEvtOccured(this, FCOEComState.CONNECTED);
                        }
                        lPreviousTimestamp += (long)(lTheoreticalSleepTime < 0L ? (int)(Math.abs(lTheoreticalSleepTime) / this.m_lThreadLoopTime) + 1 : 1) * this.m_lThreadLoopTime;
                    }
                    Thread.sleep(lSleepTime);
                }
                catch (InterruptedException interruptedException) {}
                continue;
            }
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (this.m_CommPort != null) {
            this.m_CommPort.close();
        }
        this.fireComDevEvtOccured(this, FCOEComState.DISCONNECTED);
    }

    protected static enum EDeviceSteps {
        IPRead,
        IPWrite,
        IPSub;

    }
}

