/*
 * Decompiled with CFR 0.152.
 */
package com.fivecolibs.devices;

import com.fivecolibs.devices.FCOCInterfaceInfo;
import com.fivecolibs.devices.FCOCRegisterBase;
import com.fivecolibs.devices.FCOEComState;
import com.fivecolibs.devices.FCOEDataEventType;
import com.fivecolibs.devices.FCOIDeviceEvent;
import com.fivecolibs.utils.FCOCUtils;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.swing.event.EventListenerList;

public abstract class FCOCDevice
implements Runnable {
    private static final byte ucGETINTERFACEINFOVERSION = 0;
    private static final byte ucSUBMENUGETINTERFACEINFO = 2;
    private static final byte ucGETINFO = 5;
    protected static boolean m_isDebugLogEnabled = false;
    protected FCOEComState m_DeviceComState = FCOEComState.DISCONNECTED;
    protected long m_lThreadLoopTime = 1000L;
    protected boolean m_isInterfaceComSupended = false;
    protected boolean m_isWaitingAnswer = false;
    protected boolean m_isAutoreadSuspended = false;
    protected EventListenerList m_ListenerList = new EventListenerList();
    protected final Hashtable<String, FCOCRegisterBase> m_aRegistersList;
    protected final Thread m_ComThread;
    protected boolean m_isThreadEnabled = true;
    protected int m_nUniqueID = 0;
    protected final ConcurrentLinkedQueue<FCOCRegisterBase> m_WriteQueue = new ConcurrentLinkedQueue();
    protected final ConcurrentLinkedQueue<CQueueElement> m_ReadQueue = new ConcurrentLinkedQueue();
    protected final ConcurrentLinkedQueue<CQueueElement> m_ReadCallbackQueue = new ConcurrentLinkedQueue();
    protected int m_nBufferSize;
    protected int m_nParentMaxBufferSize;
    protected FCOIDeviceEvent m_DevInfoDevEvt;
    public FCOCInterfaceInfo[] m_aInterfacesInfo = new FCOCInterfaceInfo[16];

    public FCOCDevice(int nNumberOfRegisters, int nBufferSize, long lThreadLoopTime, int nParentMaxBufferSize) {
        if (nBufferSize < 50) {
            throw new IllegalArgumentException("Buffer size must be at least 50 bytes !");
        }
        this.m_aRegistersList = new Hashtable(nNumberOfRegisters);
        this.m_ComThread = new Thread((Runnable)this, "ComThread");
        this.m_nBufferSize = nBufferSize;
        this.m_lThreadLoopTime = lThreadLoopTime;
        this.m_nParentMaxBufferSize = nParentMaxBufferSize;
    }

    public FCOCDevice(int nNumberOfRegisters, int nBufferSize, long lThreadLoopTime) {
        this(nNumberOfRegisters, nBufferSize, lThreadLoopTime, nBufferSize);
    }

    public FCOCDevice(int nNumberOfRegisters, int nBufferSize) {
        this(nNumberOfRegisters, nBufferSize, 1000L, nBufferSize);
    }

    public void setMaxParentBufferSize(int nParentMaxBufferSize) {
        this.m_nParentMaxBufferSize = nParentMaxBufferSize;
        if (this.m_nBufferSize > this.m_nParentMaxBufferSize) {
            this.m_nBufferSize = this.m_nParentMaxBufferSize;
        }
    }

    public void setBufferSize(int nBufferSize) {
        this.m_nBufferSize = nBufferSize;
    }

    public int getBufferSize() {
        return this.m_nBufferSize;
    }

    public abstract void delete();

    public void addDeviceListener(FCOIDeviceEvent DevListener) {
        this.m_ListenerList.add(FCOIDeviceEvent.class, DevListener);
    }

    public void removeDeviceListener(FCOIDeviceEvent DevListener) {
        this.m_ListenerList.remove(FCOIDeviceEvent.class, DevListener);
    }

    public FCOIDeviceEvent[] getDeviceListeners() {
        return (FCOIDeviceEvent[])this.m_ListenerList.getListeners(FCOIDeviceEvent.class);
    }

    public void setInterfaceComSupendedState(boolean isInterfaceComSupended) {
        this.m_isInterfaceComSupended = isInterfaceComSupended;
    }

    public void setDebugLogEnabled(boolean isEnabled) {
        m_isDebugLogEnabled = isEnabled;
    }

    public void setAutoreadSupended(boolean isSuspended) {
        this.m_isAutoreadSuspended = isSuspended;
    }

    public void setThreadLoopTime(long lThreadLoopTime) {
        this.m_lThreadLoopTime = lThreadLoopTime;
        System.out.println("Com thread sleep time changed to " + lThreadLoopTime + " ms.");
    }

    public long getThreadLoopTime() {
        return this.m_lThreadLoopTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRegister(String szRegisterName, int nRegisterAddress, int nRegisterSize, int nRegisterAccessType, int nDataType, boolean isAutoReadEnabled, Object GeneralCallbackParameter) throws IllegalArgumentException {
        FCOCRegisterBase NewRegister = new FCOCRegisterBase(nRegisterAddress, nRegisterSize, nRegisterAccessType, nDataType, isAutoReadEnabled, GeneralCallbackParameter);
        Hashtable<String, FCOCRegisterBase> hashtable = this.m_aRegistersList;
        synchronized (hashtable) {
            this.m_aRegistersList.put(szRegisterName, NewRegister);
        }
    }

    public void addRegister(String szRegisterName, int nRegisterAddress, int nRegisterSize, int nRegisterAccessType, int nDataType, boolean isAutoReadEnabled) throws IllegalArgumentException {
        this.addRegister(szRegisterName, nRegisterAddress, nRegisterSize, nRegisterAccessType, nDataType, isAutoReadEnabled, null);
    }

    public boolean getRegisterAddress(String szRegisterName, Integer nRegisterAddress) {
        FCOCRegisterBase Register = this.m_aRegistersList.get(szRegisterName);
        if (Register != null) {
            nRegisterAddress = Register.getAddress();
            return true;
        }
        nRegisterAddress = 0;
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FCOCRegisterBase removeRegister(String szRegisterName) {
        Hashtable<String, FCOCRegisterBase> hashtable = this.m_aRegistersList;
        synchronized (hashtable) {
            return this.m_aRegistersList.remove(szRegisterName);
        }
    }

    public void call(String szRegisterName) throws IllegalArgumentException {
        FCOCRegisterBase Register = this.getRegisterObject(szRegisterName);
        if (Register.getAccesType() != 0) {
            throw new IllegalArgumentException("Register " + szRegisterName + " is not a function.");
        }
        this.addElementToWriteQueue(Register);
    }

    public void setValue(String szRegisterName, Object Value, boolean isMandatory) throws IllegalArgumentException {
        FCOCRegisterBase Register = this.getRegisterObject(szRegisterName);
        if (Register.getAccesType() == 2 || Register.getAccesType() == 3) {
            if (this.isWriteQueueContains(Register) && !isMandatory) {
                return;
            }
        } else {
            throw new IllegalArgumentException("Register " + szRegisterName + " is not writable.");
        }
        Register.setDataToWrite(Value);
        this.addElementToWriteQueue(Register);
    }

    public void setValue(String szRegisterName, Object Value) throws IllegalArgumentException {
        this.setValue(szRegisterName, Value, true);
    }

    public void getValue(String szRegisterName) throws IllegalArgumentException {
        this.getValue(szRegisterName, false, null);
    }

    public void getValue(String szRegisterName, boolean isForced, Object CallbackParameter) throws IllegalArgumentException {
        FCOCRegisterBase Register = this.getRegisterObject(szRegisterName);
        if (Register.getAccesType() == 1 || Register.getAccesType() == 3) {
            if (!isForced && this.isReadQueueContains(Register)) {
                System.out.println("Warning : Register " + szRegisterName + " already in read queue. Skipping.");
            } else {
                this.addElementToReadQueue(new CQueueElement(Register, CallbackParameter, true));
            }
        } else {
            throw new IllegalArgumentException("Register " + szRegisterName + " is not readable.");
        }
    }

    public Object getLastValueRead(String szRegisterName) throws IllegalArgumentException {
        FCOCRegisterBase Register = this.getRegisterObject(szRegisterName);
        if (Register.getAccesType() != 0) {
            return Register.getDataRead();
        }
        throw new IllegalArgumentException("Register " + szRegisterName + " is a function.");
    }

    public Object getLastValueWritten(String szRegisterName) throws IllegalArgumentException {
        FCOCRegisterBase Register = this.getRegisterObject(szRegisterName);
        if (Register.getAccesType() != 0) {
            return Register.getDataLastWritten();
        }
        throw new IllegalArgumentException("Register " + szRegisterName + " is a function.");
    }

    public boolean askGetInterfaceInfo(boolean isCreateRegisters, Object Asker) {
        Integer nAddress = 0;
        CGetIntInfoPara CallbackPara = new CGetIntInfoPara(Asker, false);
        if (!this.getRegisterAddress("FlashPointer", nAddress)) {
            if (!isCreateRegisters) {
                System.out.println("Could not reach the <FlashPointer> register in the register list of the device");
                return false;
            }
            this.addRegister("FlashPointer", 28, 6, 3, 5, false, new Boolean(true));
            CallbackPara = new CGetIntInfoPara(Asker, true);
        }
        if (!this.getRegisterAddress("ForceDataFlash", nAddress)) {
            if (!isCreateRegisters) {
                System.out.println("Could not reach the <ForceDataFlash> register in the register list of the device");
                return false;
            }
            this.addRegister("ForceDataFlash", 29, 0, 0, 5, false, new Boolean(true));
        }
        if (!this.getRegisterAddress("FlashData0", nAddress)) {
            if (!isCreateRegisters) {
                System.out.println("Could not reach the <FlashData0> register in the register list of the device");
                return false;
            }
            this.addRegister("FlashData0", 24, 16, 3, 5, false, new Boolean(true));
        }
        if (!this.getRegisterAddress("FlashData1", nAddress)) {
            if (!isCreateRegisters) {
                System.out.println("Could not reach the <FlashData1> register in the register list of the device");
                return false;
            }
            this.addRegister("FlashData1", 25, 16, 3, 5, false, new Boolean(true));
        }
        if (!this.getRegisterAddress("FlashData2", nAddress)) {
            if (!isCreateRegisters) {
                System.out.println("Could not reach the <FlashData2> register in the register list of the device");
                return false;
            }
            this.addRegister("FlashData2", 26, 16, 3, 5, false, new Boolean(true));
        }
        if (!this.getRegisterAddress("FlashData3", nAddress)) {
            if (!isCreateRegisters) {
                System.out.println("Could not reach the <FlashData3> register in the register list of the device");
                return false;
            }
            this.addRegister("FlashData3", 27, 16, 3, 5, false, new Boolean(true));
        }
        int i = 0;
        while (i < this.m_aInterfacesInfo.length) {
            this.m_aInterfacesInfo[i] = null;
            ++i;
        }
        this.m_DevInfoDevEvt = new FCOIDeviceEvent(){

            @Override
            public void comDevEvtOccured(FCOCDevice Source, FCOEComState ComState) {
            }

            @Override
            public void dataDevEvtOccured(FCOCDevice Source, String szRegisterName, Object Data, FCOEDataEventType EvtType, Object CallbackParameter) {
                block7: {
                    if (EvtType != FCOEDataEventType.VALIDDATAEVENT) break block7;
                    switch (szRegisterName) {
                        case "FlashPointer": {
                            Byte[] aucFlashPointer = (Byte[])Data;
                            if (aucFlashPointer[0] != 5 || aucFlashPointer[1] != 2) break;
                            FCOCDevice.this.receivedGetInterfacesInfo(CallbackParameter);
                        }
                    }
                }
            }

            @Override
            public void autoreadRegAddedToQueue(FCOCDevice Source, String szRegisterName, Object CallbackParameter) {
            }
        };
        this.addDeviceListener(this.m_DevInfoDevEvt);
        Byte[] aucSendBytes = new Byte[]{(byte)5, (byte)2, (byte)0, (byte)0, (byte)0, (byte)0};
        this.setValue("FlashPointer", aucSendBytes, true);
        this.call("ForceDataFlash");
        this.getValue("FlashData0", true, null);
        this.getValue("FlashData1", true, null);
        this.getValue("FlashData2", true, null);
        this.getValue("FlashData3", true, null);
        this.getValue("FlashPointer", true, CallbackPara);
        return true;
    }

    public boolean receivedGetInterfacesInfo(Object CallbackParameter) {
        Byte b;
        Integer nAddress = 0;
        CGetIntInfoPara CallbackPara = (CGetIntInfoPara)CallbackParameter;
        this.removeDeviceListener(this.m_DevInfoDevEvt);
        this.m_DevInfoDevEvt = null;
        if (!this.getRegisterAddress("FlashData0", nAddress)) {
            System.out.println("Could not reach the <FlashData0> register in the register list of the device");
            return false;
        }
        if (!this.getRegisterAddress("FlashData1", nAddress)) {
            System.out.println("Could not reach the <FlashData1> register in the register list of the device");
            return false;
        }
        if (!this.getRegisterAddress("FlashData2", nAddress)) {
            System.out.println("Could not reach the <FlashData2> register in the register list of the device");
            return false;
        }
        if (!this.getRegisterAddress("FlashData3", nAddress)) {
            System.out.println("Could not reach the <FlashData3> register in the register list of the device");
            return false;
        }
        byte[] aucFlashData = new byte[64];
        int j = 0;
        Byte[] byteArray = (Byte[])this.getLastValueRead("FlashData0");
        int n = byteArray.length;
        int n2 = 0;
        while (n2 < n) {
            b = byteArray[n2];
            aucFlashData[j++] = b;
            ++n2;
        }
        byteArray = (Byte[])this.getLastValueRead("FlashData1");
        n = byteArray.length;
        n2 = 0;
        while (n2 < n) {
            b = byteArray[n2];
            aucFlashData[j++] = b;
            ++n2;
        }
        byteArray = (Byte[])this.getLastValueRead("FlashData2");
        n = byteArray.length;
        n2 = 0;
        while (n2 < n) {
            b = byteArray[n2];
            aucFlashData[j++] = b;
            ++n2;
        }
        byteArray = (Byte[])this.getLastValueRead("FlashData3");
        n = byteArray.length;
        n2 = 0;
        while (n2 < n) {
            b = byteArray[n2];
            aucFlashData[j++] = b;
            ++n2;
        }
        if (aucFlashData[0] != 0 || aucFlashData[2] != 2) {
            System.out.println("The get interfaces info answer is not correct. Version : " + aucFlashData[0] + " instead of " + 0 + ", Submenu: " + aucFlashData[2] + " instead of " + 2 + ".");
            return false;
        }
        int ucLength = aucFlashData[1];
        if (ucLength > 64) {
            System.out.println("The get interfaces info answer length is not correct. " + ucLength + " is bigger than 64.");
            return false;
        }
        int nInterfaceNumber = 0;
        int i = 3;
        while (i < ucLength) {
            byte ucSubLength = (byte)(aucFlashData[i] & 0xF);
            switch (ucSubLength) {
                case 0: {
                    this.m_aInterfacesInfo[nInterfaceNumber++] = new FCOCInterfaceInfo(aucFlashData[i]);
                    break;
                }
                case 1: {
                    this.m_aInterfacesInfo[nInterfaceNumber++] = new FCOCInterfaceInfo(aucFlashData[i], aucFlashData[i + 1]);
                    break;
                }
                case 2: {
                    this.m_aInterfacesInfo[nInterfaceNumber++] = new FCOCInterfaceInfo(aucFlashData[i], aucFlashData[i + 1], aucFlashData[i + 2]);
                    break;
                }
                case 3: {
                    this.m_aInterfacesInfo[nInterfaceNumber++] = new FCOCInterfaceInfo(aucFlashData[i], aucFlashData[i + 1], aucFlashData[i + 2], aucFlashData[i + 3]);
                    break;
                }
                default: {
                    int nMaxSize = (int)FCOCUtils.byteArrayLEToUnsignedInt(aucFlashData, i + 3, 2);
                    this.m_aInterfacesInfo[nInterfaceNumber++] = new FCOCInterfaceInfo(aucFlashData[i], aucFlashData[i + 1], aucFlashData[i + 2], nMaxSize);
                }
            }
            i += ucSubLength;
            ++i;
        }
        FCOIDeviceEvent[] listeners = this.getDeviceListeners();
        int i2 = listeners.length - 1;
        while (i2 >= 0) {
            listeners[i2].interfaceInfoReceived(this, this.m_aInterfacesInfo, CallbackPara.m_CallerCallBackPara);
            --i2;
        }
        if (CallbackPara.m_isAutoCreated) {
            this.removeRegister("FlashPointer");
            this.removeRegister("ForceDataFlash");
            this.removeRegister("FlashData0");
            this.removeRegister("FlashData1");
            this.removeRegister("FlashData2");
            this.removeRegister("FlashData3");
        }
        return true;
    }

    public int getThisInterfaceInfo() {
        int i = 0;
        while (i < this.m_aInterfacesInfo.length) {
            FCOCInterfaceInfo IntInfo = this.m_aInterfacesInfo[i];
            if (IntInfo != null && IntInfo.m_isTheInterfaceToCommunicate) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void setAutoreadState(String szRegisterName, boolean isAutoReadEnabled) throws IllegalArgumentException {
        this.getRegisterObject(szRegisterName).setAutoReadEnabled(isAutoReadEnabled);
    }

    public abstract void removeSubDevice(String var1);

    public abstract FCOCDevice addSubDevice(String var1, int var2, int var3, int var4) throws IOException;

    public abstract int getInterface();

    protected abstract void addElementToReadQueue(CQueueElement var1);

    protected abstract void addElementToWriteQueue(FCOCRegisterBase var1);

    protected abstract boolean isReadQueueContains(FCOCRegisterBase var1);

    protected abstract boolean isWriteQueueContains(FCOCRegisterBase var1);

    protected void fireComDevEvtOccured(FCOCDevice Source, FCOEComState ComState) {
        this.m_DeviceComState = ComState;
        FCOIDeviceEvent[] listeners = this.getDeviceListeners();
        int i = listeners.length - 1;
        while (i >= 0) {
            listeners[i].comDevEvtOccured(Source, ComState);
            --i;
        }
    }

    protected void fireDataDevEvtOccured(FCOCDevice Source, String szRegisterName, Object Data, FCOEDataEventType EvtType, Object CallbackParameter) {
        FCOIDeviceEvent[] listeners = this.getDeviceListeners();
        int i = listeners.length - 1;
        while (i >= 0) {
            listeners[i].dataDevEvtOccured(Source, szRegisterName, Data, EvtType, CallbackParameter);
            --i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addAutoreadRegisterToQueue() {
        if (this.m_isAutoreadSuspended) {
            return;
        }
        Hashtable<String, FCOCRegisterBase> hashtable = this.m_aRegistersList;
        synchronized (hashtable) {
            for (Map.Entry<String, FCOCRegisterBase> RegEntry : this.m_aRegistersList.entrySet()) {
                FCOCRegisterBase RegisterItem = RegEntry.getValue();
                if (!RegisterItem.isAutoReadEnabled() || RegisterItem.getAccesType() != 1 && RegisterItem.getAccesType() != 3 || this.isReadQueueContains(RegisterItem)) continue;
                Object CallbackPara = RegisterItem.getGeneralCallbackParameter();
                this.addElementToReadQueue(new CQueueElement(RegisterItem, CallbackPara, true));
                FCOIDeviceEvent[] listeners = this.getDeviceListeners();
                int i = listeners.length - 1;
                while (i >= 0) {
                    listeners[i].autoreadRegAddedToQueue(this, RegEntry.getKey(), CallbackPara);
                    --i;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected FCOCRegisterBase getRegisterObject(String szRegisterName) throws IllegalArgumentException {
        Hashtable<String, FCOCRegisterBase> hashtable = this.m_aRegistersList;
        synchronized (hashtable) {
            if (this.m_aRegistersList.containsKey(szRegisterName)) {
                return this.m_aRegistersList.get(szRegisterName);
            }
        }
        throw new IllegalArgumentException("Register " + szRegisterName + " not found.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getKeyFromValue(Object Value, Hashtable<String, ?> aList) {
        Hashtable<String, ?> hashtable = aList;
        synchronized (hashtable) {
            Enumeration<String> EKeys = aList.keys();
            String szKey = "";
            while (EKeys.hasMoreElements()) {
                szKey = EKeys.nextElement();
                Object ValueItem = aList.get(szKey);
                if (ValueItem == null || !ValueItem.equals(Value)) continue;
                return szKey;
            }
        }
        return null;
    }

    protected abstract int fillBufferWithData(FCOCRegisterBase var1, byte[] var2, int var3);

    protected abstract int getDataFromBuffer(FCOCRegisterBase var1, byte[] var2, int var3);

    @Override
    public abstract void run();

    private class CGetIntInfoPara {
        public Object m_CallerCallBackPara;
        public boolean m_isAutoCreated;

        public CGetIntInfoPara(Object CallerCallBackPara, boolean isAutoCreated) {
            this.m_CallerCallBackPara = CallerCallBackPara;
            isAutoCreated = this.m_isAutoCreated;
        }
    }

    protected class CGetNextPacketResult {
        public int m_nBufferOffset = 0;
        public int m_nExpectedReturnBufSize = 0;
        public boolean m_isNotFinished = false;
        public Object m_Source = null;

        public CGetNextPacketResult() {
        }

        public CGetNextPacketResult(int nBufferOffset, int nExpectedReturnBufSize, boolean isNotFinished, FCOCDevice Source) {
            this.m_nBufferOffset = nBufferOffset;
            this.m_nExpectedReturnBufSize = nExpectedReturnBufSize;
            this.m_isNotFinished = isNotFinished;
            this.m_Source = Source;
        }
    }

    protected class CQueueElement {
        public FCOCRegisterBase m_Register;
        public Object m_CallbackParameter;
        public int m_nFrameID = -1;
        public boolean m_isReadRequest = true;

        public CQueueElement(FCOCRegisterBase Register, Object CallbackParameter) {
            this(Register, CallbackParameter, false);
        }

        public CQueueElement(FCOCRegisterBase Register, Object CallbackParameter, boolean isReadRequest) {
            this.m_Register = Register;
            this.m_CallbackParameter = CallbackParameter;
            this.m_isReadRequest = isReadRequest;
        }
    }
}

