/*
 * Decompiled with CFR 0.152.
 */
package purejavacomm.testsuite;

import purejavacomm.testsuite.TestBase;

public class TestYY
extends TestBase {
    static void run() throws Exception {
        try {
            TestYY.begin("Test10 - threshold performance ");
            System.setProperty("purejavacomm.rawreadmode", "false");
            TestYY.openPort();
            m_Port.setSerialPortParams(230000, 8, 1, 0);
            m_Port.setFlowControlMode(12);
            m_Out = m_Port.getOutputStream();
            m_In = m_Port.getInputStream();
            m_Port.enableReceiveTimeout(1000);
            final byte[] txbuffer = new byte[500];
            final byte[] rxbuffer = new byte[txbuffer.length];
            m_Port.enableReceiveThreshold(txbuffer.length);
            int messages = 10000;
            final boolean[] done = new boolean[1];
            Thread rxthread = new Thread(new Runnable(){

                public void run() {
                    try {
                        long avg = 0L;
                        int i = 0;
                        while (i < 10000) {
                            long t0 = System.nanoTime();
                            int rxn = m_In.read(rxbuffer, 0, txbuffer.length);
                            long dt = System.nanoTime() - t0;
                            System.out.print(" received " + rxn + " bytes");
                            System.out.print(" in " + (double)(dt / 1000L) / 1000.0 + " msec (average " + (double)((avg += dt) / (long)(i + 1) / 1000L) / 1000.0 + ")");
                            System.out.println();
                            ++i;
                        }
                        done[0] = true;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
            System.out.println();
            rxthread.start();
            int i = 0;
            while (i < 10000) {
                m_Out.write(txbuffer);
                ++i;
            }
            while (!done[0]) {
                Thread.sleep(100L);
            }
            TestYY.finishedOK();
        }
        finally {
            TestYY.closePort();
        }
    }
}

