/*
 * Decompiled with CFR 0.152.
 */
package com.fiveco.ledsequ;

import com.fiveco.devices.FCOCIPDevice;
import com.fiveco.jcomponents.FCOCGridBagJPanel;
import com.fiveco.ledsequ.FCOCSequActionBreakpoint;
import com.fiveco.ledsequ.FCOCSequActionCallRel;
import com.fiveco.ledsequ.FCOCSequActionComment;
import com.fiveco.ledsequ.FCOCSequActionEOF;
import com.fiveco.ledsequ.FCOCSequActionExtension;
import com.fiveco.ledsequ.FCOCSequActionJumpRel;
import com.fiveco.ledsequ.FCOCSequActionLabel;
import com.fiveco.ledsequ.FCOCSequActionNone;
import com.fiveco.ledsequ.FCOCSequActionPan;
import com.fiveco.ledsequ.FCOCSequActionReturn;
import com.fiveco.ledsequ.FCOCSequActionUnknown;
import com.fiveco.ledsequ.FCOEI2CSeqRegisters;
import com.fiveco.ledsequ.FCOESequAction;
import com.fiveco.utils.FCOCHexPlainDocument;
import com.fiveco.utils.FCOCUtils;
import com.fiveco.utils.FCOISimpleEvent;
import java.awt.Canvas;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.font.TextAttribute;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.BitSet;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.Vector;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class FCOCSequencerGUI
extends JTabbedPane
implements ActionListener,
KeyListener,
ItemListener,
ListSelectionListener,
AdjustmentListener,
ChangeListener {
    private final FCOISimpleEvent m_Caller;
    private FCOCIPDevice m_FDevice;
    private final String m_szI2CSEQNAME = "Sequencer";
    private final SimpleDateFormat m_DateFormatter = new SimpleDateFormat("EE MMM d, yyyy  HH:mm:ss", Locale.ENGLISH);
    private boolean m_isDietlinEnabled = false;
    private int m_nType = -1;
    private final Hashtable<String, Class<FCOCSequActionPan>> m_AvailableActions = new Hashtable();
    private int m_nTransferState = 0;
    private final Vector<FCOCSequActionPan> m_CopyPasteVector = new Vector();
    private boolean isCopyPasteAllowed = false;
    private String m_szCurrentDirectory = String.valueOf(System.getProperty("user.home")) + "/Desktop";
    private static final int nRUN = 0;
    private static final int nFLASH = 1;
    private static final int nDEVCOMTHREADSLEEPNORMAL = 50;
    private static final int nDEVCOMTHREADSLEEPLIVE = 5;
    private final FCOCGridBagJPanel m_SequPan = new FCOCGridBagJPanel(2, 2, 1, 2);
    private final JLabel m_SequPanActionIDLabel = new JLabel("Action ID:");
    private final JLabel m_SequPanActionIDDispLabel = new JLabel("----");
    private final JLabel m_SequPanActionLabel = new JLabel("Action type:");
    private final JComboBox<String> m_SequPanActionCombo = new JComboBox();
    private final JLabel m_SequPanActActionIDLabel = new JLabel("Actual ID:");
    private final JLabel m_SequPanActActionIDDispLabel = new JLabel("----");
    private final JCheckBox m_SequPanActActionADEnableCB = new JCheckBox("Live view");
    private final JCheckBox m_SequPanActSuspendCB = new JCheckBox("Suspend");
    private final JButton m_ResetSequButton = new JButton("Reset");
    private final JButton m_ClearSequButton = new JButton("Clear");
    private final FCOCGridBagJPanel m_SequPanActionParaPanel = new FCOCGridBagJPanel(5, 5, 5, 5);
    private final DefaultListModel<FCOCSequActionPan> m_SequPanSeqListModel = new DefaultListModel();
    private final JList<FCOCSequActionPan> m_SequPanSeqList = new JList<FCOCSequActionPan>(this.m_SequPanSeqListModel);
    private final JScrollPane m_SequPanScrollingList = new JScrollPane(this.m_SequPanSeqList);
    private final FCOCGridBagJPanel m_SequPanVariablesParaPanel = new FCOCGridBagJPanel(1, 1, 1, 1);
    private final JLabel[] m_SequPanVarLabels = new JLabel[16];
    private final String[] m_SequPanVarChoicesList = new String[]{"Dec", "Hex"};
    private final JComboBox<String>[] m_SequPanVarChoices = new JComboBox[16];
    private final JLabel[] m_SequPanVarDispLabel = new JLabel[16];
    private final JTextField[] m_SequPanVarInputText = new JTextField[16];
    private final JButton[] m_SequPanVarSetButton = new JButton[16];
    private final FCOCGridBagJPanel m_SequVarRightPanel = new FCOCGridBagJPanel(0, 0, 2, 0);
    private final JButton m_SequPanModifyActionButton = new JButton("Modify");
    private final JButton m_SequPanInsertActionButton = new JButton("Insert");
    private final JButton m_SequPanDeleteActionButton = new JButton("Delete");
    private final JButton m_SequPanMoveDownActionButton = new JButton("Down");
    private final JButton m_SequPanMoveUpActionButton = new JButton("Up");
    private final JButton m_SequPanSaveSeqButton = new JButton("Save sequence to file");
    private final JButton m_SequPanOpenSeqButton = new JButton("Open sequence from file");
    private final JButton m_SequPanSendSeqButton = new JButton("Send sequence");
    private final JButton m_SequPanReadSeqButton = new JButton("Read sequence");
    private final JButton m_SequPanCpyToSCButton = new JButton("Copy to SmartCard");
    private final FCOCGridBagJPanel m_SequPanDebugPanel = new FCOCGridBagJPanel(1, 1, 1, 1);
    private final JCheckBox m_SequPanDebugEnForcedBPCB = new JCheckBox("Enable forced breakpoints");
    private final JCheckBox[] m_SequPanDebugEnGroupBPCBs = new JCheckBox[7];
    private final JCheckBox m_SequPanDebugEnJumpsBPCB = new JCheckBox("Enable breakpoints on jumps");
    private final JCheckBox m_SequPanDebugEnEventsBPCB = new JCheckBox("Enable breakpoints on events");
    private final JButton m_SequPanDebugPlayButton = new JButton(FCOCUtils.createImageIcon("/images/DebugPlay.png"));
    private final JButton m_SequPanDebugPlayDButton = new JButton(FCOCUtils.createImageIcon("/images/DebugPlayD.png"));
    private final JButton m_SequPanDebugPauseButton = new JButton(FCOCUtils.createImageIcon("/images/DebugPause.png"));
    private final JButton m_SequPanDebugStepButton = new JButton(FCOCUtils.createImageIcon("/images/DebugStep.png"));
    private final JButton m_SequPanDebugSlowedButton = new JButton(FCOCUtils.createImageIcon("/images/DebugSlowed.png"));
    private final JLabel m_SequPanDebugStatusLabel = new JLabel("Status:");
    private final JLabel m_SequPanDebugStatusDispLabel = new JLabel("none");
    private final FCOCGridBagJPanel m_LivePan = new FCOCGridBagJPanel(1, 2, 1, 2);
    private final FCOCGridBagJPanel m_LivePanLeds = new FCOCGridBagJPanel(1, 2, 1, 2);
    private final JLabel m_LivePanLed1Label = new JLabel("Led 1 luminosity value [100%] :");
    private final JScrollBar m_LivePanLed1ValScrollB = new JScrollBar(0, 0, 655, 0, 66190);
    private final JLabel m_LivePanLed2Label = new JLabel("Led 2 luminosity value [100%] :");
    private final JScrollBar m_LivePanLed2ValScrollB = new JScrollBar(0, 0, 655, 0, 66190);
    private final JLabel m_LivePanLed3Label = new JLabel("Led 3 luminosity value [100%] :");
    private final JScrollBar m_LivePanLed3ValScrollB = new JScrollBar(0, 0, 655, 0, 66190);
    private final JLabel m_LivePanLed4Label = new JLabel("Led 4 luminosity value [100%] :");
    private final JScrollBar m_LivePanLed4ValScrollB = new JScrollBar(0, 0, 655, 0, 66190);
    private final JLabel m_LivePanLed5Label = new JLabel("Led 5 luminosity value [100%] :");
    private final JScrollBar m_LivePanLed5ValScrollB = new JScrollBar(0, 0, 655, 0, 66190);
    private final FCOCGridBagJPanel m_LivePanButtons = new FCOCGridBagJPanel(1, 2, 1, 2);
    private final JLabel m_LivePanMinLabel = new JLabel("Min");
    private final JLabel m_LivePanMaxLabel = new JLabel("Max");
    private final JLabel m_LivePanThreshB1Label = new JLabel("Button 1:");
    private final JSpinner m_LivePanThreshB1MinTA = new JSpinner(new SpinnerNumberModel(1, 0, 255, 1));
    private final JSpinner m_LivePanThreshB1MaxTA = new JSpinner(new SpinnerNumberModel(255, 0, 255, 1));
    private final JLabel m_LivePanLiveB1Label = new JLabel("---");
    private final JLabel m_LivePanThreshB2Label = new JLabel("Button 2:");
    private final JSpinner m_LivePanThreshB2MinTA = new JSpinner(new SpinnerNumberModel(1, 0, 255, 1));
    private final JSpinner m_LivePanThreshB2MaxTA = new JSpinner(new SpinnerNumberModel(255, 0, 255, 1));
    private final JLabel m_LivePanLiveB2Label = new JLabel("---");
    private final JLabel m_LivePanThreshB3Label = new JLabel("Button 3:");
    private final JSpinner m_LivePanThreshB3MinTA = new JSpinner(new SpinnerNumberModel(1, 0, 255, 1));
    private final JSpinner m_LivePanThreshB3MaxTA = new JSpinner(new SpinnerNumberModel(255, 0, 255, 1));
    private final JLabel m_LivePanLiveB3Label = new JLabel("---");
    private final JLabel m_LivePanThreshB4Label = new JLabel("Button 4:");
    private final JSpinner m_LivePanThreshB4MinTA = new JSpinner(new SpinnerNumberModel(1, 0, 255, 1));
    private final JSpinner m_LivePanThreshB4MaxTA = new JSpinner(new SpinnerNumberModel(255, 0, 255, 1));
    private final JLabel m_LivePanLiveB4Label = new JLabel("---");
    private final JLabel m_LivePanThreshB5Label = new JLabel("Button 5:");
    private final JSpinner m_LivePanThreshB5MinTA = new JSpinner(new SpinnerNumberModel(1, 0, 255, 1));
    private final JSpinner m_LivePanThreshB5MaxTA = new JSpinner(new SpinnerNumberModel(255, 0, 255, 1));
    private final JLabel m_LivePanLiveB5Label = new JLabel("---");
    private final JLabel m_LivePanThreshB6Label = new JLabel("Button 6:");
    private final JSpinner m_LivePanThreshB6MinTA = new JSpinner(new SpinnerNumberModel(1, 0, 255, 1));
    private final JSpinner m_LivePanThreshB6MaxTA = new JSpinner(new SpinnerNumberModel(255, 0, 255, 1));
    private final JLabel m_LivePanLiveB6Label = new JLabel("---");
    private final JLabel m_LivePanThreshB7Label = new JLabel("Button 7:");
    private final JSpinner m_LivePanThreshB7MinTA = new JSpinner(new SpinnerNumberModel(1, 0, 255, 1));
    private final JSpinner m_LivePanThreshB7MaxTA = new JSpinner(new SpinnerNumberModel(255, 0, 255, 1));
    private final JLabel m_LivePanLiveB7Label = new JLabel("---");
    private final JLabel m_LivePanThreshB8Label = new JLabel("Button 8:");
    private final JSpinner m_LivePanThreshB8MinTA = new JSpinner(new SpinnerNumberModel(1, 0, 255, 1));
    private final JSpinner m_LivePanThreshB8MaxTA = new JSpinner(new SpinnerNumberModel(255, 0, 255, 1));
    private final JLabel m_LivePanLiveB8Label = new JLabel("---");
    private final JButton m_LivePanChangeThButton = new JButton("Change");
    private final JLabel m_LivePanAutoCfgLabel = new JLabel("Auto config (all buttons):");
    private final JButton m_LivePanAutoCfgButton1 = new JButton("Low");
    private final JButton m_LivePanAutoCfgButton2 = new JButton("Medium");
    private final JButton m_LivePanAutoCfgButton3 = new JButton("High");
    private final FCOCGridBagJPanel m_WrapParaPan = new FCOCGridBagJPanel(0, 0, 0, 0);
    private final FCOCGridBagJPanel m_ParaPanCom = new FCOCGridBagJPanel(1, 2, 1, 2);
    private final JLabel m_ParaPanVersionLabel = new JLabel("Rev (Int/LSHW/LSFW) :");
    private final JLabel m_ParaPanVersionTCPDispLabel = new JLabel("----------------");
    private final JLabel m_ParaPanVersionI2CDispLabel = new JLabel("----------------");
    private final JLabel m_ParaPanMACLabel = new JLabel("MAC address : ");
    private final JLabel m_ParaPanMACValueLabel = new JLabel("xx-xx-xx-xx-xx-xx");
    private final JLabel m_ParaPanIPLabel = new JLabel("IP Address :");
    private final JSpinner m_ParaPanIP1Text = new JSpinner(new SpinnerNumberModel(1, 0, 255, 1));
    private final JSpinner m_ParaPanIP2Text = new JSpinner(new SpinnerNumberModel(1, 0, 255, 1));
    private final JSpinner m_ParaPanIP3Text = new JSpinner(new SpinnerNumberModel(1, 0, 255, 1));
    private final JSpinner m_ParaPanIP4Text = new JSpinner(new SpinnerNumberModel(1, 1, 254, 1));
    private final JLabel m_ParaPanSNMLabel = new JLabel("Subnet mask :");
    private final JSpinner m_ParaPanSNM1Text = new JSpinner(new SpinnerNumberModel(255, 0, 255, 1));
    private final JSpinner m_ParaPanSNM2Text = new JSpinner(new SpinnerNumberModel(255, 0, 255, 1));
    private final JSpinner m_ParaPanSNM3Text = new JSpinner(new SpinnerNumberModel(255, 0, 255, 1));
    private final JSpinner m_ParaPanSNM4Text = new JSpinner(new SpinnerNumberModel(255, 0, 255, 1));
    private final JLabel m_ParaPanNameLabel = new JLabel("Device name : ");
    private final JTextField m_ParaPanNameText = new JTextField(new DeviceNamePlainDocument(), "", 16);
    private final JButton m_ParaPanChgCommButton = new JButton("Change");
    private final FCOCGridBagJPanel m_ParaPanLedsCurrent = new FCOCGridBagJPanel(1, 2, 1, 2);
    private final JLabel m_ParaPanLed1ILabel = new JLabel("Led 1 : [mA]", 2);
    private final JSpinner m_ParaPanLed1IText = new JSpinner(new SpinnerNumberModel(1, 0, 500, 1));
    private final JLabel m_ParaPanLed2ILabel = new JLabel("Led 2 : [mA]", 2);
    private final JSpinner m_ParaPanLed2IText = new JSpinner(new SpinnerNumberModel(1, 0, 500, 1));
    private final JLabel m_ParaPanLed3ILabel = new JLabel("Led 3 : [mA]", 2);
    private final JSpinner m_ParaPanLed3IText = new JSpinner(new SpinnerNumberModel(1, 0, 500, 1));
    private final JLabel m_ParaPanLed4ILabel = new JLabel("Led 4 : [mA]", 2);
    private final JSpinner m_ParaPanLed4IText = new JSpinner(new SpinnerNumberModel(1, 0, 500, 1));
    private final JLabel m_ParaPanLed5ILabel = new JLabel("Led 5 : [mA]", 2);
    private final JSpinner m_ParaPanLed5IText = new JSpinner(new SpinnerNumberModel(1, 0, 500, 1));
    private final JButton m_ParaPanChgIButton = new JButton("Change");
    private final JLabel m_ParaPanVoltageDispLabel = new JLabel("Voltage : --V");
    private final JLabel m_ParaPanTempDispLabel = new JLabel("Temperature : --\u00b0C");
    private final JLabel m_ParaPanNbPowUpDispLabel = new JLabel("Nb of power up : xxxxxxx");
    private final JLabel m_ParaPanServTimeDispLabel = new JLabel("Time in service : 000h 00min");
    private final FCOCGridBagJPanel m_ParaPanTime = new FCOCGridBagJPanel(1, 2, 1, 2);
    private final JLabel m_ParaPanBoardTimeLabel = new JLabel("Board time:");
    private final JLabel m_ParaPanBoardTimeDispLabel = new JLabel("Tue Aug 19, 2008  13:20:41", 0);
    private final JLabel m_ParaPanPCTimeLabel = new JLabel("New time based on selected time zone:");
    private final JLabel m_ParaPanPCTimeDispLabel = new JLabel("Tue Aug 19, 2008  13:20:41", 0);
    private final Choice m_ParaPanTimeZoneChoice = new Choice();
    private final JButton m_ParaPanUpdateTimeButton = new JButton("Update board time");
    private final JButton m_ParaPanReadButton = new JButton("Read actual settings");
    private final JButton m_ParaPanSaveUserButton = new JButton("Save user settings");
    private final JButton m_ParaPanRestoreUserButton = new JButton("Restore user settings");
    private final JButton m_ParaPanRestoreFactButton = new JButton("Restore factory settings");

    public FCOCSequencerGUI(FCOISimpleEvent Caller) {
        this.m_Caller = Caller;
        FCOCSequActionPan.setup(this.m_SequPanSeqList);
        this.m_LivePanLeds.add((Component)this.m_LivePanLed1Label, 0, 1);
        this.m_LivePanLeds.add((Component)this.m_LivePanLed1ValScrollB, 0, 2);
        this.m_LivePanLeds.add((Component)this.m_LivePanLed2Label, 0, 3);
        this.m_LivePanLeds.add((Component)this.m_LivePanLed2ValScrollB, 0, 4);
        this.m_LivePanLeds.add((Component)this.m_LivePanLed3Label, 0, 5);
        this.m_LivePanLeds.add((Component)this.m_LivePanLed3ValScrollB, 0, 6);
        this.m_LivePanLeds.add((Component)this.m_LivePanLed4Label, 0, 7);
        this.m_LivePanLeds.add((Component)this.m_LivePanLed4ValScrollB, 0, 8);
        this.m_LivePanLeds.add((Component)this.m_LivePanLed5Label, 0, 9);
        this.m_LivePanLeds.add((Component)this.m_LivePanLed5ValScrollB, 0, 10);
        this.m_LivePanLed1ValScrollB.addAdjustmentListener(this);
        this.m_LivePanLed1ValScrollB.setUnitIncrement(65);
        this.m_LivePanLed2ValScrollB.addAdjustmentListener(this);
        this.m_LivePanLed2ValScrollB.setUnitIncrement(65);
        this.m_LivePanLed3ValScrollB.addAdjustmentListener(this);
        this.m_LivePanLed3ValScrollB.setUnitIncrement(65);
        this.m_LivePanLed4ValScrollB.addAdjustmentListener(this);
        this.m_LivePanLed4ValScrollB.setUnitIncrement(65);
        this.m_LivePanLed5ValScrollB.addAdjustmentListener(this);
        this.m_LivePanLed5ValScrollB.setUnitIncrement(65);
        this.m_LivePanButtons.add(this.m_LivePanMinLabel, 3, 1, 1, 1, 10, 0);
        this.m_LivePanButtons.add(this.m_LivePanMaxLabel, 4, 1, 1, 1, 10, 0);
        this.m_LivePanButtons.add(this.m_LivePanThreshB1Label, 2, 2, 1, 1, 10, 0);
        this.m_LivePanButtons.add((Component)this.m_LivePanThreshB1MinTA, 3, 2);
        this.m_LivePanButtons.add((Component)this.m_LivePanThreshB1MaxTA, 4, 2);
        this.m_LivePanButtons.add(this.m_LivePanLiveB1Label, 5, 2, 1, 1, 10, 0);
        this.m_LivePanButtons.add((Component)this.m_LivePanThreshB2Label, 2, 3);
        this.m_LivePanButtons.add((Component)this.m_LivePanThreshB2MinTA, 3, 3);
        this.m_LivePanButtons.add((Component)this.m_LivePanThreshB2MaxTA, 4, 3);
        this.m_LivePanButtons.add((Component)this.m_LivePanLiveB2Label, 5, 3);
        this.m_LivePanButtons.add((Component)this.m_LivePanThreshB3Label, 2, 4);
        this.m_LivePanButtons.add((Component)this.m_LivePanThreshB3MinTA, 3, 4);
        this.m_LivePanButtons.add((Component)this.m_LivePanThreshB3MaxTA, 4, 4);
        this.m_LivePanButtons.add((Component)this.m_LivePanLiveB3Label, 5, 4);
        this.m_LivePanButtons.add((Component)this.m_LivePanThreshB4Label, 2, 5);
        this.m_LivePanButtons.add((Component)this.m_LivePanThreshB4MinTA, 3, 5);
        this.m_LivePanButtons.add((Component)this.m_LivePanThreshB4MaxTA, 4, 5);
        this.m_LivePanButtons.add((Component)this.m_LivePanLiveB4Label, 5, 5);
        this.m_LivePanButtons.add((Component)this.m_LivePanThreshB5Label, 2, 6);
        this.m_LivePanButtons.add((Component)this.m_LivePanThreshB5MinTA, 3, 6);
        this.m_LivePanButtons.add((Component)this.m_LivePanThreshB5MaxTA, 4, 6);
        this.m_LivePanButtons.add((Component)this.m_LivePanLiveB5Label, 5, 6);
        this.m_LivePanButtons.add((Component)this.m_LivePanThreshB6Label, 2, 7);
        this.m_LivePanButtons.add((Component)this.m_LivePanThreshB6MinTA, 3, 7);
        this.m_LivePanButtons.add((Component)this.m_LivePanThreshB6MaxTA, 4, 7);
        this.m_LivePanButtons.add((Component)this.m_LivePanLiveB6Label, 5, 7);
        this.m_LivePanButtons.add((Component)this.m_LivePanThreshB7Label, 2, 8);
        this.m_LivePanButtons.add((Component)this.m_LivePanThreshB7MinTA, 3, 8);
        this.m_LivePanButtons.add((Component)this.m_LivePanThreshB7MaxTA, 4, 8);
        this.m_LivePanButtons.add((Component)this.m_LivePanLiveB7Label, 5, 8);
        this.m_LivePanButtons.add((Component)this.m_LivePanThreshB8Label, 2, 9);
        this.m_LivePanButtons.add((Component)this.m_LivePanThreshB8MinTA, 3, 9);
        this.m_LivePanButtons.add((Component)this.m_LivePanThreshB8MaxTA, 4, 9);
        this.m_LivePanButtons.add((Component)this.m_LivePanLiveB8Label, 5, 9);
        this.m_LivePanButtons.add(this.m_LivePanChangeThButton, 3, 10, 2, 1, 0, 0, 1, 10);
        this.m_LivePanChangeThButton.addActionListener(this);
        this.m_LivePanButtons.add(this.m_LivePanAutoCfgLabel, 2, 11, 4, 1, 20, 10);
        this.m_LivePanButtons.add((Component)this.m_LivePanAutoCfgButton1, 2, 12);
        this.m_LivePanAutoCfgButton1.addActionListener(this);
        this.m_LivePanButtons.add((Component)this.m_LivePanAutoCfgButton2, 3, 12);
        this.m_LivePanAutoCfgButton2.addActionListener(this);
        this.m_LivePanButtons.add((Component)this.m_LivePanAutoCfgButton3, 4, 12);
        this.m_LivePanAutoCfgButton3.addActionListener(this);
        this.m_LivePanLeds.setBorder(BorderFactory.createTitledBorder("Live Leds driving"));
        this.m_LivePanButtons.setBorder(BorderFactory.createTitledBorder("Buttons threshold"));
        this.m_LivePan.add(this.m_LivePanLeds, 0, 0, 1, 1, 10, 10, 2, 11);
        this.m_LivePan.add(this.m_LivePanButtons, 1, 0, 1, 1, 10, 10, 2, 11);
        this.m_ParaPanCom.add(this.m_ParaPanVersionLabel, 0, 1, 1, 1);
        this.m_ParaPanCom.add(this.m_ParaPanVersionTCPDispLabel, 1, 1, 2, 1);
        this.m_ParaPanCom.add(this.m_ParaPanVersionI2CDispLabel, 3, 1, 2, 1);
        this.m_ParaPanCom.add(this.m_ParaPanMACLabel, 0, 2, 1, 1);
        this.m_ParaPanCom.add(this.m_ParaPanMACValueLabel, 1, 2, 4, 1);
        this.m_ParaPanCom.add(this.m_ParaPanIPLabel, 0, 3, 1, 1, 20, 10);
        this.m_ParaPanCom.add(this.m_ParaPanIP1Text, 1, 3, 1, 1, 12, 0);
        this.m_ParaPanCom.add(this.m_ParaPanIP2Text, 2, 3, 1, 1, 12, 0);
        this.m_ParaPanCom.add(this.m_ParaPanIP3Text, 3, 3, 1, 1, 12, 0);
        this.m_ParaPanCom.add(this.m_ParaPanIP4Text, 4, 3, 1, 1, 12, 0);
        this.m_ParaPanCom.add(this.m_ParaPanSNMLabel, 0, 4, 1, 1, 20, 10);
        this.m_ParaPanCom.add(this.m_ParaPanSNM1Text, 1, 4, 1, 1, 12, 0);
        this.m_ParaPanCom.add(this.m_ParaPanSNM2Text, 2, 4, 1, 1, 12, 0);
        this.m_ParaPanCom.add(this.m_ParaPanSNM3Text, 3, 4, 1, 1, 12, 0);
        this.m_ParaPanCom.add(this.m_ParaPanSNM4Text, 4, 4, 1, 1, 12, 0);
        this.m_ParaPanCom.add(this.m_ParaPanNameLabel, 0, 6, 1, 1);
        this.m_ParaPanCom.add(this.m_ParaPanNameText, 1, 6, 4, 1);
        this.m_ParaPanCom.add(this.m_ParaPanChgCommButton, 5, 3, 1, 4, 36, 0, 1, 10);
        this.m_ParaPanChgCommButton.addActionListener(this);
        this.m_ParaPanCom.add(this.m_ParaPanVoltageDispLabel, 0, 7, 1, 1);
        this.m_ParaPanCom.add(this.m_ParaPanTempDispLabel, 1, 7, 2, 1);
        this.m_ParaPanCom.add(this.m_ParaPanNbPowUpDispLabel, 0, 8, 1, 1);
        this.m_ParaPanCom.add(this.m_ParaPanServTimeDispLabel, 1, 8, 2, 1);
        this.m_ParaPanLedsCurrent.add(this.m_ParaPanLed1ILabel, 0, 10, 1, 1);
        this.m_ParaPanLedsCurrent.add(this.m_ParaPanLed1IText, 1, 10, 1, 1);
        this.m_ParaPanLedsCurrent.add(this.m_ParaPanLed2ILabel, 0, 11, 1, 1);
        this.m_ParaPanLedsCurrent.add(this.m_ParaPanLed2IText, 1, 11, 1, 1);
        this.m_ParaPanLedsCurrent.add(this.m_ParaPanLed3ILabel, 0, 12, 1, 1);
        this.m_ParaPanLedsCurrent.add(this.m_ParaPanLed3IText, 1, 12, 1, 1);
        this.m_ParaPanLedsCurrent.add(this.m_ParaPanLed4ILabel, 0, 13, 1, 1);
        this.m_ParaPanLedsCurrent.add(this.m_ParaPanLed4IText, 1, 13, 1, 1);
        this.m_ParaPanLedsCurrent.add(this.m_ParaPanLed5ILabel, 0, 14, 1, 1);
        this.m_ParaPanLedsCurrent.add(this.m_ParaPanLed5IText, 1, 14, 1, 1);
        this.m_ParaPanLedsCurrent.add(this.m_ParaPanChgIButton, 2, 10, 1, 5, 0, 0, 1, 10);
        this.m_ParaPanChgIButton.addActionListener(this);
        this.m_ParaPanTime.add(this.m_ParaPanBoardTimeLabel, 3, 9, 3, 1);
        this.m_ParaPanBoardTimeDispLabel.setFont(new Font("Arial", 1, 15));
        this.m_ParaPanTime.add(this.m_ParaPanBoardTimeDispLabel, 3, 10, 3, 1);
        this.m_ParaPanPCTimeDispLabel.setFont(new Font("Arial", 1, 15));
        this.m_ParaPanTime.add(this.m_ParaPanPCTimeLabel, 3, 11, 3, 1);
        this.m_ParaPanTime.add(this.m_ParaPanPCTimeDispLabel, 3, 12, 3, 1);
        this.m_ParaPanTime.add(this.m_ParaPanTimeZoneChoice, 3, 13, 3, 1);
        String[] IDsList = TimeZone.getAvailableIDs();
        int timeZoneListDefaultOffset = 0;
        try {
            int i = 0;
            while (i < IDsList.length) {
                TimeZone tz = TimeZone.getTimeZone(IDsList[i]);
                this.m_ParaPanTimeZoneChoice.add(String.valueOf(IDsList[i]) + " GMT" + (tz.getRawOffset() >= 0 ? "+" : "") + tz.getRawOffset() / 3600000);
                if (Calendar.getInstance().getTimeZone().getID().indexOf(IDsList[i].toString()) != -1) {
                    timeZoneListDefaultOffset = i;
                }
                ++i;
            }
        }
        catch (Exception i) {
            // empty catch block
        }
        this.m_ParaPanTimeZoneChoice.select(timeZoneListDefaultOffset);
        this.m_ParaPanTime.add(this.m_ParaPanUpdateTimeButton, 3, 14, 3, 1);
        this.m_ParaPanUpdateTimeButton.addActionListener(this);
        FCOCGridBagJPanel ParaButtonsPan = new FCOCGridBagJPanel(1, 1, 1, 1);
        ParaButtonsPan.add((Component)this.m_ParaPanReadButton, 0, 1);
        this.m_ParaPanReadButton.addActionListener(this);
        ParaButtonsPan.add((Component)this.m_ParaPanSaveUserButton, 1, 1);
        this.m_ParaPanSaveUserButton.addActionListener(this);
        ParaButtonsPan.add((Component)this.m_ParaPanRestoreUserButton, 0, 2);
        this.m_ParaPanRestoreUserButton.addActionListener(this);
        ParaButtonsPan.add((Component)this.m_ParaPanRestoreFactButton, 1, 2);
        this.m_ParaPanRestoreFactButton.addActionListener(this);
        this.m_ParaPanCom.setBorder(BorderFactory.createTitledBorder("Communication parameters"));
        this.m_ParaPanLedsCurrent.setBorder(BorderFactory.createTitledBorder("Leds current"));
        this.m_ParaPanTime.setBorder(BorderFactory.createTitledBorder("Time"));
        FCOCGridBagJPanel ParaPan = new FCOCGridBagJPanel(1, 2, 1, 2);
        ParaPan.add(this.m_ParaPanCom, 0, 0, 2, 1, 0, 10, 2, 11);
        ParaPan.add(this.m_ParaPanLedsCurrent, 0, 1, 1, 1, 10, 10, 2, 11);
        ParaPan.add(this.m_ParaPanTime, 1, 1, 1, 1, 10, 10, 2, 11);
        ParaPan.add(ParaButtonsPan, 0, 2, 2, 1, 0, 10, 2, 11);
        Canvas SequPanC2 = new Canvas();
        SequPanC2.setSize(460, 1);
        this.m_SequPan.add(SequPanC2, 4, 1, 4, 1, 0, 0);
        this.m_SequPan.add(this.m_SequPanActionIDLabel, 0, 2, 1, 1, 10, 0);
        this.m_SequPan.add(this.m_SequPanActionIDDispLabel, 1, 2, 3, 1, 20, 0);
        FCOCGridBagJPanel ActionIDPanel = new FCOCGridBagJPanel(0, 1, 0, 0);
        ActionIDPanel.add((Component)this.m_SequPanActActionIDLabel, 0, 0);
        ActionIDPanel.add((Component)this.m_SequPanActActionIDDispLabel, 1, 0);
        ActionIDPanel.add((Component)this.m_SequPanActActionADEnableCB, 2, 0);
        this.m_SequPanActActionADEnableCB.addItemListener(this);
        ActionIDPanel.add((Component)this.m_SequPanActSuspendCB, 3, 0);
        this.m_SequPanActSuspendCB.addItemListener(this);
        ActionIDPanel.add((Component)this.m_ResetSequButton, 4, 0);
        this.m_ResetSequButton.addActionListener(this);
        ActionIDPanel.add((Component)this.m_ClearSequButton, 5, 0);
        this.m_ClearSequButton.addActionListener(this);
        this.m_SequPan.add(ActionIDPanel, 4, 2, 4, 1, 0, 0);
        this.m_SequPan.add(this.m_SequPanActionLabel, 0, 3, 1, 1, 0, 0);
        this.m_SequPan.add(this.m_SequPanActionCombo, 1, 3, 3, 1, 0, 0);
        this.m_SequPanActionCombo.addItemListener(this);
        this.m_SequPanActionCombo.addKeyListener(this);
        this.m_SequPanActionCombo.setMaximumRowCount(30);
        this.m_SequPanActionParaPanel.addKeyListener(this);
        this.m_SequPanActionParaPanel.setBorder(BorderFactory.createTitledBorder("Action parameters"));
        this.m_SequPan.add(this.m_SequPanActionParaPanel, 0, 4, 4, 1, 0, 60, 1, 11);
        this.m_SequPan.add(this.m_SequPanModifyActionButton, 0, 5, 4, 1, 0, 0);
        this.m_SequPanModifyActionButton.addActionListener(this);
        this.m_SequPan.add(this.m_SequPanSendSeqButton, 0, 6, 2, 1, 0, 0);
        this.m_SequPanSendSeqButton.addActionListener(this);
        this.m_SequPan.add(this.m_SequPanReadSeqButton, 2, 6, 2, 1, 0, 0);
        this.m_SequPanReadSeqButton.addActionListener(this);
        this.m_SequPan.add(this.m_SequPanCpyToSCButton, 0, 7, 4, 1, 0, 0);
        this.m_SequPanCpyToSCButton.addActionListener(this);
        FCOCGridBagJPanel ListPanel = new FCOCGridBagJPanel(0, 0, 0, 0);
        JLabel ActionLabel = new JLabel("ID    Action");
        ActionLabel.setFont(new Font("Courier", 0, 12));
        ActionLabel.setForeground(Color.WHITE);
        ActionLabel.setBackground(new Color(49, 48, 49));
        ActionLabel.setOpaque(true);
        ListPanel.add(ActionLabel, 0, 0, 1, 1, 10, 1);
        ListPanel.add(this.m_SequPanScrollingList, 0, 1, 1, 1, 10, 500, 1, 11);
        this.m_SequPanSeqList.setSelectionMode(1);
        this.m_SequPanSeqList.setCellRenderer(new CActionsCellRenderer());
        this.m_SequPanSeqList.addKeyListener(this);
        this.m_SequPanSeqList.addListSelectionListener(this);
        this.m_SequPanSeqListModel.ensureCapacity(4000);
        this.m_SequPanSeqListModel.add(0, new FCOCSequActionEOF(null));
        this.m_SequPanSeqList.setSelectedIndex(0);
        this.m_SequPan.add(ListPanel, 4, 3, 5, 3, 0, 500, 1, 11);
        this.m_SequPanDebugPanel.setBorder(BorderFactory.createTitledBorder("Debug"));
        this.m_SequPanDebugPanel.add(this.m_SequPanDebugEnForcedBPCB, 0, 0, 8, 1);
        this.m_SequPanDebugEnForcedBPCB.addActionListener(this);
        this.m_SequPanDebugPanel.add((Component)new JLabel("Enable breakpoints groups:"), 0, 1);
        int i = 0;
        while (i < 7) {
            this.m_SequPanDebugEnGroupBPCBs[i] = new JCheckBox("" + (i + 1));
            this.m_SequPanDebugPanel.add((Component)this.m_SequPanDebugEnGroupBPCBs[i], 1 + i, 1);
            this.m_SequPanDebugEnGroupBPCBs[i].addActionListener(this);
            ++i;
        }
        this.m_SequPanDebugPanel.add(this.m_SequPanDebugEnJumpsBPCB, 0, 2, 8, 1);
        this.m_SequPanDebugEnJumpsBPCB.addActionListener(this);
        this.m_SequPanDebugPanel.add(this.m_SequPanDebugEnEventsBPCB, 0, 3, 8, 1);
        this.m_SequPanDebugEnEventsBPCB.addActionListener(this);
        FCOCGridBagJPanel DebugButtonsPanel = new FCOCGridBagJPanel(0, 0, 0, 2);
        DebugButtonsPanel.add((Component)this.m_SequPanDebugPlayButton, 0, 0);
        this.m_SequPanDebugPlayButton.addActionListener(this);
        DebugButtonsPanel.add((Component)this.m_SequPanDebugPlayDButton, 1, 0);
        this.m_SequPanDebugPlayDButton.addActionListener(this);
        DebugButtonsPanel.add((Component)this.m_SequPanDebugPauseButton, 2, 0);
        this.m_SequPanDebugPauseButton.addActionListener(this);
        DebugButtonsPanel.add((Component)this.m_SequPanDebugStepButton, 3, 0);
        this.m_SequPanDebugStepButton.addActionListener(this);
        DebugButtonsPanel.add((Component)this.m_SequPanDebugSlowedButton, 4, 0);
        this.m_SequPanDebugSlowedButton.addActionListener(this);
        this.m_SequPanDebugPanel.add(DebugButtonsPanel, 0, 4, 8, 1);
        this.m_SequPanDebugPanel.add((Component)this.m_SequPanDebugStatusLabel, 0, 5);
        this.m_SequPanDebugPanel.add(this.m_SequPanDebugStatusDispLabel, 1, 5, 7, 1);
        this.m_SequVarRightPanel.add(this.m_SequPanDebugPanel, 0, 0, 1, 1, 10, 10, 2, 11);
        this.m_SequPanVariablesParaPanel.setBorder(BorderFactory.createTitledBorder("Sequencer variables"));
        Canvas SequPanvARC1 = new Canvas();
        SequPanvARC1.setSize(90, 1);
        this.m_SequPanVariablesParaPanel.add((Component)SequPanvARC1, 2, 0);
        Canvas SequPanvARC2 = new Canvas();
        SequPanvARC2.setSize(90, 1);
        this.m_SequPanVariablesParaPanel.add((Component)SequPanvARC2, 3, 0);
        int i2 = 0;
        while (i2 < 16) {
            this.m_SequPanVarLabels[i2] = new JLabel("Var " + (i2 + 1) + ":");
            this.m_SequPanVariablesParaPanel.add((Component)this.m_SequPanVarLabels[i2], 0, i2 + 1);
            this.m_SequPanVarChoices[i2] = new JComboBox<String>(this.m_SequPanVarChoicesList);
            this.m_SequPanVarChoices[i2].addItemListener(this);
            this.m_SequPanVariablesParaPanel.add((Component)this.m_SequPanVarChoices[i2], 1, i2 + 1);
            this.m_SequPanVarDispLabel[i2] = new JLabel("xxxxxxxxx");
            this.m_SequPanVariablesParaPanel.add((Component)this.m_SequPanVarDispLabel[i2], 2, i2 + 1);
            this.m_SequPanVarInputText[i2] = new JTextField(new IntegerPlainDocument(), "", 7);
            this.m_SequPanVariablesParaPanel.add(this.m_SequPanVarInputText[i2], 3, i2 + 1, 1, 1, 10, 10, 2, 13);
            this.m_SequPanVarSetButton[i2] = new JButton("Set");
            this.m_SequPanVariablesParaPanel.add((Component)this.m_SequPanVarSetButton[i2], 4, i2 + 1);
            this.m_SequPanVarSetButton[i2].addActionListener(this);
            ++i2;
        }
        this.m_SequVarRightPanel.add(this.m_SequPanVariablesParaPanel, 0, 1, 1, 1, 10, 10, 2, 11);
        this.m_SequPan.add(this.m_SequPanInsertActionButton, 4, 6, 1, 1, 20, 0);
        this.m_SequPanInsertActionButton.addActionListener(this);
        this.m_SequPan.add(this.m_SequPanDeleteActionButton, 5, 6, 1, 1, 20, 0);
        this.m_SequPanDeleteActionButton.addActionListener(this);
        this.m_SequPan.add(this.m_SequPanMoveDownActionButton, 6, 6, 1, 1, 20, 0);
        this.m_SequPanMoveDownActionButton.addActionListener(this);
        this.m_SequPan.add(this.m_SequPanMoveUpActionButton, 7, 6, 1, 1, 20, 0);
        this.m_SequPanMoveUpActionButton.addActionListener(this);
        this.m_SequPan.add(this.m_SequPanSaveSeqButton, 4, 7, 2, 1, 0, 0);
        this.m_SequPanSaveSeqButton.addActionListener(this);
        this.m_SequPan.add(this.m_SequPanOpenSeqButton, 6, 7, 2, 1, 0, 0);
        this.m_SequPanOpenSeqButton.addActionListener(this);
        this.m_SequPan.setName("Sequence");
        this.m_LivePan.setName("Live control");
        this.m_WrapParaPan.setName("Main parameters");
        this.m_WrapParaPan.add(ParaPan, 0, 0, 1, 1, 1, 1, 2, 11);
        this.add(this.m_SequPan);
        this.add(this.m_LivePan);
        this.add(this.m_WrapParaPan);
        this.setDevice(null);
        this.getModel().addChangeListener(this);
    }

    public void buildAvailableActionsList(boolean isDietlinEnabled) {
        this.m_isDietlinEnabled = isDietlinEnabled;
        this.buildAvailableActionsList(this.m_nType);
    }

    public void buildAvailableActionsList(int nType, boolean isDietlinEnabled) {
        this.m_isDietlinEnabled = isDietlinEnabled;
        this.buildAvailableActionsList(nType);
    }

    public synchronized void buildAvailableActionsList(int nType) {
        this.m_nType = nType;
        this.m_SequPanActionCombo.removeItemListener(this);
        this.m_AvailableActions.clear();
        this.m_SequPanActionCombo.removeAllItems();
        if (!this.m_isDietlinEnabled) {
            nType = nType == 3 || nType == 4 ? 2 : 0;
        }
        String szPackageName = this.getClass().getPackage().getName();
        FCOESequAction[] fCOESequActionArray = FCOESequAction.values();
        int n = fCOESequActionArray.length;
        int n2 = 0;
        while (n2 < n) {
            FCOESequAction Act = fCOESequActionArray[n2];
            if (nType == -1 || Act.isAvailable(nType) || Act == FCOESequAction.EMPTY || Act == FCOESequAction.EOF || Act == FCOESequAction.EXTENSION) {
                String szNotFoundMsg = "Action \"" + Act.m_szActionString + "\" class not available.";
                try {
                    ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                    if (classLoader.getResource(String.valueOf(szPackageName.replace('.', '/')) + "/FCOCSequAction" + Act.m_szClassName + ".class") == null) {
                        System.out.println(szNotFoundMsg);
                    } else {
                        Class<?> ActClass = Class.forName(String.valueOf(szPackageName) + ".FCOCSequAction" + Act.m_szClassName);
                        this.m_AvailableActions.put(Act.m_szClassName, ActClass);
                        if (Act != FCOESequAction.EMPTY && Act != FCOESequAction.EOF && Act != FCOESequAction.EXTENSION) {
                            this.m_SequPanActionCombo.addItem(Act.m_szActionString);
                        }
                    }
                }
                catch (ClassNotFoundException e) {
                    System.out.println(szNotFoundMsg);
                }
                catch (NoClassDefFoundError e) {
                    System.out.println(szNotFoundMsg);
                }
            }
            ++n2;
        }
        this.m_SequPanActionCombo.addItemListener(this);
        this.checkItemsToEnable();
    }

    public void setDevice(FCOCIPDevice FDevice) {
        this.m_FDevice = FDevice;
        this.checkItemsToEnable();
    }

    private void checkItemsToEnable() {
        if (this.m_FDevice != null && this.m_FDevice.getClass() == FCOCIPDevice.class) {
            int i;
            FCOCUtils.setContainerEnabled(this.m_SequPan, true);
            FCOCUtils.setContainerEnabled(this.m_SequPanVariablesParaPanel, true);
            boolean isDisplayActualActionIDDisabled = !this.m_SequPanActActionADEnableCB.isSelected();
            this.m_SequPanActionParaPanel.setEnabled(isDisplayActualActionIDDisabled);
            this.m_SequPanSeqList.setEnabled(isDisplayActualActionIDDisabled);
            this.m_SequPanActionCombo.setEnabled(isDisplayActualActionIDDisabled);
            this.m_SequPanModifyActionButton.setEnabled(isDisplayActualActionIDDisabled);
            this.m_SequPanInsertActionButton.setEnabled(isDisplayActualActionIDDisabled);
            this.m_SequPanDeleteActionButton.setEnabled(isDisplayActualActionIDDisabled);
            this.m_SequPanMoveUpActionButton.setEnabled(isDisplayActualActionIDDisabled);
            this.m_SequPanMoveDownActionButton.setEnabled(isDisplayActualActionIDDisabled);
            FCOCUtils.setContainerEnabled(this.m_SequPanVariablesParaPanel, true);
            FCOCUtils.setContainerEnabled(this.m_LivePan, true);
            if (this.m_nType == 5 || this.m_nType == 6 || this.m_nType == 4) {
                FCOCUtils.setContainerEnabled(this.m_LivePanButtons, true);
            } else {
                FCOCUtils.setContainerEnabled(this.m_LivePanButtons, false);
            }
            FCOCUtils.setContainerEnabled(this.m_WrapParaPan, true);
            if (this.m_nType != 4 && this.m_nType != 3) {
                FCOCUtils.setContainerEnabled(this.m_ParaPanTime, false);
                FCOCUtils.setContainerEnabled(this.m_SequPanDebugPanel, false);
                i = 0;
                while (i < 16) {
                    this.m_SequPanVarInputText[i].setEnabled(false);
                    this.m_SequPanVarSetButton[i].setEnabled(false);
                    ++i;
                }
                this.m_SequPanCpyToSCButton.setEnabled(false);
                this.m_FDevice.setI2CAutoreadState("Sequencer", "SeqBreakStatus", false);
            } else {
                this.m_SequPanCpyToSCButton.setEnabled(true);
                FCOCUtils.setContainerEnabled(this.m_SequPanDebugPanel, true);
                this.m_FDevice.setI2CAutoreadState("Sequencer", "SeqBreakStatus", true);
            }
            if (this.m_nType == 5 || this.m_nType == 6) {
                FCOCUtils.setContainerEnabled(this.m_ParaPanTime, true);
                this.m_ParaPanNbPowUpDispLabel.setEnabled(false);
                this.m_ParaPanServTimeDispLabel.setEnabled(false);
                this.m_FDevice.setI2CAutoreadState("Sequencer", FCOEI2CSeqRegisters.ServiceTime.toString(), false);
                i = 0;
                while (i < 16) {
                    this.m_FDevice.setI2CAutoreadState("Sequencer", "SeqVariable" + Integer.toHexString(i).toUpperCase(), false);
                    ++i;
                }
                FCOCUtils.setContainerEnabled(this.m_SequPanVariablesParaPanel, false);
            } else {
                this.m_ParaPanNbPowUpDispLabel.setEnabled(true);
                this.m_ParaPanServTimeDispLabel.setEnabled(true);
                this.m_FDevice.setI2CAutoreadState("Sequencer", FCOEI2CSeqRegisters.ServiceTime.toString(), true);
                i = 0;
                while (i < 16) {
                    this.m_FDevice.setI2CAutoreadState("Sequencer", "SeqVariable" + Integer.toHexString(i).toUpperCase(), true);
                    ++i;
                }
            }
            this.m_SequPanSendSeqButton.setEnabled(true);
            this.m_SequPanReadSeqButton.setEnabled(true);
            this.m_SequPanActActionIDLabel.setEnabled(true);
            this.m_SequPanActActionIDDispLabel.setEnabled(true);
            this.m_SequPanActActionADEnableCB.setEnabled(true);
            this.m_SequPanActSuspendCB.setEnabled(true);
            this.m_ResetSequButton.setEnabled(true);
        } else {
            try {
                FCOCUtils.setContainerEnabled(this.m_SequPanVariablesParaPanel, false);
                FCOCUtils.setContainerEnabled(this.m_SequPanDebugPanel, false);
                FCOCUtils.setContainerEnabled(this.m_LivePan, false);
                FCOCUtils.setContainerEnabled(this.m_WrapParaPan, false);
                this.m_SequPanSendSeqButton.setEnabled(false);
                this.m_SequPanReadSeqButton.setEnabled(false);
                this.m_SequPanCpyToSCButton.setEnabled(false);
                this.m_SequPanActActionIDLabel.setEnabled(false);
                this.m_SequPanActActionIDDispLabel.setEnabled(false);
                this.m_SequPanActActionADEnableCB.setEnabled(false);
                this.m_SequPanActSuspendCB.setEnabled(false);
                this.m_SequPanActActionADEnableCB.setSelected(false);
                this.m_SequPanSeqList.setEnabled(true);
                this.m_ResetSequButton.setEnabled(false);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.validate();
    }

    public int getActualState() {
        return this.m_nTransferState;
    }

    public void forceReadSequenceIfEmpty() {
        if (this.m_SequPanSeqListModel.getSize() < 2) {
            this.actionPerformed(new ActionEvent(this.m_SequPanReadSeqButton, 0, ""));
        }
    }

    public synchronized void saveSeqToFile() {
        JFileChooser SeqFileDialog = new JFileChooser(this.m_szCurrentDirectory);
        SeqFileDialog.setFileFilter(new FileNameExtensionFilter("FMod-LEDSEQUENCER file", "5seq"));
        SeqFileDialog.showSaveDialog(this);
        if (SeqFileDialog.getSelectedFile() != null) {
            String szFilePath;
            this.m_szCurrentDirectory = szFilePath = SeqFileDialog.getSelectedFile().getPath();
            if (!SeqFileDialog.getSelectedFile().getName().matches(".+\\.5seq")) {
                szFilePath = String.valueOf(szFilePath) + ".5seq";
            }
            File WriteFile = new File(szFilePath);
            boolean isFileOK = true;
            if (WriteFile.exists()) {
                String szMessage = "File already exists. Overwrite ?";
                Object[] options = new Object[]{"Overwrite", "Cancel"};
                if (JOptionPane.showOptionDialog(null, "File already exists. Overwrite ?", "Warning", -1, 2, null, options, options[1]) == 1) {
                    isFileOK = false;
                }
            }
            if (isFileOK) {
                this.m_nTransferState = 0;
                try {
                    BufferedWriter FileWritter = new BufferedWriter(new FileWriter(WriteFile));
                    FileWritter.write("LEDSEQ Save file format.\r\n");
                    int i = 0;
                    while (i < this.m_SequPanSeqListModel.getSize()) {
                        this.m_nTransferState = i;
                        FCOCSequActionPan Act = this.m_SequPanSeqListModel.get(i);
                        Byte[] aActionBytes = Act.getClass() != FCOCSequActionExtension.class ? Act.bytesGetter() : this.m_SequPanSeqListModel.elementAt(i - 1).bytesGetterExtension();
                        FileWritter.write(String.valueOf(FCOCUtils.toHexString(FCOCUtils.byteArrayBEToInt(aActionBytes, 0), 8)) + FCOCUtils.toHexString(FCOCUtils.byteArrayBEToInt(aActionBytes, 4), 8) + "\r\n");
                        if (Act.getClassName() == "EOF") {
                            this.m_nTransferState = 0;
                            break;
                        }
                        ++i;
                    }
                    FileWritter.close();
                }
                catch (IOException iox) {
                    System.err.println("Error: File write error !");
                    iox.printStackTrace();
                }
            }
            Object var3_3 = null;
        }
    }

    public synchronized void readSeqFromFile(String szFilePath) {
        if (szFilePath == null || szFilePath.length() == 0) {
            JFileChooser SeqFileDialog = new JFileChooser(this.m_szCurrentDirectory);
            SeqFileDialog.setFileFilter(new FileNameExtensionFilter("FMod-LEDSEQUENCER file", "5seq"));
            SeqFileDialog.showOpenDialog(this);
            if (SeqFileDialog.getSelectedFile() != null) {
                szFilePath = SeqFileDialog.getSelectedFile().getPath();
            }
        }
        if (szFilePath != null) {
            this.m_szCurrentDirectory = szFilePath;
            try {
                BufferedReader FileReader2 = new BufferedReader(new FileReader(szFilePath));
                String szInFile = FileReader2.readLine();
                if (!szInFile.equals("LEDSEQ Save file format.") && !szInFile.equals("DIE004 Save file format.")) {
                    System.err.println("Bad file format !");
                } else {
                    this.m_SequPanActionParaPanel.removeAll();
                    this.m_SequPanActionParaPanel.repaint();
                    this.m_SequPanSeqListModel.clear();
                    this.m_nTransferState = 0;
                    FCOCUtils.setContainerEnabled(this.m_SequPan, false);
                    Byte[] aByteRead = new Byte[8];
                    long lData = 0L;
                    Class<FCOCSequActionPan> ActClass = null;
                    while ((szInFile = FileReader2.readLine()) != null) {
                        if (szInFile.length() % 16 != 0) {
                            System.err.println("Bad file format !");
                            break;
                        }
                        lData = Long.parseLong(szInFile.substring(0, 8), 16);
                        FCOCUtils.intToByteArrayBE((int)lData, aByteRead, 0);
                        lData = Long.parseLong(szInFile.substring(8), 16);
                        FCOCUtils.intToByteArrayBE((int)lData, aByteRead, 4);
                        String szClassName = FCOESequAction.getClassName(aByteRead);
                        FCOCSequActionPan NewAction = new FCOCSequActionUnknown(aByteRead);
                        if (szClassName == "Extension") {
                            NewAction = this.m_SequPanSeqListModel.get(this.m_SequPanSeqListModel.getSize() - 1).bytesSetterExtension(aByteRead) ? new FCOCSequActionExtension(aByteRead) : new FCOCSequActionUnknown(aByteRead);
                        } else if (this.m_AvailableActions.containsKey(szClassName)) {
                            ActClass = this.m_AvailableActions.get(szClassName);
                            try {
                                NewAction = ActClass.getDeclaredConstructor(Byte[].class).newInstance(new Object[]{aByteRead});
                            }
                            catch (Exception e) {
                                System.err.println("Error while adding new Action @ ID = " + this.m_SequPanSeqListModel.getSize());
                                e.printStackTrace();
                            }
                        }
                        this.m_SequPanSeqListModel.addElement(NewAction);
                        ++this.m_nTransferState;
                        this.m_Caller.simpleEventPerformed(this);
                        if (szClassName != "EOF") continue;
                        this.m_nTransferState = 0;
                        this.m_Caller.simpleEventPerformed(this);
                        Enumeration<FCOCSequActionPan> ActionPan = this.m_SequPanSeqListModel.elements();
                        while (ActionPan.hasMoreElements()) {
                            FCOCSequActionPan Action2 = ActionPan.nextElement();
                            try {
                                Action2.updateJumps();
                            }
                            catch (ClassCastException Excep) {
                                JOptionPane.showMessageDialog(this, "Error in action at index " + Action2.getIndex() + "\r\nThe jump does not reach a Label.\r\nPlease correct the Label name.");
                            }
                        }
                        FCOCUtils.setContainerEnabled(this.m_SequPan, true);
                        this.checkItemsToEnable();
                        this.m_SequPanSeqList.setSelectedIndex(0);
                        break;
                    }
                }
                FileReader2.close();
            }
            catch (FileNotFoundException FNFException) {
                System.err.println("Error: File not found !");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public synchronized void displaySeqVars(boolean isDisplayed) {
        if (isDisplayed) {
            this.m_SequPan.add(this.m_SequVarRightPanel, 9, 1, 1, 7, 0, 60, 2, 11);
        } else {
            try {
                this.m_SequPan.remove(this.m_SequVarRightPanel);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void dataDevEvtOccured(String szRegisterName, Object Data) {
        if (szRegisterName.compareTo("Version") == 0) {
            long lVersion = (Long)Data;
            this.m_ParaPanVersionTCPDispLabel.setText(String.valueOf((int)(lVersion / 65536L)) + "." + (lVersion & 0xFFFFL));
        } else if (szRegisterName.compareTo("IPAddress") == 0) {
            Byte[] aIPAddress = (Byte[])Data;
            this.m_ParaPanIP4Text.setValue(aIPAddress[0] & 0xFF);
            this.m_ParaPanIP3Text.setValue(aIPAddress[1] & 0xFF);
            this.m_ParaPanIP2Text.setValue(aIPAddress[2] & 0xFF);
            this.m_ParaPanIP1Text.setValue(aIPAddress[3] & 0xFF);
        } else if (szRegisterName.compareTo("SubnetMask") == 0) {
            Byte[] aSubnetMask = (Byte[])Data;
            this.m_ParaPanSNM4Text.setValue(aSubnetMask[0] & 0xFF);
            this.m_ParaPanSNM3Text.setValue(aSubnetMask[1] & 0xFF);
            this.m_ParaPanSNM2Text.setValue(aSubnetMask[2] & 0xFF);
            this.m_ParaPanSNM1Text.setValue(aSubnetMask[3] & 0xFF);
        } else if (szRegisterName.compareTo("MACAddress") == 0) {
            Byte[] aMACAddress = (Byte[])Data;
            String szMACAddress = "";
            int i = 5;
            while (i >= 0) {
                szMACAddress = String.valueOf(szMACAddress) + FCOCUtils.toHexString(aMACAddress[i].byteValue()) + " ";
                --i;
            }
            this.m_ParaPanMACValueLabel.setText(szMACAddress);
        } else if (szRegisterName.compareTo("Name") == 0) {
            this.m_ParaPanNameText.setText((String)Data);
        }
        this.validate();
    }

    public void dataI2CDevEvtOccured(String szRegisterName, Object Data) {
        try {
            switch (FCOEI2CSeqRegisters.getFromString(szRegisterName)) {
                case Type: {
                    long lType = (Long)Data;
                    System.out.print("Device type detected: ");
                    if (lType == 720897L) {
                        this.buildAvailableActionsList(1);
                        System.out.println("FMod-LEDSEQUENCER 2");
                        break;
                    }
                    if (lType == 720898L) {
                        this.buildAvailableActionsList(3);
                        System.out.println("FMod-LEDSEQUENCER 3");
                        break;
                    }
                    if (lType == 720900L) {
                        this.buildAvailableActionsList(4);
                        System.out.println("FMod-LEDSEQUENCER 4");
                        break;
                    }
                    if (lType == 0x100001L) {
                        this.buildAvailableActionsList(5);
                        System.out.println("Carrousel");
                        break;
                    }
                    if (lType == 0x110001L) {
                        this.buildAvailableActionsList(6);
                        System.out.println("Carrousel sequencer");
                    }
                    break;
                }
                case Version: {
                    long lVersion = (Long)Data;
                    this.m_ParaPanVersionI2CDispLabel.setText(String.valueOf((int)(lVersion / 0x1000000L)) + "." + (lVersion / 65536L & 0xFFL) + "/" + (lVersion / 256L & 0xFFL) + "." + (lVersion & 0xFFL));
                    break;
                }
                case Voltage: {
                    double dVoltage = (Double)Data;
                    dVoltage = (double)((int)Math.round(dVoltage * 10.0)) / 10.0;
                    this.m_ParaPanVoltageDispLabel.setText("Voltage: " + dVoltage + " V");
                    if (dVoltage > 50.0) {
                        this.m_ParaPanVoltageDispLabel.setForeground(Color.red);
                        break;
                    }
                    this.m_ParaPanVoltageDispLabel.setForeground(Color.black);
                    break;
                }
                case TimeR: {
                    GregorianCalendar BoardCalendar = new GregorianCalendar(Locale.ENGLISH);
                    GregorianCalendar SpecificGMTCalendar = new GregorianCalendar(TimeZone.getTimeZone(this.m_ParaPanTimeZoneChoice.getSelectedItem().substring(0, this.m_ParaPanTimeZoneChoice.getSelectedItem().indexOf(" "))), Locale.ENGLISH);
                    Byte[] Time = (Byte[])Data;
                    BoardCalendar.set(FCOCUtils.bcd2Int(Time[6]) + 2000, FCOCUtils.bcd2Int(Time[5]) - 1, FCOCUtils.bcd2Int(Time[4]), FCOCUtils.bcd2Int(Time[2]), FCOCUtils.bcd2Int(Time[1]), FCOCUtils.bcd2Int(Time[0]));
                    this.m_DateFormatter.setCalendar(BoardCalendar);
                    this.m_ParaPanBoardTimeDispLabel.setText(this.m_DateFormatter.format(BoardCalendar.getTime()));
                    this.m_DateFormatter.setCalendar(SpecificGMTCalendar);
                    this.m_ParaPanPCTimeDispLabel.setText(this.m_DateFormatter.format(SpecificGMTCalendar.getTime()));
                    break;
                }
                case NbPowerUp: {
                    this.m_ParaPanNbPowUpDispLabel.setText("Nb of power up : " + ((Long)Data).intValue());
                    break;
                }
                case ServiceTime: {
                    int nServiceTime = ((Long)Data).intValue();
                    String szServiceTime = "Service time : " + nServiceTime / 3600 + "h ";
                    szServiceTime = String.valueOf(szServiceTime) + nServiceTime % 3600 / 60 + "m ";
                    szServiceTime = String.valueOf(szServiceTime) + nServiceTime % 3600 % 60 + "s";
                    this.m_ParaPanServTimeDispLabel.setText(szServiceTime);
                    break;
                }
                case Temperature: {
                    double dTemperature = (Double)Data;
                    dTemperature = (double)((int)Math.round(dTemperature * 10.0)) / 10.0;
                    this.m_ParaPanTempDispLabel.setText("Temperature : " + dTemperature + " \u00b0C");
                    if (dTemperature > 54.0) {
                        this.m_ParaPanTempDispLabel.setForeground(Color.red);
                        break;
                    }
                    this.m_ParaPanTempDispLabel.setForeground(Color.black);
                    break;
                }
                case ActionID: {
                    int i = ((Long)Data).intValue() >> 8;
                    this.m_nTransferState = i++;
                    if (i < this.m_SequPanSeqListModel.getSize()) {
                        FCOCSequActionPan Act = this.m_SequPanSeqListModel.elementAt(i);
                        this.m_FDevice.setI2CValue("Sequencer", "ActionID", new Long(3 + (i << 8)), true);
                        Byte[] aActionBytes = Act.getClass() != FCOCSequActionExtension.class ? Act.bytesGetter() : this.m_SequPanSeqListModel.elementAt(i - 1).bytesGetterExtension();
                        this.m_FDevice.setI2CValue("Sequencer", "ActionValue", aActionBytes);
                        this.m_FDevice.callI2C("Sequencer", "ForceUpdateActV");
                        if (!Act.getClassName().equals("EOF")) {
                            this.m_FDevice.getI2CValue("Sequencer", "ActionID");
                        } else {
                            BitSet OptionsBits = (BitSet)this.m_FDevice.getI2CLastValue("Sequencer", "Options");
                            OptionsBits.set(0);
                            OptionsBits.clear(1);
                            this.m_FDevice.setI2CValue("Sequencer", "Options", OptionsBits);
                            this.m_nTransferState = 0;
                            this.m_FDevice.setInterfaceComSupendedState(false);
                            this.m_FDevice.setThreadSleepTime(50L);
                            this.checkItemsToEnable();
                        }
                    } else {
                        this.m_nTransferState = 0;
                        this.m_FDevice.setInterfaceComSupendedState(false);
                        this.m_FDevice.setThreadSleepTime(50L);
                        this.checkItemsToEnable();
                    }
                    this.m_Caller.simpleEventPerformed(this);
                    break;
                }
                case ActionValue: {
                    int nNextID;
                    Byte[] aActionBytes = (Byte[])Data;
                    String szClassName = FCOESequAction.getClassName(aActionBytes);
                    this.m_nTransferState = nNextID = this.m_SequPanSeqListModel.getSize() + 1;
                    if (szClassName != "EOF" && nNextID < 4000) {
                        try {
                            this.m_FDevice.setI2CValue("Sequencer", "ActionID", new Long(1 + (nNextID << 8)), true);
                            this.m_FDevice.callI2C("Sequencer", "ForceUpdateActV");
                            this.m_FDevice.getI2CValue("Sequencer", "ActionValue");
                        }
                        catch (NullPointerException nullPointerException) {}
                    } else {
                        this.m_nTransferState = 0;
                        this.m_FDevice.setInterfaceComSupendedState(false);
                        this.m_FDevice.setThreadSleepTime(50L);
                        Enumeration<FCOCSequActionPan> ActionPan = this.m_SequPanSeqListModel.elements();
                        while (ActionPan.hasMoreElements()) {
                            FCOCSequActionPan Action2 = ActionPan.nextElement();
                            try {
                                Action2.updateJumps();
                            }
                            catch (ClassCastException Excep) {
                                JOptionPane.showMessageDialog(this, "Error in action at index " + Action2.getIndex() + "\r\nThe jump does not reach a Label.\r\nPlease correct the Label name.");
                            }
                        }
                        this.checkItemsToEnable();
                        this.m_SequPanSeqList.setSelectedIndex(0);
                    }
                    Class<FCOCSequActionPan> ActClass = null;
                    FCOCSequActionPan NewAction = new FCOCSequActionUnknown(aActionBytes);
                    if (szClassName == "Extension") {
                        NewAction = this.m_SequPanSeqListModel.get(this.m_SequPanSeqListModel.getSize() - 1).bytesSetterExtension(aActionBytes) ? new FCOCSequActionExtension(aActionBytes) : new FCOCSequActionUnknown(aActionBytes);
                    } else if (this.m_AvailableActions.containsKey(szClassName)) {
                        ActClass = this.m_AvailableActions.get(szClassName);
                        try {
                            NewAction = ActClass.getDeclaredConstructor(Byte[].class).newInstance(new Object[]{aActionBytes});
                        }
                        catch (Exception e) {
                            System.err.println("Error while adding new Action @ ID = " + this.m_SequPanSeqListModel.getSize());
                            e.printStackTrace();
                        }
                    } else if (!this.m_AvailableActions.containsKey("FCOCSequActionUnknown")) {
                        Class<?> UKActClass = Class.forName(String.valueOf(this.getClass().getPackage().getName()) + ".FCOCSequActionUnknown");
                        this.m_AvailableActions.put("FCOCSequActionUnknown", UKActClass);
                        this.m_SequPanActionCombo.addItem("Special");
                    }
                    this.m_SequPanSeqListModel.addElement(NewAction);
                    this.m_Caller.simpleEventPerformed(this);
                    break;
                }
                case ActualActionID: {
                    int nActualActionID = ((Long)Data).intValue();
                    this.m_SequPanActActionIDDispLabel.setText("" + nActualActionID);
                    if (!this.m_SequPanActActionADEnableCB.isSelected()) break;
                    try {
                        this.m_SequPanSeqList.setSelectedValue(this.m_SequPanSeqListModel.elementAt(nActualActionID), true);
                        byte nActionLength = FCOESequAction.getActionLength(this.m_SequPanSeqListModel.getElementAt(nActualActionID).getClassName());
                        if (nActionLength > 1) {
                            this.m_SequPanSeqList.setSelectionInterval(nActualActionID, nActualActionID + nActionLength - 1);
                        }
                    }
                    catch (ArrayIndexOutOfBoundsException nActionLength) {}
                    break;
                }
                case ButtonThreshold: {
                    Byte[] BThres = (Byte[])Data;
                    this.m_LivePanThreshB1MinTA.setValue(BThres[0] & 0xFF);
                    this.m_LivePanThreshB1MaxTA.setValue(BThres[1] & 0xFF);
                    this.m_LivePanThreshB2MinTA.setValue(BThres[2] & 0xFF);
                    this.m_LivePanThreshB2MaxTA.setValue(BThres[3] & 0xFF);
                    this.m_LivePanThreshB3MinTA.setValue(BThres[4] & 0xFF);
                    this.m_LivePanThreshB3MaxTA.setValue(BThres[5] & 0xFF);
                    this.m_LivePanThreshB4MinTA.setValue(BThres[6] & 0xFF);
                    this.m_LivePanThreshB4MaxTA.setValue(BThres[7] & 0xFF);
                    this.m_LivePanThreshB5MinTA.setValue(BThres[8] & 0xFF);
                    this.m_LivePanThreshB5MaxTA.setValue(BThres[9] & 0xFF);
                    this.m_LivePanThreshB6MinTA.setValue(BThres[10] & 0xFF);
                    this.m_LivePanThreshB6MaxTA.setValue(BThres[11] & 0xFF);
                    this.m_LivePanThreshB7MinTA.setValue(BThres[12] & 0xFF);
                    this.m_LivePanThreshB7MaxTA.setValue(BThres[13] & 0xFF);
                    this.m_LivePanThreshB8MinTA.setValue(BThres[14] & 0xFF);
                    this.m_LivePanThreshB8MaxTA.setValue(BThres[15] & 0xFF);
                    break;
                }
                case ButtonSensorsVal: {
                    Byte[] BSensVal = (Byte[])Data;
                    this.setSensorActVal(this.m_LivePanLiveB1Label, (int)(BSensVal[0] & 0xFF), ((SpinnerNumberModel)this.m_LivePanThreshB1MinTA.getModel()).getNumber().intValue(), ((SpinnerNumberModel)this.m_LivePanThreshB1MaxTA.getModel()).getNumber().intValue());
                    this.setSensorActVal(this.m_LivePanLiveB2Label, (int)(BSensVal[1] & 0xFF), ((SpinnerNumberModel)this.m_LivePanThreshB2MinTA.getModel()).getNumber().intValue(), ((SpinnerNumberModel)this.m_LivePanThreshB2MaxTA.getModel()).getNumber().intValue());
                    this.setSensorActVal(this.m_LivePanLiveB3Label, (int)(BSensVal[2] & 0xFF), ((SpinnerNumberModel)this.m_LivePanThreshB3MinTA.getModel()).getNumber().intValue(), ((SpinnerNumberModel)this.m_LivePanThreshB3MaxTA.getModel()).getNumber().intValue());
                    this.setSensorActVal(this.m_LivePanLiveB4Label, (int)(BSensVal[3] & 0xFF), ((SpinnerNumberModel)this.m_LivePanThreshB4MinTA.getModel()).getNumber().intValue(), ((SpinnerNumberModel)this.m_LivePanThreshB4MaxTA.getModel()).getNumber().intValue());
                    this.setSensorActVal(this.m_LivePanLiveB5Label, (int)(BSensVal[4] & 0xFF), ((SpinnerNumberModel)this.m_LivePanThreshB5MinTA.getModel()).getNumber().intValue(), ((SpinnerNumberModel)this.m_LivePanThreshB5MaxTA.getModel()).getNumber().intValue());
                    this.setSensorActVal(this.m_LivePanLiveB6Label, (int)(BSensVal[5] & 0xFF), ((SpinnerNumberModel)this.m_LivePanThreshB6MinTA.getModel()).getNumber().intValue(), ((SpinnerNumberModel)this.m_LivePanThreshB6MaxTA.getModel()).getNumber().intValue());
                    this.setSensorActVal(this.m_LivePanLiveB7Label, (int)(BSensVal[6] & 0xFF), ((SpinnerNumberModel)this.m_LivePanThreshB7MinTA.getModel()).getNumber().intValue(), ((SpinnerNumberModel)this.m_LivePanThreshB7MaxTA.getModel()).getNumber().intValue());
                    this.setSensorActVal(this.m_LivePanLiveB8Label, (int)(BSensVal[7] & 0xFF), ((SpinnerNumberModel)this.m_LivePanThreshB8MinTA.getModel()).getNumber().intValue(), ((SpinnerNumberModel)this.m_LivePanThreshB8MaxTA.getModel()).getNumber().intValue());
                    break;
                }
                case MaxCurrentLed1: {
                    this.m_ParaPanLed1IText.setValue((int)Math.round((Double)Data * 10.0));
                    break;
                }
                case MaxCurrentLed2: {
                    this.m_ParaPanLed2IText.setValue((int)Math.round((Double)Data * 10.0));
                    break;
                }
                case MaxCurrentLed3: {
                    this.m_ParaPanLed3IText.setValue((int)Math.round((Double)Data * 10.0));
                    break;
                }
                case MaxCurrentLed4: {
                    this.m_ParaPanLed4IText.setValue((int)Math.round((Double)Data * 10.0));
                    break;
                }
                case MaxCurrentLed5: {
                    this.m_ParaPanLed5IText.setValue((int)Math.round((Double)Data * 10.0));
                    break;
                }
                case Led1Goal: {
                    this.m_LivePanLed1ValScrollB.setValue((int)((Long)Data >> 32 & 0xFFFFL));
                    break;
                }
                case Led2Goal: {
                    this.m_LivePanLed2ValScrollB.setValue((int)((Long)Data >> 32 & 0xFFFFL));
                    break;
                }
                case Led3Goal: {
                    this.m_LivePanLed3ValScrollB.setValue((int)((Long)Data >> 32 & 0xFFFFL));
                    break;
                }
                case Led4Goal: {
                    this.m_LivePanLed4ValScrollB.setValue((int)((Long)Data >> 32 & 0xFFFFL));
                    break;
                }
                case Led5Goal: {
                    this.m_LivePanLed5ValScrollB.setValue((int)((Long)Data >> 32 & 0xFFFFL));
                    break;
                }
                case SmartCardStatus: {
                    boolean isWriteEnded;
                    long lSmartCardStatus = (Long)Data;
                    int nCounter = (int)(lSmartCardStatus >> 16 & 0xFFFFL);
                    int nStatus = (int)(lSmartCardStatus & 0xFFFFL);
                    boolean bl = isWriteEnded = (lSmartCardStatus & 0x80L) == 128L;
                    if (isWriteEnded) {
                        if ((nStatus & 0xBFFF) != 49039) {
                            String szError = "No Smart Card found !";
                            if (nStatus != 32896) {
                                szError = "Unknown error in Smart Card write (0x" + Integer.toHexString(nStatus) + ") !";
                            }
                            JOptionPane.showMessageDialog(this, szError);
                        }
                        this.checkItemsToEnable();
                        this.m_nTransferState = 0;
                    } else {
                        this.m_FDevice.getI2CValue("Sequencer", "SmartCardStatus");
                        this.m_nTransferState = nCounter;
                    }
                    this.m_Caller.simpleEventPerformed(this);
                    break;
                }
                case SeqVariable0: {
                    long lVarValue = (Long)Data;
                    if (this.m_SequPanVarChoices[0].getSelectedItem().equals("Dec")) {
                        this.m_SequPanVarDispLabel[0].setText("" + lVarValue);
                        break;
                    }
                    this.m_SequPanVarDispLabel[0].setText("0x" + FCOCUtils.toHexString((int)lVarValue, 8));
                    break;
                }
                case SeqVariable1: {
                    long lVarValue = (Long)Data;
                    if (this.m_SequPanVarChoices[1].getSelectedItem().equals("Dec")) {
                        this.m_SequPanVarDispLabel[1].setText("" + lVarValue);
                        break;
                    }
                    this.m_SequPanVarDispLabel[1].setText("0x" + FCOCUtils.toHexString((int)lVarValue, 8));
                    break;
                }
                case SeqVariable2: {
                    long lVarValue = (Long)Data;
                    if (this.m_SequPanVarChoices[2].getSelectedItem().equals("Dec")) {
                        this.m_SequPanVarDispLabel[2].setText("" + lVarValue);
                        break;
                    }
                    this.m_SequPanVarDispLabel[2].setText("0x" + FCOCUtils.toHexString((int)lVarValue, 8));
                    break;
                }
                case SeqVariable3: {
                    long lVarValue = (Long)Data;
                    if (this.m_SequPanVarChoices[3].getSelectedItem().equals("Dec")) {
                        this.m_SequPanVarDispLabel[3].setText("" + lVarValue);
                        break;
                    }
                    this.m_SequPanVarDispLabel[3].setText("0x" + FCOCUtils.toHexString((int)lVarValue, 8));
                    break;
                }
                case SeqVariable4: {
                    long lVarValue = (Long)Data;
                    if (this.m_SequPanVarChoices[4].getSelectedItem().equals("Dec")) {
                        this.m_SequPanVarDispLabel[4].setText("" + lVarValue);
                        break;
                    }
                    this.m_SequPanVarDispLabel[4].setText("0x" + FCOCUtils.toHexString((int)lVarValue, 8));
                    break;
                }
                case SeqVariable5: {
                    long lVarValue = (Long)Data;
                    if (this.m_SequPanVarChoices[5].getSelectedItem().equals("Dec")) {
                        this.m_SequPanVarDispLabel[5].setText("" + lVarValue);
                        break;
                    }
                    this.m_SequPanVarDispLabel[5].setText("0x" + FCOCUtils.toHexString((int)lVarValue, 8));
                    break;
                }
                case SeqVariable6: {
                    long lVarValue = (Long)Data;
                    if (this.m_SequPanVarChoices[6].getSelectedItem().equals("Dec")) {
                        this.m_SequPanVarDispLabel[6].setText("" + lVarValue);
                        break;
                    }
                    this.m_SequPanVarDispLabel[6].setText("0x" + FCOCUtils.toHexString((int)lVarValue, 8));
                    break;
                }
                case SeqVariable7: {
                    long lVarValue = (Long)Data;
                    if (this.m_SequPanVarChoices[7].getSelectedItem().equals("Dec")) {
                        this.m_SequPanVarDispLabel[7].setText("" + lVarValue);
                        break;
                    }
                    this.m_SequPanVarDispLabel[7].setText("0x" + FCOCUtils.toHexString((int)lVarValue, 8));
                    break;
                }
                case SeqVariable8: {
                    long lVarValue = (Long)Data;
                    if (this.m_SequPanVarChoices[8].getSelectedItem().equals("Dec")) {
                        this.m_SequPanVarDispLabel[8].setText("" + lVarValue);
                        break;
                    }
                    this.m_SequPanVarDispLabel[8].setText("0x" + FCOCUtils.toHexString((int)lVarValue, 8));
                    break;
                }
                case SeqVariable9: {
                    long lVarValue = (Long)Data;
                    if (this.m_SequPanVarChoices[9].getSelectedItem().equals("Dec")) {
                        this.m_SequPanVarDispLabel[9].setText("" + lVarValue);
                        break;
                    }
                    this.m_SequPanVarDispLabel[9].setText("0x" + FCOCUtils.toHexString((int)lVarValue, 8));
                    break;
                }
                case SeqVariableA: {
                    long lVarValue = (Long)Data;
                    if (this.m_SequPanVarChoices[10].getSelectedItem().equals("Dec")) {
                        this.m_SequPanVarDispLabel[10].setText("" + lVarValue);
                        break;
                    }
                    this.m_SequPanVarDispLabel[10].setText("0x" + FCOCUtils.toHexString((int)lVarValue, 8));
                    break;
                }
                case SeqVariableB: {
                    long lVarValue = (Long)Data;
                    if (this.m_SequPanVarChoices[11].getSelectedItem().equals("Dec")) {
                        this.m_SequPanVarDispLabel[11].setText("" + lVarValue);
                        break;
                    }
                    this.m_SequPanVarDispLabel[11].setText("0x" + FCOCUtils.toHexString((int)lVarValue, 8));
                    break;
                }
                case SeqVariableC: {
                    long lVarValue = (Long)Data;
                    if (this.m_SequPanVarChoices[12].getSelectedItem().equals("Dec")) {
                        this.m_SequPanVarDispLabel[12].setText("" + lVarValue);
                        break;
                    }
                    this.m_SequPanVarDispLabel[12].setText("0x" + FCOCUtils.toHexString((int)lVarValue, 8));
                    break;
                }
                case SeqVariableD: {
                    long lVarValue = (Long)Data;
                    if (this.m_SequPanVarChoices[13].getSelectedItem().equals("Dec")) {
                        this.m_SequPanVarDispLabel[13].setText("" + lVarValue);
                        break;
                    }
                    this.m_SequPanVarDispLabel[13].setText("0x" + FCOCUtils.toHexString((int)lVarValue, 8));
                    break;
                }
                case SeqVariableE: {
                    long lVarValue = (Long)Data;
                    if (this.m_SequPanVarChoices[14].getSelectedItem().equals("Dec")) {
                        this.m_SequPanVarDispLabel[14].setText("" + lVarValue);
                        break;
                    }
                    this.m_SequPanVarDispLabel[14].setText("0x" + FCOCUtils.toHexString((int)lVarValue, 8));
                    break;
                }
                case SeqVariableF: {
                    long lVarValue = (Long)Data;
                    if (this.m_SequPanVarChoices[15].getSelectedItem().equals("Dec")) {
                        this.m_SequPanVarDispLabel[15].setText("" + lVarValue);
                        break;
                    }
                    this.m_SequPanVarDispLabel[15].setText("0x" + FCOCUtils.toHexString((int)lVarValue, 8));
                    break;
                }
                case SeqBreakCfg: {
                    Byte[] BBreakCfg = (Byte[])Data;
                    boolean isSelected = false;
                    if ((BBreakCfg[0].intValue() & 4) == 4) {
                        isSelected = true;
                    }
                    isSelected = false;
                    this.m_SequPanDebugEnJumpsBPCB.setSelected(isSelected);
                    if ((BBreakCfg[0].intValue() & 8) == 8) {
                        isSelected = true;
                    }
                    this.m_SequPanDebugEnEventsBPCB.setSelected(isSelected);
                    isSelected = false;
                    if ((BBreakCfg[1].intValue() & 1) == 1) {
                        isSelected = true;
                    }
                    this.m_SequPanDebugEnForcedBPCB.setSelected(isSelected);
                    int i1 = 0;
                    while (i1 < 7) {
                        isSelected = false;
                        if ((BBreakCfg[1].intValue() >> i1 + 1 & 1) == 1) {
                            isSelected = true;
                        }
                        this.m_SequPanDebugEnGroupBPCBs[i1].setSelected(isSelected);
                        ++i1;
                    }
                    break;
                }
                case SeqBreakStatus: {
                    Byte[] BBreakStatus = (Byte[])Data;
                    String szState = "";
                    boolean isPaused = true;
                    switch (BBreakStatus[0]) {
                        case 0: {
                            szState = "Running";
                            isPaused = false;
                            break;
                        }
                        case 1: {
                            szState = "Paused on a breakpoint";
                            break;
                        }
                        case 2: {
                            szState = "Step by step";
                            isPaused = false;
                            break;
                        }
                        case 3: {
                            szState = "Paused";
                            break;
                        }
                        case 4: {
                            szState = "Paused on a jump";
                            break;
                        }
                        case 5: {
                            szState = "Paused by an event";
                            break;
                        }
                        default: {
                            szState = "Unknown";
                        }
                    }
                    this.m_SequPanDebugStatusDispLabel.setText(szState);
                    this.m_SequPanDebugPauseButton.setEnabled(!isPaused);
                    break;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.repaint();
    }

    private void setSensorActVal(JLabel DispLabel, int nValue, int nMinTH, int nMaxTH) {
        String szTemp = "";
        if (nValue < 100) {
            szTemp = String.valueOf(szTemp) + "0";
        }
        if (nValue < 10) {
            szTemp = String.valueOf(szTemp) + "0";
        }
        DispLabel.setText(String.valueOf(szTemp) + nValue);
        if (nValue >= nMinTH && nValue <= nMaxTH) {
            DispLabel.setForeground(FCOCUtils.m_MEDIUMGREEN);
        } else {
            DispLabel.setForeground(Color.BLACK);
        }
    }

    @Override
    public void actionPerformed(ActionEvent ActEvent) {
        block112: {
            Object EvtSource = ActEvent.getSource();
            try {
                int nSelectedIndex = this.m_SequPanSeqList.getSelectedIndex();
                int nLastSelectedIndex = this.m_SequPanSeqList.getMaxSelectionIndex();
                List<FCOCSequActionPan> SelectedActions = this.m_SequPanSeqList.getSelectedValuesList();
                if (EvtSource == this.m_SequPanModifyActionButton) {
                    FCOCSequActionPan NewComp = (FCOCSequActionPan)this.m_SequPanActionParaPanel.getComponent(0);
                    FCOCSequActionPan SelectedAction = SelectedActions.get(0);
                    this.m_SequPanSeqList.removeListSelectionListener(this);
                    if (!SelectedAction.modifyAction(NewComp)) {
                        System.err.println("This action type cannot be modified !");
                    } else {
                        NewComp.forceAddPointer();
                    }
                    this.m_SequPanSeqList.addListSelectionListener(this);
                    this.m_SequPanSeqList.setSelectedValue(NewComp, true);
                    this.m_SequPanSeqList.requestFocusInWindow();
                    break block112;
                }
                if (EvtSource == this.m_SequPanInsertActionButton) {
                    this.m_SequPanSeqListModel.add(nSelectedIndex, new FCOCSequActionNone(null));
                    this.m_SequPanSeqList.setSelectedIndex(nSelectedIndex);
                    this.m_SequPanSeqList.requestFocusInWindow();
                    break block112;
                }
                if (EvtSource == this.m_SequPanDeleteActionButton) {
                    for (FCOCSequActionPan Act : SelectedActions) {
                        try {
                            Act.isDeleteAllowed(true);
                        }
                        catch (NullPointerException nullPointerException) {
                            // empty catch block
                        }
                        this.m_SequPanSeqListModel.removeElement(Act);
                    }
                    this.m_SequPanSeqList.setSelectedIndex(nSelectedIndex);
                    this.m_SequPanSeqList.requestFocusInWindow();
                    break block112;
                }
                if (EvtSource == this.m_SequPanMoveDownActionButton) {
                    int nNextActionLength = FCOESequAction.getActionLength(this.m_SequPanSeqListModel.getElementAt(nLastSelectedIndex + 1).getClassName());
                    int i = 0;
                    while (i < nNextActionLength) {
                        this.m_SequPanSeqListModel.add(nSelectedIndex + i, this.m_SequPanSeqListModel.getElementAt(nLastSelectedIndex + 1 + i));
                        this.m_SequPanSeqListModel.removeElementAt(nLastSelectedIndex + 2 + i);
                        ++i;
                    }
                    this.m_SequPanSeqList.setSelectionInterval(nSelectedIndex + nNextActionLength, nLastSelectedIndex + nNextActionLength);
                    this.valueChanged(new ListSelectionEvent(this.m_SequPanSeqList, nSelectedIndex + nNextActionLength, nLastSelectedIndex + nNextActionLength, false));
                    this.m_SequPanSeqList.requestFocusInWindow();
                } else if (EvtSource == this.m_SequPanMoveUpActionButton) {
                    FCOCSequActionPan PreviousAction;
                    int nPreviousActionLength = 0;
                    do {
                        PreviousAction = this.m_SequPanSeqListModel.getElementAt(nSelectedIndex - 1 - nPreviousActionLength);
                        this.m_SequPanSeqListModel.add(nLastSelectedIndex + 1 - nPreviousActionLength, PreviousAction);
                        this.m_SequPanSeqListModel.removeElement(PreviousAction);
                        ++nPreviousActionLength;
                    } while (PreviousAction.getClass() == FCOCSequActionExtension.class);
                    this.m_SequPanSeqList.setSelectionInterval(nSelectedIndex - nPreviousActionLength, nLastSelectedIndex - nPreviousActionLength);
                    this.valueChanged(new ListSelectionEvent(this.m_SequPanSeqList, nSelectedIndex - nPreviousActionLength, nLastSelectedIndex - nPreviousActionLength, false));
                    this.m_SequPanSeqList.requestFocusInWindow();
                } else if (EvtSource == this.m_SequPanSaveSeqButton) {
                    this.saveSeqToFile();
                } else if (EvtSource == this.m_SequPanOpenSeqButton) {
                    this.readSeqFromFile(null);
                } else if (EvtSource == this.m_SequPanSendSeqButton) {
                    if (this.m_SequPanSeqListModel.getElementAt(0).getClass() == FCOCSequActionEOF.class) {
                        String szMessage = "The sequence is empty. Are-you sure you want to send it ?";
                        Object[] options = new Object[]{"Yes", "No"};
                        if (JOptionPane.showOptionDialog(null, "The sequence is empty. Are-you sure you want to send it ?", "Attention", -1, 2, null, options, options[1]) == 1) {
                            return;
                        }
                    }
                    FCOCUtils.setContainerEnabled(this.m_SequPan, false);
                    BitSet OptionsBits = (BitSet)this.m_FDevice.getI2CLastValue("Sequencer", "Options");
                    OptionsBits.set(1);
                    this.m_FDevice.setI2CValue("Sequencer", "Options", OptionsBits);
                    this.m_FDevice.setI2CValue("Sequencer", "ActionID", new Long(3L), true);
                    this.m_FDevice.setI2CValue("Sequencer", "ActionValue", this.m_SequPanSeqListModel.elementAt(0).bytesGetter());
                    this.m_FDevice.callI2C("Sequencer", "ForceUpdateActV");
                    this.m_FDevice.getI2CValue("Sequencer", "ActionID");
                    this.m_FDevice.setInterfaceComSupendedState(true);
                    this.m_FDevice.setThreadSleepTime(5L);
                } else if (EvtSource == this.m_SequPanReadSeqButton) {
                    this.m_SequPanActionParaPanel.removeAll();
                    this.m_SequPanActionParaPanel.repaint();
                    this.m_SequPanSeqListModel.clear();
                    FCOCUtils.setContainerEnabled(this.m_SequPan, false);
                    this.m_FDevice.setI2CValue("Sequencer", "ActionID", new Long(1L), true);
                    this.m_FDevice.callI2C("Sequencer", "ForceUpdateActV");
                    this.m_FDevice.getI2CValue("Sequencer", "ActionValue");
                    this.m_FDevice.setInterfaceComSupendedState(true);
                    this.m_FDevice.setThreadSleepTime(5L);
                } else if (EvtSource == this.m_SequPanCpyToSCButton) {
                    FCOCUtils.setContainerEnabled(this.m_SequPan, false);
                    this.m_FDevice.callI2C("Sequencer", "WriteSmartCard");
                    this.m_FDevice.getI2CValue("Sequencer", "SmartCardStatus");
                } else if (EvtSource == this.m_ResetSequButton) {
                    this.m_FDevice.callI2C("Sequencer", "Reset");
                    Thread.sleep(200L);
                } else if (EvtSource == this.m_ClearSequButton) {
                    this.m_SequPanActionParaPanel.removeAll();
                    this.m_SequPanActionParaPanel.repaint();
                    this.m_SequPanSeqListModel.clear();
                    this.m_SequPanSeqListModel.add(0, new FCOCSequActionEOF(null));
                    this.m_SequPanSeqList.setSelectedIndex(0);
                } else if (EvtSource == this.m_SequPanVarSetButton[0]) {
                    this.setSeqVar(0);
                } else if (EvtSource == this.m_SequPanVarSetButton[1]) {
                    this.setSeqVar(1);
                } else if (EvtSource == this.m_SequPanVarSetButton[2]) {
                    this.setSeqVar(2);
                } else if (EvtSource == this.m_SequPanVarSetButton[3]) {
                    this.setSeqVar(3);
                } else if (EvtSource == this.m_SequPanVarSetButton[4]) {
                    this.setSeqVar(4);
                } else if (EvtSource == this.m_SequPanVarSetButton[5]) {
                    this.setSeqVar(5);
                } else if (EvtSource == this.m_SequPanVarSetButton[6]) {
                    this.setSeqVar(6);
                } else if (EvtSource == this.m_SequPanVarSetButton[7]) {
                    this.setSeqVar(7);
                } else if (EvtSource == this.m_SequPanVarSetButton[8]) {
                    this.setSeqVar(8);
                } else if (EvtSource == this.m_SequPanVarSetButton[9]) {
                    this.setSeqVar(9);
                } else if (EvtSource == this.m_SequPanVarSetButton[10]) {
                    this.setSeqVar(10);
                } else if (EvtSource == this.m_SequPanVarSetButton[11]) {
                    this.setSeqVar(11);
                } else if (EvtSource == this.m_SequPanVarSetButton[12]) {
                    this.setSeqVar(12);
                } else if (EvtSource == this.m_SequPanVarSetButton[13]) {
                    this.setSeqVar(13);
                } else if (EvtSource == this.m_SequPanVarSetButton[14]) {
                    this.setSeqVar(14);
                } else if (EvtSource == this.m_SequPanVarSetButton[15]) {
                    this.setSeqVar(15);
                } else if (EvtSource == this.m_SequPanDebugPlayButton) {
                    this.m_FDevice.setI2CValue("Sequencer", "SeqBreakCfg", this.initDebugCfgByteArray(0, 0, 1));
                } else if (EvtSource == this.m_SequPanDebugPlayDButton) {
                    int nGroups = 0;
                    if (this.m_SequPanDebugEnForcedBPCB.isSelected()) {
                        nGroups = 1;
                    }
                    int i = 0;
                    while (i < 7) {
                        if (this.m_SequPanDebugEnGroupBPCBs[i].isSelected()) {
                            nGroups |= 2 << i;
                        }
                        ++i;
                    }
                    int nBreakCfg = 1;
                    if (this.m_SequPanDebugEnJumpsBPCB.isSelected()) {
                        nBreakCfg |= 4;
                    }
                    if (this.m_SequPanDebugEnEventsBPCB.isSelected()) {
                        nBreakCfg |= 8;
                    }
                    this.m_FDevice.setI2CValue("Sequencer", "SeqBreakCfg", this.initDebugCfgByteArray(65535, nGroups, nBreakCfg));
                } else if (EvtSource == this.m_SequPanDebugPauseButton) {
                    this.m_FDevice.setI2CValue("Sequencer", "SeqBreakCfg", this.initDebugCfgByteArray(65535, 0, 2));
                } else if (EvtSource == this.m_SequPanDebugStepButton) {
                    this.m_FDevice.setI2CValue("Sequencer", "SeqBreakCfg", this.initDebugCfgByteArray(65535, 0, 3));
                } else if (EvtSource == this.m_SequPanDebugSlowedButton) {
                    int nGroups = 0;
                    if (this.m_SequPanDebugEnForcedBPCB.isSelected()) {
                        nGroups = 1;
                    }
                    int i = 0;
                    while (i < 7) {
                        if (this.m_SequPanDebugEnGroupBPCBs[i].isSelected()) {
                            nGroups |= 2 << i;
                        }
                        ++i;
                    }
                    int nBreakCfg = 3;
                    if (this.m_SequPanDebugEnJumpsBPCB.isSelected()) {
                        nBreakCfg |= 4;
                    }
                    if (this.m_SequPanDebugEnEventsBPCB.isSelected()) {
                        nBreakCfg |= 8;
                    }
                    this.m_FDevice.setI2CValue("Sequencer", "SeqBreakCfg", this.initDebugCfgByteArray(1000, nGroups, nBreakCfg));
                } else if (EvtSource == this.m_SequPanDebugEnForcedBPCB || EvtSource == this.m_SequPanDebugEnJumpsBPCB || EvtSource == this.m_SequPanDebugEnEventsBPCB || EvtSource == this.m_SequPanDebugEnGroupBPCBs[0] || EvtSource == this.m_SequPanDebugEnGroupBPCBs[1] || EvtSource == this.m_SequPanDebugEnGroupBPCBs[2] || EvtSource == this.m_SequPanDebugEnGroupBPCBs[3] || EvtSource == this.m_SequPanDebugEnGroupBPCBs[4] || EvtSource == this.m_SequPanDebugEnGroupBPCBs[5] || EvtSource == this.m_SequPanDebugEnGroupBPCBs[6]) {
                    Byte[] LastBPCfg = (Byte[])this.m_FDevice.getI2CLastValue("Sequencer", "SeqBreakCfg");
                    int nGroups = 0;
                    if (this.m_SequPanDebugEnForcedBPCB.isSelected()) {
                        nGroups = 1;
                    }
                    int i = 0;
                    while (i < 7) {
                        if (this.m_SequPanDebugEnGroupBPCBs[i].isSelected()) {
                            nGroups |= 2 << i;
                        }
                        ++i;
                    }
                    LastBPCfg[1] = (byte)nGroups;
                    int nBreakCfg = 0;
                    if (this.m_SequPanDebugEnJumpsBPCB.isSelected()) {
                        nBreakCfg |= 4;
                    }
                    if (this.m_SequPanDebugEnEventsBPCB.isSelected()) {
                        nBreakCfg |= 8;
                    }
                    LastBPCfg[0] = (byte)(LastBPCfg[0] & 0xF2 | nBreakCfg);
                    this.m_FDevice.setI2CValue("Sequencer", "SeqBreakCfg", LastBPCfg);
                } else if (EvtSource == this.m_LivePanChangeThButton) {
                    Byte[] aThreshold = new Byte[]{new Byte((byte)((SpinnerNumberModel)this.m_LivePanThreshB1MinTA.getModel()).getNumber().intValue()), new Byte((byte)((SpinnerNumberModel)this.m_LivePanThreshB1MaxTA.getModel()).getNumber().intValue()), new Byte((byte)((SpinnerNumberModel)this.m_LivePanThreshB2MinTA.getModel()).getNumber().intValue()), new Byte((byte)((SpinnerNumberModel)this.m_LivePanThreshB2MaxTA.getModel()).getNumber().intValue()), new Byte((byte)((SpinnerNumberModel)this.m_LivePanThreshB3MinTA.getModel()).getNumber().intValue()), new Byte((byte)((SpinnerNumberModel)this.m_LivePanThreshB3MaxTA.getModel()).getNumber().intValue()), new Byte((byte)((SpinnerNumberModel)this.m_LivePanThreshB4MinTA.getModel()).getNumber().intValue()), new Byte((byte)((SpinnerNumberModel)this.m_LivePanThreshB4MaxTA.getModel()).getNumber().intValue()), new Byte((byte)((SpinnerNumberModel)this.m_LivePanThreshB5MinTA.getModel()).getNumber().intValue()), new Byte((byte)((SpinnerNumberModel)this.m_LivePanThreshB5MaxTA.getModel()).getNumber().intValue()), new Byte((byte)((SpinnerNumberModel)this.m_LivePanThreshB6MinTA.getModel()).getNumber().intValue()), new Byte((byte)((SpinnerNumberModel)this.m_LivePanThreshB6MaxTA.getModel()).getNumber().intValue()), new Byte((byte)((SpinnerNumberModel)this.m_LivePanThreshB7MinTA.getModel()).getNumber().intValue()), new Byte((byte)((SpinnerNumberModel)this.m_LivePanThreshB7MaxTA.getModel()).getNumber().intValue()), new Byte((byte)((SpinnerNumberModel)this.m_LivePanThreshB8MinTA.getModel()).getNumber().intValue()), new Byte((byte)((SpinnerNumberModel)this.m_LivePanThreshB8MaxTA.getModel()).getNumber().intValue())};
                    this.m_FDevice.setI2CValue("Sequencer", "ButtonThreshold", aThreshold);
                    this.m_FDevice.callI2C("Sequencer", "SaveUser");
                } else if (EvtSource == this.m_LivePanAutoCfgButton1) {
                    this.m_FDevice.setI2CValue("Sequencer", "ButtonAutoCgSens", new Long(1L));
                    this.m_FDevice.callI2C("Sequencer", "ButtonAutoCfg");
                    this.m_FDevice.getI2CValue("Sequencer", "ButtonThreshold");
                    this.m_FDevice.callI2C("Sequencer", "SaveUser");
                } else if (EvtSource == this.m_LivePanAutoCfgButton2) {
                    this.m_FDevice.setI2CValue("Sequencer", "ButtonAutoCgSens", new Long(2L));
                    this.m_FDevice.callI2C("Sequencer", "ButtonAutoCfg");
                    this.m_FDevice.getI2CValue("Sequencer", "ButtonThreshold");
                    this.m_FDevice.callI2C("Sequencer", "SaveUser");
                } else if (EvtSource == this.m_LivePanAutoCfgButton3) {
                    this.m_FDevice.setI2CValue("Sequencer", "ButtonAutoCgSens", new Long(3L));
                    this.m_FDevice.callI2C("Sequencer", "ButtonAutoCfg");
                    this.m_FDevice.getI2CValue("Sequencer", "ButtonThreshold");
                    this.m_FDevice.callI2C("Sequencer", "SaveUser");
                } else if (EvtSource == this.m_ParaPanChgCommButton) {
                    Byte[] aIPAddress = new Byte[4];
                    aIPAddress[3] = new Byte((byte)((SpinnerNumberModel)this.m_ParaPanIP1Text.getModel()).getNumber().intValue());
                    aIPAddress[2] = new Byte((byte)((SpinnerNumberModel)this.m_ParaPanIP2Text.getModel()).getNumber().intValue());
                    aIPAddress[1] = new Byte((byte)((SpinnerNumberModel)this.m_ParaPanIP3Text.getModel()).getNumber().intValue());
                    aIPAddress[0] = new Byte((byte)((SpinnerNumberModel)this.m_ParaPanIP4Text.getModel()).getNumber().intValue());
                    this.m_FDevice.setValue("IPAddress", aIPAddress);
                    Byte[] aSubnetMask = new Byte[4];
                    aSubnetMask[3] = new Byte((byte)((SpinnerNumberModel)this.m_ParaPanSNM1Text.getModel()).getNumber().intValue());
                    aSubnetMask[2] = new Byte((byte)((SpinnerNumberModel)this.m_ParaPanSNM2Text.getModel()).getNumber().intValue());
                    aSubnetMask[1] = new Byte((byte)((SpinnerNumberModel)this.m_ParaPanSNM3Text.getModel()).getNumber().intValue());
                    aSubnetMask[0] = new Byte((byte)((SpinnerNumberModel)this.m_ParaPanSNM4Text.getModel()).getNumber().intValue());
                    this.m_FDevice.setValue("SubnetMask", aSubnetMask);
                    this.m_FDevice.setValue("Name", this.m_ParaPanNameText.getText());
                } else if (EvtSource == this.m_ParaPanChgIButton) {
                    this.m_FDevice.setI2CValue("Sequencer", "MaxCurrentLed1", new Double(((SpinnerNumberModel)this.m_ParaPanLed1IText.getModel()).getNumber().doubleValue() / 10.0));
                    this.m_FDevice.setI2CValue("Sequencer", "MaxCurrentLed2", new Double(((SpinnerNumberModel)this.m_ParaPanLed2IText.getModel()).getNumber().doubleValue() / 10.0));
                    this.m_FDevice.setI2CValue("Sequencer", "MaxCurrentLed3", new Double(((SpinnerNumberModel)this.m_ParaPanLed3IText.getModel()).getNumber().doubleValue() / 10.0));
                    this.m_FDevice.setI2CValue("Sequencer", "MaxCurrentLed4", new Double(((SpinnerNumberModel)this.m_ParaPanLed4IText.getModel()).getNumber().doubleValue() / 10.0));
                    this.m_FDevice.setI2CValue("Sequencer", "MaxCurrentLed5", new Double(((SpinnerNumberModel)this.m_ParaPanLed5IText.getModel()).getNumber().doubleValue() / 10.0));
                } else if (EvtSource == this.m_ParaPanUpdateTimeButton) {
                    GregorianCalendar GCalendar = new GregorianCalendar(TimeZone.getTimeZone(this.m_ParaPanTimeZoneChoice.getSelectedItem().substring(0, this.m_ParaPanTimeZoneChoice.getSelectedItem().indexOf(" "))), Locale.ENGLISH);
                    int year = GCalendar.get(1) - 2000;
                    int month = GCalendar.get(2) + 1;
                    int day = GCalendar.get(5);
                    int hour = GCalendar.get(11);
                    int minute = GCalendar.get(12);
                    int nSeconds = GCalendar.get(13);
                    int dayOfWeek = 0;
                    dayOfWeek = GCalendar.get(7) > 1 ? 1 << GCalendar.get(7) - 2 : 64;
                    Byte[] aTime = new Byte[8];
                    aTime[7] = -128;
                    aTime[6] = FCOCUtils.int2Bcd(year);
                    aTime[5] = FCOCUtils.int2Bcd(month);
                    aTime[4] = FCOCUtils.int2Bcd(day);
                    aTime[3] = (byte)dayOfWeek;
                    aTime[2] = FCOCUtils.int2Bcd(hour);
                    aTime[1] = FCOCUtils.int2Bcd(minute);
                    aTime[0] = FCOCUtils.int2Bcd(nSeconds);
                    this.m_FDevice.setI2CValue("Sequencer", "TimeW", aTime);
                } else if (EvtSource == this.m_ParaPanReadButton) {
                    this.m_FDevice.getValue("IPAddress");
                    this.m_FDevice.getValue("SubnetMask");
                    this.m_FDevice.getValue("Name");
                    this.m_FDevice.getI2CValue("Sequencer", "MaxCurrentLed1");
                    this.m_FDevice.getI2CValue("Sequencer", "MaxCurrentLed2");
                    this.m_FDevice.getI2CValue("Sequencer", "MaxCurrentLed3");
                    this.m_FDevice.getI2CValue("Sequencer", "MaxCurrentLed4");
                    this.m_FDevice.getI2CValue("Sequencer", "MaxCurrentLed5");
                } else if (EvtSource == this.m_ParaPanSaveUserButton) {
                    this.m_FDevice.call("SaveUser");
                    this.m_FDevice.callI2C("Sequencer", "SaveUser");
                } else if (EvtSource == this.m_ParaPanRestoreUserButton) {
                    this.m_FDevice.call("RestoreUser");
                    this.m_FDevice.callI2C("Sequencer", "RestoreUser");
                } else if (EvtSource == this.m_ParaPanRestoreFactButton) {
                    this.m_FDevice.call("RestoreFactory");
                    this.m_FDevice.callI2C("Sequencer", "RestoreFactory");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private Byte[] initDebugCfgByteArray(int nTimeout, int i, int j) {
        Byte[] Cfg = new Byte[]{new Byte((byte)j), new Byte((byte)i), new Byte((byte)(nTimeout & 0xFF)), new Byte((byte)(nTimeout >> 8 & 0xFF))};
        return Cfg;
    }

    private void setSeqVar(int nID) {
        String szSeqVarValue = this.m_SequPanVarInputText[nID].getText();
        try {
            Long SeqVarValue = this.m_SequPanVarChoices[nID].getSelectedItem().equals("Dec") ? new Long(szSeqVarValue) : new Long(Long.parseLong(szSeqVarValue, 16));
            this.m_FDevice.setI2CValue("Sequencer", "SeqVariable" + Integer.toHexString(nID).toUpperCase(), SeqVarValue);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void keyPressed(KeyEvent KbEvent) {
        Object EvtSource = KbEvent.getSource();
        int nKeyCode = KbEvent.getKeyCode();
        if (nKeyCode == 10) {
            if (EvtSource == this.m_SequPanSeqList && this.m_SequPanModifyActionButton.isEnabled()) {
                if (this.m_SequPanActionCombo.isEnabled()) {
                    this.m_SequPanActionCombo.requestFocusInWindow();
                }
                try {
                    Component[] componentArray = ((Container)this.m_SequPanActionParaPanel.getComponent(0)).getComponents();
                    int n = componentArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Component Comp = componentArray[n2];
                        if (Comp.isFocusable()) {
                            Comp.requestFocusInWindow();
                        }
                        ++n2;
                    }
                }
                catch (Exception Comp) {}
            } else if (EvtSource == this.m_SequPanActionCombo) {
                Component[] componentArray = ((Container)this.m_SequPanActionParaPanel.getComponent(0)).getComponents();
                int n = componentArray.length;
                int n3 = 0;
                while (n3 < n) {
                    Component Comp = componentArray[n3];
                    if (Comp.isFocusable()) {
                        Comp.requestFocusInWindow();
                    }
                    ++n3;
                }
            } else if (this.m_SequPanModifyActionButton.isEnabled()) {
                this.m_SequPanModifyActionButton.doClick();
            }
        } else if (EvtSource == this.m_SequPanSeqList) {
            switch (nKeyCode) {
                case 127: {
                    if (!this.m_SequPanDeleteActionButton.isEnabled()) break;
                    this.m_SequPanDeleteActionButton.doClick();
                    break;
                }
                case 155: {
                    if (!this.m_SequPanInsertActionButton.isEnabled()) break;
                    this.m_SequPanInsertActionButton.doClick();
                    break;
                }
                case 107: 
                case 521: {
                    if (!this.m_SequPanMoveDownActionButton.isEnabled()) break;
                    this.m_SequPanMoveDownActionButton.doClick();
                    break;
                }
                case 45: 
                case 109: {
                    if (!this.m_SequPanMoveUpActionButton.isEnabled()) break;
                    this.m_SequPanMoveUpActionButton.doClick();
                    break;
                }
                case 67: 
                case 88: {
                    if (!KbEvent.isControlDown() || !this.isCopyPasteAllowed) break;
                    this.unsetAllCutInProgress();
                    this.m_CopyPasteVector.clear();
                    for (FCOCSequActionPan Act : this.m_SequPanSeqList.getSelectedValuesList()) {
                        try {
                            this.m_CopyPasteVector.add(Act);
                            if (nKeyCode != 88) continue;
                            Act.setCutInProgress(true);
                        }
                        catch (Exception e) {
                            System.err.println("Copy/Cut error on line " + this.m_SequPanSeqList.getSelectedIndex() + "\n\r");
                            e.printStackTrace();
                        }
                    }
                    break;
                }
                case 86: {
                    int nInsertIndex;
                    if (!KbEvent.isControlDown()) break;
                    int nInitialInsertIndex = nInsertIndex = this.m_SequPanSeqList.getSelectedIndex();
                    for (FCOCSequActionPan Act : this.m_CopyPasteVector) {
                        if (Act.isCutInProgress()) {
                            if (nInsertIndex > this.m_SequPanSeqListModel.indexOf(Act)) {
                                --nInsertIndex;
                                --nInitialInsertIndex;
                            }
                            this.m_SequPanSeqListModel.removeElement(Act);
                            this.m_SequPanSeqListModel.add(nInsertIndex, Act);
                            nInsertIndex = this.m_SequPanSeqListModel.indexOf(Act) + 1;
                            continue;
                        }
                        FCOCSequActionPan ActClone = Act.clone(true);
                        this.m_SequPanSeqListModel.add(nInsertIndex++, ActClone);
                        if (!ActClone.hasJumps()) continue;
                        ActClone.forceAddPointer();
                    }
                    this.m_SequPanSeqList.setSelectionInterval(nInitialInsertIndex, nInsertIndex - 1);
                }
                case 27: {
                    this.unsetAllCutInProgress();
                    break;
                }
                case 38: {
                    int nAnchorSelectedIndex = this.m_SequPanSeqList.getAnchorSelectionIndex();
                    int nLeadSelectedIndex = this.m_SequPanSeqList.getLeadSelectionIndex();
                    this.m_SequPanSeqList.removeListSelectionListener(this);
                    if (KbEvent.isShiftDown()) {
                        if (nLeadSelectedIndex > nAnchorSelectedIndex) {
                            int nPreviousLead = nLeadSelectedIndex;
                            while (this.m_SequPanSeqListModel.getElementAt(nLeadSelectedIndex).getClass() == FCOCSequActionExtension.class) {
                                --nLeadSelectedIndex;
                            }
                            if (nLeadSelectedIndex == nAnchorSelectedIndex) {
                                this.m_SequPanSeqList.setSelectionInterval(nPreviousLead, nAnchorSelectedIndex);
                            } else {
                                this.m_SequPanSeqList.getSelectionModel().setLeadSelectionIndex(nLeadSelectedIndex);
                            }
                        }
                    } else if (nAnchorSelectedIndex != nLeadSelectedIndex) {
                        this.m_SequPanSeqList.getSelectionModel().setLeadSelectionIndex(nAnchorSelectedIndex);
                    }
                    this.m_SequPanSeqList.addListSelectionListener(this);
                    break;
                }
                case 40: {
                    int nAnchorSelectedIndex = this.m_SequPanSeqList.getAnchorSelectionIndex();
                    int nLeadSelectedIndex = this.m_SequPanSeqList.getLeadSelectionIndex();
                    this.m_SequPanSeqList.removeListSelectionListener(this);
                    if (KbEvent.isShiftDown() && nLeadSelectedIndex < nAnchorSelectedIndex) {
                        while (this.m_SequPanSeqListModel.getElementAt(nLeadSelectedIndex + 1).getClass() == FCOCSequActionExtension.class) {
                            ++nLeadSelectedIndex;
                        }
                        this.m_SequPanSeqList.getSelectionModel().setLeadSelectionIndex(nLeadSelectedIndex);
                    }
                    this.m_SequPanSeqList.addListSelectionListener(this);
                }
            }
            this.m_SequPanSeqList.repaint();
        }
    }

    private void unsetAllCutInProgress() {
        Enumeration<FCOCSequActionPan> e = this.m_SequPanSeqListModel.elements();
        while (e.hasMoreElements()) {
            try {
                e.nextElement().setCutInProgress(false);
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
    }

    @Override
    public void keyTyped(KeyEvent KbEvent) {
    }

    @Override
    public void keyReleased(KeyEvent KbEvent) {
    }

    @Override
    public void itemStateChanged(ItemEvent ItmEvt) {
        Object EvtSource = ItmEvt.getSource();
        if (EvtSource == this.m_SequPanActionCombo && ItmEvt.getStateChange() == 1) {
            try {
                String szActionString = (String)this.m_SequPanActionCombo.getSelectedItem();
                Class<FCOCSequActionPan> ActClass = this.m_AvailableActions.get(FCOESequAction.getClassName(szActionString));
                Byte[] aActionBytes = new Byte[]{(byte)0, (byte)0, (byte)0, (byte)0, (byte)0, (byte)0, (byte)0, (byte)0};
                this.m_SequPanActionParaPanel.removeAll();
                try {
                    FCOCSequActionPan NewAction = ActClass == FCOCSequActionUnknown.class ? new FCOCSequActionUnknown(this.m_SequPanSeqList.getSelectedValue().bytesGetter()) : (ActClass == FCOCSequActionComment.class && this.m_SequPanSeqList.getSelectedValue().getClass() == FCOCSequActionLabel.class ? new FCOCSequActionComment(this.m_SequPanSeqList.getSelectedValue().bytesGetter()) : (ActClass == FCOCSequActionLabel.class && this.m_SequPanSeqList.getSelectedValue().getClass() == FCOCSequActionComment.class ? new FCOCSequActionLabel(this.m_SequPanSeqList.getSelectedValue().bytesGetter()) : ActClass.getDeclaredConstructor(Byte[].class).newInstance(new Object[]{aActionBytes})));
                    if (NewAction.hasJumps() && FCOCSequActionPan.getLabelsList().isEmpty()) {
                        JLabel WarnLabel = new JLabel("Please add at least one Label before.");
                        WarnLabel.setForeground(Color.RED);
                        this.m_SequPanActionParaPanel.add(WarnLabel, 0, 0, 1, 1, 10, 10, 2, 11);
                        this.m_SequPanModifyActionButton.setEnabled(false);
                        WarnLabel.updateUI();
                    } else {
                        this.m_SequPanActionParaPanel.add(NewAction, 0, 0, 1, 1, 10, 10, 2, 11);
                        this.m_SequPanModifyActionButton.setEnabled(true);
                        NewAction.updateJumps();
                        NewAction.updateUI();
                        Component[] componentArray = NewAction.getComponents();
                        int n = componentArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Component Comp = componentArray[n2];
                            if (Comp.isFocusable()) {
                                Comp.addKeyListener(this);
                            }
                            ++n2;
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                this.m_SequPanActionParaPanel.repaint();
            }
            catch (ClassCastException szActionString) {}
        } else if (EvtSource == this.m_SequPanActActionADEnableCB) {
            boolean isDisplayActualActionIDDisabled;
            boolean bl = isDisplayActualActionIDDisabled = !this.m_SequPanActActionADEnableCB.isSelected();
            if (isDisplayActualActionIDDisabled) {
                this.valueChanged(new ListSelectionEvent(this.m_SequPanSeqList, 0, 0, false));
            } else {
                this.m_SequPanActionParaPanel.removeAll();
            }
            this.checkItemsToEnable();
        } else if (EvtSource == this.m_SequPanActSuspendCB) {
            BitSet OptionsBits = (BitSet)this.m_FDevice.getI2CLastValue("Sequencer", "Options");
            if (this.m_SequPanActSuspendCB.isSelected()) {
                OptionsBits.clear(0);
            } else {
                OptionsBits.set(0);
            }
            this.m_FDevice.setI2CValue("Sequencer", "Options", OptionsBits);
        } else if (ItmEvt.getStateChange() == 1) {
            int i = 0;
            while (i < 16) {
                if (EvtSource == this.m_SequPanVarChoices[i]) {
                    this.setSeqVarType(i);
                    break;
                }
                ++i;
            }
        }
    }

    private void setSeqVarType(int nID) {
        String szActualValue = this.m_SequPanVarInputText[nID].getText();
        try {
            if (this.m_SequPanVarChoices[nID].getSelectedItem().equals("Dec")) {
                this.m_SequPanVarInputText[nID].setDocument(new IntegerPlainDocument());
                long lValue = Long.parseLong(szActualValue, 16);
                szActualValue = lValue < Integer.MIN_VALUE ? "" + lValue : "" + (lValue - 0x100000000L);
            } else {
                this.m_SequPanVarInputText[nID].setDocument(new FCOCHexPlainDocument(8));
                szActualValue = FCOCUtils.toHexString(Integer.parseInt(szActualValue, 10), 8);
            }
            this.m_SequPanVarInputText[nID].setText(szActualValue);
        }
        catch (NumberFormatException NbExc) {
            this.m_SequPanVarInputText[nID].setText("");
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void valueChanged(ListSelectionEvent ListSelEvt) {
        block15: {
            block16: {
                if (ListSelEvt.getSource() != this.m_SequPanSeqList || ListSelEvt.getValueIsAdjusting() || this.m_SequPanActActionADEnableCB.isSelected()) break block15;
                nAnchorSelectedIndex = this.m_SequPanSeqList.getAnchorSelectionIndex();
                nLeadSelectedIndex = this.m_SequPanSeqList.getLeadSelectionIndex();
                if (this.m_SequPanSeqList.getSelectedIndices().length == 0) {
                    this.m_SequPanActionParaPanel.removeAll();
                    this.m_SequPanActionParaPanel.repaint();
                    return;
                }
                SelectedActions = this.m_SequPanSeqList.getSelectedValuesList();
                this.m_SequPanActionParaPanel.removeAll();
                this.m_SequPanActionIDDispLabel.setText("----");
                this.m_SequPanActionCombo.setEnabled(true);
                this.m_SequPanModifyActionButton.setEnabled(true);
                this.m_SequPanDeleteActionButton.setEnabled(true);
                this.m_SequPanInsertActionButton.setEnabled(true);
                this.m_SequPanMoveDownActionButton.setEnabled(true);
                this.m_SequPanMoveUpActionButton.setEnabled(true);
                this.isCopyPasteAllowed = true;
                this.m_SequPanSeqList.removeListSelectionListener(this);
                if (nAnchorSelectedIndex > nLeadSelectedIndex) ** GOTO lbl28
                while (this.m_SequPanSeqListModel.getElementAt(nAnchorSelectedIndex).getClass() == FCOCSequActionExtension.class) {
                    --nAnchorSelectedIndex;
                }
                while (nLeadSelectedIndex < this.m_SequPanSeqListModel.size() - 1 && this.m_SequPanSeqListModel.getElementAt(nLeadSelectedIndex + 1).getClass() == FCOCSequActionExtension.class) {
                    ++nLeadSelectedIndex;
                }
                break block16;
lbl-1000:
                // 1 sources

                {
                    ++nAnchorSelectedIndex;
lbl28:
                    // 2 sources

                    ** while (this.m_SequPanSeqListModel.getElementAt((int)(nAnchorSelectedIndex + 1)).getClass() == FCOCSequActionExtension.class)
                }
lbl29:
                // 2 sources

                while (this.m_SequPanSeqListModel.getElementAt(nLeadSelectedIndex).getClass() == FCOCSequActionExtension.class) {
                    --nLeadSelectedIndex;
                }
            }
            this.m_SequPanSeqList.setSelectionInterval(nAnchorSelectedIndex, nLeadSelectedIndex);
            this.m_SequPanSeqList.addListSelectionListener(this);
            SelectedActions = this.m_SequPanSeqList.getSelectedValuesList();
            if (this.m_SequPanSeqList.isSelectedIndex(0)) {
                this.m_SequPanMoveUpActionButton.setEnabled(false);
            }
            if (this.m_SequPanSeqList.isSelectedIndex(this.m_SequPanSeqListModel.getSize() - 1) || this.m_SequPanSeqList.isSelectedIndex(this.m_SequPanSeqListModel.getSize() - 2)) {
                this.m_SequPanMoveDownActionButton.setEnabled(false);
            }
            for (FCOCSequActionPan Act : SelectedActions) {
                if (Act.getClass() == FCOCSequActionEOF.class) {
                    this.m_SequPanDeleteActionButton.setEnabled(false);
                    this.m_SequPanMoveDownActionButton.setEnabled(false);
                    this.m_SequPanMoveUpActionButton.setEnabled(false);
                    this.m_SequPanActionCombo.setEnabled(false);
                    this.m_SequPanModifyActionButton.setEnabled(false);
                    this.isCopyPasteAllowed = false;
                    continue;
                }
                if (Act.isDeleteAllowed(false)) continue;
                this.m_SequPanActionCombo.setEnabled(false);
                this.m_SequPanDeleteActionButton.setEnabled(false);
            }
            if (this.m_SequPanSeqList.getSelectedIndices().length > FCOESequAction.getActionLength(SelectedActions.get(0).getClassName())) {
                this.m_SequPanActionCombo.setEnabled(false);
                this.m_SequPanModifyActionButton.setEnabled(false);
            } else {
                this.m_SequPanActionIDDispLabel.setText("" + this.m_SequPanSeqList.getMinSelectionIndex());
                ActionClone = SelectedActions.get(0).clone();
                this.m_SequPanActionParaPanel.add(ActionClone, 0, 0, 1, 1, 10, 10, 2, 11);
                this.m_SequPanActionParaPanel.validate();
                this.m_SequPanActionCombo.removeItemListener(this);
                this.m_SequPanActionCombo.setSelectedItem(FCOESequAction.getActionString(SelectedActions.get(0).getClassName()));
                this.m_SequPanActionCombo.addItemListener(this);
            }
            try {
                this.m_SequPanActionParaPanel.repaint();
                var8_9 = ((Container)this.m_SequPanActionParaPanel.getComponent(0)).getComponents();
                var7_10 = var8_9.length;
                var6_6 = 0;
                while (var6_6 < var7_10) {
                    Comp = var8_9[var6_6];
                    if (Comp.isFocusable()) {
                        Comp.addKeyListener(this);
                    }
                    ++var6_6;
                }
            }
            catch (Exception var5_8) {
                // empty catch block
            }
        }
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent AdjEvt) {
        Object EventSource = AdjEvt.getSource();
        try {
            if (EventSource == this.m_LivePanLed1ValScrollB) {
                this.m_LivePanLed1Label.setText("Led1 luminosity value [" + (int)Math.round((double)this.m_LivePanLed1ValScrollB.getValue() / 655.35) + "%] :");
                Long Led1Goal = new Long(0xFFFFFFFFL | (long)this.m_LivePanLed1ValScrollB.getValue() << 32);
                this.m_FDevice.setI2CValue("Sequencer", "Led1Goal", Led1Goal, false);
            } else if (EventSource == this.m_LivePanLed2ValScrollB) {
                this.m_LivePanLed2Label.setText("Led2 luminosity value [" + (int)Math.round((double)this.m_LivePanLed2ValScrollB.getValue() / 655.35) + "%] :");
                Long Led1Goal = new Long(0xFFFFFFFFL | (long)this.m_LivePanLed2ValScrollB.getValue() << 32);
                this.m_FDevice.setI2CValue("Sequencer", "Led2Goal", Led1Goal, false);
            } else if (EventSource == this.m_LivePanLed3ValScrollB) {
                this.m_LivePanLed3Label.setText("Led3 luminosity value [" + (int)Math.round((double)this.m_LivePanLed3ValScrollB.getValue() / 655.35) + "%] :");
                Long Led1Goal = new Long(0xFFFFFFFFL | (long)this.m_LivePanLed3ValScrollB.getValue() << 32);
                this.m_FDevice.setI2CValue("Sequencer", "Led3Goal", Led1Goal, false);
            } else if (EventSource == this.m_LivePanLed4ValScrollB) {
                this.m_LivePanLed4Label.setText("Led4 luminosity value [" + (int)Math.round((double)this.m_LivePanLed4ValScrollB.getValue() / 655.35) + "%] :");
                Long Led1Goal = new Long(0xFFFFFFFFL | (long)this.m_LivePanLed4ValScrollB.getValue() << 32);
                this.m_FDevice.setI2CValue("Sequencer", "Led4Goal", Led1Goal, false);
            } else if (EventSource == this.m_LivePanLed5ValScrollB) {
                this.m_LivePanLed5Label.setText("Led5 luminosity value [" + (int)Math.round((double)this.m_LivePanLed5ValScrollB.getValue() / 655.35) + "%] :");
                Long Led1Goal = new Long(0xFFFFFFFFL | (long)this.m_LivePanLed5ValScrollB.getValue() << 32);
                this.m_FDevice.setI2CValue("Sequencer", "Led5Goal", Led1Goal, false);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void stateChanged(ChangeEvent ChgEvt) {
        Object EvtSource = ChgEvt.getSource();
        if (EvtSource == this.getModel() && this.m_FDevice != null) {
            Component SelComp = this.getSelectedComponent();
            int nRefreshTime = 50;
            try {
                BitSet OptionsBits = (BitSet)this.m_FDevice.getI2CLastValue("Sequencer", "Options");
                if (SelComp == this.m_LivePan) {
                    OptionsBits.clear(0);
                    nRefreshTime = 5;
                    this.m_FDevice.getI2CValue("Sequencer", "Led1Goal");
                    this.m_FDevice.getI2CValue("Sequencer", "Led2Goal");
                    this.m_FDevice.getI2CValue("Sequencer", "Led3Goal");
                    this.m_FDevice.getI2CValue("Sequencer", "Led4Goal");
                    this.m_FDevice.getI2CValue("Sequencer", "Led5Goal");
                    this.m_FDevice.getI2CValue("Sequencer", "ButtonThreshold");
                } else if (SelComp == this.m_WrapParaPan) {
                    OptionsBits.set(0);
                    this.m_FDevice.getValue("Version");
                    this.m_FDevice.getValue("IPAddress");
                    this.m_FDevice.getValue("MACAddress");
                    this.m_FDevice.getValue("SubnetMask");
                    this.m_FDevice.getValue("Name");
                    this.m_FDevice.getI2CValue("Sequencer", "MaxCurrentLed1");
                    this.m_FDevice.getI2CValue("Sequencer", "MaxCurrentLed2");
                    this.m_FDevice.getI2CValue("Sequencer", "MaxCurrentLed3");
                    this.m_FDevice.getI2CValue("Sequencer", "MaxCurrentLed4");
                    this.m_FDevice.getI2CValue("Sequencer", "MaxCurrentLed5");
                    this.m_FDevice.getI2CValue("Sequencer", "NbPowerUp");
                } else if (SelComp == this.m_SequPan) {
                    OptionsBits.set(0);
                }
                this.m_FDevice.setI2CValue("Sequencer", "Options", OptionsBits);
                this.m_FDevice.setThreadSleepTime(nRefreshTime);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    class CActionsCellRenderer
    extends JLabel
    implements ListCellRenderer<Object> {
        private final Color HIGHLIGHT_COLOR = new Color(206, 223, 247);
        private final Color KNOWN_COLOR = new Color(51, 51, 51);
        private final Color JUMP_COLOR = new Color(61, 140, 195);
        private final Color UNKNOWN_COLOR = new Color(214, 128, 128);
        private final Color COMMENT_COLOR = new Color(63, 127, 95);
        private final Color BREAK_BACKCOLOR = Color.RED;
        private final Color BREAK_SELBACKCOLOR = new Color(255, 138, 138);
        private final Color BREAK_FORECOLOR = Color.WHITE;

        public CActionsCellRenderer() {
            this.setOpaque(true);
            this.setFont(new Font("Courier", 0, 12));
        }

        @Override
        public Component getListCellRendererComponent(JList<?> SequList, Object Value, int nIndex, boolean isSelected, boolean isCellHasFocus) {
            FCOCSequActionPan Entry2 = (FCOCSequActionPan)Value;
            String szText = Entry2.toString();
            this.setFont(new Font("Courier", 0, 12));
            Color ForeColor = this.KNOWN_COLOR;
            Color SelectedBackColor = this.HIGHLIGHT_COLOR;
            Color BackColor = Color.WHITE;
            if (Entry2.getClass() == FCOCSequActionLabel.class) {
                szText = ((FCOCSequActionLabel)Entry2).getLabelName();
                this.setFont(new Font("Courier", 1, 12));
            } else if (Entry2.hasJumps()) {
                if (FCOCSequencerGUI.this.m_SequPanDebugEnJumpsBPCB.isSelected() && (Entry2.getClass() == FCOCSequActionJumpRel.class || Entry2.getClass() == FCOCSequActionCallRel.class || Entry2.getClass() == FCOCSequActionReturn.class)) {
                    ForeColor = this.BREAK_FORECOLOR;
                    BackColor = this.BREAK_BACKCOLOR;
                    SelectedBackColor = this.BREAK_SELBACKCOLOR;
                } else {
                    ForeColor = this.JUMP_COLOR;
                }
            } else if (Entry2.getClass() == FCOCSequActionExtension.class) {
                this.setFont(new Font("Courier", 2, 12));
            } else if (Entry2.getClass() == FCOCSequActionComment.class) {
                this.setFont(new Font("Courier", 2, 12));
                ForeColor = this.COMMENT_COLOR;
            } else if (Entry2.getClass() == FCOCSequActionUnknown.class) {
                ForeColor = this.UNKNOWN_COLOR;
            } else if (Entry2.getClass() == FCOCSequActionBreakpoint.class) {
                FCOCSequActionBreakpoint BPEntry = (FCOCSequActionBreakpoint)Entry2;
                byte cBPEnabledGroups = 0;
                if (FCOCSequencerGUI.this.m_SequPanDebugEnForcedBPCB.isSelected()) {
                    cBPEnabledGroups = 1;
                }
                int i = 0;
                while (i < 7) {
                    if (FCOCSequencerGUI.this.m_SequPanDebugEnGroupBPCBs[i].isSelected()) {
                        cBPEnabledGroups = (byte)(cBPEnabledGroups | 2 << i);
                    }
                    ++i;
                }
                if ((cBPEnabledGroups & BPEntry.getGroups()) != 0) {
                    ForeColor = this.BREAK_FORECOLOR;
                    BackColor = this.BREAK_BACKCOLOR;
                    SelectedBackColor = this.BREAK_SELBACKCOLOR;
                }
            }
            this.setText(szText);
            if (Entry2.isCutInProgress()) {
                Map<TextAttribute, ?> FontAttributes = this.getFont().getAttributes();
                this.setForeground(Color.GRAY);
                FontAttributes.put(TextAttribute.STRIKETHROUGH, TextAttribute.STRIKETHROUGH_ON);
                this.setFont(new Font(FontAttributes));
            }
            this.setForeground(ForeColor);
            if (isSelected) {
                this.setBackground(SelectedBackColor);
            } else {
                this.setBackground(BackColor);
            }
            this.setEnabled(true);
            return this;
        }
    }

    class DeviceNamePlainDocument
    extends PlainDocument {
        DeviceNamePlainDocument() {
        }

        @Override
        public void insertString(int nOffset, String szString, AttributeSet Attrib) throws BadLocationException {
            String szCurrent = this.getText(0, this.getLength());
            String szBeforeOffset = szCurrent.substring(0, nOffset);
            String szAfterOffset = szCurrent.substring(nOffset, szCurrent.length());
            String proposedResult = String.valueOf(szBeforeOffset) + szString + szAfterOffset;
            if (Pattern.compile(".{0,16}").matcher(proposedResult).matches()) {
                super.insertString(nOffset, szString, Attrib);
            }
        }
    }

    class IntegerPlainDocument
    extends PlainDocument {
        IntegerPlainDocument() {
        }

        @Override
        public void insertString(int nOffset, String szString, AttributeSet Attrib) throws BadLocationException {
            String szCurrent = this.getText(0, this.getLength());
            String szBeforeOffset = szCurrent.substring(0, nOffset);
            String szAfterOffset = szCurrent.substring(nOffset, szCurrent.length());
            String proposedResult = String.valueOf(szBeforeOffset) + szString + szAfterOffset;
            if (Pattern.compile("-?[0-9]{0,10}").matcher(proposedResult).matches()) {
                super.insertString(nOffset, szString, Attrib);
            }
        }
    }
}

