/*
 * Decompiled with CFR 0.152.
 */
package com.fiveco.ledsequ;

import com.fiveco.ledsequ.FCOCSequActionLabel;
import com.fiveco.ledsequ.FCOCSequActionPan;
import com.fiveco.utils.FCOCUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JRadioButton;

class FCOCSequActionTFMDetFnger
extends FCOCSequActionPan
implements ItemListener {
    private final JRadioButton m_DetectOff = new JRadioButton("Off");
    private final JRadioButton m_DetectOn = new JRadioButton("On");
    private final ButtonGroup m_JRBGroup = new ButtonGroup();
    private final JComboBox<FCOCSequActionPan> m_JumpLabChoice = new JComboBox();
    private final Integer m_JumpOffset;

    FCOCSequActionTFMDetFnger(Byte[] aActionSequObject) {
        this.add((Component)new JLabel("Detection:"), 0, 0);
        this.m_JRBGroup.add(this.m_DetectOn);
        this.m_JRBGroup.add(this.m_DetectOff);
        this.m_DetectOn.setForeground(Color.GREEN);
        this.m_DetectOn.addItemListener(this);
        this.m_DetectOff.addItemListener(this);
        this.m_DetectOff.setForeground(Color.RED);
        this.add((Component)this.m_DetectOn, 1, 0);
        this.add((Component)this.m_DetectOff, 2, 0);
        this.add((Component)new JLabel("Jump to:"), 0, 1);
        this.add(this.m_JumpLabChoice, 1, 1, 2, 1);
        if (aActionSequObject[3] == 0) {
            this.m_JRBGroup.setSelected(this.m_DetectOff.getModel(), true);
        } else {
            this.m_JRBGroup.setSelected(this.m_DetectOn.getModel(), true);
        }
        this.m_JumpOffset = FCOCUtils.byteArrayLEToInt(aActionSequObject, 4, 3);
        this.itemStateChanged(new ItemEvent(this.m_DetectOn, 0, "", 0));
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (this.m_DetectOn.isSelected()) {
            this.m_JumpLabChoice.setEnabled(true);
        } else {
            this.m_JumpLabChoice.setEnabled(false);
        }
    }

    @Override
    public void updateJumps() {
        int nJumpOffset = this.m_JumpOffset;
        FCOCSequActionLabel JumpToLabel = null;
        try {
            JumpToLabel = (FCOCSequActionLabel)m_SequenceList.getModel().getElementAt(this.getIndex() + nJumpOffset);
            JumpToLabel.addPointerAction(this);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        this.updateJumps(JumpToLabel);
    }

    public void updateJumps(FCOCSequActionLabel SelectedLabel) {
        Vector<FCOCSequActionLabel> LabelsList = FCOCSequActionTFMDetFnger.getLabelsList();
        this.m_JumpLabChoice.removeAll();
        for (FCOCSequActionLabel JLabel2 : LabelsList) {
            this.m_JumpLabChoice.addItem(JLabel2);
        }
        if (SelectedLabel != null) {
            this.m_JumpLabChoice.getModel().setSelectedItem(SelectedLabel);
        }
        this.m_JumpLabChoice.updateUI();
    }

    @Override
    public boolean hasJumps() {
        return true;
    }

    @Override
    public void modifyJumps(FCOCSequActionPan OldAction, FCOCSequActionPan NewAction) {
        FCOCSequActionPan OldJumpLabel = (FCOCSequActionPan)this.m_JumpLabChoice.getSelectedItem();
        this.m_JumpLabChoice.removeItem(OldAction);
        this.m_JumpLabChoice.addItem(NewAction);
        if (OldJumpLabel == OldAction) {
            this.m_JumpLabChoice.getModel().setSelectedItem(NewAction);
        }
    }

    @Override
    public void forceAddPointer() {
        try {
            FCOCSequActionLabel JumpToLabel = (FCOCSequActionLabel)this.m_JumpLabChoice.getModel().getSelectedItem();
            JumpToLabel.addPointerAction(this);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public FCOCSequActionPan clone(boolean isNewInstance) {
        FCOCSequActionTFMDetFnger NewAct = (FCOCSequActionTFMDetFnger)super.clone(isNewInstance);
        NewAct.updateJumps((FCOCSequActionLabel)this.m_JumpLabChoice.getSelectedItem());
        return NewAct;
    }

    @Override
    public boolean isDeleteAllowed(boolean isDeleteAsked) {
        if (isDeleteAsked) {
            ((FCOCSequActionLabel)this.m_JumpLabChoice.getSelectedItem()).removePointerAction(this);
        }
        return true;
    }

    @Override
    public Byte[] bytesGetter() {
        byte chDetectExType = 0;
        if (this.m_DetectOn.isSelected()) {
            chDetectExType = 1;
        }
        Byte[] aActionSequObject = new Byte[]{(byte)18, (byte)0, (byte)1, chDetectExType, (byte)-1, (byte)-1, (byte)-1, (byte)-1};
        int nJumpOffset = 0;
        try {
            nJumpOffset = ((FCOCSequActionPan)this.m_JumpLabChoice.getSelectedItem()).getIndex() - this.getIndex();
        }
        catch (NullPointerException e) {
            System.err.println("Error in TFMDetFnger action at line " + this.getIndex() + " : nJumpOffset calculation failed.");
        }
        FCOCUtils.intToByteArrayLE(nJumpOffset, aActionSequObject, 4, 3);
        return aActionSequObject;
    }

    @Override
    public String toString() {
        String szString = String.valueOf(this.getSzIndex()) + "TFM Detect finger ";
        if (this.m_DetectOff.isSelected()) {
            szString = String.valueOf(szString) + "turned off";
        } else {
            szString = String.valueOf(szString) + "active, jump to ";
            szString = this.m_JumpLabChoice.getModel().getSize() > 0 ? String.valueOf(szString) + ((FCOCSequActionLabel)this.m_JumpLabChoice.getSelectedItem()).getLabelName() : String.valueOf(szString) + this.m_JumpOffset;
        }
        return szString;
    }
}

