/*
 * Decompiled with CFR 0.152.
 */
package com.fiveco.ledsequ;

import com.fiveco.ledsequ.FCOCSequActionRaptPark;
import com.fiveco.utils.FCOCUtils;
import java.awt.Component;
import java.awt.event.ItemEvent;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;

class FCOCSequActionRaptParkMot
extends FCOCSequActionRaptPark {
    private static final String[] m_aszTYPES = new String[]{"Input percent", "Acceleration", "Deceleration", "Top Speed"};
    private final JComboBox<String> m_Type = new JComboBox<String>(m_aszTYPES);
    private final JComboBox<String> m_From = new JComboBox<String>(FCOCUtils.concatArrays(new String[]{"Litteral"}, m_aszVarList));
    private final JSpinner m_LiteralValue = new JSpinner(new SpinnerNumberModel(10, 0, 100, 1));

    FCOCSequActionRaptParkMot(Byte[] aActionSequObject) {
        super(aActionSequObject);
        this.add((Component)new JLabel("Type:"), 0, 1);
        this.add((Component)this.m_Type, 1, 1);
        this.add((Component)new JLabel("From:"), 0, 2);
        this.add((Component)this.m_From, 1, 2);
        this.add((Component)new JLabel("Value:"), 0, 3);
        this.add((Component)this.m_LiteralValue, 1, 3);
        this.m_Type.addItemListener(this);
        this.m_From.addItemListener(this);
        int nType = aActionSequObject[3].intValue() & 0xFF;
        this.m_Type.setSelectedIndex(nType & 0x7F);
        if ((nType & 0x80) == 128) {
            this.m_From.setSelectedIndex(aActionSequObject[4] + 1);
        } else {
            this.m_From.setSelectedIndex(0);
            if ((nType & 0x7F) == 0) {
                this.m_LiteralValue.setValue(Math.round((double)(aActionSequObject[4].intValue() & 0xFF) / 2.55));
            } else {
                this.m_LiteralValue.setValue(FCOCUtils.byteArrayLEToInt(aActionSequObject, 4));
            }
        }
        this.itemStateChanged(new ItemEvent(this.m_Type, 0, "", 0));
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        super.itemStateChanged(e);
        try {
            if (this.m_From.getSelectedIndex() == 0) {
                this.m_LiteralValue.setEnabled(true);
                switch (this.m_Type.getSelectedIndex()) {
                    case 0: {
                        ((SpinnerNumberModel)this.m_LiteralValue.getModel()).setMinimum(Integer.valueOf(0));
                        ((SpinnerNumberModel)this.m_LiteralValue.getModel()).setMaximum(Integer.valueOf(100));
                        break;
                    }
                    default: {
                        ((SpinnerNumberModel)this.m_LiteralValue.getModel()).setMinimum(Integer.valueOf(Integer.MIN_VALUE));
                        ((SpinnerNumberModel)this.m_LiteralValue.getModel()).setMaximum(Integer.valueOf(Integer.MAX_VALUE));
                        break;
                    }
                }
            } else {
                this.m_LiteralValue.setEnabled(false);
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Override
    public Byte[] bytesGetter() {
        Byte[] aActionBytes = super.bytesGetter();
        aActionBytes[2] = 1;
        int nType = this.m_Type.getSelectedIndex();
        if (this.m_From.getSelectedIndex() != 0) {
            nType |= 0x80;
        }
        aActionBytes[3] = (byte)nType;
        if (this.m_From.getSelectedIndex() == 0) {
            int nValue = ((Number)this.m_LiteralValue.getValue()).intValue();
            switch (this.m_Type.getSelectedIndex()) {
                case 0: {
                    aActionBytes[4] = (byte)Math.round((double)nValue * 2.55);
                    break;
                }
                default: {
                    FCOCUtils.intToByteArrayLE(nValue, aActionBytes, 4);
                    break;
                }
            }
        } else {
            aActionBytes[4] = (byte)(this.m_From.getSelectedIndex() - 1);
        }
        return aActionBytes;
    }

    @Override
    public String toString() {
        String szString = String.valueOf(super.toString()) + " Motor " + this.m_Type.getSelectedItem();
        if (this.m_From.getSelectedIndex() == 0) {
            szString = String.valueOf(szString) + " to " + ((Number)this.m_LiteralValue.getValue()).intValue();
            if (this.m_Type.getSelectedIndex() == 0) {
                szString = String.valueOf(szString) + "%";
            }
        } else {
            szString = String.valueOf(szString) + " from " + this.m_From.getSelectedItem();
        }
        return szString;
    }
}

