/*
 * Decompiled with CFR 0.152.
 */
package com.fiveco.ledsequ;

import com.fiveco.ledsequ.FCOCSequActionPan;
import com.fiveco.utils.FCOCUtils;
import java.awt.Component;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;

class FCOCSequActionRS485Msg
extends FCOCSequActionPan {
    private final JSpinner m_Address = new JSpinner(new SpinnerNumberModel(0, 0, 255, 1));
    private static final String[] n_aszIDLIST = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9"};
    private final JComboBox<String> m_IDChoice = new JComboBox<String>(n_aszIDLIST);
    private final byte m_chRegisterAddress = (byte)40;
    private final byte m_chRegisterLength = (byte)4;

    FCOCSequActionRS485Msg(Byte[] aActionSequObject) {
        this.add((Component)new JLabel("Destination:"), 0, 0);
        this.add((Component)this.m_Address, 1, 0);
        this.m_Address.setValue(aActionSequObject[1] & 0xFF);
        this.add((Component)new JLabel("Set Action ID to:"), 0, 1);
        this.add((Component)this.m_IDChoice, 1, 1);
        this.m_IDChoice.setSelectedIndex((int)FCOCUtils.byteArrayLEToUnsignedInt(aActionSequObject, 4));
    }

    @Override
    public Byte[] bytesGetter() {
        Byte[] aActionSequObject = new Byte[]{(byte)14, (byte)((Integer)this.m_Address.getValue()).intValue(), (byte)40, (byte)4, (byte)-1, (byte)-1, (byte)-1, (byte)-1};
        FCOCUtils.unsignedIntToByteArrayLE(this.m_IDChoice.getSelectedIndex(), aActionSequObject, 4);
        return aActionSequObject;
    }

    @Override
    public String toString() {
        String szString = String.valueOf(this.getSzIndex()) + "Start sequence @ ID=" + this.m_IDChoice.getSelectedIndex() + " on device " + (Integer)this.m_Address.getValue();
        return szString;
    }
}

