/*
 * Decompiled with CFR 0.152.
 */
package com.fiveco.ledsequ;

import com.fiveco.ledsequ.FCOCSequActionI2CAtByte1;
import com.fiveco.ledsequ.FCOCSequActionLabel;
import com.fiveco.ledsequ.FCOCSequActionPan;
import com.fiveco.utils.FCOCUtils;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;

class FCOCSequActionOledSetTime
extends FCOCSequActionI2CAtByte1
implements ItemListener {
    private final String[] m_aszSTATES = new String[]{"Hide with delay", "Show with delay", "Hide now", "Show now"};
    private final JComboBox<String> m_StateChoice = new JComboBox<String>(this.m_aszSTATES);
    private final JSpinner m_TimeHours = new JSpinner(new SpinnerNumberModel(0, 0, 1164, 1));
    private final JSpinner m_TimeMinutes = new JSpinner(new SpinnerNumberModel(0, 0, 59, 1));
    private final JSpinner m_TimeSeconds = new JSpinner(new SpinnerNumberModel(0, 0, 59, 1));
    private final JComboBox<FCOCSequActionPan> m_JumpLabel = new JComboBox();
    protected Integer m_JumpOffset;

    FCOCSequActionOledSetTime(Byte[] aActionSequObject) {
        super(aActionSequObject, 72, 5);
        this.add((Component)new JLabel("Set state:"), 0, 1);
        this.add(this.m_StateChoice, 1, 1, 4, 1);
        this.add((Component)new JLabel("Delay (h:m:s):"), 0, 2);
        int nSeconds = (int)(FCOCUtils.byteArrayLEToUnsignedInt(aActionSequObject, 2, 3) & 0x3FFFFFL);
        this.m_TimeHours.setValue(nSeconds / 3600);
        this.m_TimeMinutes.setValue((nSeconds %= 3600) / 60);
        this.m_TimeSeconds.setValue(nSeconds % 60);
        this.add(this.m_TimeHours, 1, 2, 2, 1);
        this.add((Component)this.m_TimeMinutes, 3, 2);
        this.add((Component)this.m_TimeSeconds, 4, 2);
        this.add((Component)new JLabel("Jump to:"), 0, 3);
        this.add(this.m_JumpLabel, 1, 3, 4, 1);
        this.m_StateChoice.addItemListener(this);
        this.m_JumpOffset = FCOCUtils.byteArrayLEToInt(aActionSequObject, 5, 3);
        this.m_StateChoice.setSelectedIndex(aActionSequObject[4] >> 6 & 3);
    }

    @Override
    public void updateJumps() {
        int nJumpOffset = this.m_JumpOffset;
        FCOCSequActionLabel JumpToLabel = null;
        try {
            if (this.m_StateChoice.getSelectedIndex() < 2) {
                JumpToLabel = (FCOCSequActionLabel)m_SequenceList.getModel().getElementAt(this.getIndex() + nJumpOffset);
                JumpToLabel.addPointerAction(this);
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        this.updateJumps(JumpToLabel);
    }

    public void updateJumps(FCOCSequActionLabel SelectedLabel) {
        Vector<FCOCSequActionLabel> LabelsList = FCOCSequActionOledSetTime.getLabelsList();
        this.m_JumpLabel.removeAll();
        for (FCOCSequActionLabel JLabel2 : LabelsList) {
            this.m_JumpLabel.addItem(JLabel2);
        }
        if (SelectedLabel != null) {
            this.m_JumpLabel.getModel().setSelectedItem(SelectedLabel);
        }
        this.m_JumpLabel.updateUI();
    }

    @Override
    public boolean hasJumps() {
        return true;
    }

    @Override
    public void modifyJumps(FCOCSequActionPan OldAction, FCOCSequActionPan NewAction) {
        FCOCSequActionPan OldJumpLabel = (FCOCSequActionPan)this.m_JumpLabel.getSelectedItem();
        this.m_JumpLabel.removeItem(OldAction);
        this.m_JumpLabel.addItem(NewAction);
        if (OldJumpLabel == OldAction) {
            this.m_JumpLabel.getModel().setSelectedItem(NewAction);
        }
    }

    @Override
    public FCOCSequActionPan clone(boolean isNewInstance) {
        FCOCSequActionOledSetTime NewAct = (FCOCSequActionOledSetTime)super.clone(isNewInstance);
        NewAct.updateJumps((FCOCSequActionLabel)this.m_JumpLabel.getSelectedItem());
        return NewAct;
    }

    @Override
    public boolean isDeleteAllowed(boolean isDeleteAsked) {
        if (isDeleteAsked) {
            ((FCOCSequActionLabel)this.m_JumpLabel.getSelectedItem()).removePointerAction(this);
        }
        return true;
    }

    @Override
    public void forceAddPointer() {
        try {
            if (this.m_StateChoice.getSelectedIndex() < 2) {
                FCOCSequActionLabel JumpToLabel = (FCOCSequActionLabel)this.m_JumpLabel.getModel().getSelectedItem();
                JumpToLabel.addPointerAction(this);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        super.itemStateChanged(e);
        if (e.getSource() == this.m_StateChoice) {
            boolean isEnabled = true;
            if (this.m_StateChoice.getSelectedIndex() >= 2) {
                isEnabled = false;
            }
            this.m_TimeHours.setEnabled(isEnabled);
            this.m_TimeMinutes.setEnabled(isEnabled);
            this.m_TimeSeconds.setEnabled(isEnabled);
            this.m_JumpLabel.setEnabled(isEnabled);
        }
    }

    @Override
    public Byte[] bytesGetter() {
        Byte[] aActionSequObject = super.bytesGetter(11);
        int nSeconds = (Integer)this.m_TimeHours.getValue() * 3600 + (Integer)this.m_TimeMinutes.getValue() * 60 + (Integer)this.m_TimeSeconds.getValue();
        aActionSequObject[2] = (byte)(nSeconds & 0xFF);
        aActionSequObject[3] = (byte)(nSeconds >> 8 & 0xFF);
        aActionSequObject[4] = (byte)(nSeconds >> 16 & 0x3F | this.m_StateChoice.getSelectedIndex() << 6 & 0xC0);
        int nJumpOffset = 0;
        try {
            nJumpOffset = ((FCOCSequActionPan)this.m_JumpLabel.getSelectedItem()).getIndex() - this.getIndex();
        }
        catch (NullPointerException e) {
            System.err.println("Error in OledSetTime action at line " + this.getIndex() + " : nJumpOffset calculation failed.");
        }
        FCOCUtils.intToByteArrayLE(nJumpOffset, aActionSequObject, 5, 3);
        return aActionSequObject;
    }

    @Override
    public String toString() {
        String szString = String.valueOf(this.getSzIndex()) + "Oled@" + this.I2CAddToString() + " " + this.m_StateChoice.getSelectedItem();
        if (this.m_StateChoice.getSelectedIndex() < 2) {
            szString = String.valueOf(szString) + " " + (Integer)this.m_TimeHours.getValue() + ":";
            szString = String.valueOf(szString) + (Integer)this.m_TimeMinutes.getValue() + ":";
            szString = String.valueOf(szString) + (Integer)this.m_TimeSeconds.getValue();
            szString = String.valueOf(szString) + " -> ";
            szString = this.m_JumpLabel.getModel().getSize() > 0 ? String.valueOf(szString) + ((FCOCSequActionLabel)this.m_JumpLabel.getSelectedItem()).getLabelName() : String.valueOf(szString) + this.m_JumpOffset;
        }
        return szString;
    }
}

