/*
 * Decompiled with CFR 0.152.
 */
package com.fiveco.ledsequ;

import com.fiveco.ledsequ.FCOCSequActionI2CAtByte1;
import com.fiveco.utils.FCOCUtils;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;

class FCOCSequActionMotLoopCnt
extends FCOCSequActionI2CAtByte1
implements ItemListener {
    private final JSpinner m_Input = new JSpinner(new SpinnerNumberModel(0, 0, 25500, 1));
    private final JSpinner m_Counter = new JSpinner(new SpinnerNumberModel(0, -99, 99, 1));
    private static final String[] m_aszTYPES = new String[]{"Loops", "Shortest way", "1st positive position", "1st negative position", "Same dir (shortest way if speed=0)", "Same dir (1st pos position if speed=0)", "Same dir (1st neg position if speed=0)", "Brake and set input to actual position", "Take offset input", "Take offset measured input", "Infinite positive loops (Input=speed)", "Infinite negative loops (Input=speed)"};
    private final JComboBox<String> m_Type = new JComboBox<String>(m_aszTYPES);
    private static final String[] m_aszUNITS = new String[]{"pulses", "\u2030"};
    private final JComboBox<String> m_Unit = new JComboBox<String>(m_aszUNITS);
    private final JCheckBox m_IsPeakCurrent = new JCheckBox("Peak current enabled", false);

    FCOCSequActionMotLoopCnt(Byte[] aActionSequObject) {
        super(aActionSequObject, 85, 3);
        this.add((Component)new JLabel("Type:"), 0, 1);
        this.add(this.m_Type, 0, 2, 3, 1);
        this.m_Type.addItemListener(this);
        this.add((Component)new JLabel("Input (pos):"), 0, 3);
        this.add((Component)this.m_Input, 1, 3);
        this.add((Component)this.m_Unit, 2, 3);
        this.m_Unit.addItemListener(this);
        this.add((Component)new JLabel("Counter:"), 0, 4);
        this.add(this.m_Counter, 1, 4, 2, 1);
        this.add(this.m_IsPeakCurrent, 1, 5, 2, 1);
        byte nCounter = aActionSequObject[6];
        if (nCounter > -100 && nCounter < 100) {
            this.m_Counter.setValue(nCounter);
            this.m_Type.setSelectedIndex(0);
        } else {
            this.m_Type.setSelectedIndex(nCounter - 100);
        }
        int nOptions = aActionSequObject[7] & 0xFF;
        int nInput = FCOCUtils.byteArrayLEToInt(aActionSequObject, 2);
        if ((nOptions & 0x10) == 16) {
            this.m_Unit.setSelectedIndex(1);
            this.m_Input.setValue(Math.round((double)nInput / 16777.215));
        } else {
            this.m_Unit.setSelectedIndex(0);
            ((SpinnerNumberModel)this.m_Input.getModel()).setMaximum(Integer.valueOf(1000000000));
            ((SpinnerNumberModel)this.m_Input.getModel()).setMinimum(Integer.valueOf(-1000000000));
            this.m_Input.setValue(nInput);
        }
        if ((nOptions & 8) == 8) {
            this.m_IsPeakCurrent.setSelected(true);
        } else {
            this.m_IsPeakCurrent.setSelected(false);
        }
        this.itemStateChanged(new ItemEvent(this.m_Type, 0, "", 0));
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        super.itemStateChanged(e);
        if (e.getSource() == this.m_Type || e.getSource() == this.m_Unit) {
            if (this.m_Type.getSelectedIndex() > 0) {
                this.m_Counter.setEnabled(false);
            } else {
                this.m_Counter.setEnabled(true);
            }
            boolean isEnabled = true;
            if (this.m_Type.getSelectedIndex() == 7) {
                isEnabled = false;
            }
            this.m_Input.setEnabled(isEnabled);
            this.m_Unit.setEnabled(isEnabled);
            if (this.m_Unit.getSelectedIndex() == 0) {
                ((SpinnerNumberModel)this.m_Input.getModel()).setMaximum(Integer.valueOf(1000000000));
                ((SpinnerNumberModel)this.m_Input.getModel()).setMinimum(Integer.valueOf(-1000000000));
            } else {
                ((SpinnerNumberModel)this.m_Input.getModel()).setMaximum(Integer.valueOf(25500));
                ((SpinnerNumberModel)this.m_Input.getModel()).setMinimum(Integer.valueOf(0));
            }
        }
    }

    @Override
    public Byte[] bytesGetter() {
        Byte[] aActionBytes = super.bytesGetter(21);
        double dInputPosition = ((Number)this.m_Input.getValue()).doubleValue();
        int nOptions = 128;
        if (this.m_Unit.getSelectedIndex() == 1) {
            nOptions |= 0x10;
            dInputPosition *= 16777.215;
        }
        if (this.m_IsPeakCurrent.isSelected()) {
            nOptions |= 8;
        }
        FCOCUtils.intToByteArrayLE((int)Math.round(dInputPosition), aActionBytes, 2);
        aActionBytes[6] = this.m_Type.getSelectedIndex() == 0 ? Byte.valueOf(((Number)this.m_Counter.getValue()).byteValue()) : Byte.valueOf((byte)(this.m_Type.getSelectedIndex() + 100));
        aActionBytes[7] = (byte)nOptions;
        return aActionBytes;
    }

    @Override
    public String toString() {
        String szString = String.valueOf(this.getSzIndex()) + "Mot@" + this.I2CAddToString() + " ";
        szString = this.m_Type.getSelectedIndex() == 0 ? String.valueOf(szString) + this.m_Counter.getValue() + " " + this.m_Type.getSelectedItem() + " stop at " + ((Number)this.m_Input.getValue()).intValue() + " " + this.m_Unit.getSelectedItem() : String.valueOf(szString) + this.m_Type.getSelectedItem();
        return szString;
    }
}

