/*
 * Decompiled with CFR 0.152.
 */
package com.fiveco.ledsequ;

import com.fiveco.ledsequ.FCOCSequActionI2CAtByte1;
import com.fiveco.utils.FCOCUtils;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;

class FCOCSequActionLcdSetVolt
extends FCOCSequActionI2CAtByte1 {
    private final JSpinner m_VoltagePercent = new JSpinner(new SpinnerNumberModel(100, 0, 100, 1));

    FCOCSequActionLcdSetVolt(Byte[] aActionSequObject) {
        super(aActionSequObject, 85);
        this.add((Component)new JLabel("Voltage [%]:"), 0, 1);
        this.add((Component)this.m_VoltagePercent, 1, 1);
        this.m_VoltagePercent.setValue(Math.round((double)FCOCUtils.byteArrayLEToUnsignedInt(aActionSequObject, 2, 2) / 655.35));
    }

    @Override
    public Byte[] bytesGetter() {
        Byte[] aActionSequObject = super.bytesGetter(5);
        aActionSequObject[0] = 7;
        int nVoltage = (int)(655.35 * ((Number)this.m_VoltagePercent.getValue()).doubleValue());
        FCOCUtils.unsignedIntToByteArrayLE(nVoltage, aActionSequObject, 2, 2);
        return aActionSequObject;
    }

    @Override
    public String toString() {
        String szString = String.valueOf(this.getSzIndex()) + "LCG@" + this.I2CAddToString() + " Set voltage to " + this.m_VoltagePercent.getValue() + "%";
        return szString;
    }
}

