/*
 * Decompiled with CFR 0.152.
 */
package com.fiveco.ledsequ;

import com.fiveco.ledsequ.FCOCSequActionI2CAtByte1;
import com.fiveco.utils.FCOCUtils;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;

class FCOCSequActionLcdSetTrans
extends FCOCSequActionI2CAtByte1 {
    private final JSpinner m_TransparencyPercent = new JSpinner(new SpinnerNumberModel(100, 0, 100, 1));
    private final JSpinner m_Speed = new JSpinner(new SpinnerNumberModel(10, 1, 3600000, 1));

    FCOCSequActionLcdSetTrans(Byte[] aActionSequObject) {
        super(aActionSequObject, 85);
        this.add((Component)new JLabel("Transparency value [%]:"), 0, 1);
        this.add((Component)this.m_TransparencyPercent, 1, 1);
        this.m_TransparencyPercent.setValue(Math.round((double)FCOCUtils.byteArrayLEToUnsignedInt(aActionSequObject, 6, 2) / 655.35));
        this.add((Component)new JLabel("Speed [ms/FR]:"), 0, 2);
        this.add((Component)this.m_Speed, 1, 2);
        double dSpeed = Math.round(4.294967295E9 / (double)FCOCUtils.byteArrayLEToUnsignedInt(aActionSequObject, 2));
        if (dSpeed > 3600000.0) {
            dSpeed = 1.0;
        }
        this.m_Speed.setValue((int)dSpeed);
    }

    @Override
    public Byte[] bytesGetter() {
        Byte[] aActionSequObject = super.bytesGetter(5);
        aActionSequObject[0] = 6;
        long lSpeed = (long)Math.ceil(4.294967295E9 / ((SpinnerNumberModel)this.m_Speed.getModel()).getNumber().doubleValue());
        FCOCUtils.unsignedIntToByteArrayLE(lSpeed, aActionSequObject, 2);
        int nLuminosityGoal = (int)(655.35 * ((Number)this.m_TransparencyPercent.getValue()).doubleValue());
        FCOCUtils.unsignedIntToByteArrayLE(nLuminosityGoal, aActionSequObject, 6, 2);
        return aActionSequObject;
    }

    @Override
    public String toString() {
        String szString = String.valueOf(this.getSzIndex()) + "LCG@" + this.I2CAddToString() + " Set transparency to " + this.m_TransparencyPercent.getValue() + "% within " + this.m_Speed.getValue() + "ms/FR";
        return szString;
    }
}

