/*
 * Decompiled with CFR 0.152.
 */
package com.fiveco.ledsequ;

import com.fiveco.jcomponents.FCOCGridBagJPanel;
import com.fiveco.ledsequ.FCOCSequActionI2CAtByte1;
import com.fiveco.utils.FCOCHexPlainDocument;
import com.fiveco.utils.FCOCUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

class FCOCSequActionGenI2CCmd
extends FCOCSequActionI2CAtByte1
implements ChangeListener,
ActionListener {
    private final JSpinner m_NbBytesToWrite = new JSpinner(new SpinnerNumberModel(5, 0, 5, 1));
    private final String[] m_aszWriteFrom = new String[]{"Literal", "Var", "1B Lit and var"};
    private final JComboBox<String> m_WriteFrom = new JComboBox<String>(this.m_aszWriteFrom);
    private final JTextField[] m_I2CData = new JTextField[5];
    private final JSpinner m_NbBytesToRead = new JSpinner(new SpinnerNumberModel(4, 0, 4, 1));
    private final JLabel m_ResultToVarLabel = new JLabel("Store read bytes in :");
    private final JComboBox<String> m_ResultToVarNum = new JComboBox<String>(m_aszVarShortList);

    FCOCSequActionGenI2CCmd(Byte[] aActionSequObject) {
        super(aActionSequObject, 85, 2, 1, 1);
        this.add(new JLabel("Nb of B to write :"), 0, 1, 1, 1, 10, 10);
        this.add(this.m_NbBytesToWrite, 1, 1, 1, 1, 20, 10);
        int nNumberOfBytesToWrite = (aActionSequObject[1] << 2 & 4) + (aActionSequObject[2] >> 6 & 3);
        this.m_NbBytesToWrite.setValue((byte)nNumberOfBytesToWrite);
        this.m_NbBytesToWrite.addChangeListener(this);
        this.add((Component)new JLabel("Write B from :"), 0, 2);
        this.add((Component)this.m_WriteFrom, 1, 2);
        this.m_WriteFrom.addActionListener(this);
        this.add((Component)new JLabel("B to write (0x) :"), 0, 3);
        FCOCGridBagJPanel I2CDataPan = new FCOCGridBagJPanel(0, 0, 0, 0);
        int i = 0;
        while (i < 5) {
            this.m_I2CData[i] = new JTextField(new FCOCHexPlainDocument(), FCOCUtils.toHexString(aActionSequObject[3 + i].intValue() & 0xFF), 2);
            I2CDataPan.add((Component)this.m_I2CData[i], i, 0);
            ++i;
        }
        this.add((Component)I2CDataPan, 1, 3);
        this.add((Component)new JLabel("Nb of B to read :"), 0, 4);
        this.add((Component)this.m_NbBytesToRead, 1, 4);
        this.m_NbBytesToRead.addChangeListener(this);
        int nNumberOfBytesToRead = aActionSequObject[2] >> 3 & 7;
        if (nNumberOfBytesToRead < 5) {
            this.m_NbBytesToRead.setValue((byte)nNumberOfBytesToRead);
        } else {
            this.m_WriteFrom.setSelectedIndex(nNumberOfBytesToRead + 1 - 5);
        }
        this.add((Component)this.m_ResultToVarLabel, 0, 5);
        this.add((Component)this.m_ResultToVarNum, 1, 5);
        this.m_ResultToVarNum.setSelectedIndex((byte)(aActionSequObject[2] & 7));
        this.enableGenI2C();
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        super.stateChanged(e);
        if (e.getSource() == this.m_NbBytesToWrite || e.getSource() == this.m_NbBytesToRead) {
            this.enableGenI2C();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.enableGenI2C();
    }

    private void enableGenI2C() {
        int nNumberOfBytesToWrite = ((SpinnerNumberModel)this.m_NbBytesToWrite.getModel()).getNumber().intValue();
        int nNumberOfBytesToRead = ((SpinnerNumberModel)this.m_NbBytesToRead.getModel()).getNumber().intValue();
        if (this.m_WriteFrom.getSelectedIndex() == 0) {
            int i = 0;
            while (i < 5) {
                if (i >= nNumberOfBytesToWrite) {
                    this.m_I2CData[i].setEnabled(false);
                } else {
                    this.m_I2CData[i].setEnabled(true);
                }
                ++i;
            }
            if (nNumberOfBytesToRead > 0) {
                this.m_ResultToVarNum.setEnabled(true);
            } else {
                this.m_ResultToVarNum.setEnabled(false);
            }
            this.m_NbBytesToRead.setEnabled(true);
            this.m_NbBytesToWrite.setModel(new SpinnerNumberModel(nNumberOfBytesToWrite, 0, 5, 1));
            this.m_ResultToVarLabel.setText("Store read bytes in :");
        } else {
            int i = 1;
            while (i < 5) {
                this.m_I2CData[i].setEnabled(false);
                ++i;
            }
            this.m_ResultToVarNum.setEnabled(true);
            this.m_NbBytesToRead.setEnabled(false);
            if (this.m_WriteFrom.getSelectedIndex() == 1) {
                if (nNumberOfBytesToWrite < 1 || nNumberOfBytesToWrite > 4) {
                    nNumberOfBytesToWrite = 4;
                }
                this.m_NbBytesToWrite.setModel(new SpinnerNumberModel(nNumberOfBytesToWrite, 1, 4, 1));
                this.m_I2CData[0].setEnabled(false);
            } else {
                if (nNumberOfBytesToWrite < 1) {
                    nNumberOfBytesToWrite = 5;
                }
                this.m_NbBytesToWrite.setModel(new SpinnerNumberModel(nNumberOfBytesToWrite, 1, 5, 1));
                this.m_I2CData[0].setEnabled(true);
            }
            this.m_ResultToVarLabel.setText("Write bytes from :");
        }
    }

    @Override
    public Byte[] bytesGetter() {
        Byte[] aActionSequObject = super.bytesGetter(20);
        int nNumberOfBytesToWrite = ((SpinnerNumberModel)this.m_NbBytesToWrite.getModel()).getNumber().intValue();
        int nNumberOfBytesToRead = this.m_WriteFrom.getSelectedIndex() == 0 ? ((SpinnerNumberModel)this.m_NbBytesToRead.getModel()).getNumber().intValue() : this.m_WriteFrom.getSelectedIndex() - 1 + 5;
        int nResultToVarNum = this.m_ResultToVarNum.getSelectedIndex();
        aActionSequObject[1] = (byte)(aActionSequObject[1] & 0xFE | nNumberOfBytesToWrite >> 2);
        aActionSequObject[2] = (byte)((nNumberOfBytesToWrite << 6) + (nNumberOfBytesToRead << 3) + nResultToVarNum);
        int i = 0;
        while (i < 5) {
            aActionSequObject[3 + i] = (byte)Integer.parseInt(this.m_I2CData[i].getText(), 16);
            ++i;
        }
        return aActionSequObject;
    }

    @Override
    public String toString() {
        int nNumberOfBytesToWrite = ((SpinnerNumberModel)this.m_NbBytesToWrite.getModel()).getNumber().intValue();
        int nNumberOfBytesToRead = ((SpinnerNumberModel)this.m_NbBytesToRead.getModel()).getNumber().intValue();
        int nResultToVarNum = this.m_ResultToVarNum.getSelectedIndex();
        String szString = String.valueOf(this.getSzIndex()) + "I2C:" + this.I2CAddToString();
        if (this.m_WriteFrom.getSelectedIndex() == 0) {
            if (nNumberOfBytesToWrite > 0) {
                szString = String.valueOf(szString) + " Write 0x";
                int i = 0;
                while (i < nNumberOfBytesToWrite) {
                    String szI2CValue = this.m_I2CData[i].getText();
                    if (szI2CValue.length() < 2) {
                        szString = String.valueOf(szString) + "0";
                    }
                    szString = String.valueOf(szString) + szI2CValue;
                    ++i;
                }
            }
            if (nNumberOfBytesToRead > 0) {
                szString = nNumberOfBytesToWrite > 0 ? String.valueOf(szString) + " and read " : String.valueOf(szString) + " Read ";
                szString = String.valueOf(szString) + nNumberOfBytesToRead + "B in Var" + (nResultToVarNum + 1);
            }
        } else {
            szString = String.valueOf(szString) + " Write ";
            if (this.m_WriteFrom.getSelectedIndex() == 2) {
                szString = String.valueOf(szString) + "0x" + this.m_I2CData[0].getText() + " and ";
            }
            szString = String.valueOf(szString) + (nNumberOfBytesToWrite - 1) + "B from Var" + (nResultToVarNum + 1);
        }
        return szString;
    }
}

