/*
 * Decompiled with CFR 0.152.
 */
package com.fiveco.ledsequ;

import com.fiveco.ledsequ.FCOCSequActionPan;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;

class FCOCSequActionBuzzer
extends FCOCSequActionPan
implements ActionListener {
    private static final String[] m_aszTYPES = new String[]{"Buzzer 1", "Buzzer 2"};
    private final JComboBox<String> m_Type = new JComboBox<String>(m_aszTYPES);
    private static final String[] m_aszACTION = new String[]{"Stop", "1 type of beep", "2 types of beep", "3 types of beep"};
    private final JComboBox<String> m_Action = new JComboBox<String>(m_aszACTION);
    private final JSpinner m_Duration = new JSpinner(new SpinnerNumberModel(1, 1, 1984, 1));
    private final JSpinner m_1stBeep = new JSpinner(new SpinnerNumberModel(1, 1, 458752, 1));
    private final JSpinner m_1stPause = new JSpinner(new SpinnerNumberModel(0, 0, 458752, 1));
    private final JSpinner m_2ndBeep = new JSpinner(new SpinnerNumberModel(1, 1, 458752, 1));
    private final JSpinner m_2ndPause = new JSpinner(new SpinnerNumberModel(0, 0, 458752, 1));
    private final JSpinner m_3rdBeep = new JSpinner(new SpinnerNumberModel(1, 1, 458752, 1));
    private final JSpinner m_3rdPause = new JSpinner(new SpinnerNumberModel(0, 0, 458752, 1));

    FCOCSequActionBuzzer(Byte[] aActionSequObject) {
        this.add((Component)new JLabel("Buzzer:"), 0, 0);
        this.add((Component)this.m_Type, 1, 0);
        this.m_Type.setEnabled(false);
        this.add((Component)new JLabel("Action:"), 0, 1);
        this.add((Component)this.m_Action, 1, 1);
        this.add((Component)new JLabel("Cycles count:"), 0, 2);
        this.add((Component)this.m_Duration, 1, 2);
        this.add((Component)new JLabel("1st beep [ms]:"), 0, 3);
        this.add((Component)this.m_1stBeep, 1, 3);
        this.add((Component)new JLabel("1st pause [ms]:"), 0, 4);
        this.add((Component)this.m_1stPause, 1, 4);
        this.add((Component)new JLabel("2nd beep [ms]:"), 0, 5);
        this.add((Component)this.m_2ndBeep, 1, 5);
        this.add((Component)new JLabel("2nd pause [ms]:"), 0, 6);
        this.add((Component)this.m_2ndPause, 1, 6);
        this.add((Component)new JLabel("3rd beep [ms]:"), 0, 7);
        this.add((Component)this.m_3rdBeep, 1, 7);
        this.add((Component)new JLabel("3rd pause [ms]:"), 0, 8);
        this.add((Component)this.m_3rdPause, 1, 8);
        this.m_Type.setSelectedIndex(aActionSequObject[1] >> 7 & 1);
        int nDuration = this.getDurVal((byte)(aActionSequObject[1] & 0x7F));
        this.m_Duration.setValue(nDuration);
        int n1stBeep = this.getDurVal(aActionSequObject[2]);
        this.m_1stBeep.setValue(n1stBeep);
        this.m_1stPause.setValue(this.getDurVal(aActionSequObject[3]));
        int n2ndBeep = this.getDurVal(aActionSequObject[4]);
        this.m_2ndBeep.setValue(n2ndBeep);
        this.m_2ndPause.setValue(this.getDurVal(aActionSequObject[5]));
        int n3rdBeep = this.getDurVal(aActionSequObject[6]);
        this.m_3rdBeep.setValue(n3rdBeep);
        this.m_3rdPause.setValue(this.getDurVal(aActionSequObject[7]));
        this.m_Action.setSelectedIndex(3);
        if (n3rdBeep == 0) {
            this.m_3rdBeep.setEnabled(false);
            this.m_3rdPause.setEnabled(false);
            this.m_Action.setSelectedIndex(2);
        }
        if (n2ndBeep == 0) {
            this.m_2ndBeep.setEnabled(false);
            this.m_2ndPause.setEnabled(false);
            this.m_Action.setSelectedIndex(1);
        }
        if (nDuration == 0) {
            this.m_1stBeep.setEnabled(false);
            this.m_1stPause.setEnabled(false);
            this.m_Duration.setEnabled(false);
            this.m_Action.setSelectedIndex(0);
        }
        this.m_Type.addActionListener(this);
        this.m_Action.addActionListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent ActEvt) {
        Object Source = ActEvt.getSource();
        if (Source == this.m_Action) {
            this.m_Duration.setEnabled(true);
            this.m_1stBeep.setEnabled(true);
            this.m_1stPause.setEnabled(true);
            this.m_2ndBeep.setEnabled(true);
            this.m_2ndPause.setEnabled(true);
            this.m_3rdBeep.setEnabled(true);
            this.m_3rdPause.setEnabled(true);
            switch (this.m_Action.getSelectedIndex()) {
                case 0: {
                    this.m_Duration.setEnabled(false);
                    this.m_1stBeep.setEnabled(false);
                    this.m_1stPause.setEnabled(false);
                }
                case 1: {
                    this.m_2ndBeep.setEnabled(false);
                    this.m_2ndPause.setEnabled(false);
                }
                case 2: {
                    this.m_3rdBeep.setEnabled(false);
                    this.m_3rdPause.setEnabled(false);
                }
            }
        }
    }

    private int getDurVal(byte cVal) {
        int m = cVal & 0xF;
        int e = cVal >> 4 & 0xF;
        if (e == 0) {
            return m;
        }
        return (int)((double)(m + 16) * Math.pow(2.0, e - 1));
    }

    private byte setDurVal(int nVal) {
        int m;
        int e;
        if (nVal < 16) {
            e = 0;
            m = nVal;
        } else {
            e = (int)Math.floor(Math.log10((double)nVal / 16.0) / Math.log10(2.0)) + 1;
            m = (int)Math.floor((double)nVal / Math.pow(2.0, e - 1)) - 16;
        }
        return (byte)(e << 4 | m & 0xF);
    }

    @Override
    public Byte[] bytesGetter() {
        Byte[] aActionBytes = new Byte[]{(byte)25, (byte)0, (byte)0, (byte)0, (byte)0, (byte)0, (byte)0, (byte)0};
        switch (this.m_Action.getSelectedIndex()) {
            case 3: {
                int nVal = (Integer)this.m_3rdPause.getValue();
                aActionBytes[7] = this.setDurVal(nVal);
                nVal = (Integer)this.m_3rdBeep.getValue();
                aActionBytes[6] = this.setDurVal(nVal);
            }
            case 2: {
                int nVal = (Integer)this.m_2ndPause.getValue();
                aActionBytes[5] = this.setDurVal(nVal);
                nVal = (Integer)this.m_2ndBeep.getValue();
                aActionBytes[4] = this.setDurVal(nVal);
            }
            case 1: {
                int nVal = (Integer)this.m_1stPause.getValue();
                aActionBytes[3] = this.setDurVal(nVal);
                nVal = (Integer)this.m_1stBeep.getValue();
                aActionBytes[2] = this.setDurVal(nVal);
                nVal = (Integer)this.m_Duration.getValue();
                aActionBytes[1] = (byte)(this.setDurVal(nVal) & 0x7F | this.m_Type.getSelectedIndex() << 7);
            }
        }
        return aActionBytes;
    }

    @Override
    public String toString() {
        String szString = String.valueOf(this.getSzIndex()) + this.m_Type.getSelectedItem() + ": " + this.m_Action.getSelectedItem();
        return szString;
    }
}

