/*
 * Decompiled with CFR 0.152.
 */
package com.fiveco.ledsequ;

import com.fiveco.ledsequ.FCOCSequActionLabel;
import com.fiveco.ledsequ.FCOCSequActionPan;
import com.fiveco.utils.FCOCUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JRadioButton;

class FCOCSequActionButEvt
extends FCOCSequActionPan
implements ItemListener {
    private final ButtonGroup m_aCBG = new ButtonGroup();
    private final JRadioButton m_aImmediatCB = new JRadioButton("Immediate");
    private final JRadioButton m_aEventCB = new JRadioButton("Event", true);
    private final JLabel m_InfoLabel = new JLabel("Buttons with alpha prefix are for external boards");
    private final String[] m_aszButtons = new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "A1", "A2", "A3", "A4", "A5", "A6", "A7", "A8", "A9", "A10", "A11", "A12", "A13", "A14", "A15", "A16", "B1", "B2", "B3", "B4", "B5", "B6", "B7", "B8", "B9", "B10", "B11", "B12", "B13", "B14", "B15", "B16", "C1", "C2", "C3", "C4", "C5", "C6", "C7", "C8", "C9", "C10", "C11", "C12", "C13", "C14", "C15", "C16", "D1", "D2", "D3", "D4", "D5", "D6", "D7", "D8", "D9", "D10", "D11", "D12", "D13", "D14", "D15", "D16"};
    private final JComboBox<String> m_Button = new JComboBox<String>(this.m_aszButtons);
    private final JCheckBox m_IsOnPressUsed = new JCheckBox("Used");
    private final JComboBox<FCOCSequActionPan> m_OnPressLabel = new JComboBox();
    private final JCheckBox m_IsOnReleaseUsed = new JCheckBox("Used");
    private final JComboBox<FCOCSequActionPan> m_OnReleaseLabel = new JComboBox();
    protected Integer m_OnPressOffset;
    protected Integer m_OnReleaseOffset;

    FCOCSequActionButEvt(Byte[] aActionSequObject) {
        this.m_aCBG.add(this.m_aImmediatCB);
        this.m_aCBG.add(this.m_aEventCB);
        this.add((Component)new JLabel("Action type:"), 0, 0);
        this.add((Component)this.m_aImmediatCB, 2, 0);
        this.add((Component)this.m_aEventCB, 1, 0);
        this.m_aCBG.setSelected(this.m_aImmediatCB.getModel(), (aActionSequObject[1] & 0x80) == 128);
        this.add(this.m_InfoLabel, 0, 1, 3, 1);
        this.m_InfoLabel.setForeground(Color.green);
        this.add((Component)new JLabel("Button:"), 0, 2);
        this.add(this.m_Button, 1, 2, 2, 1);
        if ((aActionSequObject[1] & 0x7F) == 0) {
            this.m_Button.setSelectedIndex(0);
        } else {
            this.m_Button.setSelectedIndex((aActionSequObject[1] & 0x7F) - 1);
        }
        this.add((Component)new JLabel("Press:"), 0, 3);
        this.add((Component)this.m_IsOnPressUsed, 1, 3);
        this.m_IsOnPressUsed.addItemListener(this);
        this.add((Component)this.m_OnPressLabel, 2, 3);
        this.add((Component)new JLabel("Release:"), 0, 4);
        this.add((Component)this.m_IsOnReleaseUsed, 1, 4);
        this.m_IsOnReleaseUsed.addItemListener(this);
        this.add((Component)this.m_OnReleaseLabel, 2, 4);
        this.m_OnPressOffset = FCOCUtils.byteArrayLEToInt(aActionSequObject, 2, 3);
        if (this.m_OnPressOffset != 0) {
            this.m_IsOnPressUsed.setSelected(true);
        } else {
            this.m_OnPressLabel.setEnabled(false);
        }
        this.m_OnReleaseOffset = FCOCUtils.byteArrayLEToInt(aActionSequObject, 5, 3);
        if (this.m_OnReleaseOffset != 0) {
            this.m_IsOnReleaseUsed.setSelected(true);
        } else {
            this.m_OnReleaseLabel.setEnabled(false);
        }
    }

    @Override
    public void updateJumps() {
        int nPressOffset = this.m_OnPressOffset;
        int nReleaseOffset = this.m_OnReleaseOffset;
        FCOCSequActionLabel OnPressJumpToLabel = null;
        FCOCSequActionLabel OnReleaseJumpToLabel = null;
        try {
            if (this.m_IsOnPressUsed.isSelected()) {
                OnPressJumpToLabel = (FCOCSequActionLabel)m_SequenceList.getModel().getElementAt(this.getIndex() + nPressOffset);
                OnPressJumpToLabel.addPointerAction(this);
            }
            if (this.m_IsOnReleaseUsed.isSelected()) {
                OnReleaseJumpToLabel = (FCOCSequActionLabel)m_SequenceList.getModel().getElementAt(this.getIndex() + nReleaseOffset);
                OnReleaseJumpToLabel.addPointerAction(this);
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        this.updateJumps(OnPressJumpToLabel, "Press");
        this.updateJumps(OnReleaseJumpToLabel, "Release");
    }

    public void updateJumps(FCOCSequActionLabel SelectedLabel, String szOnCB) {
        JComboBox<FCOCSequActionPan> OnCB = szOnCB.equals("Press") ? this.m_OnPressLabel : this.m_OnReleaseLabel;
        Vector<FCOCSequActionLabel> LabelsList = FCOCSequActionButEvt.getLabelsList();
        OnCB.removeAll();
        for (FCOCSequActionLabel JLabel2 : LabelsList) {
            OnCB.addItem(JLabel2);
        }
        if (SelectedLabel != null) {
            OnCB.getModel().setSelectedItem(SelectedLabel);
        }
        OnCB.updateUI();
    }

    @Override
    public boolean hasJumps() {
        return true;
    }

    @Override
    public void modifyJumps(FCOCSequActionPan OldAction, FCOCSequActionPan NewAction) {
        FCOCSequActionPan OldJumpLabel = (FCOCSequActionPan)this.m_OnPressLabel.getSelectedItem();
        this.m_OnPressLabel.removeItem(OldAction);
        this.m_OnPressLabel.addItem(NewAction);
        if (OldJumpLabel == OldAction) {
            this.m_OnPressLabel.getModel().setSelectedItem(NewAction);
        }
        OldJumpLabel = (FCOCSequActionPan)this.m_OnReleaseLabel.getSelectedItem();
        this.m_OnReleaseLabel.removeItem(OldAction);
        this.m_OnReleaseLabel.addItem(NewAction);
        if (OldJumpLabel == OldAction) {
            this.m_OnReleaseLabel.getModel().setSelectedItem(NewAction);
        }
    }

    @Override
    public FCOCSequActionPan clone(boolean isNewInstance) {
        FCOCSequActionButEvt NewAct = (FCOCSequActionButEvt)super.clone(isNewInstance);
        NewAct.updateJumps((FCOCSequActionLabel)this.m_OnPressLabel.getSelectedItem(), "Press");
        NewAct.updateJumps((FCOCSequActionLabel)this.m_OnReleaseLabel.getSelectedItem(), "Release");
        return NewAct;
    }

    @Override
    public boolean isDeleteAllowed(boolean isDeleteAsked) {
        if (isDeleteAsked) {
            ((FCOCSequActionLabel)this.m_OnPressLabel.getSelectedItem()).removePointerAction(this);
            ((FCOCSequActionLabel)this.m_OnReleaseLabel.getSelectedItem()).removePointerAction(this);
        }
        return true;
    }

    @Override
    public void forceAddPointer() {
        try {
            if (this.m_IsOnPressUsed.isSelected()) {
                FCOCSequActionLabel OnPressLabel = (FCOCSequActionLabel)this.m_OnPressLabel.getModel().getSelectedItem();
                OnPressLabel.addPointerAction(this);
            }
            if (this.m_IsOnReleaseUsed.isSelected()) {
                FCOCSequActionLabel OnReleaseLabel = (FCOCSequActionLabel)this.m_OnReleaseLabel.getModel().getSelectedItem();
                OnReleaseLabel.addPointerAction(this);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public Byte[] bytesGetter() {
        Byte[] aActionSequObject = new Byte[]{(byte)9, (byte)-1, (byte)-1, (byte)-1, (byte)-1, (byte)-1, (byte)-1, (byte)-1};
        aActionSequObject[1] = (byte)(this.m_Button.getSelectedIndex() + 1);
        if (this.m_aImmediatCB.isSelected()) {
            aActionSequObject[1] = (byte)(aActionSequObject[1] | 0xFFFFFF80);
        }
        int nPressOffset = 0;
        if (this.m_IsOnPressUsed.isSelected()) {
            try {
                nPressOffset = ((FCOCSequActionPan)this.m_OnPressLabel.getSelectedItem()).getIndex() - this.getIndex();
            }
            catch (NullPointerException e) {
                System.err.println("Error in ButEvt action at line " + this.getIndex() + " : nPressOffset calculation failed.");
            }
        }
        FCOCUtils.intToByteArrayLE(nPressOffset, aActionSequObject, 2, 3);
        int nReleaseOffset = 0;
        if (this.m_IsOnReleaseUsed.isSelected()) {
            try {
                nReleaseOffset = ((FCOCSequActionPan)this.m_OnReleaseLabel.getSelectedItem()).getIndex() - this.getIndex();
            }
            catch (NullPointerException e) {
                System.err.println("Error in ButEvt action at line " + this.getIndex() + " : nReleaseOffset calculation failed.");
            }
        }
        FCOCUtils.intToByteArrayLE(nReleaseOffset, aActionSequObject, 5, 3);
        return aActionSequObject;
    }

    @Override
    public String toString() {
        String szType = "On ";
        if (this.m_aImmediatCB.isSelected()) {
            szType = "If ";
        }
        String szString = String.valueOf(this.getSzIndex()) + "But" + this.m_Button.getSelectedItem() + " " + szType + ": ";
        szString = this.m_IsOnPressUsed.isSelected() ? (this.m_OnPressLabel.getModel().getSize() > 0 ? String.valueOf(szString) + "press->" + ((FCOCSequActionLabel)this.m_OnPressLabel.getSelectedItem()).getLabelName() : String.valueOf(szString) + this.m_OnPressOffset) : String.valueOf(szString) + "(unused)";
        szString = String.valueOf(szString) + " / ";
        szString = this.m_IsOnReleaseUsed.isSelected() ? (this.m_OnReleaseLabel.getModel().getSize() > 0 ? String.valueOf(szString) + "release->" + ((FCOCSequActionLabel)this.m_OnReleaseLabel.getSelectedItem()).getLabelName() : String.valueOf(szString) + this.m_OnReleaseOffset) : String.valueOf(szString) + "(unused)";
        return szString;
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (this.m_IsOnPressUsed.isSelected()) {
            this.m_OnPressLabel.setEnabled(true);
        } else {
            this.m_OnPressLabel.setEnabled(false);
        }
        if (this.m_IsOnReleaseUsed.isSelected()) {
            this.m_OnReleaseLabel.setEnabled(true);
        } else {
            this.m_OnReleaseLabel.setEnabled(false);
        }
    }
}

