/*
 * Decompiled with CFR 0.152.
 */
package com.fiveco.jcomponents;

import com.fiveco.jcomponents.FCOCGridBagJPanel;
import com.fiveco.utils.FCOCHexPlainDocument;
import com.fiveco.utils.FCOCUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class FCOCIntHexAddPanel
extends FCOCGridBagJPanel
implements ChangeListener,
FocusListener {
    private static final long serialVersionUID = 1L;
    private final JSpinner m_IntAddSpinner;
    private final JTextField m_HexAddTextField;
    private int m_nMinValue;
    private int m_nMaxValue;
    private final ChangeListener m_ChgListener;

    public FCOCIntHexAddPanel(String szLabelString, int nDefaultValue, int nMinValue, int nMaxValue, ChangeListener ChgList) {
        super(0, 0, 0, 0);
        this.setBackground(null);
        this.m_nMinValue = nMinValue;
        this.m_nMaxValue = nMaxValue;
        this.m_ChgListener = ChgList;
        this.m_IntAddSpinner = new JSpinner(new SpinnerNumberModel(nDefaultValue, nMinValue, nMaxValue, 1));
        this.m_HexAddTextField = new JTextField(new FCOCHexPlainDocument(), FCOCUtils.toHexString(nDefaultValue, 2), 2);
        this.m_IntAddSpinner.addChangeListener(this);
        this.m_HexAddTextField.addFocusListener(this);
        if (szLabelString.length() > 0) {
            this.add((Component)new JLabel(String.valueOf(szLabelString) + " ", 4), 0, 0);
        }
        this.add(this.m_IntAddSpinner, 1, 0, 1, 1, 20, 10, 1, 17);
        this.add(new JLabel("  0x"), 2, 0, 1, 1, 1, 10, 1, 10);
        this.add(this.m_HexAddTextField, 3, 0, 1, 1, 20, 10, 1, 13);
    }

    public int getAddress() {
        return (Integer)this.m_IntAddSpinner.getModel().getValue();
    }

    public void setAddress(int nAdd) {
        if (nAdd < this.m_nMinValue || nAdd > this.m_nMaxValue) {
            throw new IllegalArgumentException("New address must be between min and max values !");
        }
        this.m_IntAddSpinner.setValue(nAdd);
        this.m_HexAddTextField.setText(FCOCUtils.toHexString(nAdd, 2));
    }

    public void setMinAddress(int nMinAdd) {
        ((SpinnerNumberModel)this.m_IntAddSpinner.getModel()).setMinimum(Integer.valueOf(nMinAdd));
        this.m_nMinValue = nMinAdd;
    }

    public void setMaxAddress(int nMaxAdd) {
        ((SpinnerNumberModel)this.m_IntAddSpinner.getModel()).setMaximum(Integer.valueOf(nMaxAdd));
        this.m_nMaxValue = nMaxAdd;
    }

    @Override
    public void stateChanged(ChangeEvent ChgEvt) {
        Object ChgEvtSrc = ChgEvt.getSource();
        if (ChgEvtSrc == this.m_IntAddSpinner) {
            this.m_HexAddTextField.setText(FCOCUtils.toHexString(this.getAddress(), 2));
            if (this.m_ChgListener != null) {
                this.m_ChgListener.stateChanged(new ChangeEvent(this));
            }
        }
    }

    @Override
    public void focusGained(FocusEvent arg0) {
    }

    @Override
    public void focusLost(FocusEvent FcusEvt) {
        Object FcusEvtSrc = FcusEvt.getSource();
        if (FcusEvtSrc == this.m_HexAddTextField) {
            int nAdd = Integer.parseUnsignedInt(this.m_HexAddTextField.getText(), 16);
            if (nAdd >= this.m_nMinValue && nAdd <= this.m_nMaxValue) {
                this.setBorder(BorderFactory.createEmptyBorder());
                this.m_IntAddSpinner.setValue(nAdd);
                if (this.m_ChgListener != null) {
                    this.m_ChgListener.stateChanged(new ChangeEvent(this));
                }
            } else {
                this.m_HexAddTextField.requestFocus();
                this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.RED, 1), BorderFactory.createEmptyBorder(0, 4, 0, 4)));
            }
        }
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        this.m_IntAddSpinner.setEnabled(isEnabled);
        this.m_HexAddTextField.setEnabled(isEnabled);
    }
}

