/*
 * Decompiled with CFR 0.152.
 */
package com.fiveco.devices;

import java.util.BitSet;

public class FCOCRegisterBase {
    public static final int nAT_FCT = 0;
    public static final int nAT_R = 1;
    public static final int nAT_W = 2;
    public static final int nAT_RW = 3;
    public static final int nDT_INT = 0;
    public static final int nDT_UINT = 1;
    public static final int nDT_BIN = 2;
    public static final int nDT_PERCENT = 3;
    public static final int nDT_TEXT = 4;
    public static final int nDT_ARRAY = 5;
    public static final int nDT_FIXEDP_50_50 = 6;
    public static final int nDT_FIXEDP_25_75 = 7;
    public static final int nDT_FIXEDP_75_25 = 8;
    private int m_nAddress;
    private int m_nSize;
    private int m_nAccesType;
    private int m_nDataType;
    private Object m_Data;
    private boolean m_isAutoReadEnabled = false;

    public FCOCRegisterBase(int nAddress, int nSize, int nAccessType, int nDataType, boolean isAutoReadEnabled) throws IllegalArgumentException {
        if (nSize < 0) {
            throw new IllegalArgumentException("Register size cannot be negative !");
        }
        if (nAccessType == 0 && nSize > 0) {
            throw new IllegalArgumentException("Function size must be 0 !");
        }
        this.m_nAddress = nAddress;
        this.m_nSize = nSize;
        this.m_nAccesType = nAccessType;
        this.m_nDataType = nDataType;
        this.m_isAutoReadEnabled = isAutoReadEnabled;
        if (nAccessType != 0) {
            switch (nDataType) {
                case 0: {
                    if (this.m_nSize <= 8) {
                        this.m_Data = new Long(0L);
                        break;
                    }
                    throw new IllegalArgumentException("Register INT type does not support a size bigger than 8 !", null);
                }
                case 3: {
                    if (this.m_nSize <= 7) {
                        this.m_Data = new Double(0.0);
                        break;
                    }
                    throw new IllegalArgumentException("Register PERCENT types do not support a size bigger than 7 !", null);
                }
                case 1: {
                    if (this.m_nSize <= 7) {
                        this.m_Data = new Long(0L);
                        break;
                    }
                    throw new IllegalArgumentException("Register UINT types do not support a size bigger than 7 !", null);
                }
                case 2: {
                    this.m_Data = new BitSet(this.m_nSize * 8);
                    break;
                }
                case 4: {
                    this.m_Data = new String("");
                    break;
                }
                case 5: {
                    this.m_Data = new Byte[this.m_nSize];
                    break;
                }
                case 6: 
                case 7: 
                case 8: {
                    if (nSize % 2 != 0) {
                        throw new IllegalArgumentException("Register FIXEDP type size must be multiple of 2 !", null);
                    }
                    this.m_Data = new Double(0.0);
                    break;
                }
            }
        }
    }

    public int getAddress() {
        return this.m_nAddress;
    }

    public int getSize() {
        return this.m_nSize;
    }

    public int getAccesType() {
        return this.m_nAccesType;
    }

    public int getDataType() {
        return this.m_nDataType;
    }

    public Object getData() {
        return this.m_Data;
    }

    public void setData(Object Value) throws IllegalArgumentException {
        switch (this.m_nDataType) {
            case 0: 
            case 1: {
                if (Value.getClass().getSimpleName().equals("Long")) {
                    this.m_Data = new Long((Long)Value);
                    break;
                }
                throw new IllegalArgumentException("Register value must be Long.");
            }
            case 3: {
                if (Value.getClass().getSimpleName().equals("Double")) {
                    double dPercent = (Double)Value;
                    if (dPercent >= 0.0 && dPercent <= 100.0) {
                        this.m_Data = new Double((Double)Value);
                        break;
                    }
                    throw new IllegalArgumentException("Register value must be between 0 and 100.");
                }
                throw new IllegalArgumentException("Register value must be Double.");
            }
            case 2: {
                if (Value.getClass().getSimpleName().equals("BitSet")) {
                    if (((BitSet)Value).size() >= this.m_nSize * 8) {
                        this.m_Data = ((BitSet)Value).clone();
                        break;
                    }
                    throw new IllegalArgumentException("Register BitSet size must be " + this.m_nSize * 8 + ".");
                }
                throw new IllegalArgumentException("Register value must be BitSet.");
            }
            case 4: {
                if (Value.getClass().getSimpleName().equals("String")) {
                    this.m_Data = new String(((String)Value).toString());
                    break;
                }
                throw new IllegalArgumentException("Register value must be String.");
            }
            case 5: {
                if (Value.getClass().getSimpleName().equals("Byte[]")) {
                    Byte[] aByteValue = (Byte[])Value;
                    this.m_Data = new Byte[this.m_nSize];
                    int i = this.m_nSize - 1;
                    while (i >= 0) {
                        ((Byte[])this.m_Data)[i] = new Byte(aByteValue[i]);
                        --i;
                    }
                    break;
                }
                throw new IllegalArgumentException("Register value must be Byte[].");
            }
            case 6: 
            case 7: 
            case 8: {
                if (Value.getClass().getSimpleName().equals("Double")) {
                    this.m_Data = new Double((Double)Value);
                    break;
                }
                throw new IllegalArgumentException("Register value must be Double.");
            }
            default: {
                throw new IllegalArgumentException("Register data type is unknown or not supported.");
            }
        }
    }

    public boolean isAutoReadEnabled() {
        return this.m_isAutoReadEnabled;
    }

    public void setAutoReadEnabled(boolean isAutoReadEnabled) {
        this.m_isAutoReadEnabled = isAutoReadEnabled;
    }
}

