/*
 * Decompiled with CFR 0.152.
 */
package com.fiveco.devices;

import com.fiveco.devices.FCOCDevice;
import com.fiveco.devices.FCOCRegisterBase;
import com.fiveco.devices.FCOIDeviceEvent;
import com.fiveco.utils.FCOCUtils;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;
import java.util.BitSet;
import java.util.Calendar;
import java.util.Hashtable;

public class FCOCIPOnlyDevice
extends FCOCDevice {
    private static final String m_szLOGFILENAME = "C:/FCOCDeviceLog.txt";
    protected final int m_nTCPMAINPORT = 8010;
    protected String m_szIPAdd = "";
    protected Socket m_Socket;

    public FCOCIPOnlyDevice(String szIPAdd, int nNumberOfRegisters, FCOIDeviceEvent DeviceEvent, int nBufferSize) {
        super(nNumberOfRegisters, DeviceEvent, nBufferSize);
        this.m_szIPAdd = szIPAdd;
        this.m_ComThread.start();
    }

    public FCOCIPOnlyDevice(String szIPAdd, int nNumberOfRegisters, FCOIDeviceEvent DeviceEvent) {
        super(nNumberOfRegisters, DeviceEvent, 180);
        this.m_szIPAdd = szIPAdd;
        this.m_ComThread.start();
    }

    @Override
    public synchronized void delete() {
        if (!this.m_ComThread.isAlive()) {
            return;
        }
        int nTimeout = 20;
        while (this.m_WriteQueue.size() > 0 && nTimeout-- > 0) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.m_isThreadEnabled = false;
    }

    @Override
    public void removeSubDevice(String szSubDevName) {
    }

    @Override
    public FCOCDevice addSubDevice(String szSubDevName, int nAddress, int nNumberOfRegisters, int nInterface) throws IOException {
        return null;
    }

    @Override
    public int getInterface() {
        return -1;
    }

    @Override
    protected int fillBufferWithData(FCOCRegisterBase Register, byte[] acBuffer, int nOffset) {
        acBuffer[nOffset++] = (byte)Register.getAddress();
        if (Register.getData() != null) {
            switch (Register.getDataType()) {
                case 0: 
                case 1: {
                    long lValue = (Long)Register.getData();
                    int i = Register.getSize() - 1;
                    while (i >= 0) {
                        acBuffer[nOffset++] = (byte)(lValue >> i * 8 & 0xFFL);
                        --i;
                    }
                    break;
                }
                case 3: {
                    double dPercent = (Double)Register.getData();
                    long lPercent = (long)(Math.pow(2.0, Register.getSize() * 8) * dPercent / 100.0);
                    if ((double)lPercent > Math.pow(2.0, Register.getSize() * 8) - 1.0) {
                        lPercent = (long)(Math.pow(2.0, Register.getSize() * 8) - 1.0);
                    }
                    int i = Register.getSize() - 1;
                    while (i >= 0) {
                        acBuffer[nOffset++] = (byte)(lPercent >> i * 8 & 0xFFL);
                        --i;
                    }
                    break;
                }
                case 2: {
                    BitSet Data = (BitSet)Register.getData();
                    int i = Register.getSize() - 1;
                    while (i >= 0) {
                        byte cTemp = 0;
                        int j = 0;
                        while (j < 8) {
                            if (Data.get(8 * i + j)) {
                                cTemp = (byte)(cTemp | 1 << j);
                            }
                            ++j;
                        }
                        acBuffer[nOffset++] = cTemp;
                        --i;
                    }
                    break;
                }
                case 4: {
                    String szText = (String)Register.getData();
                    if (szText.length() > Register.getSize()) {
                        szText = szText.substring(0, Register.getSize() - 1);
                    }
                    byte[] acText = szText.getBytes();
                    int i = 0;
                    while (i < Register.getSize()) {
                        acBuffer[nOffset++] = i < szText.length() ? acText[i] : (byte)0;
                        ++i;
                    }
                    break;
                }
                case 5: {
                    Byte[] aByte = (Byte[])Register.getData();
                    int i = Register.getSize() - 1;
                    while (i >= 0) {
                        acBuffer[nOffset++] = aByte[i];
                        --i;
                    }
                    break;
                }
                case 6: {
                    double dValue = (Double)Register.getData();
                    long lValue = (long)(dValue * Math.pow(2.0, 8 * Register.getSize() / 2));
                    int i = Register.getSize() - 1;
                    while (i >= 0) {
                        acBuffer[nOffset++] = (byte)(lValue >> i * 8 & 0xFFL);
                        --i;
                    }
                    break;
                }
                case 7: {
                    double dValue = (Double)Register.getData();
                    long lValue = (long)(dValue * Math.pow(2.0, 24 * Register.getSize() / 4));
                    int i = Register.getSize() - 1;
                    while (i >= 0) {
                        acBuffer[nOffset++] = (byte)(lValue >> i * 8 & 0xFFL);
                        --i;
                    }
                    break;
                }
                case 8: {
                    double dValue = (Double)Register.getData();
                    long lValue = (long)(dValue * Math.pow(2.0, 8 * Register.getSize() / 4));
                    int i = Register.getSize() - 1;
                    while (i >= 0) {
                        acBuffer[nOffset++] = (byte)(lValue >> i * 8 & 0xFFL);
                        --i;
                    }
                    break;
                }
                default: {
                    nOffset += Register.getSize();
                }
            }
        }
        return nOffset;
    }

    @Override
    protected int getDataFromBuffer(FCOCRegisterBase Register, byte[] acBuffer, int nOffset) {
        switch (Register.getDataType()) {
            case 0: 
            case 1: 
            case 3: 
            case 6: 
            case 7: 
            case 8: {
                long lValue = 0L;
                int i = Register.getSize() - 1;
                while (i >= 0) {
                    long lMask = i == Register.getSize() - 1 && (Register.getDataType() == 0 || Register.getDataType() == 6 || Register.getDataType() == 7 || Register.getDataType() == 8) ? -1L : 255L;
                    lValue |= ((long)acBuffer[nOffset++] & lMask) << i * 8;
                    --i;
                }
                if (Register.getDataType() == 3) {
                    Register.setData(new Double((double)(100L * lValue) / Math.pow(2.0, Register.getSize() * 8)));
                    break;
                }
                if (Register.getDataType() == 6) {
                    Register.setData(new Double((double)lValue / Math.pow(2.0, 8 * Register.getSize() / 2)));
                    break;
                }
                if (Register.getDataType() == 7) {
                    Register.setData(new Double((double)lValue / Math.pow(2.0, 24 * Register.getSize() / 4)));
                    break;
                }
                if (Register.getDataType() == 8) {
                    Register.setData(new Double((double)lValue / Math.pow(2.0, 8 * Register.getSize() / 4)));
                    break;
                }
                Register.setData(new Long(lValue));
                break;
            }
            case 2: {
                BitSet Data = (BitSet)Register.getData();
                int i = Register.getSize() - 1;
                while (i >= 0) {
                    byte cTemp = acBuffer[nOffset++];
                    int j = 0;
                    while (j < 8) {
                        if ((cTemp & 1 << j) == 1 << j) {
                            Data.set(8 * i + j);
                        } else {
                            Data.set(8 * i + j, false);
                        }
                        ++j;
                    }
                    --i;
                }
                break;
            }
            case 4: {
                Register.setData(FCOCUtils.byteArrayToString(acBuffer, nOffset, Register.getSize()));
                nOffset += Register.getSize();
                break;
            }
            case 5: {
                Byte[] aData = new Byte[Register.getSize()];
                int i = Register.getSize() - 1;
                while (i >= 0) {
                    aData[i] = acBuffer[nOffset++];
                    --i;
                }
                Register.setData(aData);
                break;
            }
            default: {
                nOffset += Register.getSize();
            }
        }
        return nOffset;
    }

    protected int getUShortFromBuffer(byte[] acBuffer, int nOffset) {
        return (acBuffer[nOffset] << 8 & 0xFF00) + (acBuffer[nOffset + 1] & 0xFF);
    }

    protected void setUShortToBuffer(byte[] acBuffer, int nOffset, int nValue) {
        acBuffer[nOffset++] = (byte)((nValue & 0xFF00) >> 8);
        acBuffer[nOffset] = (byte)(nValue & 0xFF);
    }

    protected int calcChecksum(byte[] acInBuffer, int nBufferLength) {
        int nChecksum = 0;
        int nTemp = 0;
        int j = 0;
        int i = nBufferLength;
        while (i > 0) {
            if (i > 1) {
                nTemp = (acInBuffer[j] << 8 & 0xFF00) + (acInBuffer[j + 1] & 0xFF);
                j += 2;
                nChecksum += ~nTemp & 0xFFFF;
            } else {
                nChecksum += ~(acInBuffer[j++] << 8 & 0xFF00) & 0xFFFF;
            }
            i -= 2;
        }
        nChecksum = ((nChecksum & 0xFFFF0000) >> 16) + (nChecksum & 0xFFFF);
        nChecksum = ((nChecksum & 0xFFFF0000) >> 16) + (nChecksum & 0xFFFF);
        return nChecksum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        DataInputStream InStream = null;
        DataOutputStream OutStream = null;
        byte[] acInBuffer = new byte[1000];
        int nInBufferOffset = 0;
        byte[] acOutBuffer = new byte[this.m_nBufferSize];
        int nOutBufferOffset = 0;
        int nStep = 0;
        long lPreviousTimestamp = Calendar.getInstance().getTime().getTime();
        String szLastError = "";
        while (this.m_isThreadEnabled) {
            if (this.m_Socket == null || this.m_Socket.isClosed() || !this.m_Socket.isConnected()) {
                this.m_DeviceEvent.comDevEvtOccured(this, 0);
                try {
                    this.m_Socket = new Socket(this.m_szIPAdd, 8010);
                    this.m_Socket.setKeepAlive(true);
                    this.m_Socket.setTcpNoDelay(true);
                    this.m_Socket.setSoTimeout(1000);
                    InStream = new DataInputStream(this.m_Socket.getInputStream());
                    OutStream = new DataOutputStream(this.m_Socket.getOutputStream());
                    lPreviousTimestamp = Calendar.getInstance().getTime().getTime();
                    this.m_DeviceEvent.comDevEvtOccured(this, 1);
                    szLastError = "";
                }
                catch (IOException e) {
                    if (!szLastError.equals(e.getMessage())) {
                        System.err.println("IO Exception : can't create m_Socket ! " + e.getMessage());
                        this.m_DeviceEvent.comDevEvtOccured(this, 2);
                    }
                    szLastError = e.getMessage();
                }
                continue;
            }
            switch (nStep) {
                case 0: {
                    FCOCRegisterBase Register;
                    this.addAutoreadRegisterToQueue();
                    if (this.m_WriteQueue.size() == 0 && this.m_ReadQueue.size() > 0 && OutStream != null) {
                        int nReturnBufSize = 0;
                        nOutBufferOffset = 6;
                        Register = (FCOCRegisterBase)this.m_ReadQueue.peek();
                        do {
                            if (nOutBufferOffset >= this.m_nBufferSize - 2 || nReturnBufSize + Register.getSize() + 1 >= this.m_nBufferSize - 8) {
                                System.err.println("Missing space in IP read request buffer. Regs count remaining: " + this.m_ReadQueue.size());
                                break;
                            }
                            this.m_ReadQueue.poll();
                            acOutBuffer[nOutBufferOffset++] = (byte)Register.getAddress();
                            nReturnBufSize = 1 + Register.getSize();
                        } while ((Register = (FCOCRegisterBase)this.m_ReadQueue.peek()) != null);
                        this.setUShortToBuffer(acOutBuffer, 0, 33);
                        this.setUShortToBuffer(acOutBuffer, 2, this.m_nUniqueID++);
                        this.setUShortToBuffer(acOutBuffer, 4, nOutBufferOffset - 6);
                        this.setUShortToBuffer(acOutBuffer, nOutBufferOffset, this.calcChecksum(acOutBuffer, nOutBufferOffset));
                        nOutBufferOffset += 2;
                        try {
                            OutStream.write(acOutBuffer, 0, nOutBufferOffset);
                            this.m_isWaitingAnswer = true;
                        }
                        catch (IOException IoException) {
                            System.err.println("IO Exception : can't write to m_MainPortSocket ! " + IoException.getMessage());
                            try {
                                this.m_Socket.close();
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                            this.m_DeviceEvent.comDevEvtOccured(this, 3);
                        }
                    }
                    ++nStep;
                    break;
                }
                case 1: {
                    FCOCRegisterBase Register;
                    if (this.m_WriteQueue.size() > 0 && OutStream != null) {
                        nOutBufferOffset = 6;
                        Register = (FCOCRegisterBase)this.m_WriteQueue.peek();
                        do {
                            if (nOutBufferOffset + Register.getSize() + 1 >= this.m_nBufferSize - 2) {
                                System.err.println("Missing space in IP write request buffer. Regs count remaining: " + this.m_WriteQueue.size());
                                break;
                            }
                            this.m_WriteQueue.poll();
                            nOutBufferOffset = this.fillBufferWithData(Register, acOutBuffer, nOutBufferOffset);
                        } while ((Register = (FCOCRegisterBase)this.m_WriteQueue.peek()) != null);
                        this.setUShortToBuffer(acOutBuffer, 0, 34);
                        this.setUShortToBuffer(acOutBuffer, 2, this.m_nUniqueID++);
                        this.setUShortToBuffer(acOutBuffer, 4, nOutBufferOffset - 6);
                        this.setUShortToBuffer(acOutBuffer, nOutBufferOffset, this.calcChecksum(acOutBuffer, nOutBufferOffset));
                        nOutBufferOffset += 2;
                        try {
                            OutStream.write(acOutBuffer, 0, nOutBufferOffset);
                            this.m_isWaitingAnswer = true;
                        }
                        catch (IOException IoException) {
                            System.err.println("IO Exception : can't write to m_MainPortSocket ! " + IoException.getMessage());
                            try {
                                this.m_Socket.close();
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                            this.m_DeviceEvent.comDevEvtOccured(this, 3);
                        }
                    }
                    ++nStep;
                }
            }
            long lCurrentTimestamp = Calendar.getInstance().getTime().getTime();
            long lSleepRemaining = this.m_lThreadSleep / 2L - (lCurrentTimestamp - lPreviousTimestamp);
            if (lSleepRemaining < 0L) {
                lSleepRemaining = 2L;
            }
            lPreviousTimestamp += this.m_lThreadSleep / 2L;
            if (this.m_isWaitingAnswer) {
                int nRxTryCounter = 20;
                while (nRxTryCounter-- > 0) {
                    block50: {
                        try {
                            Thread.sleep(10L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        lSleepRemaining -= 10L;
                        try {
                            if (!this.m_Socket.isConnected() || InStream == null) break block50;
                            int nDataLength = InStream.available();
                            if (nInBufferOffset + nDataLength < 8) continue;
                            InStream.read(acInBuffer, nInBufferOffset, nDataLength);
                            nInBufferOffset += nDataLength;
                            int nLengthOfParameters = this.getUShortFromBuffer(acInBuffer, 4);
                            while (nInBufferOffset >= nLengthOfParameters + 8) {
                                int nChecksumReceived = this.getUShortFromBuffer(acInBuffer, nLengthOfParameters + 6);
                                int nChecksum = this.calcChecksum(acInBuffer, nLengthOfParameters + 6);
                                if (acInBuffer[0] == 0 && nChecksumReceived == nChecksum) {
                                    switch (acInBuffer[1]) {
                                        case 35: {
                                            int i = 6;
                                            while (i < 6 + nLengthOfParameters) {
                                                int y = i;
                                                Hashtable hashtable = this.m_aRegistersList;
                                                synchronized (hashtable) {
                                                    for (FCOCRegisterBase RegisterItem : this.m_aRegistersList.values()) {
                                                        if (RegisterItem.getAddress() != acInBuffer[i] || i + RegisterItem.getSize() > 6 + nLengthOfParameters) continue;
                                                        y = this.getDataFromBuffer(RegisterItem, acInBuffer, i + 1) - 1;
                                                        this.m_DeviceEvent.dataDevEvtOccured(this, this.getKeyFromValue(RegisterItem, this.m_aRegistersList), RegisterItem.getData());
                                                    }
                                                }
                                                i = y;
                                                ++i;
                                            }
                                            break;
                                        }
                                        case 36: {
                                            break;
                                        }
                                        default: {
                                            System.err.println("Error: received a bad command code from device.");
                                        }
                                    }
                                    int j = 0;
                                    int i = nLengthOfParameters + 8;
                                    while (i < nInBufferOffset) {
                                        acInBuffer[j++] = acInBuffer[i];
                                        ++i;
                                    }
                                    nInBufferOffset = j;
                                    if (nInBufferOffset < 8) break;
                                    nLengthOfParameters = this.getUShortFromBuffer(acInBuffer, 4);
                                } else {
                                    System.err.println("Error: received a bad packet from device.");
                                }
                                nInBufferOffset = 0;
                            }
                        }
                        catch (IOException IoException) {
                            System.err.println("IO Exception : can't read from device ! " + IoException.getMessage());
                            try {
                                this.m_Socket.close();
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                            this.m_DeviceEvent.comDevEvtOccured(this, 3);
                        }
                    }
                    this.m_isWaitingAnswer = false;
                    break;
                }
            }
            if (lSleepRemaining <= 0L) continue;
            try {
                Thread.sleep(lSleepRemaining);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (this.m_Socket != null && this.m_Socket.isConnected()) {
            try {
                this.m_Socket.close();
            }
            catch (IOException e) {
                System.err.println("IO Exception : can't close m_Socket ! " + e.getMessage());
            }
            this.m_DeviceEvent.comDevEvtOccured(this, 4);
        }
    }
}

