/*
 * Decompiled with CFR 0.152.
 */
package com.fiveco.devices;

import com.fiveco.devices.FCOCRegisterBase;
import com.fiveco.devices.FCOIDeviceEvent;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;

public abstract class FCOCDevice
implements Runnable {
    protected static final boolean m_isDEBUGENABLED = false;
    protected long m_lThreadSleep = 1000L;
    protected boolean m_isInterfaceComSupended = false;
    protected boolean m_isWaitingAnswer = false;
    protected boolean m_isAutoreadSuspended = false;
    protected final FCOIDeviceEvent m_DeviceEvent;
    protected final Hashtable<String, FCOCRegisterBase> m_aRegistersList;
    protected final Thread m_ComThread;
    protected boolean m_isThreadEnabled = true;
    protected int m_nUniqueID = 0;
    protected final ConcurrentLinkedQueue<FCOCRegisterBase> m_WriteQueue = new ConcurrentLinkedQueue();
    protected final ConcurrentLinkedQueue<FCOCRegisterBase> m_ReadQueue = new ConcurrentLinkedQueue();
    protected final int m_nBufferSize;

    public FCOCDevice(int nNumberOfRegisters, FCOIDeviceEvent DeviceEvent, int nBufferSize, long lThreadSleep) {
        if (nBufferSize < 50) {
            throw new IllegalArgumentException("Buffer size must be at least 50 bytes !");
        }
        this.m_DeviceEvent = DeviceEvent;
        this.m_aRegistersList = new Hashtable(nNumberOfRegisters);
        this.m_ComThread = new Thread((Runnable)this, "ComThread");
        this.m_nBufferSize = nBufferSize;
        this.m_lThreadSleep = lThreadSleep;
    }

    public FCOCDevice(int nNumberOfRegisters, FCOIDeviceEvent DeviceEvent, int nBufferSize) {
        if (nBufferSize < 50) {
            throw new IllegalArgumentException("Buffer size must be at least 50 bytes !");
        }
        this.m_DeviceEvent = DeviceEvent;
        this.m_aRegistersList = new Hashtable(nNumberOfRegisters);
        this.m_ComThread = new Thread((Runnable)this, "ComThread");
        this.m_nBufferSize = nBufferSize;
    }

    public abstract void delete();

    public void setInterfaceComSupendedState(boolean isInterfaceComSupended) {
        this.m_isInterfaceComSupended = isInterfaceComSupended;
    }

    public synchronized void setAutoreadSupended(boolean isSuspended) {
        this.m_isAutoreadSuspended = isSuspended;
    }

    public void setThreadSleepTime(long lThreadSleep) {
        this.m_lThreadSleep = lThreadSleep;
        System.out.println("Com thread sleep time changed to " + lThreadSleep + " ms.");
    }

    public long getThreadSleepTime() {
        return this.m_lThreadSleep;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRegister(String szRegisterName, int nRegisterAddress, int nRegisterSize, int nRegisterAccessType, int nDataType, boolean isAutoReadEnabled) throws IllegalArgumentException {
        FCOCRegisterBase NewRegister = new FCOCRegisterBase(nRegisterAddress, nRegisterSize, nRegisterAccessType, nDataType, isAutoReadEnabled);
        Hashtable<String, FCOCRegisterBase> hashtable = this.m_aRegistersList;
        synchronized (hashtable) {
            this.m_aRegistersList.put(szRegisterName, NewRegister);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FCOCRegisterBase removeRegister(String szRegisterName) {
        Hashtable<String, FCOCRegisterBase> hashtable = this.m_aRegistersList;
        synchronized (hashtable) {
            return this.m_aRegistersList.remove(szRegisterName);
        }
    }

    public synchronized void call(String szRegisterName) throws IllegalArgumentException {
        FCOCRegisterBase Register = this.getRegisterObject(szRegisterName);
        if (Register.getAccesType() != 0) {
            throw new IllegalArgumentException("Register " + szRegisterName + " is not a function.");
        }
        this.m_WriteQueue.add(Register);
    }

    public synchronized void setValue(String szRegisterName, Object Value, boolean isMandatory) throws IllegalArgumentException {
        FCOCRegisterBase Register = this.getRegisterObject(szRegisterName);
        if (Register.getAccesType() == 2 || Register.getAccesType() == 3) {
            if (this.m_WriteQueue.contains(Register) && !isMandatory) {
                return;
            }
        } else {
            throw new IllegalArgumentException("Register " + szRegisterName + " is not writable.");
        }
        Register.setData(Value);
        this.m_WriteQueue.add(Register);
    }

    public void setValue(String szRegisterName, Object Value) throws IllegalArgumentException {
        this.setValue(szRegisterName, Value, true);
    }

    public synchronized void getValue(String szRegisterName) throws IllegalArgumentException {
        FCOCRegisterBase Register = this.getRegisterObject(szRegisterName);
        if (Register.getAccesType() == 1 || Register.getAccesType() == 3) {
            if (this.m_ReadQueue.contains(Register)) {
                System.err.println("Warning : Register " + szRegisterName + " already in read queue. Skipping.");
            } else {
                this.m_ReadQueue.add(Register);
            }
        } else {
            throw new IllegalArgumentException("Register " + szRegisterName + " is not readable.");
        }
    }

    public synchronized Object getLastValue(String szRegisterName) throws IllegalArgumentException {
        FCOCRegisterBase Register = this.getRegisterObject(szRegisterName);
        if (Register.getAccesType() != 0) {
            return Register.getData();
        }
        throw new IllegalArgumentException("Register " + szRegisterName + " is a function.");
    }

    public synchronized void setAutoreadState(String szRegisterName, boolean isAutoReadEnabled) throws IllegalArgumentException {
        this.getRegisterObject(szRegisterName).setAutoReadEnabled(isAutoReadEnabled);
    }

    public abstract void removeSubDevice(String var1);

    public abstract FCOCDevice addSubDevice(String var1, int var2, int var3, int var4) throws IOException;

    public abstract int getInterface();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void addAutoreadRegisterToQueue() {
        if (this.m_isAutoreadSuspended) {
            return;
        }
        Hashtable<String, FCOCRegisterBase> hashtable = this.m_aRegistersList;
        synchronized (hashtable) {
            for (Map.Entry<String, FCOCRegisterBase> RegEntry : this.m_aRegistersList.entrySet()) {
                FCOCRegisterBase RegisterItem = RegEntry.getValue();
                if (!RegisterItem.isAutoReadEnabled() || RegisterItem.getAccesType() != 1 && RegisterItem.getAccesType() != 3 || this.m_ReadQueue.contains(RegisterItem)) continue;
                this.m_ReadQueue.add(RegisterItem);
                this.m_DeviceEvent.autoreadRegAddedToQueue(this, RegEntry.getKey());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected FCOCRegisterBase getRegisterObject(String szRegisterName) throws IllegalArgumentException {
        Hashtable<String, FCOCRegisterBase> hashtable = this.m_aRegistersList;
        synchronized (hashtable) {
            if (this.m_aRegistersList.containsKey(szRegisterName)) {
                return this.m_aRegistersList.get(szRegisterName);
            }
        }
        throw new IllegalArgumentException("Register " + szRegisterName + " not found.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getKeyFromValue(Object Value, Hashtable<String, ?> aList) {
        Hashtable<String, ?> hashtable = aList;
        synchronized (hashtable) {
            Enumeration<String> EKeys = aList.keys();
            String szKey = "";
            while (EKeys.hasMoreElements()) {
                szKey = EKeys.nextElement();
                Object ValueItem = aList.get(szKey);
                if (ValueItem == null || !ValueItem.equals(Value)) continue;
                return szKey;
            }
        }
        return null;
    }

    protected abstract int fillBufferWithData(FCOCRegisterBase var1, byte[] var2, int var3);

    protected abstract int getDataFromBuffer(FCOCRegisterBase var1, byte[] var2, int var3);

    @Override
    public abstract void run();
}

