/*
 * Decompiled with CFR 0.152.
 */
package com.fiveco.ledsequApp;

import com.fiveco.appMisc.FCOCAbout;
import com.fiveco.appMisc.FCOCEasyIPChange;
import com.fiveco.appMisc.FCOCScanNetwork;
import com.fiveco.appMisc.FCOCStatusBar;
import com.fiveco.devices.FCOCDevice;
import com.fiveco.devices.FCOCIPDevice;
import com.fiveco.devices.FCOIIPDeviceEvent;
import com.fiveco.errlog.FCOCErrLog;
import com.fiveco.jcomponents.FCOCGridBagJPanel;
import com.fiveco.ledsequ.FCOCScanDevices;
import com.fiveco.ledsequ.FCOCSequencerGUI;
import com.fiveco.ledsequ.FCOEI2CSeqRegisters;
import com.fiveco.utils.FCOCUtils;
import com.fiveco.utils.FCOISimpleEvent;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JSeparator;
import javax.swing.UIManager;

public class FCOCSequencerApp
extends JFrame
implements FCOISimpleEvent,
ActionListener,
FCOIIPDeviceEvent,
WindowListener {
    private static final long serialVersionUID = -221303271386962209L;
    private FCOCErrLog m_LogSystem = null;
    private static final boolean m_isDIETLINENABLED = false;
    private static final String m_szVersion = "Version 2.13 (14.10.2016)";
    private final int nFRAMEHEIGHT = 800;
    private final int nFRAMEWIDTH = 700;
    private final JMenuItem m_FileSaveMenuItem;
    private final JMenuItem m_FileOpenMenuItem;
    private final JMenuItem m_ScanNetMenuItem;
    private final JMenuItem m_ChangeIPMenuItem;
    private final JMenuItem m_CloseComMenuItem;
    private final JMenuItem m_ScanI2CBusMenuItem;
    private final JMenuItem m_LedSeq2MenuItem;
    private final JMenuItem m_LedSeq3MenuItem;
    private final JMenuItem m_LedSeq4MenuItem;
    private final JMenuItem m_CarrouselMenuItem;
    private final JMenuItem m_CarrouselSeqMenuItem;
    private final JMenuItem m_ForceAllMenuItem;
    private final JMenuItem m_DietlinOptionMenuItem;
    private final JMenuItem m_DisplaySeqVarsMenuItem;
    private final JMenuItem m_AboutMenuItem;
    private final FCOCSequencerGUI m_MainPanel = new FCOCSequencerGUI(this);
    private final FCOCStatusBar m_StatusBar = new FCOCStatusBar();
    private String m_szIPAddress;
    private FCOCScanNetwork m_ScanWindow;
    private FCOCEasyIPChange m_EasyIPChangeWindow;
    private FCOCScanDevices m_ScanDevices;
    private final JLabel m_TCPComMessage = new JLabel("TCP com state : Disconnected");
    private final JLabel m_I2CComMessage = new JLabel("I2C bus state : NA");
    private FCOCIPDevice m_FModTCP;
    private final String m_szI2CSEQNAME = "Sequencer";

    public FCOCSequencerApp() {
        super("FMod-LEDSEQUENCER control application - Version 2.13 (14.10.2016)");
        try {
            this.m_LogSystem = new FCOCErrLog(this, String.valueOf(System.getProperty("user.home")) + "/FiveCo_Data/LedSequencerApp_" + this.hashCode() + ".err.log", "LedSequencer App Version 2.13 (14.10.2016)");
            System.setErr(this.m_LogSystem.getErrPS());
            System.setOut(this.m_LogSystem.getOutPS());
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        CDragDropListener DragDropListener = new CDragDropListener();
        new DropTarget(this, DragDropListener);
        this.m_FileSaveMenuItem = new JMenuItem("Save sequence");
        this.m_FileSaveMenuItem.setMnemonic(83);
        this.m_FileSaveMenuItem.addActionListener(this);
        this.m_FileOpenMenuItem = new JMenuItem("Open sequence");
        this.m_FileOpenMenuItem.setMnemonic(83);
        this.m_FileOpenMenuItem.addActionListener(this);
        JMenu FileMenu = new JMenu("File");
        FileMenu.add(this.m_FileSaveMenuItem);
        FileMenu.add(this.m_FileOpenMenuItem);
        this.m_ScanNetMenuItem = new JMenuItem("Scan network...");
        this.m_ScanNetMenuItem.setMnemonic(83);
        this.m_ScanNetMenuItem.addActionListener(this);
        this.m_CloseComMenuItem = new JMenuItem("Close connection");
        this.m_CloseComMenuItem.setMnemonic(67);
        this.m_CloseComMenuItem.addActionListener(this);
        this.m_CloseComMenuItem.setEnabled(false);
        this.m_ChangeIPMenuItem = new JMenuItem("Change IP Address easily...");
        this.m_ChangeIPMenuItem.setMnemonic(73);
        this.m_ChangeIPMenuItem.addActionListener(this);
        this.m_ScanI2CBusMenuItem = new JMenuItem("Scan I2C bus...");
        this.m_ScanI2CBusMenuItem.addActionListener(this);
        this.m_ScanI2CBusMenuItem.setEnabled(false);
        JMenu ConnectionMenu = new JMenu("Connection");
        ConnectionMenu.add(this.m_ScanNetMenuItem);
        ConnectionMenu.add(this.m_CloseComMenuItem);
        ConnectionMenu.add(new JSeparator());
        ConnectionMenu.add(this.m_ChangeIPMenuItem);
        ButtonGroup DevTypesGroup = new ButtonGroup();
        this.m_LedSeq2MenuItem = new JRadioButtonMenuItem("FMod-LEDSEQUENCER 2");
        this.m_LedSeq2MenuItem.setSelected(true);
        this.m_LedSeq2MenuItem.setMnemonic(50);
        this.m_LedSeq2MenuItem.addActionListener(this);
        DevTypesGroup.add(this.m_LedSeq2MenuItem);
        this.m_LedSeq3MenuItem = new JRadioButtonMenuItem("FMod-LEDSEQUENCER 3");
        this.m_LedSeq3MenuItem.setMnemonic(51);
        this.m_LedSeq3MenuItem.addActionListener(this);
        DevTypesGroup.add(this.m_LedSeq3MenuItem);
        this.m_LedSeq4MenuItem = new JRadioButtonMenuItem("FMod-LEDSEQUENCER 4");
        this.m_LedSeq4MenuItem.setMnemonic(52);
        this.m_LedSeq4MenuItem.addActionListener(this);
        DevTypesGroup.add(this.m_LedSeq4MenuItem);
        this.m_CarrouselMenuItem = new JRadioButtonMenuItem("Carrousel");
        this.m_CarrouselMenuItem.setMnemonic(67);
        this.m_CarrouselMenuItem.addActionListener(this);
        DevTypesGroup.add(this.m_CarrouselMenuItem);
        this.m_CarrouselSeqMenuItem = new JRadioButtonMenuItem("Carrousel sequencer");
        this.m_CarrouselSeqMenuItem.setMnemonic(83);
        this.m_CarrouselSeqMenuItem.addActionListener(this);
        DevTypesGroup.add(this.m_CarrouselSeqMenuItem);
        this.m_ForceAllMenuItem = new JRadioButtonMenuItem("Force all available actions");
        this.m_ForceAllMenuItem.setSelected(false);
        this.m_ForceAllMenuItem.setMnemonic(65);
        this.m_ForceAllMenuItem.addActionListener(this);
        DevTypesGroup.add(this.m_ForceAllMenuItem);
        this.m_DietlinOptionMenuItem = new JCheckBoxMenuItem("Dietlin actions enabled");
        this.m_DietlinOptionMenuItem.addActionListener(this);
        this.m_DietlinOptionMenuItem.setSelected(false);
        JMenu DevicesMenu = new JMenu("Device choice");
        DevicesMenu.add(this.m_LedSeq2MenuItem);
        DevicesMenu.add(this.m_LedSeq3MenuItem);
        DevicesMenu.add(this.m_LedSeq4MenuItem);
        DevicesMenu.add(this.m_CarrouselMenuItem);
        DevicesMenu.add(this.m_CarrouselSeqMenuItem);
        DevicesMenu.add(this.m_ForceAllMenuItem);
        DevicesMenu.add(new JSeparator());
        DevicesMenu.add(this.m_DietlinOptionMenuItem);
        JMenu OptionsMenu = new JMenu("Options");
        this.m_DisplaySeqVarsMenuItem = new JCheckBoxMenuItem("Display debug options and sequence variables");
        this.m_DisplaySeqVarsMenuItem.addActionListener(this);
        this.m_DisplaySeqVarsMenuItem.setSelected(false);
        OptionsMenu.add(this.m_DisplaySeqVarsMenuItem);
        this.m_AboutMenuItem = new JMenuItem("About...");
        this.m_AboutMenuItem.setMnemonic(65);
        this.m_AboutMenuItem.addActionListener(this);
        JMenu HelpMenu = new JMenu("Help");
        HelpMenu.add(this.m_AboutMenuItem);
        JMenuBar MenuBar2 = new JMenuBar();
        MenuBar2.add(FileMenu);
        MenuBar2.add(ConnectionMenu);
        MenuBar2.add(OptionsMenu);
        MenuBar2.add(HelpMenu);
        this.setJMenuBar(MenuBar2);
        this.m_MainPanel.buildAvailableActionsList(-1, false);
        this.m_StatusBar.addJComponent(this.m_TCPComMessage);
        this.m_StatusBar.addJComponent(this.m_I2CComMessage);
        this.addWindowListener(this);
        FCOCGridBagJPanel MainPanel = new FCOCGridBagJPanel(1, 1, 1, 1);
        MainPanel.add(this.m_MainPanel, 0, 0, 1, 1, 10, 10, 1, 17);
        MainPanel.add(this.m_StatusBar, 0, 1, 1, 1, 10, 0);
        this.add(MainPanel);
        ArrayList<Image> imageList = new ArrayList<Image>();
        imageList.add(Toolkit.getDefaultToolkit().getImage(FCOCSequencerApp.class.getResource("/images/logo198px.gif")));
        imageList.add(Toolkit.getDefaultToolkit().getImage(FCOCSequencerApp.class.getResource("/images/logo75px.gif")));
        imageList.add(Toolkit.getDefaultToolkit().getImage(FCOCSequencerApp.class.getResource("/images/logo40px.gif")));
        imageList.add(Toolkit.getDefaultToolkit().getImage(FCOCSequencerApp.class.getResource("/images/logo32px.png")));
        this.setIconImages(imageList);
        Dimension DisplayDim = Toolkit.getDefaultToolkit().getScreenSize();
        int nHeight = 800;
        if (DisplayDim.height - 40 < 800) {
            nHeight = DisplayDim.height - 40;
        }
        this.setMinimumSize(new Dimension(700, nHeight));
        this.setResizable(true);
        FCOCUtils.centerFrame(this);
        this.setVisible(true);
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel("javax.swing.plaf.metal.MetalLookAndFeel");
        }
        catch (Exception exception) {
            // empty catch block
        }
        FCOCSequencerApp App = new FCOCSequencerApp();
        App.setDefaultCloseOperation(3);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object EvtSource = e.getSource();
        if (EvtSource == this.m_FileSaveMenuItem) {
            this.m_MainPanel.saveSeqToFile();
        } else if (EvtSource == this.m_FileOpenMenuItem) {
            this.m_MainPanel.readSeqFromFile(null);
        } else if (EvtSource == this.m_ScanNetMenuItem) {
            this.m_ScanWindow = new FCOCScanNetwork(this);
            this.m_ScanWindow.addWindowListener(this);
            this.m_ScanWindow.start(0L);
            this.setVisible(false);
        } else if (EvtSource == this.m_CloseComMenuItem) {
            this.disconnectFromDevice();
        } else if (EvtSource == this.m_ChangeIPMenuItem) {
            this.m_EasyIPChangeWindow = new FCOCEasyIPChange(this);
            this.m_EasyIPChangeWindow.addWindowListener(this);
            this.m_EasyIPChangeWindow.start(0L);
            this.setVisible(false);
        } else if (EvtSource == this.m_ScanI2CBusMenuItem) {
            this.m_ScanDevices = new FCOCScanDevices(this, this.m_szIPAddress, this.getX() + this.getWidth() + 5, this.getY());
            this.m_ScanDevices.addWindowListener(this);
            this.m_ScanDevices.start();
        } else if (EvtSource == this.m_LedSeq2MenuItem) {
            this.m_MainPanel.buildAvailableActionsList(1);
        } else if (EvtSource == this.m_LedSeq3MenuItem) {
            this.m_MainPanel.buildAvailableActionsList(3);
        } else if (EvtSource == this.m_LedSeq4MenuItem) {
            this.m_MainPanel.buildAvailableActionsList(4);
        } else if (EvtSource == this.m_CarrouselMenuItem) {
            this.m_MainPanel.buildAvailableActionsList(5);
        } else if (EvtSource == this.m_CarrouselSeqMenuItem) {
            this.m_MainPanel.buildAvailableActionsList(6);
        } else if (EvtSource == this.m_ForceAllMenuItem) {
            this.m_MainPanel.buildAvailableActionsList(-1);
        } else if (EvtSource == this.m_DietlinOptionMenuItem) {
            this.m_MainPanel.buildAvailableActionsList(this.m_DietlinOptionMenuItem.isSelected());
        } else if (EvtSource == this.m_DisplaySeqVarsMenuItem) {
            if (this.m_DisplaySeqVarsMenuItem.isSelected()) {
                this.setMinimumSize(new Dimension(1120, this.getMinimumSize().height));
            } else {
                this.setMinimumSize(new Dimension(700, this.getMinimumSize().height));
                this.setSize(this.getSize().width - 420, this.getSize().height);
            }
            this.m_MainPanel.displaySeqVars(this.m_DisplaySeqVarsMenuItem.isSelected());
        } else if (EvtSource == this.m_AboutMenuItem) {
            FCOCAbout fCOCAbout = new FCOCAbout("FMod-LEDSEQUENCER Application", m_szVersion);
        }
    }

    @Override
    public void simpleEventPerformed(Object EvtSource) {
        if (EvtSource == this.m_ScanWindow) {
            this.disconnectFromDevice();
            this.m_szIPAddress = this.m_ScanWindow.getIPAddressSelected();
            this.connectToDevice();
            this.m_ScanWindow.dispose();
            this.setVisible(true);
        } else if (EvtSource == this.m_EasyIPChangeWindow && this.m_FModTCP == null) {
            this.disconnectFromDevice();
            this.m_szIPAddress = this.m_EasyIPChangeWindow.getIPAddressSelected();
            this.connectToDevice();
            this.m_EasyIPChangeWindow.dispose();
            this.setVisible(true);
        } else if (EvtSource == this.m_MainPanel) {
            int nReadCount = this.m_MainPanel.getActualState();
            if (nReadCount > 0) {
                this.m_StatusBar.setStatusBarProgress("" + nReadCount, 0, 50, nReadCount % 50);
            } else {
                this.m_StatusBar.setStatusBarProgressFinished();
            }
        }
    }

    private void connectToDevice() {
        this.m_StatusBar.setText("Connecting to device.");
        this.m_FModTCP = new FCOCIPDevice(this.m_szIPAddress, 32, this);
        try {
            this.m_FModTCP.addRegister("Version", 1, 4, 1, 1, false);
            this.m_FModTCP.addRegister("SaveUser", 3, 0, 0, -1, false);
            this.m_FModTCP.addRegister("RestoreUser", 4, 0, 0, -1, false);
            this.m_FModTCP.addRegister("RestoreFactory", 5, 0, 0, -1, false);
            this.m_FModTCP.addRegister("MACAddress", 17, 6, 1, 5, false);
            this.m_FModTCP.addRegister("IPAddress", 18, 4, 3, 5, false);
            this.m_FModTCP.addRegister("SubnetMask", 19, 4, 3, 5, false);
            this.m_FModTCP.addRegister("Name", 21, 16, 3, 4, false);
            this.m_FModTCP.addRegister("I2CSpd", 24, 1, 3, 1, false);
            this.m_FModTCP.addSubDevice("Sequencer", 85, 80, 0);
            FCOEI2CSeqRegisters[] fCOEI2CSeqRegistersArray = FCOEI2CSeqRegisters.values();
            int n = fCOEI2CSeqRegistersArray.length;
            int n2 = 0;
            while (n2 < n) {
                FCOEI2CSeqRegisters RegDef = fCOEI2CSeqRegistersArray[n2];
                this.m_FModTCP.addI2CDeviceRegister("Sequencer", RegDef.toString(), RegDef.m_nRegAdd, RegDef.m_nRegSize, RegDef.m_nAT, RegDef.m_nDT, RegDef.m_isAutoReadEnabled);
                ++n2;
            }
            this.m_CloseComMenuItem.setEnabled(true);
            this.m_ScanI2CBusMenuItem.setEnabled(true);
        }
        catch (Exception e) {
            System.err.println("Exception : Create FiveCo device failed (" + e.getLocalizedMessage() + ")");
        }
        this.m_MainPanel.setDevice(this.m_FModTCP);
        try {
            this.m_FModTCP.getI2CValue("Sequencer", "Type");
            this.m_FModTCP.setValue("I2CSpd", new Long(24L));
            this.m_FModTCP.getValue("Version");
            this.m_FModTCP.getValue("IPAddress");
            this.m_FModTCP.getValue("MACAddress");
            this.m_FModTCP.getValue("SubnetMask");
            this.m_FModTCP.getValue("Name");
            this.m_FModTCP.getI2CValue("Sequencer", "NbPowerUp");
            this.m_FModTCP.getI2CValue("Sequencer", "Version");
            this.m_FModTCP.getI2CValue("Sequencer", "Options");
            this.m_FModTCP.getI2CValue("Sequencer", "MaxCurrentLed1");
            this.m_FModTCP.getI2CValue("Sequencer", "MaxCurrentLed2");
            this.m_FModTCP.getI2CValue("Sequencer", "MaxCurrentLed3");
            this.m_FModTCP.getI2CValue("Sequencer", "MaxCurrentLed4");
            this.m_FModTCP.getI2CValue("Sequencer", "MaxCurrentLed5");
            this.m_FModTCP.getI2CValue("Sequencer", "Led1Goal");
            this.m_FModTCP.getI2CValue("Sequencer", "Led2Goal");
            this.m_FModTCP.getI2CValue("Sequencer", "Led3Goal");
            this.m_FModTCP.getI2CValue("Sequencer", "Led4Goal");
            this.m_FModTCP.getI2CValue("Sequencer", "Led5Goal");
            this.m_FModTCP.getI2CValue("Sequencer", "ButtonThreshold");
            this.m_FModTCP.getI2CValue("Sequencer", "SeqBreakCfg");
        }
        catch (Exception e) {
            System.err.println("Exception : Read initial parameters failed (" + e.getLocalizedMessage() + ")");
        }
        this.m_StatusBar.setText(" ");
    }

    private void disconnectFromDevice() {
        if (this.m_FModTCP != null) {
            this.m_StatusBar.setText("Disconnecting from device.");
            this.m_MainPanel.setDevice(null);
            BitSet OptionSet = new BitSet();
            OptionSet.set(0);
            try {
                this.m_FModTCP.setI2CValue("Sequencer", FCOEI2CSeqRegisters.Options.toString(), OptionSet);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.m_FModTCP.delete();
            this.m_FModTCP = null;
            this.m_CloseComMenuItem.setEnabled(false);
            if (this.m_ScanDevices != null) {
                this.m_ScanDevices.dispose();
            }
            this.m_ScanI2CBusMenuItem.setEnabled(false);
            this.m_StatusBar.setText(" ");
        }
    }

    @Override
    public void comDevEvtOccured(FCOCDevice Source, int nCause) {
        String szTCPComMessage;
        boolean isError = true;
        Color SBColor = Color.black;
        switch (nCause) {
            case 0: {
                szTCPComMessage = "Connecting...";
                isError = false;
                break;
            }
            case 1: {
                szTCPComMessage = "Connected";
                SBColor = FCOCUtils.m_MEDIUMGREEN;
                isError = false;
                break;
            }
            case 2: {
                szTCPComMessage = "Write or read failed";
                SBColor = Color.RED;
                break;
            }
            case 3: {
                szTCPComMessage = "Connection lost";
                SBColor = Color.RED;
                break;
            }
            case 4: {
                szTCPComMessage = "Disconnected";
                isError = false;
                this.m_I2CComMessage.setText("I2C bus state : NA");
                this.m_I2CComMessage.setForeground(Color.BLACK);
                break;
            }
            default: {
                szTCPComMessage = "Unknown";
                SBColor = Color.RED;
            }
        }
        if (isError) {
            System.err.println("TCP com error : " + szTCPComMessage);
        }
        this.m_TCPComMessage.setForeground(SBColor);
        this.m_TCPComMessage.setText("TCP com state : " + szTCPComMessage);
    }

    @Override
    public void dataDevEvtOccured(FCOCDevice Source, String szRegisterName, Object Data) {
        this.m_MainPanel.dataDevEvtOccured(szRegisterName, Data);
    }

    @Override
    public void comI2CEvtOccured(FCOCIPDevice Source, String szI2CDeviceName, int nCause) {
        String szI2CComMessage;
        boolean isError = true;
        switch (nCause) {
            case 0: {
                szI2CComMessage = "OK";
                isError = false;
                break;
            }
            case 1: {
                szI2CComMessage = "Bus not ready";
                break;
            }
            case 2: {
                szI2CComMessage = "Bus timeout";
                break;
            }
            case 4: {
                szI2CComMessage = "Message too long";
                break;
            }
            case 100: {
                szI2CComMessage = "Bad ack";
                break;
            }
            default: {
                szI2CComMessage = "Unknown";
            }
        }
        if (isError) {
            System.err.println("I2C com error state : " + szI2CComMessage);
            this.m_I2CComMessage.setForeground(Color.RED);
        } else {
            this.m_I2CComMessage.setForeground(FCOCUtils.m_MEDIUMGREEN);
        }
        this.m_I2CComMessage.setText("I2C bus state : " + szI2CComMessage);
    }

    @Override
    public void dataI2CDevEvtOccured(FCOCIPDevice Source, String szI2CDeviceName, String szRegisterName, Object Data) {
        switch (FCOEI2CSeqRegisters.getFromString(szRegisterName)) {
            case Type: {
                long lType = (Long)Data;
                if (lType == 720897L) {
                    this.m_LedSeq2MenuItem.setSelected(true);
                    break;
                }
                if (lType == 720898L) {
                    this.m_LedSeq3MenuItem.setSelected(true);
                    break;
                }
                if (lType == 720900L) {
                    this.m_LedSeq4MenuItem.setSelected(true);
                    break;
                }
                if (lType == 0x100001L) {
                    this.m_CarrouselMenuItem.setSelected(true);
                    break;
                }
                if (lType == 0x110001L) {
                    this.m_CarrouselSeqMenuItem.setSelected(true);
                    break;
                }
                this.m_ForceAllMenuItem.setSelected(true);
                break;
            }
        }
        this.m_MainPanel.dataI2CDevEvtOccured(szRegisterName, Data);
    }

    @Override
    public void autoreadRegAddedToQueue(FCOCDevice Source, String szRegisterName) {
    }

    @Override
    public void autoreadI2CRegAddedToQueue(FCOCDevice Source, String szI2CDeviceName, String szRegisterName) {
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    @Override
    public void windowClosing(WindowEvent WinEvt) {
        Object WinEvtSource = WinEvt.getSource();
        if (WinEvtSource == this) {
            this.disconnectFromDevice();
        } else if (WinEvtSource == this.m_ScanWindow) {
            this.m_ScanWindow.dispose();
            this.setVisible(true);
        } else if (WinEvtSource == this.m_EasyIPChangeWindow) {
            this.m_EasyIPChangeWindow.dispose();
            this.setVisible(true);
        }
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    class CDragDropListener
    implements DropTargetListener {
        CDragDropListener() {
        }

        @Override
        public void drop(DropTargetDropEvent DropTargetEvt) {
            DataFlavor[] Flav;
            DropTargetEvt.acceptDrop(1);
            Transferable Transf = DropTargetEvt.getTransferable();
            DataFlavor[] dataFlavorArray = Flav = Transf.getTransferDataFlavors();
            int n = Flav.length;
            int n2 = 0;
            while (n2 < n) {
                DataFlavor flavor = dataFlavorArray[n2];
                try {
                    if (flavor.isFlavorJavaFileListType()) {
                        List files = (List)Transf.getTransferData(flavor);
                        if (files.size() > 1) {
                            JOptionPane.showMessageDialog(null, "Only one sequence file can be openend at a time !", "Error", 0);
                        } else {
                            for (File file : files) {
                                System.out.println("Dropped file path is '" + file.getPath() + "'.");
                                FCOCSequencerApp.this.m_MainPanel.readSeqFromFile(file.getPath());
                            }
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                ++n2;
            }
            DropTargetEvt.dropComplete(true);
        }

        @Override
        public void dragEnter(DropTargetDragEvent event) {
        }

        @Override
        public void dragExit(DropTargetEvent event) {
        }

        @Override
        public void dragOver(DropTargetDragEvent event) {
        }

        @Override
        public void dropActionChanged(DropTargetDragEvent event) {
        }
    }
}

