/*
 * Decompiled with CFR 0.152.
 */
package com.fiveco.ledsequ;

import com.fiveco.ledsequ.FCOCSequActionLabel;
import com.fiveco.ledsequ.FCOCSequActionPan;
import com.fiveco.utils.FCOCUtils;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.DateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JSpinner;
import javax.swing.SpinnerDateModel;

class FCOCSequActionRTCEvent
extends FCOCSequActionPan
implements ItemListener {
    private final JComboBox<String> m_TimerChoice = new JComboBox();
    private final JComboBox<FCOCSequActionPan> m_JumpLabel = new JComboBox();
    protected Integer m_JumpOffset;
    private final JSpinner m_Time = new JSpinner(new SpinnerDateModel(new Date(), null, null, 13));
    private final JSpinner m_SinceDate = new JSpinner(new SpinnerDateModel(new Date(), null, null, 5));
    private final JCheckBox m_UntilCB = new JCheckBox("Until (d:m:y):", true);
    private final JSpinner m_UntilDate = new JSpinner(new SpinnerDateModel(new Date(), null, null, 5));
    private final JCheckBox m_MoCB = new JCheckBox("Monday", false);
    private final JCheckBox m_TuCB = new JCheckBox("Tuesday", false);
    private final JCheckBox m_WeCB = new JCheckBox("Wednesday", false);
    private final JCheckBox m_ThCB = new JCheckBox("Thirsday", false);
    private final JCheckBox m_FrCB = new JCheckBox("Friday", false);
    private final JCheckBox m_SaCB = new JCheckBox("Saturday", false);
    private final JCheckBox m_SuCB = new JCheckBox("Sunday", false);

    FCOCSequActionRTCEvent(Byte[] aActionSequObject) {
        this.add((Component)new JLabel("Timer number:"), 0, 0);
        this.add((Component)this.m_TimerChoice, 1, 0);
        int i = 1;
        while (i < 26) {
            this.m_TimerChoice.addItem("" + i);
            ++i;
        }
        this.m_TimerChoice.updateUI();
        this.add((Component)new JLabel("Jump to:"), 0, 1);
        this.add((Component)this.m_JumpLabel, 1, 1);
        this.add((Component)new JLabel("When it is (h:m:s):"), 0, 2);
        this.add((Component)this.m_Time, 1, 2);
        this.m_Time.setEditor(new JSpinner.DateEditor(this.m_Time, "HH:mm:ss"));
        this.add((Component)new JLabel("Since (d.m.y)"), 0, 3);
        this.add((Component)this.m_SinceDate, 1, 3);
        this.m_SinceDate.setEditor(new JSpinner.DateEditor(this.m_SinceDate, "dd.MM.yy"));
        this.add((Component)this.m_UntilCB, 0, 4);
        this.m_UntilCB.addItemListener(this);
        this.add((Component)this.m_UntilDate, 1, 4);
        this.m_UntilDate.setEditor(new JSpinner.DateEditor(this.m_UntilDate, "dd.MM.yy"));
        this.add((Component)new JLabel("On:"), 0, 5);
        this.add((Component)this.m_MoCB, 1, 5);
        this.add((Component)this.m_TuCB, 1, 6);
        this.add((Component)this.m_WeCB, 1, 7);
        this.add((Component)this.m_ThCB, 1, 8);
        this.add((Component)this.m_FrCB, 1, 9);
        this.add((Component)this.m_SaCB, 1, 10);
        this.add((Component)this.m_SuCB, 1, 11);
        this.m_TimerChoice.setSelectedIndex(aActionSequObject[1].byteValue());
        if ((aActionSequObject[2] & 1) == 1) {
            this.m_MoCB.setSelected(true);
        }
        if ((aActionSequObject[2] & 2) == 2) {
            this.m_TuCB.setSelected(true);
        }
        if ((aActionSequObject[2] & 4) == 4) {
            this.m_WeCB.setSelected(true);
        }
        if ((aActionSequObject[2] & 8) == 8) {
            this.m_ThCB.setSelected(true);
        }
        if ((aActionSequObject[2] & 0x10) == 16) {
            this.m_FrCB.setSelected(true);
        }
        if ((aActionSequObject[2] & 0x20) == 32) {
            this.m_SaCB.setSelected(true);
        }
        if ((aActionSequObject[2] & 0x40) == 64) {
            this.m_SuCB.setSelected(true);
        }
        if (aActionSequObject[7] != 0) {
            GregorianCalendar SinceDate = new GregorianCalendar(2000 + FCOCUtils.bcd2Int(aActionSequObject[6]), FCOCUtils.bcd2Int(aActionSequObject[7]) - 1, 1);
            this.m_SinceDate.setValue(SinceDate.getTime());
            GregorianCalendar Time = new GregorianCalendar(2000, 0, 1, FCOCUtils.bcd2Int(aActionSequObject[3]), FCOCUtils.bcd2Int(aActionSequObject[4]), FCOCUtils.bcd2Int(aActionSequObject[5]));
            this.m_Time.setValue(Time.getTime());
        }
    }

    @Override
    public boolean bytesSetterExtension(Byte[] aActionSequObject) {
        this.m_UntilCB.setSelected(false);
        if (aActionSequObject[3] != 0) {
            Date SinceDateD = (Date)this.m_SinceDate.getValue();
            GregorianCalendar SinceDate = new GregorianCalendar();
            SinceDate.setTime(SinceDateD);
            SinceDate.set(5, FCOCUtils.bcd2Int(aActionSequObject[1]));
            this.m_SinceDate.setValue(SinceDate.getTime());
            GregorianCalendar UntilDate = new GregorianCalendar(2000 + FCOCUtils.bcd2Int(aActionSequObject[2]), FCOCUtils.bcd2Int(aActionSequObject[3]) - 1, FCOCUtils.bcd2Int(aActionSequObject[4]));
            this.m_UntilDate.setValue(UntilDate.getTime());
            if (UntilDate.get(1) != 2099) {
                this.m_UntilCB.setSelected(true);
            }
        }
        this.m_JumpOffset = FCOCUtils.byteArrayLEToInt(aActionSequObject, 5, 3);
        return true;
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (this.m_UntilCB.getModel().isSelected()) {
            this.m_UntilDate.setEnabled(true);
        } else {
            this.m_UntilDate.setEnabled(false);
        }
    }

    @Override
    public void updateJumps() {
        if (this.m_JumpOffset == null) {
            this.updateJumps(null);
            return;
        }
        int nJumpOffset = this.m_JumpOffset;
        FCOCSequActionLabel JumpToLabel = null;
        try {
            JumpToLabel = (FCOCSequActionLabel)m_SequenceList.getModel().getElementAt(this.getIndex() + nJumpOffset);
            JumpToLabel.addPointerAction(this);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        this.updateJumps(JumpToLabel);
    }

    public void updateJumps(FCOCSequActionLabel SelectedLabel) {
        Vector<FCOCSequActionLabel> LabelsList = FCOCSequActionRTCEvent.getLabelsList();
        this.m_JumpLabel.removeAll();
        for (FCOCSequActionLabel JLabel2 : LabelsList) {
            this.m_JumpLabel.addItem(JLabel2);
        }
        if (SelectedLabel != null) {
            this.m_JumpLabel.getModel().setSelectedItem(SelectedLabel);
        }
        this.m_JumpLabel.updateUI();
    }

    @Override
    public boolean hasJumps() {
        return true;
    }

    @Override
    public void modifyJumps(FCOCSequActionPan OldAction, FCOCSequActionPan NewAction) {
        FCOCSequActionPan OldJumpLabel = (FCOCSequActionPan)this.m_JumpLabel.getSelectedItem();
        this.m_JumpLabel.removeItem(OldAction);
        this.m_JumpLabel.addItem(NewAction);
        if (OldJumpLabel == OldAction) {
            this.m_JumpLabel.getModel().setSelectedItem(NewAction);
        }
    }

    @Override
    public FCOCSequActionPan clone(boolean isNewInstance) {
        FCOCSequActionRTCEvent NewAct = (FCOCSequActionRTCEvent)super.clone(isNewInstance);
        NewAct.updateJumps((FCOCSequActionLabel)this.m_JumpLabel.getSelectedItem());
        return NewAct;
    }

    @Override
    public boolean isDeleteAllowed(boolean isDeleteAsked) {
        if (isDeleteAsked) {
            ((FCOCSequActionLabel)this.m_JumpLabel.getSelectedItem()).removePointerAction(this);
        }
        return true;
    }

    @Override
    public void forceAddPointer() {
        try {
            FCOCSequActionLabel JumpToLabel = (FCOCSequActionLabel)this.m_JumpLabel.getModel().getSelectedItem();
            JumpToLabel.addPointerAction(this);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public Byte[] bytesGetter() {
        Byte[] aActionSequObject = new Byte[]{(byte)12, (byte)this.m_TimerChoice.getSelectedIndex(), (byte)-1, (byte)-1, (byte)-1, (byte)-1, (byte)-1, (byte)-1};
        byte chActiveDays = 0;
        if (this.m_MoCB.isSelected()) {
            chActiveDays = (byte)(chActiveDays + 1);
        }
        if (this.m_TuCB.isSelected()) {
            chActiveDays = (byte)(chActiveDays + 2);
        }
        if (this.m_WeCB.isSelected()) {
            chActiveDays = (byte)(chActiveDays + 4);
        }
        if (this.m_ThCB.isSelected()) {
            chActiveDays = (byte)(chActiveDays + 8);
        }
        if (this.m_FrCB.isSelected()) {
            chActiveDays = (byte)(chActiveDays + 16);
        }
        if (this.m_SaCB.isSelected()) {
            chActiveDays = (byte)(chActiveDays + 32);
        }
        if (this.m_SuCB.isSelected()) {
            chActiveDays = (byte)(chActiveDays + 64);
        }
        aActionSequObject[2] = chActiveDays;
        GregorianCalendar SinceDate = new GregorianCalendar();
        SinceDate.setTime((Date)this.m_SinceDate.getValue());
        GregorianCalendar Time = new GregorianCalendar();
        Time.setTime((Date)this.m_Time.getValue());
        aActionSequObject[3] = FCOCUtils.int2Bcd(Time.get(11));
        aActionSequObject[4] = FCOCUtils.int2Bcd(Time.get(12));
        aActionSequObject[5] = FCOCUtils.int2Bcd(Time.get(13));
        aActionSequObject[6] = FCOCUtils.int2Bcd(SinceDate.get(1) - 2000);
        aActionSequObject[7] = FCOCUtils.int2Bcd(SinceDate.get(2) + 1);
        return aActionSequObject;
    }

    @Override
    public Byte[] bytesGetterExtension() {
        Byte[] aActionSequObject = new Byte[]{(byte)-3, (byte)-1, (byte)-1, (byte)-1, (byte)-1, (byte)-1, (byte)-1, (byte)-1};
        GregorianCalendar SinceDate = new GregorianCalendar();
        SinceDate.setTime((Date)this.m_SinceDate.getValue());
        aActionSequObject[1] = FCOCUtils.int2Bcd(SinceDate.get(5));
        GregorianCalendar UntilDate = new GregorianCalendar();
        if (this.m_UntilCB.isSelected()) {
            UntilDate.setTime((Date)this.m_UntilDate.getValue());
        } else {
            UntilDate.set(2099, 11, 31);
        }
        aActionSequObject[2] = FCOCUtils.int2Bcd(UntilDate.get(1) - 2000);
        aActionSequObject[3] = FCOCUtils.int2Bcd(UntilDate.get(2) + 1);
        aActionSequObject[4] = FCOCUtils.int2Bcd(UntilDate.get(5));
        int nJumpOffset = 0;
        try {
            nJumpOffset = ((FCOCSequActionPan)this.m_JumpLabel.getSelectedItem()).getIndex() - this.getIndex();
        }
        catch (NullPointerException e) {
            System.err.println("Error in RTCEvent action at line " + this.getIndex() + " : nJumpOffset calculation failed.");
        }
        FCOCUtils.intToByteArrayLE(nJumpOffset, aActionSequObject, 5, 3);
        return aActionSequObject;
    }

    @Override
    public String toString() {
        String szString = String.valueOf(this.getSzIndex()) + "Timer " + this.m_TimerChoice.getSelectedItem();
        szString = String.valueOf(szString) + " @ " + DateFormat.getTimeInstance().format((Date)this.m_Time.getValue());
        szString = String.valueOf(szString) + " on ";
        szString = this.m_MoCB.isSelected() ? String.valueOf(szString) + "M" : String.valueOf(szString) + "-";
        szString = this.m_TuCB.isSelected() ? String.valueOf(szString) + "T" : String.valueOf(szString) + "-";
        szString = this.m_WeCB.isSelected() ? String.valueOf(szString) + "W" : String.valueOf(szString) + "-";
        szString = this.m_ThCB.isSelected() ? String.valueOf(szString) + "T" : String.valueOf(szString) + "-";
        szString = this.m_FrCB.isSelected() ? String.valueOf(szString) + "F" : String.valueOf(szString) + "-";
        szString = this.m_SaCB.isSelected() ? String.valueOf(szString) + "S" : String.valueOf(szString) + "-";
        szString = this.m_SuCB.isSelected() ? String.valueOf(szString) + "S" : String.valueOf(szString) + "-";
        szString = String.valueOf(szString) + " -> ";
        if (this.m_JumpLabel.getModel().getSize() > 0) {
            szString = String.valueOf(szString) + ((FCOCSequActionLabel)this.m_JumpLabel.getSelectedItem()).getLabelName();
        } else if (this.m_JumpOffset != null) {
            szString = String.valueOf(szString) + this.m_JumpOffset;
        }
        return szString;
    }

    @Override
    public String toStringExtension() {
        String szString = "since " + DateFormat.getDateInstance(3).format((Date)this.m_SinceDate.getValue());
        szString = this.m_UntilCB.isSelected() ? String.valueOf(szString) + " until " + DateFormat.getDateInstance(3).format((Date)this.m_UntilDate.getValue()) : String.valueOf(szString) + " forever";
        return szString;
    }
}

