/*
 * Decompiled with CFR 0.152.
 */
package com.fiveco.ledsequ;

import com.fiveco.jcomponents.FCOCGridBagJPanel;
import com.fiveco.ledsequ.FCOCSequActionMediaPlayerBase;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JComboBox;
import javax.swing.JSpinner;
import javax.swing.JToggleButton;
import javax.swing.SpinnerNumberModel;

class FCOCSequActionMediaPlayer
extends FCOCSequActionMediaPlayerBase
implements ActionListener,
ItemListener {
    private byte[] m_acTemp = new byte[12];
    private static final String[] m_aszTYPES = new String[]{"EyeZone B1080P", "DigitalView ViewStream 500", "OEM HSK1080", "Harman Kardon BDS570"};
    private final JComboBox<String> m_Type = new JComboBox<String>(m_aszTYPES);
    private JToggleButton m_ButPlayIndex;
    private final JSpinner m_FileIndex = new JSpinner(new SpinnerNumberModel(0, 0, 9999, 1));

    FCOCSequActionMediaPlayer(Byte[] aActionSequObject) {
        super(3, 1, 3, 1, aActionSequObject, 64, 2);
        this.m_ButPlayIndex = this.m_PlayIcon != null ? new JToggleButton(" index:", this.m_PlayIcon) : new JToggleButton("Play index:");
        this.m_ButtonsGroup.add(this.m_ButPlayIndex);
        this.m_ButPlayIndex.setSelected(true);
        this.add(this.m_Type, 0, 1, 2, 1);
        this.m_Type.addItemListener(this);
        this.m_Type.setSelectedIndex(aActionSequObject[2].byteValue());
        int i = 0;
        while (i < 5) {
            this.m_acTemp[i + 7] = aActionSequObject[7 - i];
            ++i;
        }
        FCOCGridBagJPanel FileIndexPan = new FCOCGridBagJPanel(0, 5, 5, 5);
        FileIndexPan.add((Component)this.m_ButPlayIndex, 0, 0);
        FileIndexPan.add((Component)this.m_FileIndex, 1, 0);
        this.add(FileIndexPan, 0, 4, 2, 1);
        this.m_ButPlayIndex.addActionListener(this);
        this.actionPerformed(new ActionEvent(this.m_ButPower, 0, ""));
    }

    @Override
    public boolean bytesSetterExtension(Byte[] aActionSequObject) {
        int i = 0;
        while (i < 7) {
            this.m_acTemp[i] = aActionSequObject[7 - i];
            ++i;
        }
        String szTemp = new String(this.m_acTemp);
        if ((szTemp = szTemp.replace('\u0000', ' ').replace(" ", "")).equals(EASCIICodes.POWER.get(this.m_Type.getSelectedIndex()))) {
            this.m_ButPower.setSelected(true);
        } else if (szTemp.equals(EASCIICodes.STOP.get(this.m_Type.getSelectedIndex()))) {
            this.m_ButStop.setSelected(true);
        } else if (szTemp.equals(EASCIICodes.PLAY.get(this.m_Type.getSelectedIndex()))) {
            this.m_ButPlay.setSelected(true);
        } else if (szTemp.equals(EASCIICodes.PAUSE.get(this.m_Type.getSelectedIndex()))) {
            this.m_ButPause.setSelected(true);
        } else if (szTemp.equals(EASCIICodes.NEXT.get(this.m_Type.getSelectedIndex()))) {
            this.m_ButNext.setSelected(true);
        } else if (szTemp.equals(EASCIICodes.PREVIOUS.get(this.m_Type.getSelectedIndex()))) {
            this.m_ButPrevious.setSelected(true);
        } else if (szTemp.indexOf(EASCIICodes.INDEX.getPrefix(this.m_Type.getSelectedIndex())) == 0 && szTemp.indexOf(EASCIICodes.INDEX.getPostfix(this.m_Type.getSelectedIndex())) == szTemp.length() - EASCIICodes.INDEX.getPostfix(this.m_Type.getSelectedIndex()).length()) {
            this.m_ButPlayIndex.setSelected(true);
            this.m_FileIndex.setValue(Integer.decode(szTemp.substring(EASCIICodes.INDEX.getPrefix(this.m_Type.getSelectedIndex()).length(), szTemp.length() - EASCIICodes.INDEX.getPostfix(this.m_Type.getSelectedIndex()).length())));
        }
        this.actionPerformed(new ActionEvent(this.m_ButPower, 0, ""));
        return true;
    }

    @Override
    public void itemStateChanged(ItemEvent ItemEvt) {
        super.itemStateChanged(ItemEvt);
        if (ItemEvt.getSource() == this.m_Type) {
            if (this.m_Type.getSelectedIndex() == 3) {
                this.m_ButStop.setEnabled(true);
                this.m_ButPlayIndex.setEnabled(false);
                this.m_ButNext.setEnabled(true);
                this.m_ButPrevious.setEnabled(true);
            } else if (this.m_Type.getSelectedIndex() == 2) {
                this.m_ButStop.setEnabled(false);
                this.m_ButPlayIndex.setEnabled(false);
                this.m_ButNext.setEnabled(true);
                this.m_ButPrevious.setEnabled(true);
            } else {
                this.m_ButStop.setEnabled(true);
                this.m_ButPlayIndex.setEnabled(true);
                this.m_ButNext.setEnabled(false);
                this.m_ButPrevious.setEnabled(false);
                if (this.m_Type.getSelectedIndex() == 1) {
                    this.m_ButPower.setEnabled(false);
                } else {
                    this.m_ButPower.setEnabled(true);
                }
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent ActEvt) {
        if (this.m_ButPlayIndex.isSelected()) {
            this.m_FileIndex.setEnabled(true);
        } else {
            this.m_FileIndex.setEnabled(false);
        }
    }

    @Override
    public Byte[] bytesGetter() {
        Byte[] aActionBytes = super.bytesGetter(22);
        aActionBytes[2] = (byte)this.m_Type.getSelectedIndex();
        String szString = this.getCmdString();
        int i = 0;
        while (i < 5) {
            aActionBytes[7 - i] = i < szString.length() - 7 ? Byte.valueOf(szString.getBytes()[i + 7]) : Byte.valueOf((byte)0);
            ++i;
        }
        return aActionBytes;
    }

    @Override
    public Byte[] bytesGetterExtension() {
        Byte[] aActionBytes = new Byte[]{(byte)-3, (byte)-1, (byte)-1, (byte)-1, (byte)-1, (byte)-1, (byte)-1, (byte)-1};
        String szString = this.getCmdString();
        int i = 0;
        while (i < 7) {
            aActionBytes[7 - i] = i < szString.length() ? Byte.valueOf(szString.getBytes()[i]) : Byte.valueOf((byte)0);
            ++i;
        }
        return aActionBytes;
    }

    private String getCmdString() {
        String szString = "";
        if (this.m_ButPower.isSelected()) {
            szString = EASCIICodes.POWER.get(this.m_Type.getSelectedIndex());
        } else if (this.m_ButStop.isSelected()) {
            szString = EASCIICodes.STOP.get(this.m_Type.getSelectedIndex());
        } else if (this.m_ButPlay.isSelected()) {
            szString = EASCIICodes.PLAY.get(this.m_Type.getSelectedIndex());
        } else if (this.m_ButPause.isSelected()) {
            szString = EASCIICodes.PAUSE.get(this.m_Type.getSelectedIndex());
        } else if (this.m_ButNext.isSelected()) {
            szString = EASCIICodes.NEXT.get(this.m_Type.getSelectedIndex());
        } else if (this.m_ButPrevious.isSelected()) {
            szString = EASCIICodes.PREVIOUS.get(this.m_Type.getSelectedIndex());
        } else if (this.m_ButPlayIndex.isSelected()) {
            String szIndex = ((SpinnerNumberModel)this.m_FileIndex.getModel()).getNumber().toString();
            String szFormat = EASCIICodes.INDEX.getFormat(this.m_Type.getSelectedIndex());
            if (szIndex.length() < szFormat.length()) {
                szIndex = String.valueOf(szFormat.substring(0, szFormat.length() - szIndex.length())) + szIndex;
            }
            szString = String.valueOf(EASCIICodes.INDEX.getPrefix(this.m_Type.getSelectedIndex())) + szIndex + EASCIICodes.INDEX.getPostfix(this.m_Type.getSelectedIndex());
        }
        return szString;
    }

    @Override
    public String toString() {
        String szString = String.valueOf(this.getSzIndex()) + "Media player @ " + this.I2CAddToString() + " (" + this.m_Type.getSelectedItem() + ")";
        return szString;
    }

    @Override
    public String toStringExtension() {
        String szString = "";
        if (this.m_ButPower.isSelected()) {
            szString = "Power";
        } else if (this.m_ButStop.isSelected()) {
            szString = "Stop";
        } else if (this.m_ButPlay.isSelected()) {
            szString = "Play";
        } else if (this.m_ButPause.isSelected()) {
            szString = "Pause";
        } else if (this.m_ButNext.isSelected()) {
            szString = "Next";
        } else if (this.m_ButPrevious.isSelected()) {
            szString = "Previous";
        } else if (this.m_ButPlayIndex.isSelected()) {
            szString = "Play file at index=" + this.m_FileIndex.getValue();
        }
        return String.valueOf(szString) + " (" + this.getCmdString() + ")";
    }

    private static enum EASCIICodes {
        POWER("q\r\n", "", new String(new byte[]{-126, -104}), new String(new byte[]{97, 110, 13, -14})),
        PLAY("p\r\n", "0001\r", new String(new byte[]{-126, 72}), new String(new byte[]{97, 110, 83, -84})),
        PAUSE("P\r\n", "0003\r", new String(new byte[]{-126, -72}), new String(new byte[]{97, 110, -45, 44})),
        STOP("x\r\n", "0002\r", "", new String(new byte[]{97, 110, 51, -52})),
        NEXT(">\r\n", "0005\r", new String(new byte[]{-126, 96}), new String(new byte[]{97, 110, -109, 108})),
        PREVIOUS("<\r\n", "0004\r", new String(new byte[]{-126, 104}), new String(new byte[]{97, 110, 19, -20})),
        INDEX(new String[]{"[", "", "]\r\n"}, new String[]{"F", "000", "\r"}, new String[]{"", "", ""}, new String[]{"", "", ""});

        private final String m_szB1080P;
        private final String m_szVS500;
        private final String m_szHSK1080;
        private final String m_szBDS570;
        private final String[] m_aszB1080P;
        private final String[] m_aszVS500;
        private final String[] m_aszHSK1080;
        private final String[] m_aszBDS570;

        private EASCIICodes(String szB1080P, String szVS500, String szHSK1080, String szBDS570) {
            this.m_szB1080P = szB1080P;
            this.m_szVS500 = szVS500;
            this.m_szHSK1080 = szHSK1080;
            this.m_szBDS570 = szBDS570;
            this.m_aszB1080P = null;
            this.m_aszVS500 = null;
            this.m_aszHSK1080 = null;
            this.m_aszBDS570 = null;
        }

        private EASCIICodes(String[] aszB1080P, String[] aszVS500, String[] aszHSK1080, String[] aszBDS570) {
            this.m_szB1080P = null;
            this.m_szVS500 = null;
            this.m_szHSK1080 = null;
            this.m_szBDS570 = null;
            this.m_aszB1080P = aszB1080P;
            this.m_aszVS500 = aszVS500;
            this.m_aszHSK1080 = aszHSK1080;
            this.m_aszBDS570 = aszBDS570;
        }

        public final String get(int nTypeIndex) {
            switch (nTypeIndex) {
                default: {
                    return this.m_szB1080P;
                }
                case 1: {
                    return this.m_szVS500;
                }
                case 2: {
                    return this.m_szHSK1080;
                }
                case 3: 
            }
            return this.m_szBDS570;
        }

        public final String getPrefix(int nTypeIndex) {
            switch (nTypeIndex) {
                default: {
                    return this.m_aszB1080P[0];
                }
                case 1: {
                    return this.m_aszVS500[0];
                }
                case 2: {
                    return this.m_aszHSK1080[0];
                }
                case 3: 
            }
            return this.m_aszBDS570[0];
        }

        public final String getFormat(int nTypeIndex) {
            switch (nTypeIndex) {
                default: {
                    return this.m_aszB1080P[1];
                }
                case 1: {
                    return this.m_aszVS500[1];
                }
                case 2: {
                    return this.m_aszHSK1080[1];
                }
                case 3: 
            }
            return this.m_aszBDS570[1];
        }

        public final String getPostfix(int nTypeIndex) {
            switch (nTypeIndex) {
                default: {
                    return this.m_aszB1080P[2];
                }
                case 1: {
                    return this.m_aszVS500[2];
                }
                case 2: {
                    return this.m_aszHSK1080[2];
                }
                case 3: 
            }
            return this.m_aszBDS570[2];
        }
    }
}

