/*
 * Decompiled with CFR 0.152.
 */
package com.fiveco.ledsequ;

import com.fiveco.ledsequ.FCOCSequActionI2CAtByte1;
import com.fiveco.utils.FCOCUtils;
import java.awt.Component;
import java.awt.event.ItemListener;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;

class FCOCSequActionLedSlave
extends FCOCSequActionI2CAtByte1
implements ItemListener {
    protected final JLabel m_LedNumLabel = new JLabel("Led number:");
    protected final JComboBox<String> m_LedNumChoice = new JComboBox();
    protected final JSpinner m_LumPercent = new JSpinner(new SpinnerNumberModel(100, 0, 100, 1));
    protected final JSpinner m_Speed = new JSpinner(new SpinnerNumberModel(10, 1, 3600000, 1));

    FCOCSequActionLedSlave(Byte[] aActionSequObject) {
        super(aActionSequObject, 85);
        this.add((Component)this.m_LedNumLabel, 0, 1);
        int i22 = 1;
        while (i22 <= 5) {
            this.m_LedNumChoice.addItem("" + i22);
            ++i22;
        }
        this.add((Component)this.m_LedNumChoice, 1, 1);
        try {
            this.m_LedNumChoice.setSelectedIndex((aActionSequObject[2].intValue() & 0xFF) - 1);
        }
        catch (IllegalArgumentException i22) {
            // empty catch block
        }
        this.add((Component)new JLabel("Luminosity value [%]:"), 0, 2);
        this.add((Component)this.m_LumPercent, 1, 2);
        this.m_LumPercent.setValue(Math.round((double)FCOCUtils.byteArrayLEToUnsignedInt(aActionSequObject, 6, 2) / 655.35));
        this.add((Component)new JLabel("Speed [ms/FR]:"), 0, 3);
        this.add((Component)this.m_Speed, 1, 3);
        double dSpeed = Math.round(1.6777215E7 / (double)FCOCUtils.byteArrayLEToUnsignedInt(aActionSequObject, 3, 3));
        if (dSpeed > 3600000.0) {
            dSpeed = 1.0;
        }
        this.m_Speed.setValue((int)dSpeed);
    }

    @Override
    public Byte[] bytesGetter() {
        Byte[] aActionSequObject = super.bytesGetter(24);
        aActionSequObject[2] = (byte)(this.m_LedNumChoice.getSelectedIndex() + 1);
        long lSpeed = (long)Math.ceil(1.6777215E7 / ((SpinnerNumberModel)this.m_Speed.getModel()).getNumber().doubleValue());
        FCOCUtils.unsignedIntToByteArrayLE(lSpeed, aActionSequObject, 3, 3);
        int nLuminosityGoal = (int)(655.35 * ((Number)this.m_LumPercent.getValue()).doubleValue());
        FCOCUtils.unsignedIntToByteArrayLE(nLuminosityGoal, aActionSequObject, 6, 2);
        return aActionSequObject;
    }

    @Override
    public String toString() {
        return String.valueOf(this.getSzIndex()) + "Slave " + super.I2CAddToString() + " : Set led " + this.m_LedNumChoice.getSelectedItem() + " to " + this.m_LumPercent.getValue() + "% within " + this.m_Speed.getValue() + "ms/FR";
    }
}

