/*
 * Decompiled with CFR 0.152.
 */
package com.fiveco.ledsequ;

import com.fiveco.ledsequ.FCOCSequActionPan;
import com.fiveco.utils.FCOCUtils;
import java.awt.Component;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;

class FCOCSequActionLedSetLum
extends FCOCSequActionPan {
    protected final JLabel m_LedNumLabel = new JLabel("Led number:");
    protected final JComboBox<String> m_LedNumChoice = new JComboBox();
    protected final JSpinner m_LumPercent = new JSpinner(new SpinnerNumberModel(100, 0, 100, 1));
    protected final JSpinner m_Speed = new JSpinner(new SpinnerNumberModel(10, 1, 3600000, 1));

    FCOCSequActionLedSetLum(Byte[] aActionSequObject) {
        this.add((Component)this.m_LedNumLabel, 0, 0);
        int i22 = 1;
        while (i22 <= 5) {
            this.m_LedNumChoice.addItem("" + i22);
            ++i22;
        }
        this.add((Component)this.m_LedNumChoice, 1, 0);
        try {
            this.m_LedNumChoice.setSelectedIndex((aActionSequObject[1].intValue() & 0xFF) - 1);
        }
        catch (IllegalArgumentException i22) {
            // empty catch block
        }
        this.add((Component)new JLabel("Luminosity value [%]:"), 0, 1);
        this.add((Component)this.m_LumPercent, 1, 1);
        this.m_LumPercent.setValue(Math.round((double)FCOCUtils.byteArrayLEToUnsignedInt(aActionSequObject, 6, 2) / 655.35));
        this.add((Component)new JLabel("Speed [ms/FR]:"), 0, 2);
        this.add((Component)this.m_Speed, 1, 2);
        double dSpeed = Math.round(4.294967295E9 / (double)FCOCUtils.byteArrayLEToUnsignedInt(aActionSequObject, 2));
        if (dSpeed > 3600000.0) {
            dSpeed = 1.0;
        }
        this.m_Speed.setValue((int)dSpeed);
    }

    @Override
    public Byte[] bytesGetter() {
        Byte[] aActionSequObject = new Byte[]{(byte)3, (byte)(this.m_LedNumChoice.getSelectedIndex() + 1), (byte)-1, (byte)-1, (byte)-1, (byte)-1, (byte)-1, (byte)-1};
        long lSpeed = (long)Math.ceil(4.294967295E9 / ((SpinnerNumberModel)this.m_Speed.getModel()).getNumber().doubleValue());
        FCOCUtils.unsignedIntToByteArrayLE(lSpeed, aActionSequObject, 2);
        int nLuminosityGoal = (int)(655.35 * ((Number)this.m_LumPercent.getValue()).doubleValue());
        FCOCUtils.unsignedIntToByteArrayLE(nLuminosityGoal, aActionSequObject, 6, 2);
        return aActionSequObject;
    }

    @Override
    public String toString() {
        return String.valueOf(this.getSzIndex()) + "Set led " + this.m_LedNumChoice.getSelectedItem() + " to " + this.m_LumPercent.getValue() + "% within " + this.m_Speed.getValue() + "ms/FR";
    }
}

