/*
 * Decompiled with CFR 0.152.
 */
package com.fiveco.ledsequ;

import com.fiveco.ledsequ.FCOCSequActionLabel;
import com.fiveco.ledsequ.FCOCSequActionPan;
import com.fiveco.utils.FCOCUtils;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JLabel;

class FCOCSequActionJumpRel
extends FCOCSequActionPan {
    protected final JComboBox<FCOCSequActionPan> m_JumpLabChoice = new JComboBox();
    protected Integer m_JumpOffset;

    FCOCSequActionJumpRel(Byte[] aActionSequObject) {
        this.add(new JLabel("Jump to:"), 0, 0, 1, 1, 5, 10);
        this.add(this.m_JumpLabChoice, 1, 0, 1, 1, 25, 10);
        this.m_JumpOffset = FCOCUtils.byteArrayLEToInt(aActionSequObject, 2, 3);
    }

    @Override
    public void updateJumps() {
        int nJumpOffset = this.m_JumpOffset;
        FCOCSequActionLabel JumpToLabel = null;
        try {
            JumpToLabel = (FCOCSequActionLabel)m_SequenceList.getModel().getElementAt(this.getIndex() + nJumpOffset);
            JumpToLabel.addPointerAction(this);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        this.updateJumps(JumpToLabel);
    }

    public void updateJumps(FCOCSequActionLabel SelectedLabel) {
        Vector<FCOCSequActionLabel> LabelsList = FCOCSequActionJumpRel.getLabelsList();
        this.m_JumpLabChoice.removeAll();
        for (FCOCSequActionLabel JLabel2 : LabelsList) {
            this.m_JumpLabChoice.addItem(JLabel2);
        }
        if (SelectedLabel != null) {
            this.m_JumpLabChoice.getModel().setSelectedItem(SelectedLabel);
        }
        this.m_JumpLabChoice.updateUI();
    }

    @Override
    public boolean hasJumps() {
        return true;
    }

    @Override
    public void modifyJumps(FCOCSequActionPan OldAction, FCOCSequActionPan NewAction) {
        FCOCSequActionPan OldJumpLabel = (FCOCSequActionPan)this.m_JumpLabChoice.getSelectedItem();
        this.m_JumpLabChoice.removeItem(OldAction);
        this.m_JumpLabChoice.addItem(NewAction);
        if (OldJumpLabel == OldAction) {
            this.m_JumpLabChoice.getModel().setSelectedItem(NewAction);
        }
    }

    @Override
    public void forceAddPointer() {
        try {
            FCOCSequActionLabel JumpToLabel = (FCOCSequActionLabel)this.m_JumpLabChoice.getModel().getSelectedItem();
            JumpToLabel.addPointerAction(this);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public FCOCSequActionPan clone(boolean isNewInstance) {
        FCOCSequActionJumpRel NewAct = (FCOCSequActionJumpRel)super.clone(isNewInstance);
        NewAct.updateJumps((FCOCSequActionLabel)this.m_JumpLabChoice.getSelectedItem());
        return NewAct;
    }

    @Override
    public boolean isDeleteAllowed(boolean isDeleteAsked) {
        if (isDeleteAsked) {
            ((FCOCSequActionLabel)this.m_JumpLabChoice.getSelectedItem()).removePointerAction(this);
        }
        return true;
    }

    @Override
    public Byte[] bytesGetter() {
        Byte[] aActionSequObject = new Byte[]{(byte)2, (byte)2, (byte)-1, (byte)-1, (byte)-1, (byte)-1, (byte)-1, (byte)-1};
        int nJumpOffset = 0;
        try {
            nJumpOffset = ((FCOCSequActionPan)this.m_JumpLabChoice.getSelectedItem()).getIndex() - this.getIndex();
        }
        catch (NullPointerException e) {
            System.err.println("Error in JumpRel action at line " + this.getIndex() + " : nJumpOffset calculation failed.");
        }
        FCOCUtils.intToByteArrayLE(nJumpOffset, aActionSequObject, 2, 3);
        return aActionSequObject;
    }

    @Override
    public String toString() {
        String szLabel = String.valueOf(this.getSzIndex()) + "Jump to ";
        szLabel = this.m_JumpLabChoice.getModel().getSize() > 0 ? String.valueOf(szLabel) + ((FCOCSequActionLabel)this.m_JumpLabChoice.getSelectedItem()).getLabelName() : String.valueOf(szLabel) + this.m_JumpOffset;
        return szLabel;
    }
}

