/*
 * Decompiled with CFR 0.152.
 */
package com.fiveco.ledsequ;

import com.fiveco.jcomponents.FCOCGridBagJPanel;
import com.fiveco.ledsequ.FCOCSequActionPan;
import com.fiveco.utils.FCOCUtils;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

abstract class FCOCSequActionI2CAtByte1
extends FCOCSequActionPan
implements ChangeListener,
ItemListener {
    private final String[] m_aszSOURCES = new String[]{"Literal", "From var"};
    private final JComboBox<String> m_SourceChoice = new JComboBox<String>(this.m_aszSOURCES);
    private final JSpinner m_I2CAdd = new JSpinner(new SpinnerNumberModel(85, 8, 119, 1));
    private final JLabel m_I2CAddHex = new JLabel("", 4);
    private final JComboBox<String> m_I2CAddVarNum = new JComboBox<String>(m_aszVarShortList);
    private int m_nByteIndex = 1;
    private int m_nLeftShift = 0;

    FCOCSequActionI2CAtByte1(int nTopInset, int nLeftInset, int nBottomInset, int bRightInset, Byte[] aActionSequObject, int nDefaultAdd, int nColumns, int nByteIndex, int nLeftShift) throws IllegalArgumentException {
        super(nTopInset, nLeftInset, nBottomInset, bRightInset);
        if (this.m_nLeftShift > 1) {
            throw new IllegalArgumentException("Shift > 1 not supported in FCOCSequActionI2CAtByte1");
        }
        this.m_nByteIndex = nByteIndex;
        this.m_nLeftShift = nLeftShift;
        this.init(aActionSequObject, nDefaultAdd, nColumns);
    }

    FCOCSequActionI2CAtByte1(int nTopInset, int nLeftInset, int nBottomInset, int bRightInset, Byte[] aActionSequObject, int nDefaultAdd, int nColumns) {
        super(nTopInset, nLeftInset, nBottomInset, bRightInset);
        this.init(aActionSequObject, nDefaultAdd, nColumns);
    }

    FCOCSequActionI2CAtByte1(Byte[] aActionSequObject, int nDefaultAdd, int nColumns, int nByteIndex, int nLeftShift) throws IllegalArgumentException {
        if (this.m_nLeftShift > 1) {
            throw new IllegalArgumentException("Shift > 1 not supported in FCOCSequActionI2CAtByte1");
        }
        this.m_nByteIndex = nByteIndex;
        this.m_nLeftShift = nLeftShift;
        this.init(aActionSequObject, nDefaultAdd, nColumns);
    }

    FCOCSequActionI2CAtByte1(Byte[] aActionSequObject, int nDefaultAdd, int nColumns) {
        this.init(aActionSequObject, nDefaultAdd, nColumns);
    }

    FCOCSequActionI2CAtByte1(Byte[] aActionSequObject, int nDefaultAdd) {
        this.init(aActionSequObject, nDefaultAdd, 2);
    }

    private void init(Byte[] aActionSequObject, int nDefaultAdd, int nColumns) {
        FCOCGridBagJPanel AddPan = new FCOCGridBagJPanel(1, 1, 1, 1);
        this.add((Component)new JLabel("I2C address:"), 0, 0);
        int nAdd = (aActionSequObject[this.m_nByteIndex].intValue() & 0xFF) >> this.m_nLeftShift;
        if (nAdd < 8) {
            nAdd = nDefaultAdd;
        }
        this.m_SourceChoice.addItemListener(this);
        if (nAdd < 120) {
            this.m_I2CAdd.setValue(nAdd);
            this.m_SourceChoice.setSelectedIndex(0);
        } else {
            this.m_I2CAdd.setValue(nDefaultAdd);
            this.m_SourceChoice.setSelectedIndex(1);
            this.m_I2CAddVarNum.setSelectedIndex(nAdd - 120);
        }
        this.itemStateChanged(new ItemEvent(this.m_SourceChoice, 0, "", 0));
        AddPan.add((Component)this.m_SourceChoice, 0, 0);
        AddPan.add((Component)this.m_I2CAdd, 1, 0);
        this.m_I2CAdd.addChangeListener(this);
        this.m_I2CAddHex.setText("0x" + FCOCUtils.toHexString(nAdd));
        AddPan.add((Component)this.m_I2CAddHex, 2, 0);
        AddPan.add(this.m_I2CAddVarNum, 1, 0, 2, 1);
        this.add(AddPan, 1, 0, nColumns - 1, 1);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (e.getSource() == this.m_I2CAdd) {
            this.m_I2CAddHex.setText("0x" + FCOCUtils.toHexString((Integer)this.m_I2CAdd.getValue()));
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getSource() == this.m_SourceChoice) {
            if (this.m_SourceChoice.getSelectedIndex() == 0) {
                this.m_I2CAddVarNum.setVisible(false);
                this.m_I2CAdd.setVisible(true);
                this.m_I2CAddHex.setVisible(true);
            } else {
                this.m_I2CAddVarNum.setVisible(true);
                this.m_I2CAdd.setVisible(false);
                this.m_I2CAddHex.setVisible(false);
            }
        }
    }

    @Override
    public abstract Byte[] bytesGetter();

    public Byte[] bytesGetter(int nActionId) {
        Byte[] aActionSequObject = new Byte[]{(byte)nActionId, (byte)-1, (byte)-1, (byte)-1, (byte)-1, (byte)-1, (byte)-1, (byte)-1};
        int nAdd = this.m_SourceChoice.getSelectedIndex() == 0 ? ((SpinnerNumberModel)this.m_I2CAdd.getModel()).getNumber().intValue() : 120 + this.m_I2CAddVarNum.getSelectedIndex();
        aActionSequObject[this.m_nByteIndex] = (byte)(nAdd << this.m_nLeftShift);
        return aActionSequObject;
    }

    protected String I2CAddToString() {
        if (this.m_SourceChoice.getSelectedIndex() == 0) {
            return "" + ((SpinnerNumberModel)this.m_I2CAdd.getModel()).getNumber().intValue();
        }
        return "" + this.m_I2CAddVarNum.getSelectedItem();
    }

    @Override
    public abstract String toString();
}

