/*
 * Decompiled with CFR 0.152.
 */
package com.fiveco.ledsequ;

import com.fiveco.devices.FCOCDevice;
import com.fiveco.devices.FCOCIPDevice;
import com.fiveco.devices.FCOIIPDeviceEvent;
import com.fiveco.utils.FCOCUtils;
import com.fiveco.utils.FCOISimpleEvent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumnModel;

public class FCOCScanDevices
extends JFrame
implements Runnable,
FCOIIPDeviceEvent,
ActionListener {
    private final JButton m_ScanB = new JButton("Scan bus to find devices...");
    private JTable m_ResultTable;
    private final JLabel m_WarnL = new JLabel("Warning : Address 0x68 (104) is not displayed (RTC reserved) !");
    private String[] m_szNewRow = new String[]{"", "", "", ""};
    private FCOISimpleEvent m_ScanNetEvtInterface;
    private boolean m_isScanning = false;
    private String m_szIPAddress;
    private final String m_szI2CSEQNAME = "Sequencer";
    FCOCIPDevice m_FModTCP;
    private int nCurI2CAdd = 8;
    private EState State;

    public FCOCScanDevices(FCOISimpleEvent ScanNetEvtInterface, String szIPDevice, int nX, int nY) {
        super("Scan devices on I2C bus");
        try {
            ArrayList<Image> imageList = new ArrayList<Image>();
            imageList.add(Toolkit.getDefaultToolkit().getImage(FCOCScanDevices.class.getResource("/images/logo198px.gif")));
            imageList.add(Toolkit.getDefaultToolkit().getImage(FCOCScanDevices.class.getResource("/images/logo75px.gif")));
            imageList.add(Toolkit.getDefaultToolkit().getImage(FCOCScanDevices.class.getResource("/images/logo40px.gif")));
            imageList.add(Toolkit.getDefaultToolkit().getImage(FCOCScanDevices.class.getResource("/images/logo32px.png")));
            this.setIconImages(imageList);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (ScanNetEvtInterface == null) {
            throw new NullPointerException("ScanNetEvtInterface is null !");
        }
        this.m_ScanNetEvtInterface = ScanNetEvtInterface;
        if (szIPDevice == null) {
            throw new NullPointerException("IPDevice is null !");
        }
        this.m_szIPAddress = szIPDevice;
        this.m_ScanB.addActionListener(this);
        this.m_WarnL.setForeground(Color.red);
        JPanel TopPane = new JPanel();
        TopPane.add(this.m_ScanB);
        TopPane.add(this.m_WarnL);
        TopPane.setPreferredSize(new Dimension(420, 60));
        Object[][] aszTableData = new String[][]{new String[0]};
        Object[] aszColumns = new String[]{"Address", "Type", "Version", "Name"};
        DefaultTableModel ResultTableModel = new DefaultTableModel(aszTableData, aszColumns);
        this.m_ResultTable = new JTable(ResultTableModel){

            @Override
            public boolean isCellEditable(int rowIndex, int vColIndex) {
                return false;
            }
        };
        this.m_ResultTable.setSelectionMode(0);
        JScrollPane TablePane = new JScrollPane(this.m_ResultTable);
        JPanel CenterPane = new JPanel();
        CenterPane.setLayout(new BoxLayout(CenterPane, 2));
        JPanel tableContainer = new JPanel(new GridLayout(1, 1));
        tableContainer.setBorder(BorderFactory.createTitledBorder("Devices Found"));
        tableContainer.add(TablePane);
        TablePane.setPreferredSize(new Dimension(520, 130));
        CenterPane.setBorder(BorderFactory.createEmptyBorder(5, 5, 0, 5));
        CenterPane.add(tableContainer);
        TableColumnModel TableColsModel = this.m_ResultTable.getColumnModel();
        TableColsModel.getColumn(0).setPreferredWidth(60);
        TableColsModel.getColumn(1).setPreferredWidth(40);
        TableColsModel.getColumn(2).setPreferredWidth(110);
        TableColsModel.getColumn(3).setPreferredWidth(180);
        this.setSize(400, 400);
        this.setMinimumSize(new Dimension(400, 200));
        this.setResizable(true);
        GraphicsDevice gd = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
        int nMonWidth = gd.getDisplayMode().getWidth();
        if (nX > nMonWidth - 400) {
            nX = nMonWidth - 400;
        }
        this.setLocation(nX, nY);
        JPanel Pane = new JPanel();
        BorderLayout MainLayout = new BorderLayout();
        Pane.setLayout(MainLayout);
        Pane.add((Component)TopPane, "North");
        Pane.add((Component)CenterPane, "Center");
        this.setContentPane(Pane);
        this.setDefaultCloseOperation(2);
    }

    private void startScan() {
        this.m_ScanB.setEnabled(false);
        this.clearTable();
        Object[] szNewRow = new String[]{"", "", "", "Scanning..."};
        ((DefaultTableModel)this.m_ResultTable.getModel()).addRow(szNewRow);
        try {
            this.m_FModTCP = new FCOCIPDevice(this.m_szIPAddress, 32, this);
            this.m_FModTCP.setThreadSleepTime(10L);
            this.m_FModTCP.addSubDevice("Sequencer", 85, 80, 0);
            this.m_FModTCP.addI2CDeviceRegister("Sequencer", "SeqBridgeCmd", 84, 3, 3, 5, false);
            this.m_FModTCP.addI2CDeviceRegister("Sequencer", "SeqBridgeValue", 85, 16, 3, 5, false);
            this.m_isScanning = true;
            this.nCurI2CAdd = 8;
            this.State = EState.GETADD;
            Byte[] NewCmd = new Byte[]{(byte)(this.nCurI2CAdd << 1 | 1), (byte)0, (byte)-60};
            this.m_FModTCP.setI2CValue("Sequencer", "SeqBridgeCmd", NewCmd, true);
            this.m_FModTCP.getI2CValue("Sequencer", "SeqBridgeCmd");
        }
        catch (Exception e) {
            System.err.println("Exception : Create FiveCo device failed (" + e.getLocalizedMessage() + ")");
            this.endScan();
            this.clearTable();
            Object[] szFailedRow = new String[]{"", "", "", "Scan failed ! Cannot create device."};
            ((DefaultTableModel)this.m_ResultTable.getModel()).addRow(szFailedRow);
        }
    }

    private void endScan() {
        if (this.m_FModTCP != null) {
            this.m_FModTCP.delete();
        }
        this.m_FModTCP = null;
        this.m_isScanning = false;
        this.m_ScanB.setEnabled(true);
    }

    private void clearTable() {
        DefaultTableModel ResultTableModel = (DefaultTableModel)this.m_ResultTable.getModel();
        while (ResultTableModel.getRowCount() > 0) {
            ResultTableModel.removeRow(0);
        }
    }

    public void start() {
        this.startScan();
        this.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent ActEvent) {
        Object EventSource = ActEvent.getSource();
        if (EventSource == this.m_ScanB) {
            this.startScan();
        }
    }

    @Override
    public void comDevEvtOccured(FCOCDevice Source, int nCause) {
        if (this.m_isScanning && nCause != 0 && nCause != 1) {
            this.endScan();
            this.clearTable();
            Object[] szFailedRow = new String[]{"", "", "", "Scan failed ! TCP connection error."};
            ((DefaultTableModel)this.m_ResultTable.getModel()).addRow(szFailedRow);
        }
    }

    @Override
    public void dataDevEvtOccured(FCOCDevice Source, String szRegisterName, Object Data) {
    }

    @Override
    public void comI2CEvtOccured(FCOCIPDevice Source, String szI2CDeviceName, int nCause) {
        if (nCause != 0) {
            this.endScan();
            this.clearTable();
            Object[] szFailedRow = new String[]{"", "", "", "Scan failed ! I2C connection error."};
            ((DefaultTableModel)this.m_ResultTable.getModel()).addRow(szFailedRow);
        }
    }

    @Override
    public void dataI2CDevEvtOccured(FCOCIPDevice Source, String szI2CDeviceName, String szRegisterName, Object Data) {
        DefaultTableModel ResultTableModel = (DefaultTableModel)this.m_ResultTable.getModel();
        try {
            switch (szRegisterName) {
                case "SeqBridgeCmd": {
                    Byte[] SeqBridgeCmd = (Byte[])Data;
                    if ((SeqBridgeCmd[2].intValue() & 0x40) == 64) {
                        this.m_FModTCP.getI2CValue("Sequencer", "SeqBridgeCmd");
                        break;
                    }
                    if (this.State == EState.GETADD) {
                        if ((SeqBridgeCmd[2].intValue() & 0x20) == 32) {
                            this.m_szNewRow[0] = "0x" + FCOCUtils.toHexString(this.nCurI2CAdd) + " (" + this.nCurI2CAdd + ")";
                            this.m_szNewRow[1] = "";
                            this.m_szNewRow[2] = "";
                            this.m_szNewRow[3] = "";
                            this.State = EState.GETTYPE;
                        } else {
                            this.State = EState.SKIP;
                        }
                    } else if (this.State == EState.GETTYPE) {
                        this.State = EState.GETVERSION;
                    } else if (this.State == EState.GETVERSION) {
                        this.State = EState.GETNAME;
                    }
                    this.m_FModTCP.getI2CValue("Sequencer", "SeqBridgeValue");
                    break;
                }
                case "SeqBridgeValue": {
                    Byte[] SeqBridgeValue = (Byte[])Data;
                    if (this.State == EState.GETTYPE) {
                        this.m_szNewRow[1] = String.valueOf(FCOCUtils.byteArrayLEToInt(SeqBridgeValue, 2, 2)) + "." + FCOCUtils.byteArrayLEToInt(SeqBridgeValue, 0, 2);
                        Byte[] NewCmd = new Byte[]{(byte)(this.nCurI2CAdd << 1 | 1), (byte)1, (byte)-60};
                        this.m_FModTCP.setI2CValue("Sequencer", "SeqBridgeCmd", NewCmd, true);
                        this.m_FModTCP.getI2CValue("Sequencer", "SeqBridgeCmd");
                        break;
                    }
                    if (this.State == EState.GETVERSION) {
                        this.m_szNewRow[2] = SeqBridgeValue[4].intValue() == 0 ? "FW:" + FCOCUtils.byteArrayLEToInt(SeqBridgeValue, 2, 2) + "." + FCOCUtils.byteArrayLEToInt(SeqBridgeValue, 0, 2) : "HW:" + FCOCUtils.byteArrayLEToInt(SeqBridgeValue, 3, 1) + "." + FCOCUtils.byteArrayLEToInt(SeqBridgeValue, 2, 1) + "/" + "FW:" + FCOCUtils.byteArrayLEToInt(SeqBridgeValue, 1, 1) + "." + FCOCUtils.byteArrayLEToInt(SeqBridgeValue, 0, 1);
                        Byte[] NewCmd = new Byte[]{(byte)(this.nCurI2CAdd << 1 | 1), (byte)21, (byte)-48};
                        this.m_FModTCP.setI2CValue("Sequencer", "SeqBridgeCmd", NewCmd, true);
                        this.m_FModTCP.getI2CValue("Sequencer", "SeqBridgeCmd");
                        break;
                    }
                    if (this.State == EState.GETNAME) {
                        StringBuilder sb = new StringBuilder();
                        int i = 15;
                        while (SeqBridgeValue[i].intValue() != 0) {
                            sb.append((char)SeqBridgeValue[i--].byteValue());
                            if (i < 0) break;
                        }
                        this.m_szNewRow[3] = sb.toString();
                        ResultTableModel.insertRow(ResultTableModel.getRowCount() - 1, this.m_szNewRow);
                    }
                    this.State = EState.GETADD;
                    ++this.nCurI2CAdd;
                    if (this.nCurI2CAdd == 104) {
                        ++this.nCurI2CAdd;
                    }
                    if (this.nCurI2CAdd < 120) {
                        Byte[] NewCmd = new Byte[]{(byte)(this.nCurI2CAdd << 1 | 1), (byte)0, (byte)-60};
                        this.m_FModTCP.setI2CValue("Sequencer", "SeqBridgeCmd", NewCmd, true);
                        this.m_FModTCP.getI2CValue("Sequencer", "SeqBridgeCmd");
                        break;
                    }
                    this.endScan();
                    ResultTableModel.removeRow(ResultTableModel.getRowCount() - 1);
                    Object[] szFailedRow = new String[]{"", "", "", "Scan finished !"};
                    ResultTableModel.addRow(szFailedRow);
                    break;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void run() {
        DefaultTableModel ResultTableModel = (DefaultTableModel)this.m_ResultTable.getModel();
        while (ResultTableModel.getRowCount() > 0) {
            ResultTableModel.removeRow(0);
        }
    }

    @Override
    public void autoreadRegAddedToQueue(FCOCDevice Source, String szRegisterName) {
    }

    @Override
    public void autoreadI2CRegAddedToQueue(FCOCDevice Source, String szI2CDeviceName, String szRegisterName) {
    }

    private static enum EState {
        GETADD,
        GETTYPE,
        GETVERSION,
        GETNAME,
        SKIP;

    }
}

