/*
 * Decompiled with CFR 0.152.
 */
package com.fiveco.jcomponents;

import com.fiveco.jcomponents.FCOCDraggableTabbedPane;
import com.fiveco.jcomponents.GhostGlassPane;
import java.awt.Component;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;

class TabDropTargetListener
implements DropTargetListener {
    private Point prevGlassPt = new Point();

    TabDropTargetListener() {
    }

    @Override
    public void dragEnter(DropTargetDragEvent e) {
        DataFlavor[] f;
        Component c = e.getDropTargetContext().getComponent();
        if (!(c instanceof GhostGlassPane)) {
            return;
        }
        GhostGlassPane glassPane = (GhostGlassPane)c;
        FCOCDraggableTabbedPane tabbedPane = glassPane.tabbedPane;
        Transferable t = e.getTransferable();
        if (t.isDataFlavorSupported((f = e.getCurrentDataFlavors())[0]) && tabbedPane.dragTabIndex >= 0) {
            e.acceptDrag(e.getDropAction());
        } else {
            e.rejectDrag();
        }
    }

    @Override
    public void dragExit(DropTargetEvent e) {
        Component c = e.getDropTargetContext().getComponent();
        System.out.println("DropTargetListener#dragExit: " + c.getName());
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent e) {
    }

    @Override
    public void dragOver(DropTargetDragEvent e) {
        Component c = e.getDropTargetContext().getComponent();
        if (!(c instanceof GhostGlassPane)) {
            return;
        }
        GhostGlassPane glassPane = (GhostGlassPane)c;
        FCOCDraggableTabbedPane tabbedPane = glassPane.tabbedPane;
        Point glassPt = e.getLocation();
        if (tabbedPane.getTabPlacement() == 1 || tabbedPane.getTabPlacement() == 3) {
            tabbedPane.initTargetLeftRightLine(tabbedPane.getTargetTabIndex(glassPt));
        } else {
            tabbedPane.initTargetTopBottomLine(tabbedPane.getTargetTabIndex(glassPt));
        }
        if (tabbedPane.hasGhost) {
            glassPane.setPoint(glassPt);
        }
        if (!this.prevGlassPt.equals(glassPt)) {
            glassPane.repaint();
        }
        this.prevGlassPt = glassPt;
        tabbedPane.autoScrollTest(glassPt);
    }

    @Override
    public void drop(DropTargetDropEvent e) {
        DataFlavor[] f;
        Component c = e.getDropTargetContext().getComponent();
        if (!(c instanceof GhostGlassPane)) {
            return;
        }
        GhostGlassPane glassPane = (GhostGlassPane)c;
        FCOCDraggableTabbedPane tabbedPane = glassPane.tabbedPane;
        Transferable t = e.getTransferable();
        if (t.isDataFlavorSupported((f = t.getTransferDataFlavors())[0]) && tabbedPane.dragTabIndex >= 0) {
            tabbedPane.convertTab(tabbedPane.dragTabIndex, tabbedPane.getTargetTabIndex(e.getLocation()));
            e.dropComplete(true);
        } else {
            e.dropComplete(false);
        }
        tabbedPane.dragTabIndex = -1;
        glassPane.setTargetRect(0, 0, 0, 0);
        glassPane.setVisible(false);
        glassPane.setImage(null);
        tabbedPane.repaint();
    }
}

