/*
 * Decompiled with CFR 0.152.
 */
package com.fiveco.jcomponents;

import com.fiveco.jcomponents.FCOCDraggableTabbedPane;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import javax.swing.JPanel;

class GhostGlassPane
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final AlphaComposite ALPHA = AlphaComposite.getInstance(3, 0.5f);
    public final FCOCDraggableTabbedPane tabbedPane;
    private final Rectangle lineRect = new Rectangle();
    private final Color lineColor = new Color(0, 100, 255);
    private Point location = new Point(0, 0);
    private transient BufferedImage draggingGhost;

    public GhostGlassPane(FCOCDraggableTabbedPane tabbedPane) {
        this.tabbedPane = tabbedPane;
        this.setOpaque(false);
    }

    public void setTargetRect(int x, int y, int width, int height) {
        this.lineRect.setRect(x, y, width, height);
    }

    public void setImage(BufferedImage draggingGhost) {
        this.draggingGhost = draggingGhost;
    }

    public void setPoint(Point location) {
        this.location = location;
    }

    @Override
    public void paintComponent(Graphics g) {
        Graphics2D g2 = (Graphics2D)g.create();
        g2.setComposite(ALPHA);
        if (this.tabbedPane.isPaintScrollArea && this.tabbedPane.getTabLayoutPolicy() == 1) {
            g2.setPaint(Color.RED);
            g2.fill(this.tabbedPane.rBackward);
            g2.fill(this.tabbedPane.rForward);
        }
        if (this.draggingGhost != null) {
            double xx = this.location.getX() - (double)this.draggingGhost.getWidth(this) / 2.0;
            double yy = this.location.getY() - (double)this.draggingGhost.getHeight(this) / 2.0;
            g2.drawImage((Image)this.draggingGhost, (int)xx, (int)yy, null);
        }
        if (this.tabbedPane.dragTabIndex >= 0) {
            g2.setPaint(this.lineColor);
            g2.fill(this.lineRect);
        }
        g2.dispose();
    }
}

