/*
 * Decompiled with CFR 0.152.
 */
package com.fiveco.errlog;

import java.awt.Component;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.Properties;
import javax.swing.JOptionPane;

public class FCOCErrLog {
    private File m_LogFile = null;
    private String m_szLogFileName;
    private OutputStream m_OutOS = null;
    private OutputStream m_ErrOS = null;
    private final PrintStream m_OutPS;
    private final PrintStream m_ErrPS;
    private static int m_nMAXFILESIZE = 0xA00000;

    public FCOCErrLog(Component ParentComp, String szLogFileName, String szVersion) throws FileNotFoundException {
        if (szLogFileName != null && szLogFileName.length() > 0) {
            this.m_szLogFileName = szLogFileName;
            this.m_LogFile = this.getFileToUse(szLogFileName);
            PrintWriter writer = new PrintWriter(new FileOutputStream(this.m_LogFile, true));
            String zsTitle = "Log session started on " + Calendar.getInstance().getTime() + " for " + szVersion;
            String szLine = "";
            int i = 0;
            while (i < zsTitle.length()) {
                szLine = String.valueOf(szLine) + "-";
                ++i;
            }
            writer.println("\r\n" + szLine);
            writer.println(zsTitle);
            writer.println(szLine);
            Properties SysProp = System.getProperties();
            Enumeration<Object> keys = SysProp.keys();
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                String value = (String)SysProp.get(key);
                writer.println(String.valueOf(key) + ": " + value);
            }
            writer.println(szLine);
            writer.close();
            this.m_OutOS = new CErrFileOutputStream(this.m_LogFile, true, "Mesg");
            this.m_ErrOS = new CErrFileOutputStream(this.m_LogFile, true, "Error");
        } else {
            this.m_OutOS = new CErrDispOutputStream(ParentComp, "Message", 1);
            this.m_ErrOS = new CErrDispOutputStream(ParentComp, "Error", 0);
        }
        this.m_OutPS = new PrintStream(this.m_OutOS, true);
        this.m_ErrPS = new PrintStream(this.m_ErrOS, true);
    }

    private File getFileToUse(String szLogFileName) {
        String szLogFileNameNoExt = szLogFileName.substring(0, szLogFileName.indexOf(".", szLogFileName.lastIndexOf("/")));
        String szLogFileExt = szLogFileName.substring(szLogFileName.indexOf(".", szLogFileName.lastIndexOf("/")));
        File LogFile = new File(szLogFileName);
        int i = 0;
        while (LogFile.exists()) {
            LogFile = new File(String.valueOf(szLogFileNameNoExt) + "_" + i++ + szLogFileExt);
        }
        return LogFile;
    }

    public PrintStream getOutPS() {
        return this.m_OutPS;
    }

    public PrintStream getErrPS() {
        return this.m_ErrPS;
    }

    public boolean errorsOccurred() {
        if (this.m_ErrOS.getClass() == CErrFileOutputStream.class) {
            return ((CErrFileOutputStream)this.m_ErrOS).hasBeenUsed();
        }
        return false;
    }

    private class CErrDispOutputStream
    extends ByteArrayOutputStream {
        private final String m_szTitle;
        private final Component m_ParentComp;
        private final int m_nMessageType;

        public CErrDispOutputStream(Component ParentComp, String szTitle, int nMessageType) {
            this.m_ParentComp = ParentComp;
            this.m_szTitle = szTitle;
            this.m_nMessageType = nMessageType;
        }

        @Override
        public void flush() throws IOException {
            super.flush();
            if (this.toString().trim().length() > 0) {
                JOptionPane.showMessageDialog(this.m_ParentComp, this.toString(), this.m_szTitle, this.m_nMessageType);
            }
            this.reset();
        }
    }

    private class CErrFileOutputStream
    extends FileOutputStream {
        private final String m_szType;
        private boolean m_hasBeenUsed;
        private boolean m_isFileSizeWarningDone;
        private boolean m_isBeginningOfLine;

        public CErrFileOutputStream(File oFile, boolean isAppend, String szType) throws FileNotFoundException {
            super(oFile, isAppend);
            this.m_hasBeenUsed = false;
            this.m_isFileSizeWarningDone = false;
            this.m_isBeginningOfLine = true;
            this.m_szType = szType;
        }

        @Override
        public void flush() throws IOException {
            super.flush();
            this.m_hasBeenUsed = true;
            if (!this.m_isFileSizeWarningDone && FCOCErrLog.this.m_LogFile.length() > (long)m_nMAXFILESIZE) {
                JOptionPane.showMessageDialog(null, "Log file " + FCOCErrLog.this.m_szLogFileName + " begins to be too big ! Check it now.", "Warning", 2);
                this.m_isFileSizeWarningDone = true;
            }
        }

        private String getFCOCallerClassName() {
            StackTraceElement[] stElements = Thread.currentThread().getStackTrace();
            int i = 1;
            while (i < stElements.length) {
                StackTraceElement ste = stElements[i];
                if (ste.getClassName().contains("com.fiveco") && !ste.getClassName().contains("FCOCErrLog")) {
                    return ste.getClassName();
                }
                ++i;
            }
            return null;
        }

        @Override
        public void write(byte[] achData, int nOffset, int nLen) throws IOException {
            if (this.m_isBeginningOfLine) {
                this.m_isBeginningOfLine = false;
                String szHeader = String.valueOf(this.m_szType) + " - " + Calendar.getInstance().getTime() + " - " + this.getFCOCallerClassName() + " - ";
                super.write(szHeader.getBytes());
            }
            if (achData[nOffset + nLen - 1] == 13 || achData[nOffset + nLen - 2] == 13) {
                this.m_isBeginningOfLine = true;
            }
            super.write(achData, nOffset, nLen);
        }

        @Override
        public void write(byte[] achData) throws IOException {
            this.write(achData, 0, achData.length);
        }

        @Override
        public void write(int nChar) throws IOException {
            byte[] achData = new byte[]{(byte)nChar};
            this.write(achData, 0, 1);
        }

        public boolean hasBeenUsed() {
            return this.m_hasBeenUsed;
        }
    }
}

