/*
 * Decompiled with CFR 0.152.
 */
package com.fiveco.devices;

import Serialio.SerialConfig;
import Serialio.SerialPortLocal;
import com.fiveco.devices.FCOCDevice;
import com.fiveco.devices.FCOCRegisterBase;
import com.fiveco.devices.FCOIDeviceEvent;
import com.fiveco.utils.FCOCUtils;
import java.io.IOException;
import java.util.BitSet;
import java.util.Calendar;
import java.util.Hashtable;

public class FCOCRAPDevice
extends FCOCDevice {
    private final int m_nLocalAddress;
    private int m_nRemoteAddress;
    private SerialConfig m_SerCfg;
    private final boolean m_isNested;
    private boolean m_isOtherDevice = false;
    private final Hashtable<String, FCOCRAPDevice> m_OtherDevicesList = new Hashtable();
    private int m_nLastOtherDevice = -1;
    private final Hashtable<String, FCOCRAPDevice> m_NestedDevicesList = new Hashtable();
    private int m_nLastRoutedNestedDevice = 0;
    private int m_nInterface = 0;
    private int m_nDevicesStep = 0;

    public FCOCRAPDevice(int nNumberOfRegisters, FCOIDeviceEvent DeviceEvent, int nBufferSize, long lThreadSleep, SerialConfig SerCfg, int nLocalAddress, int nRemoteAddress, boolean isNested, int nInterface) throws IOException {
        super(nNumberOfRegisters, DeviceEvent, nBufferSize, lThreadSleep);
        if (nBufferSize > 127) {
            throw new IllegalArgumentException("This FRAP protocol implementation does not support packet size greater than 127 bytes !");
        }
        if (nLocalAddress < 1 || nLocalAddress > 255) {
            throw new IllegalArgumentException("Local address must be between 1 and 255 !");
        }
        if (nRemoteAddress < 0 || nRemoteAddress > 255) {
            throw new IllegalArgumentException("Remote address must be between 0 and 255 !");
        }
        this.m_nLocalAddress = nLocalAddress;
        this.m_nRemoteAddress = nRemoteAddress;
        this.m_isNested = isNested;
        if (!isNested) {
            if (SerCfg == null || SerCfg.getClass() != SerialConfig.class) {
                throw new IllegalArgumentException("Invalid serial config object !");
            }
            this.m_SerCfg = SerCfg;
            this.m_ComThread.start();
        } else {
            if (nInterface == -1) {
                this.m_isOtherDevice = true;
            } else if (nInterface < 0 || nInterface > 15) {
                throw new IllegalArgumentException("Interface num must be between 0 and 15 !");
            }
            this.m_nInterface = nInterface;
        }
    }

    public FCOCRAPDevice(int nNumberOfRegisters, FCOIDeviceEvent DeviceEvent, int nBufferSize, SerialConfig SerCfg, int nLocalAddress, int nRemoteAddress, boolean isNested, int nInterface) throws IOException {
        super(nNumberOfRegisters, DeviceEvent, nBufferSize);
        if (nBufferSize > 127) {
            throw new IllegalArgumentException("This FRAP protocol implementation does not support packet size greater than 127 bytes !");
        }
        if (nLocalAddress < 1 || nLocalAddress > 255) {
            throw new IllegalArgumentException("Local address must be between 1 and 255 !");
        }
        if (nRemoteAddress < 0 || nRemoteAddress > 255) {
            throw new IllegalArgumentException("Remote address must be between 0 and 255 !");
        }
        this.m_nLocalAddress = nLocalAddress;
        this.m_nRemoteAddress = nRemoteAddress;
        this.m_isNested = isNested;
        if (!isNested) {
            if (SerCfg == null || SerCfg.getClass() != SerialConfig.class) {
                throw new IllegalArgumentException("Invalid serial config object !");
            }
            this.m_SerCfg = SerCfg;
            this.m_ComThread.start();
        } else {
            if (nInterface == -1) {
                this.m_isOtherDevice = true;
            } else if (nInterface < 0 || nInterface > 15) {
                throw new IllegalArgumentException("Interface num must be between 0 and 15 !");
            }
            this.m_nInterface = nInterface;
        }
    }

    @Override
    public void delete() {
        if (!this.m_ComThread.isAlive()) {
            return;
        }
        int nTimeout = 20;
        while (this.m_WriteQueue.size() > 0 && nTimeout-- > 0) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.m_isThreadEnabled = false;
        nTimeout = 20;
        while (this.m_ComThread.isAlive() && nTimeout-- > 0) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public void setNewRemoteAddress(int nRemoteAddress) {
        if (nRemoteAddress < 0 || nRemoteAddress > 255) {
            throw new IllegalArgumentException("Remote address must be between 0 and 255 !");
        }
        this.m_nRemoteAddress = nRemoteAddress;
    }

    public int getRemoteAddress() {
        return this.m_nRemoteAddress;
    }

    @Override
    public void addRegister(String szRegisterName, int nRegisterAddress, int nRegisterSize, int nRegisterAccessType, int nDataType, boolean isAutoReadEnabled) throws IllegalArgumentException {
        if (nRegisterSize > 31) {
            throw new IllegalArgumentException("Register size cannot be greater than 31 for FRAP protocol !");
        }
        super.addRegister(szRegisterName, nRegisterAddress, nRegisterSize, nRegisterAccessType, nDataType, isAutoReadEnabled);
    }

    public FCOCDevice addOtherDevice(String szOtherDeviceName, int nAddress, int nNumberOfRegisters) throws IOException {
        FCOCRAPDevice OtherDevice = new FCOCRAPDevice(nNumberOfRegisters, this.m_DeviceEvent, this.m_nBufferSize, null, this.m_nLocalAddress, nAddress, true, -1);
        this.m_OtherDevicesList.put(szOtherDeviceName, OtherDevice);
        return OtherDevice;
    }

    public void removeOtherDevice(String szOtherDeviceName) {
        this.m_OtherDevicesList.remove(szOtherDeviceName);
    }

    @Override
    public FCOCDevice addSubDevice(String szNestedDeviceName, int nSubAddress, int nNumberOfRegisters, int nInterface) throws IOException {
        FCOCRAPDevice NestedDevice = null;
        NestedDevice = new FCOCRAPDevice(nNumberOfRegisters, this.m_DeviceEvent, this.m_nBufferSize, null, this.m_nLocalAddress, nSubAddress, true, nInterface);
        this.m_NestedDevicesList.put(szNestedDeviceName, NestedDevice);
        return NestedDevice;
    }

    @Override
    public void removeSubDevice(String szNestedDeviceName) {
        this.m_NestedDevicesList.remove(szNestedDeviceName);
    }

    @Override
    protected int fillBufferWithData(FCOCRegisterBase Register, byte[] acBuffer, int nOffset) {
        acBuffer[nOffset++] = (byte)(64 + Register.getSize());
        acBuffer[nOffset++] = (byte)Register.getAddress();
        if (Register.getData() != null) {
            switch (Register.getDataType()) {
                case 0: 
                case 1: {
                    long lValue = (Long)Register.getData();
                    int i = 0;
                    while (i < Register.getSize()) {
                        acBuffer[nOffset++] = (byte)(lValue >> i * 8 & 0xFFL);
                        ++i;
                    }
                    break;
                }
                case 3: {
                    double dPercent = (Double)Register.getData();
                    long lPercent = (long)(Math.pow(2.0, Register.getSize() * 8) * dPercent / 100.0);
                    if ((double)lPercent > Math.pow(2.0, Register.getSize() * 8) - 1.0) {
                        lPercent = (long)(Math.pow(2.0, Register.getSize() * 8) - 1.0);
                    }
                    int i = 0;
                    while (i < Register.getSize()) {
                        acBuffer[nOffset++] = (byte)(lPercent >> i * 8 & 0xFFL);
                        ++i;
                    }
                    break;
                }
                case 2: {
                    BitSet Data = (BitSet)Register.getData();
                    int i = 0;
                    while (i < Register.getSize()) {
                        byte cTemp = 0;
                        int j = 0;
                        while (j < 8) {
                            if (Data.get(8 * i + j)) {
                                cTemp = (byte)(cTemp | 1 << j);
                            }
                            ++j;
                        }
                        acBuffer[nOffset++] = cTemp;
                        ++i;
                    }
                    break;
                }
                case 4: {
                    String szText = (String)Register.getData();
                    if (szText.length() > Register.getSize()) {
                        szText = szText.substring(0, Register.getSize() - 1);
                    }
                    byte[] acText = szText.getBytes();
                    int i = 0;
                    while (i < Register.getSize()) {
                        acBuffer[nOffset++] = i < szText.length() ? acText[i] : (byte)0;
                        ++i;
                    }
                    break;
                }
                case 5: {
                    Byte[] aByte = (Byte[])Register.getData();
                    int i = 0;
                    while (i < Register.getSize()) {
                        acBuffer[nOffset++] = aByte[i];
                        ++i;
                    }
                    break;
                }
                case 6: {
                    double dValue = (Double)Register.getData();
                    long lValue = (long)(dValue * Math.pow(2.0, 8 * Register.getSize() / 2));
                    int i = 0;
                    while (i < Register.getSize()) {
                        acBuffer[nOffset++] = (byte)(lValue >> i * 8 & 0xFFL);
                        ++i;
                    }
                    break;
                }
                case 7: {
                    double dValue = (Double)Register.getData();
                    long lValue = (long)(dValue * Math.pow(2.0, 24 * Register.getSize() / 4));
                    int i = 0;
                    while (i < Register.getSize()) {
                        acBuffer[nOffset++] = (byte)(lValue >> i * 8 & 0xFFL);
                        ++i;
                    }
                    break;
                }
                case 8: {
                    double dValue = (Double)Register.getData();
                    long lValue = (long)(dValue * Math.pow(2.0, 8 * Register.getSize() / 4));
                    int i = 0;
                    while (i < Register.getSize()) {
                        acBuffer[nOffset++] = (byte)(lValue >> i * 8 & 0xFFL);
                        ++i;
                    }
                    break;
                }
                default: {
                    nOffset += Register.getSize();
                }
            }
        }
        return nOffset;
    }

    @Override
    protected int getDataFromBuffer(FCOCRegisterBase Register, byte[] acBuffer, int nOffset) {
        switch (Register.getDataType()) {
            case 0: 
            case 1: 
            case 3: 
            case 6: 
            case 7: 
            case 8: {
                long lValue = 0L;
                int i = 0;
                while (i < Register.getSize()) {
                    long lMask = i == Register.getSize() - 1 && (Register.getDataType() == 0 || Register.getDataType() == 6 || Register.getDataType() == 7 || Register.getDataType() == 8) ? -1L : 255L;
                    lValue |= ((long)acBuffer[nOffset++] & lMask) << i * 8;
                    ++i;
                }
                if (Register.getDataType() == 3) {
                    Register.setData(new Double((double)(100L * lValue) / Math.pow(2.0, Register.getSize() * 8)));
                    break;
                }
                if (Register.getDataType() == 6) {
                    Register.setData(new Double((double)lValue / Math.pow(2.0, 8 * Register.getSize() / 2)));
                    break;
                }
                if (Register.getDataType() == 7) {
                    Register.setData(new Double((double)lValue / Math.pow(2.0, 24 * Register.getSize() / 4)));
                    break;
                }
                if (Register.getDataType() == 8) {
                    Register.setData(new Double((double)lValue / Math.pow(2.0, 8 * Register.getSize() / 4)));
                    break;
                }
                Register.setData(new Long(lValue));
                break;
            }
            case 2: {
                BitSet Data = (BitSet)Register.getData();
                int i = 0;
                while (i < Register.getSize()) {
                    byte cTemp = acBuffer[nOffset++];
                    int j = 0;
                    while (j < 8) {
                        if ((cTemp & 1 << j) == 1 << j) {
                            Data.set(8 * i + j);
                        } else {
                            Data.set(8 * i + j, false);
                        }
                        ++j;
                    }
                    ++i;
                }
                break;
            }
            case 4: {
                Register.setData(FCOCUtils.byteArrayToString(acBuffer, nOffset, Register.getSize()));
                nOffset += Register.getSize();
                break;
            }
            case 5: {
                Byte[] aData = new Byte[Register.getSize()];
                int i = 0;
                while (i < Register.getSize()) {
                    aData[i] = acBuffer[nOffset++];
                    ++i;
                }
                Register.setData(aData);
                break;
            }
            default: {
                nOffset += Register.getSize();
            }
        }
        return nOffset;
    }

    @Override
    public int getInterface() {
        return this.m_nInterface;
    }

    private int[] createRequest(byte[] acBuffer, int nBufferOffset) {
        int nInitialBufferOffset = nBufferOffset;
        this.addAutoreadRegisterToQueue();
        int nReturnBufSize = 0;
        if (this.m_WriteQueue.size() > 0 || this.m_ReadQueue.size() > 0) {
            acBuffer[nBufferOffset + 0] = (byte)this.m_nRemoteAddress;
            acBuffer[nBufferOffset + 1] = this.m_isNested && !this.m_isOtherDevice ? -1 : (byte)this.m_nLocalAddress;
            if (this.m_nRemoteAddress != 0) {
                acBuffer[nBufferOffset + 3] = -31;
                acBuffer[nBufferOffset + 4] = (byte)this.m_nUniqueID++;
                nBufferOffset += 5;
                nReturnBufSize = 7;
            } else {
                nBufferOffset += 3;
                nReturnBufSize = 0;
            }
            FCOCRegisterBase Register = (FCOCRegisterBase)this.m_WriteQueue.peek();
            if (Register != null) {
                while (nBufferOffset + Register.getSize() + 2 < this.m_nBufferSize - 2) {
                    this.m_WriteQueue.poll();
                    nBufferOffset = this.fillBufferWithData(Register, acBuffer, nBufferOffset);
                    Register = (FCOCRegisterBase)this.m_WriteQueue.peek();
                    if (Register != null) continue;
                }
            }
            if ((Register = (FCOCRegisterBase)this.m_ReadQueue.peek()) != null) {
                while (nBufferOffset + 2 < this.m_nBufferSize - 2 && nReturnBufSize + Register.getSize() + 2 < this.m_nBufferSize) {
                    Register = (FCOCRegisterBase)this.m_ReadQueue.poll();
                    acBuffer[nBufferOffset++] = (byte)(0 + Register.getSize());
                    acBuffer[nBufferOffset++] = (byte)Register.getAddress();
                    nReturnBufSize += 2 + Register.getSize();
                    Register = (FCOCRegisterBase)this.m_ReadQueue.peek();
                    if (Register != null) continue;
                }
            }
            acBuffer[nBufferOffset++] = -29;
            int nSize = nBufferOffset - 2 - nInitialBufferOffset;
            acBuffer[nInitialBufferOffset + 2] = (byte)(nSize & 0x7F);
            if (nSize > 127) {
                acBuffer[nInitialBufferOffset + 3] = (byte)(nSize >> 7 & 0x7F);
            }
            int nChecksum = 0;
            int i = nInitialBufferOffset;
            while (i < nBufferOffset) {
                nChecksum += acBuffer[i];
                ++i;
            }
            acBuffer[nBufferOffset++] = (byte)(nChecksum & 0xFF);
        }
        int[] anReturn = new int[]{nBufferOffset, nReturnBufSize};
        return anReturn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    private int handleAnswer(int nBytesReceived, byte[] acBuffer, int nBufferOffset) throws Exception {
        if (nBytesReceived >= 6 && acBuffer[nBufferOffset + 1] == (byte)this.m_nRemoteAddress && (this.m_isNested || acBuffer[nBufferOffset] == (byte)this.m_nLocalAddress)) {
            byte nRxSize = acBuffer[nBufferOffset + 2];
            if (nBytesReceived >= nRxSize + 3) {
                int nChecksum = 0;
                int i = nBufferOffset;
                while (i < nBufferOffset + nRxSize + 2) {
                    nChecksum += acBuffer[i];
                    ++i;
                }
                if (acBuffer[nBufferOffset + nRxSize + 2] == (byte)nChecksum) {
                    if ((acBuffer[nBufferOffset += 3] & 0xD0) == 208 || (acBuffer[nBufferOffset] & 0xE4) == 228 || acBuffer[nBufferOffset++] == -30 && acBuffer[nBufferOffset++] == (byte)(this.m_nUniqueID - 1)) {
                        this.m_DeviceEvent.comDevEvtOccured(this, 1);
                        i = nBufferOffset;
                        while (i < nRxSize + 2 - 1) {
                            switch (acBuffer[i] & 0xFF) {
                                case 32: 
                                case 33: 
                                case 34: 
                                case 35: 
                                case 36: 
                                case 37: 
                                case 38: 
                                case 39: 
                                case 40: 
                                case 41: 
                                case 42: 
                                case 43: 
                                case 44: 
                                case 45: 
                                case 46: 
                                case 47: 
                                case 48: 
                                case 49: 
                                case 50: 
                                case 51: 
                                case 52: 
                                case 53: 
                                case 54: 
                                case 55: 
                                case 56: 
                                case 57: 
                                case 58: 
                                case 59: 
                                case 60: 
                                case 61: 
                                case 62: 
                                case 63: {
                                    int y = i;
                                    for (FCOCRegisterBase RegisterItem : this.m_aRegistersList.values()) {
                                        if (RegisterItem.getAddress() != (acBuffer[i + 1] & 0xFF) || RegisterItem.getSize() != (acBuffer[i] & 0x1F)) continue;
                                        y = this.getDataFromBuffer(RegisterItem, acBuffer, i + 2) - 1;
                                        this.m_DeviceEvent.dataDevEvtOccured(this, this.getKeyFromValue(RegisterItem, this.m_aRegistersList), RegisterItem.getData());
                                    }
                                    i = y;
                                    break;
                                }
                                case 208: 
                                case 209: 
                                case 210: 
                                case 211: 
                                case 212: 
                                case 213: 
                                case 214: 
                                case 215: {
                                    int nInterface = acBuffer[i++] & 0xF;
                                    byte nRouteSize = acBuffer[i++];
                                    Hashtable<String, FCOCRAPDevice> hashtable = this.m_NestedDevicesList;
                                    synchronized (hashtable) {
                                        for (FCOCRAPDevice NestedDevice : this.m_NestedDevicesList.values()) {
                                            if (NestedDevice.getInterface() != nInterface) continue;
                                            i += NestedDevice.handleAnswer(nRouteSize, acBuffer, i);
                                        }
                                        break;
                                    }
                                }
                                case 224: {
                                    ++i;
                                    break;
                                }
                                case 227: {
                                    break;
                                }
                                case 228: {
                                    System.err.println("FRAP handleAnswer frame error received !");
                                    break;
                                }
                            }
                            ++i;
                        }
                        return i;
                    }
                    System.err.println("FRAP handleAnswer frame ID error !");
                } else {
                    this.m_DeviceEvent.comDevEvtOccured(this, 5);
                }
            } else {
                System.err.println("FRAP handleAnswer size error !");
            }
        } else {
            Hashtable<String, FCOCRAPDevice> hashtable = this.m_OtherDevicesList;
            synchronized (hashtable) {
                for (FCOCRAPDevice OtherDevice : this.m_OtherDevicesList.values()) {
                    if (acBuffer[nBufferOffset + 1] != (byte)OtherDevice.getRemoteAddress()) continue;
                    OtherDevice.handleAnswer(nBytesReceived, acBuffer, nBufferOffset);
                    return 0;
                }
            }
            this.m_DeviceEvent.comDevEvtOccured(this, 3);
        }
        return 0;
    }

    private synchronized boolean isNextMain() {
        return this.m_nDevicesStep == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized int[] getNextPacket(byte[] acBuffer, int nBufferOffset, boolean isCalledByMainDevice) throws Exception {
        int[] anReturn = new int[2];
        int nInitialBufferOffset = nBufferOffset;
        switch (this.m_nDevicesStep) {
            case 1: {
                if (!this.m_NestedDevicesList.isEmpty()) {
                    if (this.m_nLastRoutedNestedDevice++ >= this.m_NestedDevicesList.size()) {
                        this.m_nLastRoutedNestedDevice = 0;
                    } else {
                        try {
                            FCOCRAPDevice NextToRoute = (FCOCRAPDevice)this.m_NestedDevicesList.values().toArray()[this.m_nLastRoutedNestedDevice - 1];
                            acBuffer[nBufferOffset++] = (byte)this.m_nRemoteAddress;
                            acBuffer[nBufferOffset++] = (byte)this.m_nLocalAddress;
                            int n = ++nBufferOffset;
                            acBuffer[n] = (byte)(192 + (NextToRoute.getInterface() & 0xF));
                            int n2 = ++nBufferOffset;
                            ++nBufferOffset;
                            acBuffer[n2] = -1;
                            int nRoutePacketOffset = ++nBufferOffset;
                            anReturn = NextToRoute.getNextPacket(acBuffer, nBufferOffset, false);
                            int nSize = anReturn[0] - nRoutePacketOffset;
                            if (nSize == 0) {
                                return this.createRequest(acBuffer, nInitialBufferOffset);
                            }
                            anReturn[1] = anReturn[1] + 7;
                            acBuffer[nRoutePacketOffset - 1] = (byte)(nSize & 0x7F);
                            if (nSize > 127) {
                                acBuffer[nInitialBufferOffset + 3] = (byte)(nSize >> 7 & 0x7F);
                            }
                            int n3 = anReturn[0];
                            anReturn[0] = n3 + 1;
                            acBuffer[n3] = -29;
                            nSize = anReturn[0] - 2 - nInitialBufferOffset;
                            acBuffer[nInitialBufferOffset + 2] = (byte)(nSize & 0x7F);
                            if (nSize > 127) {
                                acBuffer[nInitialBufferOffset + 3] = (byte)(nSize >> 7 & 0x7F);
                            }
                            int nChecksum = 0;
                            int i = nInitialBufferOffset;
                            while (i < anReturn[0]) {
                                nChecksum += acBuffer[i];
                                ++i;
                            }
                            int n4 = anReturn[0];
                            anReturn[0] = n4 + 1;
                            acBuffer[n4] = (byte)(nChecksum & 0xFF);
                            return anReturn;
                        }
                        catch (ArrayIndexOutOfBoundsException Exc) {
                            this.m_nLastRoutedNestedDevice = 0;
                        }
                    }
                }
                this.m_nDevicesStep = 2;
                if (isCalledByMainDevice) {
                    return anReturn;
                }
            }
            case 2: {
                Hashtable<String, FCOCRAPDevice> hashtable = this.m_OtherDevicesList;
                synchronized (hashtable) {
                    if (!this.m_OtherDevicesList.isEmpty()) {
                        if (this.m_nLastOtherDevice++ >= this.m_OtherDevicesList.size()) {
                            this.m_nLastOtherDevice = 0;
                        } else {
                            try {
                                FCOCRAPDevice OtherDevice = (FCOCRAPDevice)this.m_OtherDevicesList.values().toArray()[this.m_nLastOtherDevice - 1];
                                return OtherDevice.getNextPacket(acBuffer, nBufferOffset, false);
                            }
                            catch (ArrayIndexOutOfBoundsException Exc) {
                                this.m_nLastRoutedNestedDevice = 0;
                            }
                        }
                    }
                }
            }
            default: {
                this.m_nDevicesStep = 0;
                if (!isCalledByMainDevice) break;
                return anReturn;
            }
            case 0: 
        }
        this.m_nDevicesStep = 1;
        return this.createRequest(acBuffer, nBufferOffset);
    }

    @Override
    public void run() {
        byte[] acBuffer = new byte[this.m_nBufferSize];
        boolean isConnected = false;
        SerialPortLocal SerialPort2 = null;
        long lPreviousTimestamp = Calendar.getInstance().getTime().getTime();
        while (this.m_isThreadEnabled) {
            if (!isConnected) {
                if (SerialPort2 != null) {
                    try {
                        SerialPort2.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    SerialPort2 = null;
                }
                try {
                    SerialPort2 = new SerialPortLocal(this.m_SerCfg);
                    SerialPort2.setDTR(true);
                    lPreviousTimestamp = Calendar.getInstance().getTime().getTime();
                    this.m_DeviceEvent.comDevEvtOccured(this, 1);
                    isConnected = true;
                }
                catch (IOException IoException) {
                    System.err.println("IO Exception : cannot open serial port ! " + IoException.getMessage());
                }
            }
            if (!this.m_isInterfaceComSupended && isConnected) {
                int nBufferOffset = 0;
                int nReturnBufSize = 0;
                int nBytesReceived = 0;
                try {
                    int[] anRequest = this.getNextPacket(acBuffer, 0, true);
                    nBufferOffset = anRequest[0];
                    nReturnBufSize = anRequest[1];
                }
                catch (Exception e) {
                    e.printStackTrace();
                    isConnected = false;
                }
                this.m_isWaitingAnswer = false;
                if (nBufferOffset > 0) {
                    try {
                        SerialPort2.putData(acBuffer, 0, nBufferOffset);
                        if (nReturnBufSize > 0) {
                            this.m_isWaitingAnswer = true;
                        }
                    }
                    catch (IOException IoException) {
                        System.err.println("IO Exception : cannot write to serial port ! " + IoException.getMessage());
                        this.m_DeviceEvent.comDevEvtOccured(this, 3);
                        isConnected = false;
                    }
                    int nRxTryCounter = 100;
                    if (this.m_isWaitingAnswer) {
                        int nBytesReceivedLastLoop = 0;
                        while (nRxTryCounter-- > 0) {
                            try {
                                Thread.sleep(10L);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                            try {
                                nBytesReceivedLastLoop = SerialPort2.getData(acBuffer, nBytesReceived, nReturnBufSize);
                                nBytesReceived += nBytesReceivedLastLoop;
                            }
                            catch (IOException IoException) {
                                System.err.println("IO Exception : cannot read from serial port ! " + IoException.getMessage());
                                this.m_DeviceEvent.comDevEvtOccured(this, 3);
                                isConnected = false;
                            }
                            if (nBytesReceived >= nReturnBufSize && nBytesReceivedLastLoop == 0) break;
                        }
                        if (nBytesReceived == 0) {
                            this.m_DeviceEvent.comDevEvtOccured(this, 6);
                        } else {
                            try {
                                this.handleAnswer(nBytesReceived, acBuffer, 0);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                                isConnected = false;
                            }
                        }
                    }
                }
                try {
                    long lTimeout = 2L;
                    if (this.isNextMain()) {
                        long lCurrentTimestamp = Calendar.getInstance().getTime().getTime();
                        lTimeout = this.m_lThreadSleep - (lCurrentTimestamp - lPreviousTimestamp);
                        if (lTimeout < 0L) {
                            lTimeout = 2L;
                        }
                        lPreviousTimestamp += this.m_lThreadSleep;
                    }
                    Thread.sleep(lTimeout);
                }
                catch (InterruptedException interruptedException) {}
                continue;
            }
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException anRequest) {
                // empty catch block
            }
        }
        try {
            if (SerialPort2 != null) {
                SerialPort2.close();
            }
        }
        catch (IOException e) {
            System.err.println("IO Exception : cannot close serial port ! " + e.getMessage());
        }
        this.m_DeviceEvent.comDevEvtOccured(this, 4);
    }
}

