/*
 * Decompiled with CFR 0.152.
 */
package com.fiveco.devices;

import com.fiveco.devices.FCOCDevice;
import com.fiveco.devices.FCOCIPOnlyDevice;
import com.fiveco.devices.FCOCRegisterBase;
import com.fiveco.devices.FCOII2CScanBus;
import com.fiveco.devices.FCOIIPDeviceEvent;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.concurrent.ConcurrentLinkedQueue;

public class FCOCIPDevice
extends FCOCIPOnlyDevice {
    private static final boolean m_isDEBUGENABLED = false;
    private static final String m_szLOGFILENAME = "C:/FCOCDeviceLog.txt";
    private final Hashtable<String, CI2CDevice> m_aI2CDevicesList = new Hashtable();
    private final ConcurrentLinkedQueue<CI2CQueueElement> m_I2CTxQueue = new ConcurrentLinkedQueue();
    private final ConcurrentLinkedQueue<CI2CQueueElement> m_I2CRxQueue = new ConcurrentLinkedQueue();

    public FCOCIPDevice(String szIPAdd, int nNumberOfRegisters, FCOIIPDeviceEvent DeviceEvent, int nBufferSize) {
        super(szIPAdd, nNumberOfRegisters, DeviceEvent, nBufferSize);
    }

    public FCOCIPDevice(String szIPAdd, int nNumberOfRegisters, FCOIIPDeviceEvent DeviceEvent) {
        super(szIPAdd, nNumberOfRegisters, DeviceEvent, 180);
    }

    @Override
    public synchronized void delete() {
        if (!this.m_ComThread.isAlive()) {
            return;
        }
        int nTimeout = 20;
        while ((this.m_WriteQueue.size() > 0 || this.m_I2CTxQueue.size() > 0) && nTimeout-- > 0) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.m_isThreadEnabled = false;
    }

    public synchronized void setI2CAutoreadSupended(String szI2CDeviceName, boolean isSuspended) {
        try {
            this.m_aI2CDevicesList.get(szI2CDeviceName).m_isAutoreadSuspended = isSuspended;
        }
        catch (NullPointerException NPExcep) {
            System.err.println("Error in setAutoreadSupended function : NullPointerException ! szRegisterName = " + szI2CDeviceName);
            NPExcep.printStackTrace();
        }
    }

    public void scanI2Cbus(FCOII2CScanBus ScanEventHandler) {
        new CScanI2CThread(this, ScanEventHandler, this.m_szIPAdd);
    }

    public void scanI2Cbus(FCOII2CScanBus ScanEventHandler, int[] anAddressesToScan) {
        new CScanI2CThread(this, ScanEventHandler, this.m_szIPAdd, anAddressesToScan);
    }

    @Override
    public synchronized FCOCDevice addSubDevice(String szI2CDeviceName, int nI2CAddress, int nNumberOfRegisters, int nInterface) {
        CI2CDevice I2CDevice = new CI2CDevice((byte)nI2CAddress, nNumberOfRegisters);
        this.m_aI2CDevicesList.put(szI2CDeviceName, I2CDevice);
        return null;
    }

    @Override
    public synchronized void removeSubDevice(String szI2CDeviceName) {
        this.m_aI2CDevicesList.remove(szI2CDeviceName);
    }

    @Override
    public int getInterface() {
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void addI2CDeviceRegister(String szI2CDeviceName, String szRegisterName, int nRegisterAddress, int nRegisterSize, int nRegisterAccessType, int nDataType, boolean isAutoReadEnabled) throws IllegalArgumentException {
        FCOCRegisterBase Register = new FCOCRegisterBase(nRegisterAddress, nRegisterSize, nRegisterAccessType, nDataType, isAutoReadEnabled);
        try {
            Hashtable hashtable = this.m_aI2CDevicesList.get(szI2CDeviceName).m_aRegisterList;
            synchronized (hashtable) {
                this.m_aI2CDevicesList.get(szI2CDeviceName).m_aRegisterList.put(szRegisterName, Register);
            }
        }
        catch (NullPointerException NPExcep) {
            System.err.println("Error in addI2CDeviceRegister function : NullPointerException ! szRegisterName = " + szRegisterName);
            NPExcep.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized FCOCRegisterBase removeI2CDeviceRegister(String szI2CDeviceName, String szRegisterName) {
        Hashtable hashtable = this.m_aRegistersList;
        synchronized (hashtable) {
            Hashtable hashtable2 = this.m_aI2CDevicesList.get(szI2CDeviceName).m_aRegisterList;
            synchronized (hashtable2) {
                return (FCOCRegisterBase)this.m_aI2CDevicesList.get(szI2CDeviceName).m_aRegisterList.remove(szRegisterName);
            }
        }
    }

    public synchronized void callI2C(String szI2CDeviceName, String szRegisterName) throws IllegalArgumentException {
        CI2CDevice I2CDevice = this.m_aI2CDevicesList.get(szI2CDeviceName);
        FCOCRegisterBase Register = this.getI2CRegisterObject(I2CDevice, szRegisterName);
        if (Register.getAccesType() != 0) {
            throw new IllegalArgumentException("Register " + szRegisterName + " is not a function.");
        }
        CI2CQueueElement I2CQueueElement = new CI2CQueueElement(I2CDevice, Register, true);
        this.m_I2CTxQueue.add(I2CQueueElement);
    }

    public synchronized void setI2CValue(String szI2CDeviceName, String szRegisterName, Object Value, boolean isMandatory) throws IllegalArgumentException {
        CI2CDevice I2CDevice = this.m_aI2CDevicesList.get(szI2CDeviceName);
        FCOCRegisterBase Register = this.getI2CRegisterObject(I2CDevice, szRegisterName);
        if (Register.getAccesType() == 2 || Register.getAccesType() == 3) {
            if (this.i2cTxQueueContains(Register, true) && !isMandatory) {
                return;
            }
        } else {
            throw new IllegalArgumentException("Register " + szRegisterName + " is not writable.");
        }
        CI2CQueueElement I2CQueueElement = new CI2CQueueElement(I2CDevice, Register, true);
        Register.setData(Value);
        this.m_I2CTxQueue.add(I2CQueueElement);
    }

    public synchronized void setI2CValue(String szI2CDeviceName, String szRegisterName, Object Value) throws IllegalArgumentException {
        this.setI2CValue(szI2CDeviceName, szRegisterName, Value, true);
    }

    public synchronized void getI2CValue(String szI2CDeviceName, String szRegisterName) throws IllegalArgumentException {
        CI2CDevice I2CDevice = this.m_aI2CDevicesList.get(szI2CDeviceName);
        FCOCRegisterBase Register = this.getI2CRegisterObject(I2CDevice, szRegisterName);
        if (Register.getAccesType() == 1 || Register.getAccesType() == 3) {
            CI2CQueueElement I2CQueueElement = new CI2CQueueElement(I2CDevice, Register, false);
            if (this.i2cTxQueueContains(Register, false)) {
                System.err.println("Warning : Register " + szRegisterName + " already in read queue. Skipping.");
            } else {
                this.m_I2CTxQueue.add(I2CQueueElement);
            }
        } else {
            throw new IllegalArgumentException("Register " + szRegisterName + " is not readable.");
        }
    }

    public synchronized Object getI2CLastValue(String szI2CDeviceName, String szRegisterName) throws IllegalArgumentException {
        return this.getI2CRegisterObject(this.m_aI2CDevicesList.get(szI2CDeviceName), szRegisterName).getData();
    }

    public synchronized void setI2CAutoreadState(String szI2CDeviceName, String szRegisterName, boolean isAutoReadEnabled) throws IllegalArgumentException {
        this.getI2CRegisterObject(this.m_aI2CDevicesList.get(szI2CDeviceName), szRegisterName).setAutoReadEnabled(isAutoReadEnabled);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized FCOCRegisterBase getI2CRegisterObject(CI2CDevice I2CDevice, String szRegisterName) throws IllegalArgumentException {
        Hashtable hashtable = I2CDevice.m_aRegisterList;
        synchronized (hashtable) {
            if (I2CDevice.m_aRegisterList.containsKey(szRegisterName)) {
                return (FCOCRegisterBase)I2CDevice.m_aRegisterList.get(szRegisterName);
            }
        }
        throw new IllegalArgumentException("Register " + szRegisterName + " not found.");
    }

    private synchronized boolean i2cTxQueueContains(FCOCRegisterBase Register, boolean isAWrite) {
        boolean isPresent = false;
        for (CI2CQueueElement I2CQueueElementItem : this.m_I2CTxQueue) {
            if (I2CQueueElementItem.m_Register != Register || I2CQueueElementItem.m_isAWrite != isAWrite) continue;
            isPresent = true;
        }
        return isPresent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public void run() {
        InStream = null;
        OutStream = null;
        acInBuffer = new byte[1000];
        nInBufferOffset = 0;
        acOutBuffer = new byte[this.m_nBufferSize];
        nOutBufferOffset = 0;
        nStep = 0;
        lPreviousTimestamp = Calendar.getInstance().getTime().getTime();
        szLastError = "";
        while (this.m_isThreadEnabled) {
            if (this.m_Socket == null || this.m_Socket.isClosed() || !this.m_Socket.isConnected()) {
                block83: {
                    this.m_DeviceEvent.comDevEvtOccured(this, 0);
                    this.m_I2CRxQueue.clear();
                    try {
                        this.m_Socket = new Socket(this.m_szIPAdd, 8010);
                        this.m_Socket.setKeepAlive(true);
                        this.m_Socket.setTcpNoDelay(true);
                        this.m_Socket.setSoTimeout(1000);
                        InStream = new DataInputStream(this.m_Socket.getInputStream());
                        OutStream = new DataOutputStream(this.m_Socket.getOutputStream());
                        lPreviousTimestamp = Calendar.getInstance().getTime().getTime();
                        this.m_DeviceEvent.comDevEvtOccured(this, 1);
                        szLastError = "";
                        continue;
                    }
                    catch (IOException e) {
                        if (szLastError.equals(e.getMessage())) break block83;
                        System.err.println("IO Exception : can't create m_Socket ! " + e.getMessage());
                        this.m_DeviceEvent.comDevEvtOccured(this, 2);
                        szI2CDeviceNames = this.m_aI2CDevicesList.keys();
                        ** while (szI2CDeviceNames.hasMoreElements())
                    }
lbl-1000:
                    // 1 sources

                    {
                        ((FCOIIPDeviceEvent)this.m_DeviceEvent).comI2CEvtOccured(this, szI2CDeviceNames.nextElement(), -1);
                        continue;
                    }
                }
                szLastError = e.getMessage();
                continue;
            }
            switch (nStep) {
                case 0: {
                    this.addAutoreadRegisterToQueue();
                    if (this.m_WriteQueue.size() == 0 && this.m_ReadQueue.size() > 0 && OutStream != null) {
                        nReturnBufSize = 0;
                        nOutBufferOffset = 6;
                        Register = (FCOCRegisterBase)this.m_ReadQueue.peek();
                        do {
                            if (nOutBufferOffset >= this.m_nBufferSize - 2 || nReturnBufSize + Register.getSize() + 1 >= this.m_nBufferSize - 8) {
                                System.err.println("Missing space in IP read request buffer. Regs count remaining: " + this.m_ReadQueue.size());
                                break;
                            }
                            this.m_ReadQueue.poll();
                            acOutBuffer[nOutBufferOffset++] = (byte)Register.getAddress();
                            nReturnBufSize = 1 + Register.getSize();
                        } while ((Register = (FCOCRegisterBase)this.m_ReadQueue.peek()) != null);
                        this.setUShortToBuffer(acOutBuffer, 0, 33);
                        this.setUShortToBuffer(acOutBuffer, 2, this.m_nUniqueID++);
                        this.setUShortToBuffer(acOutBuffer, 4, nOutBufferOffset - 6);
                        this.setUShortToBuffer(acOutBuffer, nOutBufferOffset, this.calcChecksum(acOutBuffer, nOutBufferOffset));
                        nOutBufferOffset += 2;
                        try {
                            OutStream.write(acOutBuffer, 0, nOutBufferOffset);
                            this.m_isWaitingAnswer = true;
                        }
                        catch (IOException IoException) {
                            System.err.println("IO Exception : can't write to m_MainPortSocket ! " + IoException.getMessage());
                            try {
                                this.m_Socket.close();
                            }
                            catch (IOException szI2CDeviceNames) {
                                // empty catch block
                            }
                            this.m_DeviceEvent.comDevEvtOccured(this, 3);
                        }
                    }
                    ++nStep;
                    break;
                }
                case 1: {
                    if (this.m_WriteQueue.size() > 0 && OutStream != null) {
                        nOutBufferOffset = 6;
                        Register = (FCOCRegisterBase)this.m_WriteQueue.peek();
                        do {
                            if (nOutBufferOffset + Register.getSize() + 1 >= this.m_nBufferSize - 2) {
                                System.err.println("Missing space in IP write request buffer. Regs count remaining: " + this.m_WriteQueue.size());
                                break;
                            }
                            this.m_WriteQueue.poll();
                            nOutBufferOffset = this.fillBufferWithData(Register, acOutBuffer, nOutBufferOffset);
                        } while ((Register = (FCOCRegisterBase)this.m_WriteQueue.peek()) != null);
                        this.setUShortToBuffer(acOutBuffer, 0, 34);
                        this.setUShortToBuffer(acOutBuffer, 2, this.m_nUniqueID++);
                        this.setUShortToBuffer(acOutBuffer, 4, nOutBufferOffset - 6);
                        this.setUShortToBuffer(acOutBuffer, nOutBufferOffset, this.calcChecksum(acOutBuffer, nOutBufferOffset));
                        nOutBufferOffset += 2;
                        try {
                            OutStream.write(acOutBuffer, 0, nOutBufferOffset);
                            this.m_isWaitingAnswer = true;
                        }
                        catch (IOException IoException) {
                            System.err.println("IO Exception : can't write to m_MainPortSocket ! " + IoException.getMessage());
                            try {
                                this.m_Socket.close();
                            }
                            catch (IOException szI2CDeviceNames) {
                                // empty catch block
                            }
                            this.m_DeviceEvent.comDevEvtOccured(this, 3);
                        }
                    }
                    ++nStep;
                    break;
                }
                case 2: {
                    if (this.m_aI2CDevicesList.size() > 0) {
                        IoException = this.m_aI2CDevicesList;
                        synchronized (IoException) {
                            for (CI2CDevice I2CDevice : this.m_aI2CDevicesList.values()) {
                                if (CI2CDevice.access$2(I2CDevice)) continue;
                                var17_26 = CI2CDevice.access$1(I2CDevice);
                                synchronized (var17_26) {
                                    for (FCOCRegisterBase RegisterItem : CI2CDevice.access$1(I2CDevice).values()) {
                                        if (!RegisterItem.isAutoReadEnabled() || RegisterItem.getAccesType() != 1 && RegisterItem.getAccesType() != 3 || this.i2cTxQueueContains(RegisterItem, false)) continue;
                                        I2CQueueElement = new CI2CQueueElement(I2CDevice, RegisterItem, false);
                                        this.m_I2CTxQueue.add(I2CQueueElement);
                                    }
                                }
                            }
                        }
                        if (this.m_I2CTxQueue.size() > 0 && OutStream != null) {
                            nReturnBufSize = 0;
                            nOutBufferOffset = 6;
                            if (this.m_I2CRxQueue.size() > 0) {
                                nReturnBufSize = 0;
                            }
                            I2CQueueElement = this.m_I2CTxQueue.peek();
                            do {
                                if (I2CQueueElement.m_isAWrite) {
                                    if (nOutBufferOffset + I2CQueueElement.m_Register.getSize() + 4 < this.m_nBufferSize - 2) {
                                        this.m_I2CTxQueue.poll();
                                        this.m_I2CRxQueue.add(I2CQueueElement);
                                        acOutBuffer[nOutBufferOffset++] = CI2CDevice.access$3(I2CQueueElement.m_I2CDevice);
                                        acOutBuffer[nOutBufferOffset++] = (byte)(1 + I2CQueueElement.m_Register.getSize());
                                        nOutBufferOffset = this.fillBufferWithData(I2CQueueElement.m_Register, acOutBuffer, nOutBufferOffset);
                                        acOutBuffer[nOutBufferOffset++] = 0;
                                        continue;
                                    }
                                    System.err.println("Missing space in IP/I2C request buffer. Regs count remaining: " + this.m_I2CTxQueue.size());
                                    break;
                                }
                                if (nOutBufferOffset + 4 < this.m_nBufferSize - 2 && nReturnBufSize + I2CQueueElement.m_Register.getSize() + 1 < this.m_nBufferSize - 8) {
                                    this.m_I2CTxQueue.poll();
                                    this.m_I2CRxQueue.add(I2CQueueElement);
                                    acOutBuffer[nOutBufferOffset++] = CI2CDevice.access$3(I2CQueueElement.m_I2CDevice);
                                    acOutBuffer[nOutBufferOffset++] = 1;
                                    acOutBuffer[nOutBufferOffset++] = (byte)I2CQueueElement.m_Register.getAddress();
                                    acOutBuffer[nOutBufferOffset++] = (byte)I2CQueueElement.m_Register.getSize();
                                    nReturnBufSize = 1 + I2CQueueElement.m_Register.getSize();
                                    continue;
                                }
                                System.err.println("Missing space in IP/I2C request buffer. Regs count remaining: " + this.m_I2CTxQueue.size());
                                break;
                            } while ((I2CQueueElement = this.m_I2CTxQueue.peek()) != null);
                            this.setUShortToBuffer(acOutBuffer, 0, 7);
                            this.setUShortToBuffer(acOutBuffer, 2, this.m_nUniqueID++);
                            this.setUShortToBuffer(acOutBuffer, 4, nOutBufferOffset - 6);
                            this.setUShortToBuffer(acOutBuffer, nOutBufferOffset, this.calcChecksum(acOutBuffer, nOutBufferOffset));
                            nOutBufferOffset += 2;
                            try {
                                OutStream.write(acOutBuffer, 0, nOutBufferOffset);
                                this.m_isWaitingAnswer = true;
                            }
                            catch (IOException IoException) {
                                System.err.println("IO Exception : can't write to m_MainPortSocket ! " + IoException.getMessage());
                                try {
                                    this.m_Socket.close();
                                }
                                catch (IOException var15_23) {
                                    // empty catch block
                                }
                                this.m_DeviceEvent.comDevEvtOccured(this, 3);
                            }
                        }
                    }
                    if (this.m_isInterfaceComSupended) break;
                    nStep = 0;
                }
            }
            lCurrentTimestamp = Calendar.getInstance().getTime().getTime();
            lSleepRemaining = this.m_lThreadSleep / 3L - (lCurrentTimestamp - lPreviousTimestamp);
            if (lSleepRemaining < 0L) {
                lSleepRemaining = 2L;
            }
            lPreviousTimestamp += this.m_lThreadSleep / 3L;
            if (this.m_isWaitingAnswer) {
                nRxTryCounter = 20;
                while (nRxTryCounter-- > 0) {
                    block84: {
                        try {
                            Thread.sleep(10L);
                        }
                        catch (InterruptedException var19_31) {
                            // empty catch block
                        }
                        lSleepRemaining -= 10L;
                        try {
                            if (!this.m_Socket.isConnected() || InStream == null) break block84;
                            nDataLength = InStream.available();
                            if (nInBufferOffset + nDataLength < 8) continue;
                            InStream.read(acInBuffer, nInBufferOffset, nDataLength);
                            nInBufferOffset += nDataLength;
                            nLengthOfParameters = this.getUShortFromBuffer(acInBuffer, 4);
                            while (nInBufferOffset >= nLengthOfParameters + 8) {
                                nChecksumReceived = this.getUShortFromBuffer(acInBuffer, nLengthOfParameters + 6);
                                nChecksum = this.calcChecksum(acInBuffer, nLengthOfParameters + 6);
                                if (acInBuffer[0] == 0 && nChecksumReceived == nChecksum) {
                                    switch (acInBuffer[1]) {
                                        case 35: {
                                            i = 6;
                                            while (i < 6 + nLengthOfParameters) {
                                                y = i;
                                                var25_44 = this.m_aRegistersList;
                                                synchronized (var25_44) {
                                                    for (FCOCRegisterBase RegisterItem : this.m_aRegistersList.values()) {
                                                        if (RegisterItem.getAddress() != acInBuffer[i] || i + RegisterItem.getSize() > 6 + nLengthOfParameters) continue;
                                                        y = this.getDataFromBuffer(RegisterItem, acInBuffer, i + 1) - 1;
                                                        this.m_DeviceEvent.dataDevEvtOccured(this, this.getKeyFromValue(RegisterItem, this.m_aRegistersList), RegisterItem.getData());
                                                    }
                                                }
                                                i = y;
                                                ++i;
                                            }
                                            break;
                                        }
                                        case 36: {
                                            break;
                                        }
                                        case 8: {
                                            i = 6;
                                            while (i < 6 + nLengthOfParameters) {
                                                I2CQueueElement = this.m_I2CRxQueue.poll();
                                                if (!I2CQueueElement.m_isAWrite) {
                                                    i = this.getDataFromBuffer(I2CQueueElement.m_Register, acInBuffer, i);
                                                    szKey = this.getKeyFromValue(I2CQueueElement.m_Register, CI2CDevice.access$1(I2CQueueElement.m_I2CDevice));
                                                    if (acInBuffer[i] == -121) {
                                                        ((FCOIIPDeviceEvent)this.m_DeviceEvent).dataI2CDevEvtOccured(this, this.getKeyFromValue(I2CQueueElement.m_I2CDevice, this.m_aI2CDevicesList), szKey, I2CQueueElement.m_Register.getData());
                                                    }
                                                }
                                                if (acInBuffer[i] != -121) {
                                                    ((FCOIIPDeviceEvent)this.m_DeviceEvent).comI2CEvtOccured(this, this.getKeyFromValue(I2CQueueElement.m_I2CDevice, this.m_aI2CDevicesList), 100);
                                                } else {
                                                    ((FCOIIPDeviceEvent)this.m_DeviceEvent).comI2CEvtOccured(this, this.getKeyFromValue(I2CQueueElement.m_I2CDevice, this.m_aI2CDevicesList), 0);
                                                }
                                                ++i;
                                            }
                                            if (this.m_I2CRxQueue.size() <= 0) break;
                                            szMessage = "\tI2C RX Queue not empty (" + this.m_I2CRxQueue.size() + " elements remains) ! ";
                                            System.err.println(szMessage);
                                            while (this.m_I2CRxQueue.size() > 0) {
                                                this.m_I2CRxQueue.poll();
                                            }
                                            break;
                                        }
                                        case 9: {
                                            nI2CComCause = -1;
                                            switch (acInBuffer[6]) {
                                                case 1: {
                                                    nI2CComCause = 1;
                                                    break;
                                                }
                                                case 2: {
                                                    nI2CComCause = 2;
                                                    break;
                                                }
                                                case 3: {
                                                    nI2CComCause = 4;
                                                    break;
                                                }
                                            }
                                            ((FCOIIPDeviceEvent)this.m_DeviceEvent).comI2CEvtOccured(this, null, nI2CComCause);
                                            break;
                                        }
                                        default: {
                                            System.err.println("Error: received a bad command code from device.");
                                        }
                                    }
                                    j = 0;
                                    i = nLengthOfParameters + 8;
                                    while (i < nInBufferOffset) {
                                        acInBuffer[j++] = acInBuffer[i];
                                        ++i;
                                    }
                                    nInBufferOffset = j;
                                    if (nInBufferOffset < 8) break;
                                    nLengthOfParameters = this.getUShortFromBuffer(acInBuffer, 4);
                                } else {
                                    System.err.println("Error: received a bad packet from device.");
                                }
                                nInBufferOffset = 0;
                            }
                        }
                        catch (IOException IoException) {
                            System.err.println("IO Exception : can't read from device ! " + IoException.getMessage());
                            try {
                                this.m_Socket.close();
                            }
                            catch (IOException var20_35) {
                                // empty catch block
                            }
                            this.m_DeviceEvent.comDevEvtOccured(this, 3);
                        }
                    }
                    this.m_isWaitingAnswer = false;
                    break;
                }
            }
            if (lSleepRemaining <= 0L) continue;
            try {
                Thread.sleep(lSleepRemaining);
            }
            catch (InterruptedException var18_29) {
                // empty catch block
            }
        }
        if (this.m_Socket != null && this.m_Socket.isConnected()) {
            this.m_I2CRxQueue.clear();
            try {
                this.m_Socket.close();
            }
            catch (IOException e) {
                System.err.println("IO Exception : can't close m_Socket ! " + e.getMessage());
            }
            this.m_DeviceEvent.comDevEvtOccured(this, 4);
        }
    }

    private class CI2CDevice {
        private final byte m_cI2CAddress;
        private final Hashtable<String, FCOCRegisterBase> m_aRegisterList;
        private boolean m_isAutoreadSuspended = false;

        public CI2CDevice(byte cI2CAddress, int nNumberOfRegisters) {
            this.m_cI2CAddress = cI2CAddress;
            this.m_aRegisterList = new Hashtable(nNumberOfRegisters);
        }

        static /* synthetic */ boolean access$2(CI2CDevice cI2CDevice) {
            return cI2CDevice.m_isAutoreadSuspended;
        }

        static /* synthetic */ byte access$3(CI2CDevice cI2CDevice) {
            return cI2CDevice.m_cI2CAddress;
        }
    }

    private class CI2CQueueElement {
        public CI2CDevice m_I2CDevice;
        public FCOCRegisterBase m_Register;
        public boolean m_isAWrite = false;

        public CI2CQueueElement(CI2CDevice I2CDevice, FCOCRegisterBase Register, boolean isAWrite) {
            this.m_I2CDevice = I2CDevice;
            this.m_Register = Register;
            this.m_isAWrite = isAWrite;
        }
    }

    private class CScanI2CThread
    implements Runnable {
        private final FCOCDevice m_Caller;
        private final Thread m_ScanThread = new Thread(this);
        private final FCOII2CScanBus m_ScanEventHandler;
        private final String m_szIPAdd;
        private int[] m_anAddressesToScan = new int[0];

        public CScanI2CThread(FCOCDevice Caller, FCOII2CScanBus ScanEventHandler, String szIPAdd, int[] anAddressesToScan) {
            this.m_Caller = Caller;
            this.m_ScanEventHandler = ScanEventHandler;
            this.m_szIPAdd = szIPAdd;
            this.m_anAddressesToScan = anAddressesToScan;
            this.m_ScanThread.start();
        }

        public CScanI2CThread(FCOCDevice Caller, FCOII2CScanBus ScanEventHandler, String szIPAdd) {
            this.m_Caller = Caller;
            this.m_ScanEventHandler = ScanEventHandler;
            this.m_szIPAdd = szIPAdd;
            this.m_ScanThread.start();
        }

        @Override
        public void run() {
            byte[] acScanPacketBytes = new byte[8 + this.m_anAddressesToScan.length];
            acScanPacketBytes[0] = 0;
            acScanPacketBytes[1] = 5;
            acScanPacketBytes[4] = 0;
            acScanPacketBytes[5] = (byte)this.m_anAddressesToScan.length;
            if (this.m_anAddressesToScan.length > 0) {
                int i = 0;
                while (i < this.m_anAddressesToScan.length) {
                    acScanPacketBytes[6 + i] = (byte)this.m_anAddressesToScan[i];
                    ++i;
                }
            }
            FCOCIPDevice.this.setUShortToBuffer(acScanPacketBytes, 6 + this.m_anAddressesToScan.length, FCOCIPDevice.this.calcChecksum(acScanPacketBytes, 6 + this.m_anAddressesToScan.length));
            try {
                DatagramPacket ScanPacket = new DatagramPacket(acScanPacketBytes, 8 + this.m_anAddressesToScan.length, InetAddress.getByName(this.m_szIPAdd), 7010);
                Enumeration<NetworkInterface> NetItfs = NetworkInterface.getNetworkInterfaces();
                while (NetItfs.hasMoreElements()) {
                    NetworkInterface NetItf = NetItfs.nextElement();
                    Enumeration<InetAddress> NetItfAddresses = NetItf.getInetAddresses();
                    while (NetItfAddresses.hasMoreElements()) {
                        InetAddress NetItfAddress = NetItfAddresses.nextElement();
                        try {
                            DatagramSocket ScanSocket = new DatagramSocket(new InetSocketAddress(NetItfAddress, 0));
                            if (NetItfAddress.getClass() == Inet4Address.class) {
                                System.out.print("Interface " + NetItf.getDisplayName() + " : ");
                                try {
                                    ScanSocket.send(ScanPacket);
                                    System.out.println("Sent");
                                }
                                catch (Exception e) {
                                    System.out.println("Error (" + e.getLocalizedMessage() + ")");
                                }
                                ScanSocket.setSoTimeout(500);
                                byte[] ScanAnswerBytes = new byte[256];
                                DatagramPacket ScanAnswerPacket = new DatagramPacket(ScanAnswerBytes, 250);
                                while (true) {
                                    ScanSocket.receive(ScanAnswerPacket);
                                    if (ScanAnswerBytes[0] != 0 || ScanAnswerBytes[1] != 6 || ScanAnswerBytes[3] != 0 || ScanAnswerBytes[5] <= 0) continue;
                                    int nDevFoundCount = ScanAnswerBytes[5];
                                    int[] anDevFound = new int[nDevFoundCount];
                                    int i = 0;
                                    while (i < nDevFoundCount) {
                                        anDevFound[i] = ScanAnswerBytes[i + 6];
                                        ++i;
                                    }
                                    Arrays.sort(anDevFound);
                                    this.m_ScanEventHandler.scanI2CDevEvtOccured(this.m_Caller, nDevFoundCount, anDevFound);
                                }
                            }
                            ScanSocket.close();
                        }
                        catch (SocketTimeoutException ScanSocket) {
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
            catch (SocketException e) {
                e.printStackTrace();
            }
            catch (UnknownHostException e) {
                e.printStackTrace();
            }
        }
    }
}

