/*
 * Decompiled with CFR 0.152.
 */
package com.fiveco.appMisc;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.border.Border;

public class FCOCStatusBar
extends JPanel {
    private String m_MsgWhenEmpty = " ";
    private final JLabel m_TextLabel = new JLabel();
    private final JProgressBar m_ProgressBar = new JProgressBar();
    private final JPanel m_PnlLabelOrProgress = new JPanel();
    private final GridBagConstraints m_GBCts = new GridBagConstraints();
    private Font m_Font;

    public FCOCStatusBar() {
        super(new GridBagLayout());
        this.createGUI();
    }

    @Override
    public synchronized void setFont(Font font) {
        if (font == null) {
            throw new IllegalArgumentException("Font == null");
        }
        super.setFont(font);
        this.m_Font = font;
        this.updateSubcomponentsFont(this);
    }

    public synchronized void setText(String szText) {
        String szMyText = null;
        if (szText != null) {
            szMyText = szText.trim();
        }
        if (szMyText != null && szMyText.length() > 0) {
            this.m_TextLabel.setText(szMyText);
        } else {
            this.clearText();
        }
    }

    public synchronized String getText() {
        return this.m_TextLabel.getText();
    }

    public synchronized void clearText() {
        this.m_TextLabel.setText(this.m_MsgWhenEmpty);
    }

    public synchronized void setTextWhenEmpty(String szText) {
        boolean isEmpty = this.m_TextLabel.getText().equals(this.m_MsgWhenEmpty);
        this.m_MsgWhenEmpty = szText != null && szText.length() > 0 ? szText : " ";
        if (isEmpty) {
            this.clearText();
        }
    }

    public synchronized void addJComponent(JComponent Comp) {
        if (Comp == null) {
            throw new IllegalArgumentException("JComponent == null");
        }
        Comp.setBorder(FCOCStatusBar.createComponentBorder());
        if (this.m_Font != null) {
            Comp.setFont(this.m_Font);
            this.updateSubcomponentsFont(Comp);
        }
        super.add((Component)Comp, this.m_GBCts);
    }

    private static Border createComponentBorder() {
        return BorderFactory.createCompoundBorder(BorderFactory.createBevelBorder(1), BorderFactory.createEmptyBorder(0, 4, 0, 4));
    }

    private void createGUI() {
        this.clearText();
        Dimension ProgBarSize = this.m_ProgressBar.getPreferredSize();
        ProgBarSize.height = this.m_TextLabel.getPreferredSize().height;
        this.m_ProgressBar.setPreferredSize(ProgBarSize);
        this.m_ProgressBar.setStringPainted(true);
        this.m_PnlLabelOrProgress.setLayout(new GridLayout(1, 1));
        this.m_PnlLabelOrProgress.add(this.m_TextLabel);
        this.m_GBCts.anchor = 17;
        this.m_GBCts.weightx = 1.0;
        this.m_GBCts.fill = 2;
        this.m_GBCts.gridy = 0;
        this.m_GBCts.gridx = 0;
        this.addJComponent(this.m_PnlLabelOrProgress);
        this.m_GBCts.weightx = 0.0;
        this.m_GBCts.anchor = 10;
        this.m_GBCts.gridx = -1;
    }

    private void updateSubcomponentsFont(Container Cont) {
        Component[] Comps = Cont.getComponents();
        int i = 0;
        while (i < Comps.length) {
            Comps[i].setFont(this.m_Font);
            if (Comps[i] instanceof Container) {
                this.updateSubcomponentsFont((Container)Comps[i]);
            }
            ++i;
        }
    }

    public void setStatusBarProgress(String szMsg, int nMin, int nMax, int nValue) {
        if (!(this.m_PnlLabelOrProgress.getComponent(0) instanceof JProgressBar)) {
            this.m_PnlLabelOrProgress.remove(0);
            this.m_PnlLabelOrProgress.add(this.m_ProgressBar);
            this.validate();
        }
        this.m_ProgressBar.setMinimum(nMin);
        this.m_ProgressBar.setMaximum(nMax);
        this.m_ProgressBar.setValue(nValue);
        if (szMsg != null) {
            this.m_ProgressBar.setString(szMsg);
        } else {
            this.m_ProgressBar.setString("");
        }
    }

    public void setStatusBarProgressFinished() {
        if (this.m_PnlLabelOrProgress.getComponent(0) instanceof JProgressBar) {
            this.m_PnlLabelOrProgress.remove(0);
            this.m_PnlLabelOrProgress.add(this.m_TextLabel);
            this.validate();
            this.repaint();
        }
    }
}

