/*
 * Decompiled with CFR 0.152.
 */
package com.fiveco.appMisc;

import Serialio.SerialConfig;
import Serialio.SerialPortLocal;
import com.fiveco.jcomponents.FCOCGridBagJPanel;
import com.fiveco.jcomponents.FCOCIntHexAddPanel;
import com.fiveco.utils.FCOCUtils;
import com.fiveco.utils.FCOISimpleEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class FCOCSerialParams
extends JFrame
implements ActionListener,
ListSelectionListener {
    private final JComboBox<String> m_ComPortCB = new JComboBox();
    private final JComboBox<String> m_BiRateCB = new JComboBox();
    private final JTextField m_BitRateNonIndexed = new JTextField();
    private final FCOCIntHexAddPanel m_LocalAddress = new FCOCIntHexAddPanel("", 1, 1, 255, null);
    private final FCOCIntHexAddPanel m_RemoteAddress = new FCOCIntHexAddPanel("", 85, 1, 255, null);
    private final JButton m_CancelButton = new JButton("Cancel");
    private final JButton m_OKButton = new JButton("OK");
    private FCOISimpleEvent m_SerialParaEventInterface;
    private SerialConfig m_SerCfg;

    public FCOCSerialParams(FCOISimpleEvent SerialParaEventInterface, SerialConfig SerCfg, int nLocalAddress, int nRemoteAddress) {
        super("Set serial parameters");
        this.init(SerialParaEventInterface, SerCfg, nLocalAddress, nRemoteAddress);
    }

    private void init(FCOISimpleEvent SerialParaEventInterface, SerialConfig SerCfg, int nLocalAddress, int nRemoteAddress) {
        ArrayList<Image> imageList = new ArrayList<Image>();
        imageList.add(Toolkit.getDefaultToolkit().getImage(FCOCSerialParams.class.getResource("/images/logo198px.gif")));
        imageList.add(Toolkit.getDefaultToolkit().getImage(FCOCSerialParams.class.getResource("/images/logo75px.gif")));
        imageList.add(Toolkit.getDefaultToolkit().getImage(FCOCSerialParams.class.getResource("/images/logo40px.gif")));
        imageList.add(Toolkit.getDefaultToolkit().getImage(FCOCSerialParams.class.getResource("/images/logo32px.png")));
        this.setIconImages(imageList);
        if (SerialParaEventInterface == null) {
            throw new NullPointerException("SerialParaEventInterface is null !");
        }
        this.m_SerialParaEventInterface = SerialParaEventInterface;
        if (nLocalAddress > 0 && nLocalAddress <= 255) {
            this.m_LocalAddress.setAddress(nLocalAddress);
        }
        if (nRemoteAddress > 0 && nRemoteAddress <= 255) {
            this.m_RemoteAddress.setAddress(nRemoteAddress);
        }
        JLabel PortLabel = new JLabel("Port:");
        JLabel BitRateLabel = new JLabel("Bit rate:");
        JLabel LocalAddLabel = new JLabel("Local address:");
        JLabel RemoteAddLabel = new JLabel("Remote address:");
        FCOCGridBagJPanel ParaPanel = new FCOCGridBagJPanel(5, 1, 5, 1);
        ParaPanel.add((Component)PortLabel, 0, 0);
        ParaPanel.add((Component)this.m_ComPortCB, 1, 0);
        ParaPanel.add((Component)BitRateLabel, 0, 1);
        ParaPanel.add((Component)this.m_BiRateCB, 1, 1);
        this.m_BiRateCB.addActionListener(this);
        ParaPanel.add((Component)this.m_BitRateNonIndexed, 1, 2);
        this.m_BitRateNonIndexed.setEnabled(false);
        ParaPanel.add((Component)LocalAddLabel, 0, 3);
        ParaPanel.add(this.m_LocalAddress, 1, 3, 1, 1, 10, 10, 1, 17);
        ParaPanel.add((Component)RemoteAddLabel, 0, 4);
        ParaPanel.add(this.m_RemoteAddress, 1, 4, 1, 1, 10, 10, 1, 17);
        try {
            System.setProperty("java.library.path", "C:\\Windows\\SysWOW64\\");
            Field fieldSysPath = ClassLoader.class.getDeclaredField("sys_paths");
            fieldSysPath.setAccessible(true);
            fieldSysPath.set(null, null);
        }
        catch (Exception Exc) {
            String szError = "Unable to set library path: " + Exc.getMessage();
            System.err.println(szError);
            JOptionPane.showMessageDialog(this, szError);
        }
        if (System.getProperty("os.name").contains("Windows") && System.getProperty("sun.cpu.isalist").contains("amd64")) {
            try {
                String[] aszPortNames = SerialPortLocal.getPortList();
                int i = 0;
                while (i < aszPortNames.length) {
                    this.m_ComPortCB.addItem(aszPortNames[i]);
                    ++i;
                }
                if (SerCfg != null) {
                    this.m_ComPortCB.setSelectedItem(SerCfg.getPortNameString());
                }
            }
            catch (IOException IOExc) {
                String szError = "Unable to list serial ports: " + IOExc.getMessage();
                System.err.println(szError);
                JOptionPane.showMessageDialog(this, szError);
            }
        }
        this.m_BiRateCB.addItem("4800");
        this.m_BiRateCB.addItem("9600");
        this.m_BiRateCB.addItem("19200");
        this.m_BiRateCB.addItem("38400");
        this.m_BiRateCB.addItem("57600");
        this.m_BiRateCB.addItem("115200");
        this.m_BiRateCB.addItem("230400");
        this.m_BiRateCB.addItem("460800");
        this.m_BiRateCB.addItem("921600");
        this.m_BiRateCB.addItem("User defined");
        if (SerCfg != null) {
            if (SerCfg.getBitRate() < 115) {
                this.m_BiRateCB.setSelectedIndex(SerCfg.getBitRate() - 6);
            } else {
                this.m_BiRateCB.setSelectedItem("User defined");
                this.m_BitRateNonIndexed.setText("" + SerCfg.getBitRate());
            }
        }
        this.m_CancelButton.addActionListener(this);
        this.m_OKButton.addActionListener(this);
        JPanel ButtonsPane = new JPanel();
        ButtonsPane.add(this.m_CancelButton);
        ButtonsPane.add(this.m_OKButton);
        ButtonsPane.setPreferredSize(new Dimension(200, 35));
        this.setSize(250, 200);
        this.setResizable(false);
        FCOCUtils.centerFrame(this);
        JPanel Pane = new JPanel();
        BorderLayout MainLayout = new BorderLayout();
        Pane.setLayout(MainLayout);
        Pane.add((Component)ParaPanel, "Center");
        Pane.add((Component)ButtonsPane, "South");
        this.setContentPane(Pane);
        this.setDefaultCloseOperation(2);
    }

    public void start() {
        this.setVisible(true);
        this.getRootPane().setDefaultButton(this.m_OKButton);
        this.m_OKButton.requestFocusInWindow();
    }

    public SerialConfig getSerialConfig() {
        return this.m_SerCfg;
    }

    public int getLocalAddress() {
        return this.m_LocalAddress.getAddress();
    }

    public int getRemoteAddress() {
        return this.m_RemoteAddress.getAddress();
    }

    @Override
    public void valueChanged(ListSelectionEvent arg0) {
    }

    @Override
    public void actionPerformed(ActionEvent ActEvt) {
        Object ActEvtSrc = ActEvt.getSource();
        if (ActEvtSrc == this.m_CancelButton) {
            this.m_SerCfg = null;
            this.m_SerialParaEventInterface.simpleEventPerformed(this);
        } else if (ActEvtSrc == this.m_OKButton) {
            this.m_SerCfg = new SerialConfig(this.m_ComPortCB.getSelectedItem().toString());
            if (this.m_BiRateCB.getSelectedItem().equals("User defined")) {
                this.m_SerCfg.setBitRate(Integer.parseInt(this.m_BitRateNonIndexed.getText()));
            } else {
                this.m_SerCfg.setBitRate(this.m_BiRateCB.getSelectedIndex() + 6);
            }
            this.m_SerCfg.setDataBits(3);
            this.m_SerCfg.setStopBits(0);
            this.m_SerCfg.setParity(0);
            this.m_SerCfg.setHandshake(0);
            this.m_SerialParaEventInterface.simpleEventPerformed(this);
        } else if (ActEvtSrc == this.m_BiRateCB) {
            if (this.m_BiRateCB.getSelectedItem().equals("User defined")) {
                this.m_BitRateNonIndexed.setEnabled(true);
            } else {
                this.m_BitRateNonIndexed.setEnabled(false);
            }
        }
    }
}

