/*
 * Decompiled with CFR 0.152.
 */
package com.fiveco.appMisc;

import com.fiveco.utils.FCOCUtils;
import com.fiveco.utils.FCOISimpleEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumnModel;

public class FCOCScanNetwork
extends JFrame
implements ActionListener,
ListSelectionListener {
    private final JButton m_ScanB = new JButton("Scan network to find devices...");
    private long m_lTypeToFind = 0L;
    protected JTable m_ResultTable;
    protected FCOISimpleEvent m_ScanNetEvtInterface;
    protected String m_szIPAddressSelected = "";

    protected FCOCScanNetwork(FCOISimpleEvent ScanNetEvtInterface, String szTitle) throws HeadlessException {
        super(szTitle);
        this.init(ScanNetEvtInterface);
    }

    public FCOCScanNetwork(FCOISimpleEvent ScanNetEvtInterface) {
        super("Scan network");
        try {
            ArrayList<Image> imageList = new ArrayList<Image>();
            imageList.add(Toolkit.getDefaultToolkit().getImage(FCOCScanNetwork.class.getResource("/images/logo198px.gif")));
            imageList.add(Toolkit.getDefaultToolkit().getImage(FCOCScanNetwork.class.getResource("/images/logo75px.gif")));
            imageList.add(Toolkit.getDefaultToolkit().getImage(FCOCScanNetwork.class.getResource("/images/logo40px.gif")));
            imageList.add(Toolkit.getDefaultToolkit().getImage(FCOCScanNetwork.class.getResource("/images/logo32px.png")));
            this.setIconImages(imageList);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.init(ScanNetEvtInterface);
    }

    private void init(FCOISimpleEvent ScanNetEvtInterface) {
        if (ScanNetEvtInterface == null) {
            throw new NullPointerException("ScanNetEvtInterface is null !");
        }
        this.m_ScanNetEvtInterface = ScanNetEvtInterface;
        this.m_ScanB.addActionListener(this);
        JPanel TopPane = new JPanel();
        TopPane.add(this.m_ScanB);
        TopPane.setPreferredSize(new Dimension(420, 35));
        Object[][] aszTableData = new String[][]{new String[0]};
        Object[] aszColumns = new String[]{"MAC Address", "IP Address", "Type", "Version", "Name"};
        DefaultTableModel ResultTableModel = new DefaultTableModel(aszTableData, aszColumns);
        this.m_ResultTable = new JTable(ResultTableModel){

            @Override
            public boolean isCellEditable(int rowIndex, int vColIndex) {
                return false;
            }
        };
        this.m_ResultTable.setSelectionMode(0);
        this.m_ResultTable.getSelectionModel().addListSelectionListener(this);
        JScrollPane TablePane = new JScrollPane(this.m_ResultTable);
        JPanel CenterPane = new JPanel();
        CenterPane.setLayout(new BoxLayout(CenterPane, 2));
        JPanel tableContainer = new JPanel(new GridLayout(1, 1));
        tableContainer.setBorder(BorderFactory.createTitledBorder("Devices Found"));
        tableContainer.add(TablePane);
        TablePane.setPreferredSize(new Dimension(520, 130));
        CenterPane.setBorder(BorderFactory.createEmptyBorder(5, 5, 0, 5));
        CenterPane.add(tableContainer);
        TableColumnModel TableColsModel = this.m_ResultTable.getColumnModel();
        TableColsModel.getColumn(0).setPreferredWidth(120);
        TableColsModel.getColumn(1).setPreferredWidth(100);
        TableColsModel.getColumn(2).setPreferredWidth(50);
        TableColsModel.getColumn(3).setPreferredWidth(90);
        TableColsModel.getColumn(4).setPreferredWidth(190);
        this.setSize(600, 200);
        this.setResizable(false);
        FCOCUtils.centerFrame(this);
        JPanel Pane = new JPanel();
        BorderLayout MainLayout = new BorderLayout();
        Pane.setLayout(MainLayout);
        Pane.add((Component)TopPane, "North");
        Pane.add((Component)CenterPane, "Center");
        this.setContentPane(Pane);
        this.setDefaultCloseOperation(2);
    }

    protected void scan() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DefaultTableModel ResultTableModel = (DefaultTableModel)FCOCScanNetwork.this.m_ResultTable.getModel();
                while (ResultTableModel.getRowCount() > 0) {
                    ResultTableModel.removeRow(0);
                }
                byte[] byArray = new byte[12];
                byArray[1] = 33;
                byArray[5] = 4;
                byArray[7] = 1;
                byArray[8] = 21;
                byArray[9] = 17;
                byArray[10] = -22;
                byArray[11] = -56;
                byte[] acScanPacketBytes = byArray;
                byte[] acScanPacketAddress = new byte[]{-1, -1, -1, -1};
                try {
                    DatagramPacket ScanPacket = new DatagramPacket(acScanPacketBytes, 12, InetAddress.getByAddress(acScanPacketAddress), 7010);
                    Enumeration<NetworkInterface> NetItfs = NetworkInterface.getNetworkInterfaces();
                    while (NetItfs.hasMoreElements()) {
                        NetworkInterface NetItf = NetItfs.nextElement();
                        Enumeration<InetAddress> NetItfAddresses = NetItf.getInetAddresses();
                        while (NetItfAddresses.hasMoreElements()) {
                            InetAddress NetItfAddress = NetItfAddresses.nextElement();
                            try {
                                DatagramSocket ScanSocket = new DatagramSocket(new InetSocketAddress(NetItfAddress, 0));
                                if (NetItfAddress.getClass() == Inet4Address.class) {
                                    System.out.print("Interface " + NetItf.getDisplayName() + " : ");
                                    try {
                                        ScanSocket.send(ScanPacket);
                                        System.out.println("Sent");
                                    }
                                    catch (Exception e) {
                                        System.out.println("Error (" + e.getLocalizedMessage() + ")");
                                    }
                                    ScanSocket.setSoTimeout(500);
                                    byte[] ScanAnswerBytes = new byte[256];
                                    DatagramPacket ScanAnswerPacket = new DatagramPacket(ScanAnswerBytes, 250);
                                    while (true) {
                                        ScanSocket.receive(ScanAnswerPacket);
                                        String szFoundAddress = ScanAnswerPacket.getAddress().toString();
                                        szFoundAddress = szFoundAddress.substring(1).trim();
                                        System.out.println("Answer from " + szFoundAddress);
                                        if (ScanAnswerBytes[0] != 0 || ScanAnswerBytes[1] != 35 || ScanAnswerBytes[2] != 0 || ScanAnswerBytes[3] != 0 || ScanAnswerBytes[3] != 0 || ScanAnswerBytes[5] != 34) continue;
                                        long lType = (long)ScanAnswerBytes[7] << 16 & 0xFFFFFFFFFF000000L | (long)ScanAnswerBytes[8] << 16 & 0xFF0000L | (long)ScanAnswerBytes[9] << 8 & 0xFF00L | (long)ScanAnswerBytes[10] & 0xFFL;
                                        if (FCOCScanNetwork.this.m_lTypeToFind != 0L && FCOCScanNetwork.this.m_lTypeToFind != lType) continue;
                                        String szType = String.valueOf(ScanAnswerBytes[7] * 256 + ScanAnswerBytes[8]) + "." + (ScanAnswerBytes[9] * 256 + ScanAnswerBytes[10]);
                                        String szVersion = "";
                                        szVersion = ScanAnswerBytes[12] == 0 ? "FW:" + ScanAnswerBytes[13] + "." + ScanAnswerBytes[15] : "HW:" + ScanAnswerBytes[12] + "." + ScanAnswerBytes[13] + "/" + "FW:" + ScanAnswerBytes[14] + "." + ScanAnswerBytes[15];
                                        String szName = FCOCUtils.byteArrayToString(ScanAnswerBytes, 17, 16);
                                        String szMac = "";
                                        int i = 0;
                                        while (i < 6) {
                                            szMac = String.valueOf(szMac) + Integer.toHexString(ScanAnswerBytes[34 + i] >> 4 & 0xF).toUpperCase(Locale.ENGLISH) + Integer.toHexString(ScanAnswerBytes[34 + i] & 0xF).toUpperCase(Locale.ENGLISH) + " ";
                                            ++i;
                                        }
                                        szMac.trim();
                                        boolean isAlreadyInTable = false;
                                        int i2 = 0;
                                        while (i2 < ResultTableModel.getRowCount()) {
                                            if (szMac.equals(ResultTableModel.getDataVector().elementAt(i2).elementAt(0))) {
                                                isAlreadyInTable = true;
                                            }
                                            ++i2;
                                        }
                                        if (!isAlreadyInTable) {
                                            Object[] szNewRow = new String[]{szMac, szFoundAddress, szType, szVersion, szName};
                                            ResultTableModel.addRow(szNewRow);
                                        }
                                        int nTabHeight = FCOCScanNetwork.this.m_ResultTable.getParent().getHeight();
                                        int bRowHeight = FCOCScanNetwork.this.m_ResultTable.getRowHeight();
                                        int nNewHeight = 200 - nTabHeight + ResultTableModel.getRowCount() * bRowHeight;
                                        if (nNewHeight > 600) {
                                            nNewHeight = 600;
                                        }
                                        if (nNewHeight <= 200) continue;
                                        FCOCScanNetwork.this.setSize(600, nNewHeight);
                                    }
                                }
                                ScanSocket.close();
                            }
                            catch (SocketTimeoutException ScanSocket) {
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                        }
                    }
                }
                catch (SocketException e) {
                    e.printStackTrace();
                }
                catch (UnknownHostException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public void start(long lTypeToFind) {
        this.m_lTypeToFind = lTypeToFind;
        this.scan();
        this.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent ActEvent) {
        Object EventSource = ActEvent.getSource();
        if (EventSource == this.m_ScanB) {
            this.scan();
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent ListSelEvt) throws NullPointerException {
        int nSelectedRow = -1;
        if (ListSelEvt.getSource() == this.m_ResultTable.getSelectionModel() && !ListSelEvt.getValueIsAdjusting() && (nSelectedRow = this.m_ResultTable.getSelectedRow()) >= 0) {
            this.m_szIPAddressSelected = (String)this.m_ResultTable.getModel().getValueAt(nSelectedRow, 1);
            System.out.println("IP Address selected: " + this.m_szIPAddressSelected);
            this.m_ScanNetEvtInterface.simpleEventPerformed(this);
            this.m_ResultTable.removeRowSelectionInterval(0, this.m_ResultTable.getRowCount() - 1);
        }
    }

    public String getIPAddressSelected() {
        return this.m_szIPAddressSelected;
    }
}

