/*
 * Decompiled with CFR 0.152.
 */
package com.fiveco.appMisc;

import com.fiveco.appMisc.FCOCScanNetwork;
import com.fiveco.utils.FCOCUtils;
import com.fiveco.utils.FCOISimpleEvent;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.table.DefaultTableModel;

public class FCOCEasyIPChange
extends FCOCScanNetwork {
    private final JSpinner m_NewIP0TF;
    private final JSpinner m_NewIP1TF;
    private final JSpinner m_NewIP2TF;
    private final JSpinner m_NewIP3TF;
    private final byte[] m_acMySubnetMask = new byte[4];
    private final JButton m_SetButton;

    public FCOCEasyIPChange(FCOISimpleEvent ScanNetEvtInterface) {
        super(ScanNetEvtInterface, "Change IP Address easily");
        ArrayList<Image> imageList = new ArrayList<Image>();
        imageList.add(Toolkit.getDefaultToolkit().getImage(FCOCEasyIPChange.class.getResource("/images/logo198px.gif")));
        imageList.add(Toolkit.getDefaultToolkit().getImage(FCOCEasyIPChange.class.getResource("/images/logo75px.gif")));
        imageList.add(Toolkit.getDefaultToolkit().getImage(FCOCEasyIPChange.class.getResource("/images/logo40px.gif")));
        imageList.add(Toolkit.getDefaultToolkit().getImage(FCOCEasyIPChange.class.getResource("/images/logo32px.png")));
        this.setIconImages(imageList);
        byte[] acMyIP = new byte[4];
        try {
            InetAddress LocalHost = Inet4Address.getLocalHost();
            acMyIP = LocalHost.getAddress();
            NetworkInterface NetInterface = NetworkInterface.getByInetAddress(LocalHost);
            System.out.println(NetInterface.getInterfaceAddresses().get(0).getNetworkPrefixLength());
            long lSubnetMask = -1 << 32 - NetInterface.getInterfaceAddresses().get(0).getNetworkPrefixLength();
            this.m_acMySubnetMask[0] = (byte)(lSubnetMask >> 24 & 0xFFL);
            this.m_acMySubnetMask[1] = (byte)(lSubnetMask >> 16 & 0xFFL);
            this.m_acMySubnetMask[2] = (byte)(lSubnetMask >> 8 & 0xFFL);
            this.m_acMySubnetMask[3] = (byte)(lSubnetMask & 0xFFL);
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        catch (SocketException e) {
            e.printStackTrace();
        }
        SpinnerNumberModel NewIP0SpinnerModel = new SpinnerNumberModel(1, 0, 255, 1);
        SpinnerNumberModel NewIP1SpinnerModel = new SpinnerNumberModel(1, 0, 255, 1);
        SpinnerNumberModel NewIP2SpinnerModel = new SpinnerNumberModel(1, 0, 255, 1);
        SpinnerNumberModel NewIP3SpinnerModel = new SpinnerNumberModel(1, 1, 254, 1);
        JPanel BotPane = new JPanel();
        JLabel NewIPLabel = new JLabel("New IP Address :");
        this.m_NewIP0TF = new JSpinner(NewIP0SpinnerModel);
        this.m_NewIP0TF.setValue(acMyIP[0] & 0xFF);
        this.m_NewIP0TF.setEnabled(false);
        this.m_NewIP1TF = new JSpinner(NewIP1SpinnerModel);
        this.m_NewIP1TF.setValue(acMyIP[1] & 0xFF);
        this.m_NewIP1TF.setEnabled(false);
        this.m_NewIP2TF = new JSpinner(NewIP2SpinnerModel);
        this.m_NewIP2TF.setValue(acMyIP[2] & 0xFF);
        this.m_NewIP2TF.setEnabled(false);
        this.m_NewIP3TF = new JSpinner(NewIP3SpinnerModel);
        this.m_NewIP3TF.setValue(254);
        this.m_NewIP3TF.setEnabled(false);
        this.m_SetButton = new JButton("Set");
        this.m_SetButton.setEnabled(false);
        this.m_SetButton.addActionListener(this);
        BotPane.add(NewIPLabel);
        BotPane.add(this.m_NewIP0TF);
        BotPane.add(this.m_NewIP1TF);
        BotPane.add(this.m_NewIP2TF);
        BotPane.add(this.m_NewIP3TF);
        BotPane.add(this.m_SetButton);
        JPanel Pane = (JPanel)this.getContentPane();
        BotPane.setPreferredSize(new Dimension(420, 35));
        Pane.add((Component)BotPane, "South");
    }

    @Override
    public void valueChanged(ListSelectionEvent ListSelEvt) {
        int nSelectedRow = -1;
        if (ListSelEvt.getSource() == this.m_ResultTable.getSelectionModel() && !ListSelEvt.getValueIsAdjusting()) {
            nSelectedRow = this.m_ResultTable.getSelectedRow();
            if (nSelectedRow >= 0) {
                String szIPAddress = (String)this.m_ResultTable.getModel().getValueAt(nSelectedRow, 1);
                System.out.println("IP Address selected: " + szIPAddress);
                this.m_NewIP0TF.setEnabled(true);
                this.m_NewIP1TF.setEnabled(true);
                this.m_NewIP2TF.setEnabled(true);
                this.m_NewIP3TF.setEnabled(true);
                this.m_SetButton.setEnabled(true);
            } else {
                this.m_NewIP0TF.setEnabled(false);
                this.m_NewIP1TF.setEnabled(false);
                this.m_NewIP2TF.setEnabled(false);
                this.m_NewIP3TF.setEnabled(false);
                this.m_SetButton.setEnabled(false);
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent ActEvent) {
        block6: {
            Object EventSource = ActEvent.getSource();
            if (EventSource == this.m_SetButton) {
                try {
                    String szIPToCheck = this.m_NewIP0TF.getValue() + "." + this.m_NewIP1TF.getValue() + "." + this.m_NewIP2TF.getValue() + "." + this.m_NewIP3TF.getValue();
                    boolean isReachable = InetAddress.getByName(szIPToCheck).isReachable(100);
                    System.out.println("isReachable: " + isReachable);
                    if (isReachable) {
                        String szMessage = "Error !\nThis IP address is already used on the network.";
                        JOptionPane.showMessageDialog(this, szMessage);
                        break block6;
                    }
                    this.changeIPAdress();
                }
                catch (UnknownHostException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            } else {
                super.actionPerformed(ActEvent);
            }
        }
    }

    private void changeIPAdress() {
        try {
            DatagramSocket IpChangeSocket = new DatagramSocket();
            int nSelectedRow = this.m_ResultTable.getSelectedRow();
            String[] szMac = ((DefaultTableModel)this.m_ResultTable.getModel()).getValueAt(nSelectedRow, 0).toString().split(" ");
            byte[] acMac = new byte[6];
            int i = 0;
            while (i < 6) {
                acMac[i] = (byte)Integer.decode("0x" + szMac[i]).intValue();
                ++i;
            }
            byte[] acNewIp = new byte[]{(byte)Integer.decode(this.m_NewIP0TF.getValue().toString()).intValue(), (byte)Integer.decode(this.m_NewIP1TF.getValue().toString()).intValue(), (byte)Integer.decode(this.m_NewIP2TF.getValue().toString()).intValue(), (byte)Integer.decode(this.m_NewIP3TF.getValue().toString()).intValue()};
            String szIPToCheck = this.m_NewIP0TF.getValue() + "." + this.m_NewIP1TF.getValue() + "." + this.m_NewIP2TF.getValue() + "." + this.m_NewIP3TF.getValue();
            byte[] byArray = new byte[22];
            byArray[1] = 42;
            byArray[5] = 14;
            byArray[6] = acMac[0];
            byArray[7] = acMac[1];
            byArray[8] = acMac[2];
            byArray[9] = acMac[3];
            byArray[10] = acMac[4];
            byArray[11] = acMac[5];
            byArray[12] = acNewIp[0];
            byArray[13] = acNewIp[1];
            byArray[14] = acNewIp[2];
            byArray[15] = acNewIp[3];
            byArray[16] = this.m_acMySubnetMask[0];
            byArray[17] = this.m_acMySubnetMask[1];
            byArray[18] = this.m_acMySubnetMask[2];
            byArray[19] = this.m_acMySubnetMask[3];
            byte[] acIpChangePacketBytes = byArray;
            FCOCUtils.addChecksum(acIpChangePacketBytes, 20);
            byte[] acIpChangePacketAddress = new byte[]{-1, -1, -1, -1};
            DatagramPacket IpChangePacket = new DatagramPacket(acIpChangePacketBytes, 22, InetAddress.getByAddress(acIpChangePacketAddress), 7010);
            IpChangeSocket.send(IpChangePacket);
            Thread.sleep(250L);
            try {
                this.m_szIPAddressSelected = szIPToCheck;
                this.m_ScanNetEvtInterface.simpleEventPerformed(this);
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            this.m_ResultTable.removeRowSelectionInterval(0, this.m_ResultTable.getRowCount() - 1);
            IpChangeSocket.close();
        }
        catch (SocketException e) {
            e.printStackTrace();
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }
}

